/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.ui;

import com.android.ide.common.rendering.api.SessionParams;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.ImagePool;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RuntimeInterruptedException;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppBarConfigurationDialog
extends JDialog {
    private static final String TAG_COORDINATOR_LAYOUT = "<android.support.design.widget.CoordinatorLayout\n%3$s%4$s    %1$s:layout_width=\"match_parent\"\n    %1$s:layout_height=\"match_parent\">\n  <android.support.design.widget.AppBarLayout\n      %1$s:id=\"@+id/appbar\"\n%4$s      %1$s:layout_height=\"192dp\"\n      %1$s:layout_width=\"match_parent\">\n    <android.support.design.widget.CollapsingToolbarLayout\n        %1$s:layout_width=\"match_parent\"\n        %1$s:layout_height=\"match_parent\"\n        %2$s:toolbarId=\"@+id/toolbar\"\n        %2$s:layout_scrollFlags=\"%5$s\"\n%6$s        %2$s:contentScrim=\"?attr/colorPrimary\">\n%7$s      <android.support.v7.widget.Toolbar\n          %1$s:id=\"@+id/toolbar\"\n          %1$s:layout_height=\"?attr/actionBarSize\"\n          %1$s:layout_width=\"match_parent\">\n      </android.support.v7.widget.Toolbar>\n    </android.support.design.widget.CollapsingToolbarLayout>\n  </android.support.design.widget.AppBarLayout>\n  <android.support.v4.widget.NestedScrollView\n      %1$s:layout_width=\"match_parent\"\n      %1$s:layout_height=\"match_parent\"\n%8$s%9$s      %2$s:layout_behavior=\"android.support.design.widget.AppBarLayout$ScrollingViewBehavior\">\n%10$s  </android.support.v4.widget.NestedScrollView>\n%11$s</android.support.design.widget.CoordinatorLayout>\n";
    private static final String TAG_COORDINATOR_WITH_TABS_LAYOUT = "<android.support.design.widget.CoordinatorLayout\n%3$s    %1$s:layout_width=\"match_parent\"\n    %1$s:layout_height=\"match_parent\">\n  <android.support.design.widget.AppBarLayout\n      %1$s:id=\"@+id/appbar\"\n      %1$s:layout_height=\"wrap_content\"\n      %1$s:layout_width=\"match_parent\">\n    <android.support.v7.widget.Toolbar\n        %1$s:layout_height=\"?attr/actionBarSize\"\n        %1$s:layout_width=\"match_parent\"\n        %2$s:layout_scrollFlags=\"scroll|enterAlways\">\n    </android.support.v7.widget.Toolbar>\n    <android.support.design.widget.TabLayout\n        %1$s:id=\"@+id/tabs\"\n        %1$s:layout_width=\"match_parent\"\n        %1$s:layout_height=\"wrap_content\"\n%4$s        %2$s:tabMode=\"scrollable\">\n%5$s    </android.support.design.widget.TabLayout>\n  </android.support.design.widget.AppBarLayout>\n  <android.support.v4.widget.NestedScrollView\n      %1$s:layout_width=\"match_parent\"\n      %1$s:layout_height=\"match_parent\"\n%6$s      %2$s:layout_behavior=\"android.support.design.widget.AppBarLayout$ScrollingViewBehavior\">\n    %7$s\n  </android.support.v4.widget.NestedScrollView>\n%8$s</android.support.design.widget.CoordinatorLayout>\n";
    private static final String TAG_FLOATING_ACTION_BUTTON = "<android.support.design.widget.FloatingActionButton\n    %1$s:layout_height=\"wrap_content\"\n    %1$s:layout_width=\"wrap_content\"\n    %1$s:src=\"%3$s\"\n    %1$s:layout_gravity=\"bottom|end\"\n    %1$s:layout_margin=\"16dp\"\n    %1$s:clickable=\"true\"/>\n";
    private static final String TAG_IMAGE_VIEW = "<ImageView\n    %1$s:id=\"@+id/app_bar_image\"\n    %1$s:layout_width=\"match_parent\"\n    %1$s:layout_height=\"match_parent\"\n%2$s    %1$s:src=\"%3$s\"\n    %1$s:scaleType=\"centerCrop\"/>\n";
    private static final String TAG_TEXT_VIEW = "<TextView\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"wrap_content\"\n    android:text=\"%1$s\"\n    android:padding=\"16dp\"/>";
    private static final String TAG_TAB_ITEM = "<android.support.design.widget.TabItem\n    %1$s:layout_height=\"wrap_content\"\n    %1$s:layout_width=\"wrap_content\"\n    %1$s:text=\"%2$s\"/>\n";
    private static final String DIALOG_TITLE = "Configure App Bar";
    private static final String DEFAULT_BACKGROUND_IMAGE = "@android:drawable/sym_def_app_icon";
    private static final String DEFAULT_FAB_IMAGE = "@android:drawable/ic_input_add";
    private static final String PREVIEW_PLACEHOLDER_FILE = "preview.xml";
    private static final String DUMMY_TEXT = "This text is present to test the Application Bar. ";
    private static final int DUMMY_REPETITION = 200;
    private static final String PREVIEW_HEADER = "Preview:";
    private static final String RENDER_ERROR = "An error happened during rendering...";
    private static final String OVERLAP_TOP_FORMAT = "%1$s:behavior_overlapTop=\"%2$s\"";
    private static final double FUDGE_FACTOR = 0.95;
    private static final int MIN_WIDTH = 40;
    private static final int MIN_HEIGHT = 60;
    private static final int START_WIDTH = 225;
    private static final int START_HEIGHT = 400;
    private final ViewEditor myEditor;
    private final Disposable myDisposable;
    private final JBLoadingPanel myLoadingPanel;
    private JPanel myContentPane;
    private JButton myButtonOK;
    private JButton myButtonCancel;
    private JBLabel myPreview;
    private JCheckBox myCollapsing;
    private JCheckBox myShowBackgroundImage;
    private JCheckBox myFloatingActionButton;
    private JCheckBox myFitStatusBar;
    private JCheckBox myContentOverlap;
    private JCheckBox myWithTabs;
    private JButton myBackgroundImageSelector;
    private JButton myFloatingActionButtonImageSelector;
    private JPanel myPreviewPanel;
    private JBLabel myCollapsedPreview;
    private JBLabel myExpandedPreview;
    private Future<?> myCollapsedPreviewFuture;
    private Future<?> myExpandedPreviewFuture;
    private JBLabel myExpandedLabel;
    private JBLabel myCollapsedLabel;
    private JCheckBox myParallax;
    private JTextField myContentOverlapAmount;
    private JSpinner myTabCount;
    private boolean myWasAccepted;
    private BufferedImage myExpandedImage;
    private BufferedImage myCollapsedImage;
    private String myBackgroundImage;
    private String myFloatingActionButtonImage;

    public AppBarConfigurationDialog(@NotNull ViewEditor editor) {
        if (editor == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(0);
        }
        this.myEditor = editor;
        this.$$$setupUI$$$();
        this.myDisposable = Disposer.newDisposable();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.myDisposable, 20);
        this.myLoadingPanel.add((Component)this.myContentPane);
        Disposer.register((Disposable)editor.getModel(), (Disposable)this.myDisposable);
        this.setTitle(DIALOG_TITLE);
        this.setContentPane((Container)this.myLoadingPanel);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.myButtonOK);
        this.myBackgroundImage = DEFAULT_BACKGROUND_IMAGE;
        this.myFloatingActionButtonImage = DEFAULT_FAB_IMAGE;
        ActionListener updatePreviewListener = event -> {
            this.updateControls();
            this.generatePreviews();
        };
        this.myWithTabs.addActionListener(updatePreviewListener);
        this.myTabCount.setValue(3);
        this.myCollapsing.addActionListener(updatePreviewListener);
        this.myShowBackgroundImage.addActionListener(updatePreviewListener);
        this.myFloatingActionButton.addActionListener(updatePreviewListener);
        this.myFitStatusBar.addActionListener(updatePreviewListener);
        this.myParallax.addActionListener(updatePreviewListener);
        this.myContentOverlap.addActionListener(updatePreviewListener);
        this.myContentOverlapAmount.addActionListener(updatePreviewListener);
        ((GridLayoutManager)this.myPreviewPanel.getLayout()).setRowStretch(0, 2);
        this.myTabCount.addChangeListener(event -> this.generatePreviews());
        ActionListener actionListener = event -> {
            if (event.getSource() == this.myBackgroundImageSelector) {
                String src = this.myEditor.displayResourceInput(EnumSet.of(ResourceType.DRAWABLE));
                if (src != null) {
                    this.myBackgroundImage = src;
                    this.generatePreviews();
                }
            } else if (event.getSource() == this.myFloatingActionButtonImageSelector) {
                String src = this.myEditor.displayResourceInput(EnumSet.of(ResourceType.DRAWABLE));
                if (src != null) {
                    this.myFloatingActionButtonImage = src;
                    this.generatePreviews();
                }
            } else if (event.getSource() == this.myButtonOK) {
                this.onOK();
            } else if (event.getSource() == this.myButtonCancel || event.getSource() == this.myContentPane) {
                this.onCancel();
            }
        };
        this.myBackgroundImageSelector.addActionListener(actionListener);
        this.myFloatingActionButtonImageSelector.addActionListener(actionListener);
        this.myButtonOK.addActionListener(actionListener);
        this.myButtonCancel.addActionListener(actionListener);
        this.myContentPane.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 1);
        this.myPreviewPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AppBarConfigurationDialog.this.updatePreviewImages();
            }
        });
        this.myCollapsedPreview.setName("CollapsedPreview");
        this.myExpandedPreview.setName("ExpandedPreview");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AppBarConfigurationDialog.this.onCancel();
            }
        });
    }

    public boolean open() {
        NlModel model = this.myEditor.getModel();
        Project project = model.getProject();
        boolean hasDesignLib = DependencyManagementUtil.dependsOn(model.getModule(), GoogleMavenArtifactId.DESIGN);
        if (!hasDesignLib && !this.addDesignLibrary()) {
            return false;
        }
        this.myCollapsedPreview.setMinimumSize(new Dimension(225, 400));
        this.myExpandedPreview.setMinimumSize(new Dimension(225, 400));
        this.pack();
        this.myCollapsedPreview.setMinimumSize(null);
        this.myExpandedPreview.setMinimumSize(null);
        Dimension size = this.getSize();
        Rectangle screen = this.getGraphicsConfiguration().getBounds();
        this.setLocation(screen.x + (screen.width - size.width) / 2, screen.y + (screen.height - size.height) / 2);
        this.updateControls();
        this.myButtonOK.requestFocus();
        if (hasDesignLib) {
            this.generatePreviews();
        }
        this.setVisible(true);
        if (this.myWasAccepted) {
            final XmlFile file = model.getFile();
            WriteCommandAction action = new WriteCommandAction(project, DIALOG_TITLE, new PsiFile[]{file}){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    AppBarConfigurationDialog.this.applyChanges(file);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog$3", "run"));
                }
            };
            action.execute();
        }
        return this.myWasAccepted;
    }

    private boolean addDesignLibrary() {
        this.myLoadingPanel.startLoading();
        Module module = this.myEditor.getModel().getModule();
        boolean designAdded = DependencyManagementUtil.addDependencies(module, Collections.singletonList(GoogleMavenArtifactId.DESIGN), true, false).isEmpty();
        if (!designAdded) {
            return false;
        }
        ListenableFuture<ProjectSystemSyncManager.SyncResult> syncResult = ProjectSystemUtil.getSyncManager(module.getProject()).syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED, true);
        Futures.addCallback(syncResult, (FutureCallback)new FutureCallback<ProjectSystemSyncManager.SyncResult>(){

            public void onSuccess(@Nullable ProjectSystemSyncManager.SyncResult result) {
                if (result != null && result.isSuccessful()) {
                    AppBarConfigurationDialog.this.onDesignSourcesGenerated();
                } else {
                    AppBarConfigurationDialog.this.onBuildError();
                }
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    4.$$$reportNull$$$0(0);
                }
                AppBarConfigurationDialog.this.onBuildError();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog$4", "onFailure"));
            }
        });
        return true;
    }

    private void onDesignSourcesGenerated() {
        if (this.isVisible()) {
            ApplicationManager.getApplication().invokeLater(this::generatePreviews);
        }
    }

    private void onBuildError() {
        this.myPreview.setText("Preview is unavailable until after a successful build");
        this.myPreview.setIcon(AllIcons.General.Warning);
        this.myCollapsedLabel.setVisible(false);
        this.myExpandedLabel.setVisible(false);
        this.myLoadingPanel.stopLoading();
    }

    private void onOK() {
        this.myWasAccepted = true;
        this.dispose();
    }

    private void onCancel() {
        this.dispose();
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private void updateControls() {
        this.myTabCount.setEnabled(this.myWithTabs.isSelected());
        this.myShowBackgroundImage.setEnabled(!this.myWithTabs.isSelected());
        this.myBackgroundImageSelector.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myFitStatusBar.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myParallax.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myFitStatusBar.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myContentOverlap.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected());
        this.myContentOverlapAmount.setEnabled(!this.myWithTabs.isSelected() && this.myShowBackgroundImage.isSelected() && this.myContentOverlap.isSelected());
        this.myFloatingActionButtonImageSelector.setEnabled(this.myFloatingActionButton.isSelected());
    }

    private void generatePreviews() {
        PsiFile expandedFile = this.generateXml(false);
        PsiFile collapsedFile = this.generateXml(true);
        this.myExpandedPreviewFuture = AppBarConfigurationDialog.cancel(this.myExpandedPreviewFuture);
        this.myCollapsedPreviewFuture = AppBarConfigurationDialog.cancel(this.myCollapsedPreviewFuture);
        Application application = ApplicationManager.getApplication();
        this.myExpandedPreviewFuture = application.executeOnPooledThread(() -> {
            DumbService.getInstance((Project)this.myEditor.getModel().getProject()).waitForSmartMode();
            this.updateExpandedImage(expandedFile);
        });
        this.myCollapsedPreviewFuture = application.executeOnPooledThread(() -> {
            DumbService.getInstance((Project)this.myEditor.getModel().getProject()).waitForSmartMode();
            this.updateCollapsedImage(collapsedFile);
        });
    }

    @Nullable
    private static Future<?> cancel(@Nullable Future<?> future) {
        if (future != null) {
            future.cancel(true);
        }
        return null;
    }

    private PsiFile generateXml(boolean collapsed) {
        StringBuilder text = new StringBuilder(200 * DUMMY_TEXT.length());
        for (int i = 0; i < 200; ++i) {
            text.append(DUMMY_TEXT);
        }
        String content = String.format(TAG_TEXT_VIEW, text.toString());
        Map<String, String> namespaces = AppBarConfigurationDialog.getNameSpaces(null, collapsed);
        String xml = this.getXml(content, collapsed, namespaces);
        Project project = this.myEditor.getModel().getProject();
        return PsiFileFactory.getInstance((Project)project).createFileFromText(PREVIEW_PLACEHOLDER_FILE, (FileType)XmlFileType.INSTANCE, (CharSequence)xml);
    }

    private void updatePreviewImages() {
        if (this.myCollapsedImage != null) {
            this.updatePreviewImage(this.myCollapsedImage, this.myCollapsedPreview);
        }
        if (this.myExpandedImage != null) {
            this.updatePreviewImage(this.myExpandedImage, this.myExpandedPreview);
        }
    }

    private void applyChanges(@NotNull XmlFile file) {
        if (file == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(1);
        }
        Map<String, String> namespaces = AppBarConfigurationDialog.getNameSpaces(file.getRootTag(), false);
        String xml = this.getXml(AppBarConfigurationDialog.getDesignContent(file), false, namespaces);
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)file.getProject());
        XmlTag tag = elementFactory.createTagFromText((CharSequence)xml);
        if (file.getRootTag() == null) {
            file.add((PsiElement)tag);
        } else {
            file.getRootTag().replace((PsiElement)tag);
        }
    }

    @NotNull
    private String getXml(@NotNull String content, boolean collapsed, @NotNull Map<String, String> namespaces) {
        if (content == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(2);
        }
        if (namespaces == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(3);
        }
        String string = this.myWithTabs.isSelected() ? this.getXmlWithTabs(content, collapsed, namespaces) : this.getXmlWithoutTabs(content, collapsed, namespaces);
        if (string == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private String getXmlWithoutTabs(@NotNull String content, boolean collapsed, @NotNull Map<String, String> namespaces) {
        if (content == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(5);
        }
        if (namespaces == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(6);
        }
        String string = String.format(TAG_COORDINATOR_LAYOUT, namespaces.get("http://schemas.android.com/apk/res/android"), namespaces.get("http://schemas.android.com/apk/res-auto"), AppBarConfigurationDialog.formatNamespaces(namespaces), this.getFitsSystemWindows(namespaces), this.getToolbarScrollBehavior(), this.getInterpolator(namespaces), this.getBackgroundImage(namespaces), this.getBehaviorOverlapTop(namespaces), AppBarConfigurationDialog.getScrollPos(collapsed, namespaces), content, this.getFloatingActionButton(namespaces));
        if (string == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private String getXmlWithTabs(@NotNull String content, boolean collapsed, @NotNull Map<String, String> namespaces) {
        if (content == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(8);
        }
        if (namespaces == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(9);
        }
        String string = String.format(TAG_COORDINATOR_WITH_TABS_LAYOUT, namespaces.get("http://schemas.android.com/apk/res/android"), namespaces.get("http://schemas.android.com/apk/res-auto"), AppBarConfigurationDialog.formatNamespaces(namespaces), this.getTabLayoutScroll(namespaces), this.getTabItems(namespaces), AppBarConfigurationDialog.getScrollPos(collapsed, namespaces), content, this.getFloatingActionButton(namespaces));
        if (string == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private String getFitsSystemWindows(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(11);
        }
        if (!this.myShowBackgroundImage.isSelected() || !this.myFitStatusBar.isSelected()) {
            if ("" == null) {
                AppBarConfigurationDialog.$$$reportNull$$$0(12);
            }
            return "";
        }
        String string = String.format("    %1$s:fitsSystemWindows=\"true\"\n", namespaces.get("http://schemas.android.com/apk/res/android"));
        if (string == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private String getToolbarScrollBehavior() {
        String string = this.myCollapsing.isSelected() ? "scroll|enterAlways|enterAlwaysCollapsed" : "scroll|exitUntilCollapsed";
        if (string == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private String getTabLayoutScroll(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(15);
        }
        if (!this.myCollapsing.isSelected()) {
            if ("" == null) {
                AppBarConfigurationDialog.$$$reportNull$$$0(16);
            }
            return "";
        }
        String string = String.format("        %1$s:layout_scrollFlags=\"scroll|enterAlways\"\n", namespaces.get("http://schemas.android.com/apk/res-auto"));
        if (string == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private String getTabItems(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(18);
        }
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < (Integer)this.myTabCount.getValue(); ++index) {
            builder.append(String.format(TAG_TAB_ITEM, namespaces.get("http://schemas.android.com/apk/res/android"), "Tab" + (index + 1)));
        }
        String string = builder.toString();
        if (string == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private String getInterpolator(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(20);
        }
        if (!this.myShowBackgroundImage.isSelected()) {
            if ("" == null) {
                AppBarConfigurationDialog.$$$reportNull$$$0(21);
            }
            return "";
        }
        String string = String.format("        %2$s:layout_scrollInterpolator=\"@%1$s:anim/decelerate_interpolator\"\n", namespaces.get("http://schemas.android.com/apk/res/android"), namespaces.get("http://schemas.android.com/apk/res-auto"));
        if (string == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private String getBackgroundImage(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(23);
        }
        if (!this.myShowBackgroundImage.isSelected()) {
            if ("" == null) {
                AppBarConfigurationDialog.$$$reportNull$$$0(24);
            }
            return "";
        }
        String string = String.format(TAG_IMAGE_VIEW, namespaces.get("http://schemas.android.com/apk/res/android"), this.getBackgroundImageCollapseMode(namespaces), this.myBackgroundImage);
        if (string == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private String getBehaviorOverlapTop(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(26);
        }
        if (!this.myContentOverlap.isSelected()) {
            if ("" == null) {
                AppBarConfigurationDialog.$$$reportNull$$$0(27);
            }
            return "";
        }
        String string = String.format(OVERLAP_TOP_FORMAT, namespaces.get("http://schemas.android.com/apk/res-auto"), this.myContentOverlapAmount.getText());
        if (string == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private static String getScrollPos(boolean collapsed, @NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(29);
        }
        if (!collapsed) {
            if ("" == null) {
                AppBarConfigurationDialog.$$$reportNull$$$0(30);
            }
            return "";
        }
        String string = String.format("        %1$s:scrollY=\"830px\"\n", namespaces.get("http://schemas.android.com/tools"));
        if (string == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    private String getBackgroundImageCollapseMode(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(32);
        }
        if (this.myParallax.isSelected()) {
            if ("" == null) {
                AppBarConfigurationDialog.$$$reportNull$$$0(33);
            }
            return "";
        }
        String string = String.format("    %1$s:layout_collapseMode=\"parallax\"\n", namespaces.get("http://schemas.android.com/apk/res-auto"));
        if (string == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private String getFloatingActionButton(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(35);
        }
        if (!this.myFloatingActionButton.isSelected()) {
            if ("" == null) {
                AppBarConfigurationDialog.$$$reportNull$$$0(36);
            }
            return "";
        }
        String string = String.format(TAG_FLOATING_ACTION_BUTTON, namespaces.get("http://schemas.android.com/apk/res/android"), namespaces.get("http://schemas.android.com/apk/res-auto"), this.myFloatingActionButtonImage);
        if (string == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    private static Map<String, String> getNameSpaces(@Nullable XmlTag root, boolean includeToolsNamespace) {
        HashMap<String, String> reverse = new HashMap<String, String>();
        if (root != null) {
            Map namespaces = root.getLocalNamespaceDeclarations();
            for (String prefix : namespaces.keySet()) {
                reverse.put((String)namespaces.get(prefix), prefix);
            }
        }
        if (!reverse.containsKey("http://schemas.android.com/apk/res/android")) {
            reverse.put("http://schemas.android.com/apk/res/android", "android");
        }
        if (!reverse.containsKey("http://schemas.android.com/apk/res-auto")) {
            reverse.put("http://schemas.android.com/apk/res-auto", "app");
        }
        if (includeToolsNamespace && !reverse.containsKey("http://schemas.android.com/tools")) {
            reverse.put("http://schemas.android.com/tools", "tools");
        }
        HashMap<String, String> hashMap = reverse;
        if (hashMap == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(38);
        }
        return hashMap;
    }

    @NotNull
    private static String formatNamespaces(@NotNull Map<String, String> namespaces) {
        if (namespaces == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(39);
        }
        StringBuilder result = new StringBuilder();
        for (String ns : namespaces.keySet()) {
            String prefix = namespaces.get(ns);
            result.append(String.format("    xmlns:%1$s=\"%2$s\"\n", prefix, ns));
        }
        String string = result.toString();
        if (string == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    private static String getDesignContent(@NotNull XmlFile file) {
        XmlTag content;
        if (file == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(41);
        }
        if ((content = file.getRootTag()) != null && content.getName().equals("android.support.design.widget.CoordinatorLayout")) {
            XmlTag root = content;
            content = null;
            XmlTag[] xmlTagArray = root.getSubTags();
            int n = xmlTagArray.length;
            for (int i = 0; i < n; ++i) {
                XmlTag tag = xmlTagArray[i];
                if (tag.getName().equals("android.support.design.widget.AppBarLayout") || tag.getName().equals("android.support.design.widget.FloatingActionButton")) continue;
                if (tag.getName().equals("android.support.v4.widget.NestedScrollView")) {
                    content = tag.getSubTags().length > 0 ? tag.getSubTags()[0] : null;
                    break;
                }
                content = tag;
                break;
            }
        }
        if (content == null) {
            if ("" == null) {
                AppBarConfigurationDialog.$$$reportNull$$$0(42);
            }
            return "";
        }
        for (XmlAttribute attribute : content.getAttributes()) {
            if (attribute == null || !attribute.getName().startsWith("xmlns:")) continue;
            attribute.delete();
        }
        String string = content.getText();
        if (string == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(43);
        }
        return string;
    }

    private void updateCollapsedImage(@NotNull PsiFile collapsedXmlFile) {
        BufferedImage image;
        if (collapsedXmlFile == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(44);
        }
        if ((image = this.updateImage(collapsedXmlFile, this.myCollapsedPreview)) != null) {
            this.myCollapsedImage = image;
        }
    }

    private void updateExpandedImage(@NotNull PsiFile expandedXmlFile) {
        BufferedImage image;
        if (expandedXmlFile == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(45);
        }
        if ((image = this.updateImage(expandedXmlFile, this.myExpandedPreview)) != null) {
            this.myExpandedImage = image;
        }
        this.myLoadingPanel.stopLoading();
    }

    @Nullable
    private BufferedImage updateImage(@NotNull PsiFile xmlFile, @NotNull JBLabel preview) {
        if (xmlFile == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(46);
        }
        if (preview == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(47);
        }
        BufferedImage image = null;
        try {
            image = this.renderImage(xmlFile);
            if (image == null) {
                return null;
            }
        }
        catch (RuntimeInterruptedException ex) {
            return null;
        }
        catch (RuntimeException ex) {
            AppBarConfigurationDialog.getLogger().error((Throwable)ex);
        }
        BufferedImage finalImage = image;
        ApplicationManager.getApplication().invokeLater(() -> {
            if (preview == null) {
                AppBarConfigurationDialog.$$$reportNull$$$0(50);
            }
            this.updatePreviewImage(finalImage, preview);
        });
        return image;
    }

    private BufferedImage renderImage(@NotNull PsiFile xmlFile) {
        if (xmlFile == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(48);
        }
        AndroidFacet facet = this.myEditor.getModel().getFacet();
        RenderService renderService = RenderService.getInstance(facet);
        RenderLogger logger = renderService.createLogger();
        RenderTask task = renderService.createTask(xmlFile, this.myEditor.getConfiguration(), logger, null);
        RenderResult result = null;
        if (task != null) {
            task.setRenderingMode(SessionParams.RenderingMode.NORMAL);
            task.setFolderType(ResourceFolderType.LAYOUT);
            result = (RenderResult)Futures.getUnchecked(task.render());
            task.dispose();
        }
        if (result == null || !result.hasImage()) {
            return null;
        }
        ImagePool.Image image = result.getRenderedImage();
        if (image.getWidth() < 40 || image.getHeight() < 60) {
            return null;
        }
        return result.getRenderedImage().getCopy();
    }

    private void updatePreviewImage(@Nullable BufferedImage image, @NotNull JBLabel view) {
        if (view == null) {
            AppBarConfigurationDialog.$$$reportNull$$$0(49);
        }
        if (image == null) {
            view.setIcon(null);
            this.myPreview.setText(RENDER_ERROR);
            return;
        }
        double width = (double)this.myPreviewPanel.getWidth() / 2.0;
        double height = this.myPreviewPanel.getHeight() - this.myPreview.getHeight() - Math.max(this.myExpandedLabel.getHeight(), this.myCollapsedLabel.getHeight());
        if (width < 40.0 || height < 60.0) {
            view.setIcon(null);
        }
        double scale = Math.min(width / (double)image.getWidth(), height / (double)image.getHeight()) * 0.95;
        image = ImageUtils.scale((BufferedImage)image, (double)scale, (double)scale);
        view.setIcon((Icon)new ImageIcon(image));
        this.myPreview.setText(PREVIEW_HEADER);
    }

    private static Logger getLogger() {
        return Logger.getInstance(AppBarConfigurationDialog.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaces";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collapsedXmlFile";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expandedXmlFile";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preview";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/ui/AppBarConfigurationDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getXml";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlWithoutTabs";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlWithTabs";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFitsSystemWindows";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarScrollBehavior";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabLayoutScroll";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabItems";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpolator";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundImage";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getBehaviorOverlapTop";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollPos";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundImageCollapseMode";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getFloatingActionButton";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameSpaces";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "formatNamespaces";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyChanges";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getXml";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getXmlWithoutTabs";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getXmlWithTabs";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFitsSystemWindows";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTabLayoutScroll";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTabItems";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getInterpolator";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundImage";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getBehaviorOverlapTop";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getScrollPos";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundImageCollapseMode";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFloatingActionButton";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "formatNamespaces";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getDesignContent";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "updateCollapsedImage";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "updateExpandedImage";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "updateImage";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "renderImage";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "updatePreviewImage";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateImage$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JPanel jPanel;
        JSpinner jSpinner;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JButton jButton;
        JButton jButton2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JButton jButton3;
        JButton jButton4;
        JPanel jPanel2;
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myButtonOK = jButton4 = new JButton();
        jButton4.setText("OK");
        jPanel4.add((Component)jButton4, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myButtonCancel = jButton3 = new JButton();
        jButton3.setText("Cancel");
        jPanel4.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JSplitPane jSplitPane = new JSplitPane();
        jPanel5.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(16, 8, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCollapsing = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("Collapsing Toolbar");
        jPanel7.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myShowBackgroundImage = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Image Background");
        jPanel7.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFloatingActionButton = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Floating Action Button");
        jPanel7.add((Component)jCheckBox5, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myWithTabs = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("With Tabs");
        jPanel7.add((Component)jCheckBox4, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 12, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myFitStatusBar = jCheckBox3 = new JCheckBox();
        jCheckBox3.setActionCommand("");
        jCheckBox3.setText("Fit Status Bar on Image");
        jCheckBox3.setToolTipText("Makes the toolbar with the image appear below the status bar. The status bar can be set to draw transparent by setting the theme value for: statusBarColor to color/transparent.");
        jPanel8.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.myParallax = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Parallax Scrolling");
        jCheckBox2.setToolTipText("Makes the image scroll slower than the TabBar (only visible at runtime).");
        jPanel8.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBackgroundImageSelector = jButton2 = new JButton();
        Font font = this.$$$getFont$$$(null, -1, 8, jButton2.getFont());
        if (font != null) {
            jButton2.setFont(font);
        }
        jButton2.setText("...");
        jPanel7.add((Component)jButton2, new GridConstraints(1, 1, 1, 2, 4, 0, 3, 0, null, null, null));
        this.myFloatingActionButtonImageSelector = jButton = new JButton();
        Font font2 = this.$$$getFont$$$(null, -1, 8, jButton.getFont());
        if (font2 != null) {
            jButton.setFont(font2);
        }
        jButton.setText("...");
        jPanel7.add((Component)jButton, new GridConstraints(3, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myContentOverlap = jCheckBox = new JCheckBox();
        jCheckBox.setText("Overlapping content");
        jPanel7.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myContentOverlapAmount = jTextField = new JTextField();
        jTextField.setText("32dp");
        jPanel7.add((Component)jTextField, new GridConstraints(4, 2, 1, 1, 8, 1, 1, 0, null, new Dimension(60, -1), null));
        this.myTabCount = jSpinner = new JSpinner();
        jPanel7.add((Component)jSpinner, new GridConstraints(5, 1, 1, 2, 8, 1, 6, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel);
        this.myPreview = jBLabel5 = new JBLabel();
        jBLabel5.setText(PREVIEW_HEADER);
        jPanel.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 2, 2, 0, 7, 7, null, null, null));
        this.myExpandedLabel = jBLabel4 = new JBLabel();
        jBLabel4.setAlignmentX(0.0f);
        jBLabel4.setText("Expanded");
        jPanel.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 1, 0, 7, 7, null, null, null));
        this.myCollapsedLabel = jBLabel3 = new JBLabel();
        jBLabel3.setAlignmentX(0.0f);
        jBLabel3.setText("Collapsed");
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 1, 1, 1, 1, 0, 7, 7, null, null, null));
        this.myExpandedPreview = jBLabel2 = new JBLabel();
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 0, 7, 7, null, null, null));
        this.myCollapsedPreview = jBLabel = new JBLabel();
        jPanel.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 0, 0, 7, 7, null, null, null, 1));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

