/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.common.property.NlProperty;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.ui.ToggleActionButton;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlBooleanIconEditor {
    private static final String INSPECTOR_PLACE = "Inspector Place";
    private final BooleanAction myAction;
    private final ActionButton myButton;
    private final Presentation myPresentation;

    public NlBooleanIconEditor(@NotNull Icon icon, @NotNull String description) {
        if (icon == null) {
            NlBooleanIconEditor.$$$reportNull$$$0(0);
        }
        if (description == null) {
            NlBooleanIconEditor.$$$reportNull$$$0(1);
        }
        this(icon, description, "true", "false");
    }

    public NlBooleanIconEditor(@NotNull Icon icon, @NotNull String description, @NotNull String singleValue) {
        if (icon == null) {
            NlBooleanIconEditor.$$$reportNull$$$0(2);
        }
        if (description == null) {
            NlBooleanIconEditor.$$$reportNull$$$0(3);
        }
        if (singleValue == null) {
            NlBooleanIconEditor.$$$reportNull$$$0(4);
        }
        this(icon, description, singleValue, null);
    }

    public NlBooleanIconEditor(@NotNull Icon icon, @NotNull String description, @NotNull String trueValue, @Nullable String falseValue) {
        if (icon == null) {
            NlBooleanIconEditor.$$$reportNull$$$0(5);
        }
        if (description == null) {
            NlBooleanIconEditor.$$$reportNull$$$0(6);
        }
        if (trueValue == null) {
            NlBooleanIconEditor.$$$reportNull$$$0(7);
        }
        this.myAction = new BooleanAction(icon, description, trueValue, falseValue);
        this.myPresentation = this.myAction.getTemplatePresentation().clone();
        this.myButton = new ActionButton((AnAction)this.myAction, this.myPresentation, INSPECTOR_PLACE, ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE);
        this.myButton.setFocusable(true);
    }

    public Component getComponent() {
        return this.myButton;
    }

    public void setProperty(@NotNull NlProperty property) {
        if (property == null) {
            NlBooleanIconEditor.$$$reportNull$$$0(8);
        }
        this.myAction.setProperty(property);
        this.updateDescription(property);
        AnActionEvent event = new AnActionEvent(null, DataManager.getInstance().getDataContext((Component)this.myButton), INSPECTOR_PLACE, this.myPresentation, ActionManager.getInstance(), 0);
        ActionUtil.performDumbAwareUpdate((AnAction)this.myAction, (AnActionEvent)event, (boolean)false);
        this.myButton.updateIcon();
    }

    private void updateDescription(@NotNull NlProperty property) {
        String description;
        AttributeDefinition definition;
        if (property == null) {
            NlBooleanIconEditor.$$$reportNull$$$0(9);
        }
        if ((definition = property.getDefinition()) != null && (description = definition.getValueDoc(this.myAction.myTrueValue)) != null) {
            this.myPresentation.setDescription(description);
            this.myPresentation.setText(description);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleValue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trueValue";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/NlBooleanIconEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setProperty";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDescription";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class BooleanAction
    extends ToggleActionButton {
        private final String myTrueValue;
        private final String myFalseValue;
        private NlProperty myProperty;

        BooleanAction(@NotNull Icon icon, @Nullable String description, @NotNull String trueValue, @Nullable String falseValue) {
            if (icon == null) {
                BooleanAction.$$$reportNull$$$0(0);
            }
            if (trueValue == null) {
                BooleanAction.$$$reportNull$$$0(1);
            }
            super(description, icon);
            this.getTemplatePresentation().setIcon(icon);
            this.myTrueValue = trueValue;
            this.myFalseValue = falseValue;
        }

        public void setProperty(@NotNull NlProperty property) {
            if (property == null) {
                BooleanAction.$$$reportNull$$$0(2);
            }
            this.myProperty = property;
        }

        public boolean isSelected(AnActionEvent event) {
            return this.myProperty != null && this.myTrueValue.equals(this.myProperty.getResolvedValue());
        }

        public void setSelected(AnActionEvent event, boolean selected) {
            this.myProperty.setValue(selected ? this.myTrueValue : this.myFalseValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trueValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/NlBooleanIconEditor$BooleanAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setProperty";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

