/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.resources.ResourceType;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorWithAutoCompletion
extends TextFieldWithAutoCompletion<String> {
    private final TextAttributes myTextAttributes;
    private final Insets myEditorInsets;
    private final CompletionProvider myCompletionProvider;
    private final PropertyChangeListener myPropertyChangeListener;
    private final List<LookupListener> myLookupListeners;

    public static TextEditorWithAutoCompletion create(@NotNull Project project, @NotNull Insets editorInsets) {
        if (project == null) {
            TextEditorWithAutoCompletion.$$$reportNull$$$0(0);
        }
        if (editorInsets == null) {
            TextEditorWithAutoCompletion.$$$reportNull$$$0(1);
        }
        CompletionProvider completionProvider = new CompletionProvider();
        return new TextEditorWithAutoCompletion(project, completionProvider, editorInsets);
    }

    private TextEditorWithAutoCompletion(@NotNull Project project, @NotNull CompletionProvider completionProvider, @NotNull Insets editorInsets) {
        if (project == null) {
            TextEditorWithAutoCompletion.$$$reportNull$$$0(2);
        }
        if (completionProvider == null) {
            TextEditorWithAutoCompletion.$$$reportNull$$$0(3);
        }
        if (editorInsets == null) {
            TextEditorWithAutoCompletion.$$$reportNull$$$0(4);
        }
        super(project, (TextFieldWithAutoCompletionListProvider)completionProvider, true, null);
        this.myCompletionProvider = completionProvider;
        this.myTextAttributes = new TextAttributes(null, null, null, null, 0);
        this.myEditorInsets = editorInsets;
        this.myPropertyChangeListener = new LookupListenerHandler();
        this.myLookupListeners = new ArrayList<LookupListener>();
    }

    public void addNotify() {
        super.addNotify();
        EditorEx editor = (EditorEx)this.getEditor();
        assert (editor != null);
        TextEditorWithAutoCompletion.removeAllMouseWheelListeners(editor);
        editor.getColorsScheme().setAttributes(HighlighterColors.TEXT, this.myTextAttributes);
        editor.setHighlighter((EditorHighlighter)new EmptyEditorHighlighter(this.myTextAttributes));
        editor.getDocument().putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)true);
        LookupManager.getInstance((Project)this.getProject()).addPropertyChangeListener(this.myPropertyChangeListener);
    }

    public void removeNotify() {
        super.removeNotify();
        LookupManager.getInstance((Project)this.getProject()).removePropertyChangeListener(this.myPropertyChangeListener);
        this.removeAll();
    }

    private static void removeAllMouseWheelListeners(@NotNull EditorEx editor) {
        if (editor == null) {
            TextEditorWithAutoCompletion.$$$reportNull$$$0(5);
        }
        JScrollPane scrollPane = editor.getScrollPane();
        for (MouseWheelListener listener : scrollPane.getMouseWheelListeners()) {
            scrollPane.removeMouseWheelListener(listener);
        }
    }

    public void setTextColor(@NotNull Color color) {
        if (color == null) {
            TextEditorWithAutoCompletion.$$$reportNull$$$0(6);
        }
        this.myTextAttributes.setForegroundColor(color);
        EditorEx editor = (EditorEx)this.getEditor();
        if (editor != null) {
            editor.getColorsScheme().setAttributes(HighlighterColors.TEXT, this.myTextAttributes);
            editor.setHighlighter((EditorHighlighter)new EmptyEditorHighlighter(this.myTextAttributes));
        }
    }

    public void setFontStyle(int style) {
        this.myTextAttributes.setFontType(style);
        EditorEx editor = (EditorEx)this.getEditor();
        if (editor != null) {
            editor.getColorsScheme().setAttributes(HighlighterColors.TEXT, this.myTextAttributes);
            editor.setHighlighter((EditorHighlighter)new EmptyEditorHighlighter(this.myTextAttributes));
        }
    }

    public void addLookupListener(@NotNull LookupListener listener) {
        if (listener == null) {
            TextEditorWithAutoCompletion.$$$reportNull$$$0(7);
        }
        this.myLookupListeners.add(listener);
    }

    public static List<String> loadCompletions(@NotNull AndroidFacet facet, @NotNull EnumSet<ResourceType> types, @Nullable NlProperty property) {
        if (facet == null) {
            TextEditorWithAutoCompletion.$$$reportNull$$$0(8);
        }
        if (types == null) {
            TextEditorWithAutoCompletion.$$$reportNull$$$0(9);
        }
        ArrayList<String> items = new ArrayList<String>();
        if (property != null) {
            AttributeDefinition definition = property.getDefinition();
            if (definition != null && definition.getValues().length > 0) {
                items.addAll(Arrays.asList(definition.getValues()));
            }
            if (((AbstractCollection)types).contains(ResourceType.ID)) {
                types = ((EnumSet)types).clone();
                ((AbstractCollection)types).remove(ResourceType.ID);
                Set ids = (Set)ApplicationManager.getApplication().runReadAction(() -> ResourceHelper.findIdsInFile((PsiFile)property.getModel().getFile()));
                for (String id : ids) {
                    items.add("@id/" + id);
                }
            }
        }
        if (!((AbstractCollection)types).isEmpty()) {
            if (((AbstractCollection)types).contains(ResourceType.MIPMAP)) {
                types = ((EnumSet)types).clone();
                ((AbstractCollection)types).remove(ResourceType.MIPMAP);
                ((AbstractCollection)types).add(ResourceType.DRAWABLE);
            }
            items.addAll(ResourceHelper.getCompletionFromTypes(facet, (EnumSet<ResourceType>)types, false));
        }
        return items;
    }

    public void updateCompletions(@NotNull List<String> items) {
        if (items == null) {
            TextEditorWithAutoCompletion.$$$reportNull$$$0(10);
        }
        this.myCompletionProvider.setItems(items);
    }

    public boolean editorHasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        Editor editor = this.getEditor();
        return editor != null && editor.getContentComponent().hasFocus();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInsets";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/support/TextEditorWithAutoCompletion";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeAllMouseWheelListeners";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setTextColor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addLookupListener";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "loadCompletions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "updateCompletions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CompletionProvider
    extends TextFieldWithAutoCompletionListProvider<String> {
        protected CompletionProvider() {
            super(null);
        }

        @Nullable
        public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                CompletionProvider.$$$reportNull$$$0(0);
            }
            return new CamelHumpMatcher(prefix);
        }

        @Nullable
        protected Icon getIcon(@NotNull String item) {
            if (item == null) {
                CompletionProvider.$$$reportNull$$$0(1);
            }
            return item.startsWith("@android:") ? StudioIcons.Shell.Filetree.ANDROID_PROJECT : null;
        }

        @NotNull
        protected String getLookupString(@NotNull String item) {
            if (item == null) {
                CompletionProvider.$$$reportNull$$$0(2);
            }
            String string = item;
            if (string == null) {
                CompletionProvider.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        protected String getTailText(@NotNull String item) {
            if (item == null) {
                CompletionProvider.$$$reportNull$$$0(4);
            }
            return null;
        }

        @Nullable
        protected String getTypeText(@NotNull String item) {
            if (item == null) {
                CompletionProvider.$$$reportNull$$$0(5);
            }
            return null;
        }

        public int compare(String item1, String item2) {
            return ResourceHelper.compareResourceReferences(item1, item2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/property/editors/support/TextEditorWithAutoCompletion$CompletionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/support/TextEditorWithAutoCompletion$CompletionProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createPrefixMatcher";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getTailText";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class LookupListenerHandler
    implements PropertyChangeListener {
        private LookupListenerHandler() {
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent event) {
            Lookup lookup;
            Object newValue;
            if (event == null) {
                LookupListenerHandler.$$$reportNull$$$0(0);
            }
            if ((newValue = event.getNewValue()) instanceof Lookup && (lookup = (Lookup)newValue).getTopLevelEditor() == TextEditorWithAutoCompletion.this.getEditor()) {
                TextEditorWithAutoCompletion.this.myLookupListeners.forEach(arg_0 -> ((Lookup)lookup).addLookupListener(arg_0));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/property/editors/support/TextEditorWithAutoCompletion$LookupListenerHandler", "propertyChange"));
        }
    }
}

