/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.common.property.editors.NlComponentEditor;
import com.android.tools.idea.common.property.inspector.InspectorComponent;
import com.android.tools.idea.common.property.inspector.InspectorPanel;
import com.android.tools.idea.common.property.inspector.InspectorProvider;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutInspectorProvider
implements InspectorProvider<NlPropertiesManager> {
    private final ViewHandlerManager myViewHandlerManager;
    private final Map<String, InspectorComponent<NlPropertiesManager>> myParentInspectors;

    public LayoutInspectorProvider(@NotNull Project project) {
        if (project == null) {
            LayoutInspectorProvider.$$$reportNull$$$0(0);
        }
        this.myViewHandlerManager = ViewHandlerManager.get(project);
        this.myParentInspectors = new HashMap<String, InspectorComponent<NlPropertiesManager>>();
    }

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            LayoutInspectorProvider.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            LayoutInspectorProvider.$$$reportNull$$$0(2);
        }
        if (propertiesManager == null) {
            LayoutInspectorProvider.$$$reportNull$$$0(3);
        }
        assert (components.size() >= 1);
        String parentTagName = LayoutInspectorProvider.getParentTagName(components);
        if (parentTagName == null) {
            return false;
        }
        String tagName = parentTagName.substring(parentTagName.lastIndexOf(46) + 1) + "_layout";
        if (this.myParentInspectors.containsKey(tagName)) {
            return true;
        }
        ViewHandler handler = this.myViewHandlerManager.getHandler(parentTagName);
        if (handler == null || handler.getLayoutInspectorProperties().isEmpty()) {
            return false;
        }
        this.myParentInspectors.put(parentTagName, new LayoutInspectorComponent(tagName, properties, propertiesManager, handler.getLayoutInspectorProperties()));
        return true;
    }

    @Override
    @NotNull
    public InspectorComponent<NlPropertiesManager> createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components == null) {
            LayoutInspectorProvider.$$$reportNull$$$0(4);
        }
        if (properties == null) {
            LayoutInspectorProvider.$$$reportNull$$$0(5);
        }
        if (propertiesManager == null) {
            LayoutInspectorProvider.$$$reportNull$$$0(6);
        }
        assert (components.size() >= 1);
        String parentTagName = LayoutInspectorProvider.getParentTagName(components);
        InspectorComponent<NlPropertiesManager> inspector = this.myParentInspectors.get(parentTagName);
        assert (inspector != null);
        inspector.updateProperties(components, properties, propertiesManager);
        InspectorComponent<NlPropertiesManager> inspectorComponent = inspector;
        if (inspectorComponent == null) {
            LayoutInspectorProvider.$$$reportNull$$$0(7);
        }
        return inspectorComponent;
    }

    @Override
    public void resetCache() {
        this.myParentInspectors.clear();
    }

    @Nullable
    private static String getParentTagName(@NotNull List<NlComponent> components) {
        if (components == null) {
            LayoutInspectorProvider.$$$reportNull$$$0(8);
        }
        String parentTagName = null;
        for (NlComponent component2 : components) {
            if (component2.getParent() == null) {
                return null;
            }
            if (parentTagName != null && !component2.getParent().getTagName().equals(parentTagName)) {
                return null;
            }
            parentTagName = component2.getParent().getTagName();
        }
        return parentTagName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/inspector/LayoutInspectorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/inspector/LayoutInspectorProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomInspector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCustomInspector";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParentTagName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LayoutInspectorComponent
    implements InspectorComponent<NlPropertiesManager> {
        private final String myTagName;
        private final List<String> myPropertyNames;
        private final List<NlComponentEditor> myEditors;

        LayoutInspectorComponent(@NotNull String tagName, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager, @NotNull List<String> propertyNames) {
            if (tagName == null) {
                LayoutInspectorComponent.$$$reportNull$$$0(0);
            }
            if (properties == null) {
                LayoutInspectorComponent.$$$reportNull$$$0(1);
            }
            if (propertiesManager == null) {
                LayoutInspectorComponent.$$$reportNull$$$0(2);
            }
            if (propertyNames == null) {
                LayoutInspectorComponent.$$$reportNull$$$0(3);
            }
            this.myPropertyNames = propertyNames;
            this.myTagName = tagName;
            this.myEditors = new ArrayList<NlComponentEditor>(propertyNames.size());
            this.createEditors(properties, propertiesManager);
        }

        private void createEditors(@NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (properties == null) {
                LayoutInspectorComponent.$$$reportNull$$$0(4);
            }
            if (propertiesManager == null) {
                LayoutInspectorComponent.$$$reportNull$$$0(5);
            }
            for (String propertyName : this.myPropertyNames) {
                NlProperty property = properties.get(propertyName = StringUtil.trimStart((String)propertyName, (String)"tools:"));
                if (property == null) continue;
                NlComponentEditor editor = propertiesManager.getPropertyEditors().create(property);
                editor.setProperty(property);
                this.myEditors.add(editor);
            }
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            if (components == null) {
                LayoutInspectorComponent.$$$reportNull$$$0(6);
            }
            if (properties == null) {
                LayoutInspectorComponent.$$$reportNull$$$0(7);
            }
            if (propertiesManager == null) {
                LayoutInspectorComponent.$$$reportNull$$$0(8);
            }
            this.myEditors.clear();
            this.createEditors(properties, propertiesManager);
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            List<NlComponentEditor> list = this.myEditors;
            if (list == null) {
                LayoutInspectorComponent.$$$reportNull$$$0(9);
            }
            return list;
        }

        @Override
        public int getMaxNumberOfRows() {
            return 1 + this.myEditors.size();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            if (inspector == null) {
                LayoutInspectorComponent.$$$reportNull$$$0(10);
            }
            this.refresh();
            inspector.addTitle(this.myTagName);
            for (NlComponentEditor editor : this.myEditors) {
                NlProperty property = editor.getProperty();
                String propertyName = property.getName();
                JLabel label = inspector.addComponent(propertyName, property.getTooltipText(), editor.getComponent());
                if ("http://schemas.android.com/tools".equals(property.getNamespace())) {
                    label.setIcon(StudioIcons.LayoutEditor.Properties.DESIGN_PROPERTY);
                }
                editor.setLabel(label);
            }
        }

        @Override
        public void refresh() {
            this.myEditors.forEach(NlComponentEditor::refresh);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tagName";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertiesManager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyNames";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "components";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/property/inspector/LayoutInspectorProvider$LayoutInspectorComponent";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/property/inspector/LayoutInspectorProvider$LayoutInspectorComponent";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createEditors";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "updateProperties";
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "attachToInspector";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

