/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class MarqueeInteraction
extends Interaction {
    private MarqueeLayer myOverlay;
    private final SceneView mySceneView;
    private final Collection<NlComponent> myInitialSelection;

    public MarqueeInteraction(@NotNull SceneView surface, boolean toggle) {
        if (surface == null) {
            MarqueeInteraction.$$$reportNull$$$0(0);
        }
        this.mySceneView = surface;
        this.myInitialSelection = toggle ? this.mySceneView.getSelectionModel().getSelection() : Collections.emptySet();
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiers) {
        if (this.myOverlay == null) {
            return;
        }
        int xp = Math.min(x, this.myStartX);
        int yp = Math.min(y, this.myStartY);
        int w = Math.abs(x - this.myStartX);
        int h = Math.abs(y - this.myStartY);
        this.myOverlay.updateSize(xp, yp, w, h);
        int ax = Coordinates.getAndroidXDip(this.mySceneView, xp);
        int ay = Coordinates.getAndroidYDip(this.mySceneView, yp);
        int aw = Coordinates.getAndroidDimensionDip(this.mySceneView, w);
        int ah = Coordinates.getAndroidDimensionDip(this.mySceneView, h);
        List<SceneComponent> within = this.mySceneView.getScene().findWithin(ax, ay, aw, ah);
        List<NlComponent> result = within.stream().map(SceneComponent::getNlComponent).collect(Collectors.toList());
        this.mySceneView.getSelectionModel().setSelection(result);
        this.mySceneView.getSurface().repaint();
    }

    @Override
    public List<Layer> createOverlays() {
        this.myOverlay = new MarqueeLayer();
        return Collections.singletonList(this.myOverlay);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/surface/MarqueeInteraction", "<init>"));
    }

    private static class MarqueeLayer
    extends Layer {
        public int x;
        public int y;
        public int w;
        public int h;

        MarqueeLayer() {
        }

        public void updateSize(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        @Override
        public void create() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void paint(@NotNull Graphics2D gc) {
            if (gc == null) {
                MarqueeLayer.$$$reportNull$$$0(0);
            }
            NlGraphics.drawFilledRect(NlDrawingStyle.SELECTION, gc, this.x, this.y, this.w, this.h);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/android/tools/idea/uibuilder/surface/MarqueeInteraction$MarqueeLayer", "paint"));
        }
    }
}

