/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.DependencyManagementException;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactVersion;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a<\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\n2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u0006H\u0007\u001a\u0012\u0010\u000e\u001a\u00020\u0006*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0004\u00a8\u0006\u0010\u00b2\u0006\f\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u008a\u0084\u0002"}, d2={"createAddDependencyMessage", "", "artifactIds", "", "Lcom/android/tools/idea/projectsystem/GoogleMavenArtifactId;", "userWantsToAdd", "", "project", "Lcom/intellij/openapi/project/Project;", "addDependencies", "Lcom/intellij/openapi/module/Module;", "promptUserBeforeAdding", "requestSync", "includePreview", "dependsOn", "artifactId", "intellij.android", "platformSupportLibVersion", "Lcom/android/tools/idea/projectsystem/GoogleMavenArtifactVersion;"})
@JvmName(name="DependencyManagementUtil")
public final class DependencyManagementUtil {
    static final /* synthetic */ KProperty[] $$delegatedProperties;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(DependencyManagementUtil.class, (String)"intellij.android"), "platformSupportLibVersion", "<v#0>"))};
    }

    public static final boolean dependsOn(@NotNull Module $receiver, @NotNull GoogleMavenArtifactId artifactId) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)((Object)artifactId), (String)"artifactId");
        try {
            Project project = $receiver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            return ProjectSystemUtil.getProjectSystem(project).getModuleSystem($receiver).getResolvedVersion(artifactId) != null;
        }
        catch (DependencyManagementException e) {
            Logger.getInstance((String)$receiver.getClass().getName()).warn(e.getMessage());
            return false;
        }
    }

    @JvmOverloads
    @NotNull
    public static final List<GoogleMavenArtifactId> addDependencies(@NotNull Module $receiver, @NotNull List<? extends GoogleMavenArtifactId> artifactIds, boolean promptUserBeforeAdding, boolean requestSync, boolean includePreview) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(artifactIds, (String)"artifactIds");
        if (artifactIds.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List distinctArtifactIds = CollectionsKt.distinct((Iterable)artifactIds);
        if (promptUserBeforeAdding) {
            Project project = $receiver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            if (!DependencyManagementUtil.userWantsToAdd(project, distinctArtifactIds)) {
                return distinctArtifactIds;
            }
        }
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem($receiver);
        List artifactsNotAdded = new ArrayList();
        KProperty kProperty = $$delegatedProperties[0];
        Lazy platformSupportLibVersion2 = LazyKt.lazy((Function0)((Function0)new Function0<GoogleMavenArtifactVersion>(moduleSystem){
            final /* synthetic */ AndroidModuleSystem $moduleSystem;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final GoogleMavenArtifactVersion invoke() {
                void var3_3;
                GoogleMavenArtifactId it;
                Object $receiver$iv$iv;
                Object $receiver$iv = GoogleMavenArtifactId.values();
                GoogleMavenArtifactId[] googleMavenArtifactIdArray = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    it = element$iv$iv;
                    if (!it.isPlatformSupportLibrary()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>();
                Object $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator<T> iterator = $receiver$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    GoogleMavenArtifactVersion googleMavenArtifactVersion;
                    T element$iv$iv;
                    T element$iv$iv$iv = iterator.next();
                    element$iv$iv = element$iv$iv$iv;
                    it = (GoogleMavenArtifactId)((Object)element$iv$iv);
                    if (this.$moduleSystem.getDeclaredVersion(it) == null) continue;
                    GoogleMavenArtifactVersion it$iv$iv = googleMavenArtifactVersion;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (GoogleMavenArtifactVersion)CollectionsKt.firstOrNull((List)((List)var3_3));
            }
            {
                this.$moduleSystem = androidModuleSystem;
                super(0);
            }
        }));
        for (GoogleMavenArtifactId id : distinctArtifactIds) {
            try {
                if (id.isPlatformSupportLibrary()) {
                    Lazy lazy = platformSupportLibVersion2;
                    Object var13_14 = null;
                    GoogleMavenArtifactId googleMavenArtifactId = id;
                    AndroidModuleSystem androidModuleSystem = moduleSystem;
                    Object object = lazy.getValue();
                    AndroidModuleSystem.DefaultImpls.addDependencyWithoutSync$default(androidModuleSystem, googleMavenArtifactId, (GoogleMavenArtifactVersion)object, false, 4, null);
                    continue;
                }
                moduleSystem.addDependencyWithoutSync(id, null, includePreview);
            }
            catch (DependencyManagementException e) {
                Logger.getInstance((String)$receiver.getClass().getName()).warn(e.getMessage());
                artifactsNotAdded.add(id);
            }
        }
        if (requestSync && distinctArtifactIds.size() != artifactsNotAdded.size()) {
            Project project = $receiver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            ProjectSystemUtil.getSyncManager(project).syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED, true);
        }
        return artifactsNotAdded;
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ List addDependencies$default(Module module, List list, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        return DependencyManagementUtil.addDependencies(module, list, bl, bl2, bl3);
    }

    @JvmOverloads
    @NotNull
    public static final List<GoogleMavenArtifactId> addDependencies(@NotNull Module $receiver, @NotNull List<? extends GoogleMavenArtifactId> artifactIds, boolean promptUserBeforeAdding, boolean requestSync) {
        return DependencyManagementUtil.addDependencies$default($receiver, artifactIds, promptUserBeforeAdding, requestSync, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public static final List<GoogleMavenArtifactId> addDependencies(@NotNull Module $receiver, @NotNull List<? extends GoogleMavenArtifactId> artifactIds, boolean promptUserBeforeAdding) {
        return DependencyManagementUtil.addDependencies$default($receiver, artifactIds, promptUserBeforeAdding, false, false, 12, null);
    }

    private static final boolean userWantsToAdd(Project project, List<? extends GoogleMavenArtifactId> artifactIds) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return true;
        }
        return Messages.showOkCancelDialog((Project)project, (String)DependencyManagementUtil.createAddDependencyMessage(artifactIds), (String)"Add Project Dependency", (Icon)Messages.getErrorIcon()) == 0;
    }

    @NotNull
    public static final String createAddDependencyMessage(@NotNull List<? extends GoogleMavenArtifactId> artifactIds) {
        Intrinsics.checkParameterIsNotNull(artifactIds, (String)"artifactIds");
        String libraryNames2 = CollectionsKt.joinToString$default((Iterable)artifactIds, (CharSequence)", ", null, null, (int)0, null, (Function1)createAddDependencyMessage.libraryNames.1.INSTANCE, (int)30, null);
        return "This operation requires the " + StringUtil.pluralize((String)"library", (int)artifactIds.size()) + ' ' + libraryNames2 + ". \n\n" + "Would you like to add " + StringUtil.pluralize((String)"this", (int)artifactIds.size()) + " now?";
    }
}

