/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.welcome.install.ComponentCategory;
import com.android.tools.idea.welcome.install.ComponentTreeNode;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.wizard.deprecated.InstallComponentsPath;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Platform
extends InstallableComponent {
    private final AndroidVersion myVersion;
    private final boolean myIsDefaultPlatform;

    public Platform(@NotNull ScopedStateStore store, @NotNull String name, @NotNull String description, AndroidVersion version, boolean isDefaultPlatform, boolean installUpdates) {
        if (store == null) {
            Platform.$$$reportNull$$$0(0);
        }
        if (name == null) {
            Platform.$$$reportNull$$$0(1);
        }
        if (description == null) {
            Platform.$$$reportNull$$$0(2);
        }
        super(store, name, description, installUpdates, FileOpUtils.create());
        this.myVersion = version;
        this.myIsDefaultPlatform = isDefaultPlatform;
    }

    @Nullable
    private static Platform getLatestPlatform(@NotNull ScopedStateStore store, @Nullable Map<String, RemotePackage> remotePackages, boolean installUpdates) {
        RemotePackage latest;
        if (store == null) {
            Platform.$$$reportNull$$$0(3);
        }
        if ((latest = InstallComponentsPath.findLatestPlatform(remotePackages)) != null) {
            AndroidVersion version = ((DetailsTypes.PlatformDetailsType)latest.getTypeDetails()).getAndroidVersion();
            String versionName = SdkVersionInfo.getAndroidName((int)version.getFeatureLevel());
            String description = "Android platform libraries for targeting " + versionName + " platform";
            return new Platform(store, versionName, description, version, !version.isPreview(), installUpdates);
        }
        return null;
    }

    @NotNull
    private static List<AndroidVersion> getInstalledPlatformVersions(@Nullable AndroidSdkHandler handler) {
        ArrayList result = Lists.newArrayList();
        if (handler != null) {
            RepositoryPackages packages = handler.getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(Platform.class)).getPackages();
            for (LocalPackage p : packages.getLocalPackages().values()) {
                if (!(p.getTypeDetails() instanceof DetailsTypes.PlatformDetailsType)) continue;
                result.add(((DetailsTypes.PlatformDetailsType)p.getTypeDetails()).getAndroidVersion());
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            Platform.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public static ComponentTreeNode createSubtree(@NotNull ScopedStateStore store, @Nullable Map<String, RemotePackage> remotePackages, boolean installUpdates) {
        Platform latestPlatform;
        if (store == null) {
            Platform.$$$reportNull$$$0(5);
        }
        if ((latestPlatform = Platform.getLatestPlatform(store, remotePackages, installUpdates)) != null) {
            return new ComponentCategory("Android SDK Platform", "SDK components for creating applications for different Android platforms", latestPlatform);
        }
        return null;
    }

    @Override
    @NotNull
    protected Collection<String> getRequiredSdkPackages() {
        ArrayList requests = Lists.newArrayList((Object[])new String[]{DetailsTypes.getPlatformPath((AndroidVersion)this.myVersion), DetailsTypes.getSourcesPath((AndroidVersion)this.myVersion)});
        String buildTool = this.findLatestCompatibleBuildTool();
        if (buildTool != null) {
            requests.add(buildTool);
        }
        ArrayList arrayList = requests;
        if (arrayList == null) {
            Platform.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private String findLatestCompatibleBuildTool() {
        Revision revision = null;
        String path = null;
        for (RemotePackage remote : this.getRepositoryPackages().getRemotePackages().values()) {
            Revision testRevision;
            if (!remote.getPath().startsWith("build-tools") || (testRevision = remote.getVersion()).getMajor() != this.myVersion.getApiLevel() || revision != null && testRevision.compareTo(revision) <= 0) continue;
            revision = testRevision;
            path = remote.getPath();
        }
        return path;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
        if (installContext == null) {
            Platform.$$$reportNull$$$0(7);
        }
        if (sdkHandler == null) {
            Platform.$$$reportNull$$$0(8);
        }
    }

    @Override
    public boolean isOptionalForSdkLocation() {
        List<AndroidVersion> locals = Platform.getInstalledPlatformVersions(this.mySdkHandler);
        if (locals.isEmpty()) {
            return !this.myIsDefaultPlatform;
        }
        for (AndroidVersion androidVersion : locals) {
            int apiLevel;
            int n = apiLevel = androidVersion == null ? 0 : androidVersion.getApiLevel();
            if (this.myVersion.getFeatureLevel() != apiLevel) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSelectedByDefault() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "store";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/welcome/install/Platform";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/welcome/install/Platform";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledPlatformVersions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredSdkPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLatestPlatform";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createSubtree";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

