/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.welcome.config.AndroidFirstRunPersistentData;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.wizard.ConfirmFirstRunWizardCloseDialog;
import com.android.tools.idea.welcome.wizard.FirstRunWelcomeStep;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class StudioFirstRunWelcomeScreen
implements WelcomeScreen {
    @NotNull
    private final ModelWizard myModelWizard;
    @NotNull
    private final JComponent myMainPanel;
    private final FirstRunWizardMode myMode;

    public StudioFirstRunWelcomeScreen(FirstRunWizardMode mode) {
        this.myMode = mode;
        ModelWizard.Builder wizardBuilder = new ModelWizard.Builder(new ModelWizardStep[0]);
        boolean sdkExists = false;
        File initialSdkLocation = FirstRunWizardDefaults.getInitialSdkLocation(mode);
        if (initialSdkLocation.isDirectory()) {
            StudioLoggerProgressIndicator progress;
            AndroidSdkHandler sdkHandler = AndroidSdkHandler.getInstance((File)initialSdkLocation);
            sdkExists = sdkHandler.getLocalPackage("tools", (ProgressIndicator)(progress = new StudioLoggerProgressIndicator(this.getClass()))) != null;
        }
        this.myModelWizard = new ModelWizard.Builder(new ModelWizardStep[0]).addStep(new FirstRunWelcomeStep(sdkExists)).build();
        ModelWizardDialog modelWizardDialog = new StudioWizardDialogBuilder(this.myModelWizard, "").build();
        this.myMainPanel = modelWizardDialog.getContentPanel();
        modelWizardDialog.getPeer().setContentPane((JComponent)new JPanel());
        Disposer.register((Disposable)this, (Disposable)modelWizardDialog.getDisposable());
        Disposer.register((Disposable)this, (Disposable)this.myModelWizard);
    }

    public JComponent getWelcomePanel() {
        return this.myMainPanel;
    }

    public void setupFrame(final @NotNull JFrame frame) {
        if (frame == null) {
            StudioFirstRunWelcomeScreen.$$$reportNull$$$0(0);
        }
        frame.setTitle(AndroidBundle.message("android.wizard.welcome.dialog.title", new Object[0]));
        frame.pack();
        frame.setLocationRelativeTo(null);
        WindowListener[] oldIdeaListeners = StudioFirstRunWelcomeScreen.removeAllWindowListeners(frame);
        frame.addWindowListener(new DelegatingListener(oldIdeaListeners));
        this.myModelWizard.addResultListener(new ModelWizard.WizardListener(){

            @Override
            public void onWizardFinished(@NotNull ModelWizard.WizardResult wizardResult) {
                if (wizardResult == null) {
                    1.$$$reportNull$$$0(0);
                }
                StudioFirstRunWelcomeScreen.closeDialog(frame);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardResult", "com/android/tools/idea/welcome/wizard/StudioFirstRunWelcomeScreen$1", "onWizardFinished"));
            }
        });
        this.myModelWizard.setCancelInterceptor(() -> {
            if (frame == null) {
                StudioFirstRunWelcomeScreen.$$$reportNull$$$0(1);
            }
            return this.shouldPreventWizardCancel(frame);
        });
    }

    public void dispose() {
    }

    private static void closeDialog(Window frame) {
        frame.setVisible(false);
        frame.dispose();
        WelcomeFrame.showNow();
    }

    private boolean shouldPreventWizardCancel(Window frame) {
        ConfirmFirstRunWizardCloseDialog.Result result = new ConfirmFirstRunWizardCloseDialog().open();
        switch (result) {
            case Skip: {
                AndroidFirstRunPersistentData.getInstance().markSdkUpToDate(this.myMode.getInstallerTimestamp());
            }
            case Rerun: {
                StudioFirstRunWelcomeScreen.closeDialog(frame);
                return false;
            }
            case DoNotClose: {
                break;
            }
            default: {
                throw new RuntimeException("Invalid Close result");
            }
        }
        return true;
    }

    private static WindowListener[] removeAllWindowListeners(Window frame) {
        WindowListener[] listeners;
        for (WindowListener listener : listeners = frame.getWindowListeners()) {
            frame.removeWindowListener(listener);
        }
        return listeners;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "frame";
        objectArray2[1] = "com/android/tools/idea/welcome/wizard/StudioFirstRunWelcomeScreen";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupFrame";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$setupFrame$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class DelegatingListener
    implements WindowListener {
        @NotNull
        private final WindowListener[] myIdeaListeners;

        DelegatingListener(WindowListener[] ideaListeners) {
            if (ideaListeners == null) {
                DelegatingListener.$$$reportNull$$$0(0);
            }
            this.myIdeaListeners = ideaListeners;
        }

        @Override
        public void windowOpened(WindowEvent e) {
            for (WindowListener listener : this.myIdeaListeners) {
                listener.windowOpened(e);
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            for (WindowListener listener : this.myIdeaListeners) {
                listener.windowClosed(e);
            }
        }

        @Override
        public void windowIconified(WindowEvent e) {
            for (WindowListener listener : this.myIdeaListeners) {
                listener.windowIconified(e);
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            StudioFirstRunWelcomeScreen.this.myModelWizard.cancel();
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            for (WindowListener listener : this.myIdeaListeners) {
                listener.windowDeiconified(e);
            }
        }

        @Override
        public void windowActivated(WindowEvent e) {
            for (WindowListener listener : this.myIdeaListeners) {
                listener.windowActivated(e);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            for (WindowListener listener : this.myIdeaListeners) {
                listener.windowDeactivated(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaListeners", "com/android/tools/idea/welcome/wizard/StudioFirstRunWelcomeScreen$DelegatingListener", "<init>"));
        }
    }
}

