/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesFetcher;
import com.android.tools.idea.ddms.DeviceNamePropertiesProvider;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.help.StudioHelpManagerImpl;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProcessChooserDialog
extends DialogWrapper {
    @NonNls
    private static final String DEBUGGABLE_PROCESS_PROPERTY = "DEBUGGABLE_PROCESS";
    @NonNls
    private static final String SHOW_ALL_PROCESSES_PROPERTY = "SHOW_ALL_PROCESSES";
    @NonNls
    private static final String DEBUGGABLE_DEVICE_PROPERTY = "DEBUGGABLE_DEVICE";
    @NonNls
    private static final String DEBUGGER_ID_PROPERTY = "DEBUGGER_ID";
    private final Project myProject;
    private final boolean myShowDebuggerSelection;
    private final MyProcessTreeCellRenderer myCellRenderer;
    private JPanel myContentPanel;
    private Tree myProcessTree;
    private JBCheckBox myShowAllProcessesCheckBox;
    private JComboBox myDebuggerTypeCombo;
    private JLabel myDebuggerLabel;
    private String myLastSelectedDevice;
    private String myLastSelectedProcess;
    private final MergingUpdateQueue myUpdatesQueue;
    private final AndroidDebugBridge.IClientChangeListener myClientChangeListener;
    private final AndroidDebugBridge.IDeviceChangeListener myDeviceChangeListener;
    private Client mySelectedClient;
    private AndroidDebugger myAndroidDebugger;

    public AndroidProcessChooserDialog(@NotNull Project project, boolean showDebuggerSelection) {
        if (project == null) {
            AndroidProcessChooserDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.$$$setupUI$$$();
        this.setTitle("Choose Process");
        this.myShowDebuggerSelection = showDebuggerSelection;
        this.myProject = project;
        this.myUpdatesQueue = new MergingUpdateQueue("AndroidProcessChooserDialogUpdatingQueue", 500, true, MergingUpdateQueue.ANY_COMPONENT, this.getDisposable());
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        this.myLastSelectedProcess = properties.getValue(DEBUGGABLE_PROCESS_PROPERTY);
        this.myLastSelectedDevice = properties.getValue(DEBUGGABLE_DEVICE_PROPERTY);
        String lastSelectedDebuggerId = properties.getValue(DEBUGGER_ID_PROPERTY);
        boolean showAllProcesses = Boolean.parseBoolean(properties.getValue(SHOW_ALL_PROCESSES_PROPERTY));
        this.myShowAllProcessesCheckBox.setSelected(showAllProcesses);
        this.myClientChangeListener = (client, changeMask) -> this.updateTree();
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this.myClientChangeListener);
        this.myDeviceChangeListener = new AndroidDebugBridge.IDeviceChangeListener(){

            public void deviceConnected(@NotNull IDevice device) {
                if (device == null) {
                    1.$$$reportNull$$$0(0);
                }
                AndroidProcessChooserDialog.this.updateTree();
            }

            public void deviceDisconnected(@NotNull IDevice device) {
                if (device == null) {
                    1.$$$reportNull$$$0(1);
                }
                AndroidProcessChooserDialog.this.updateTree();
            }

            public void deviceChanged(@NotNull IDevice device, int changeMask) {
                if (device == null) {
                    1.$$$reportNull$$$0(2);
                }
                AndroidProcessChooserDialog.this.updateTree();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "device";
                objectArray2[1] = "org/jetbrains/android/actions/AndroidProcessChooserDialog$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "deviceConnected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "deviceDisconnected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "deviceChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
        this.myShowAllProcessesCheckBox.addActionListener(e -> this.updateTree());
        this.setupDebuggerSelection(showDebuggerSelection, lastSelectedDebuggerId);
        this.myProcessTree.addTreeSelectionListener(e -> {
            IDevice selectedDevice = this.getSelectedDevice();
            Client selectedClient = this.getSelectedClient();
            this.myLastSelectedDevice = AndroidProcessChooserDialog.getPersistableName(selectedDevice);
            this.myLastSelectedProcess = AndroidProcessChooserDialog.getPersistableName(selectedClient);
            this.getOKAction().setEnabled(selectedDevice != null && selectedClient != null);
        });
        TreeSpeedSearch treeSpeedSearch = new TreeSpeedSearch((JTree)this.myProcessTree){

            protected boolean isMatchingElement(Object element, String pattern) {
                Object userObject;
                Object lastComponent;
                if (element instanceof TreePath && (lastComponent = ((TreePath)element).getLastPathComponent()) instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)lastComponent).getUserObject()) instanceof Client) {
                    String pkg = ((Client)userObject).getClientData().getClientDescription();
                    return pkg != null && pkg.contains(pattern);
                }
                return false;
            }
        };
        this.myCellRenderer = new MyProcessTreeCellRenderer(treeSpeedSearch, DeviceRenderer.shouldShowSerialNumbers(this.getDeviceList()), new DeviceNamePropertiesFetcher(new FutureCallback<DeviceNameProperties>(){

            public void onSuccess(@Nullable DeviceNameProperties result) {
                AndroidProcessChooserDialog.this.updateTree();
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                Logger.getInstance(AndroidProcessChooserDialog.class).warn("Error retrieving device name properties", t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "org/jetbrains/android/actions/AndroidProcessChooserDialog$3", "onFailure"));
            }
        }, this.getDisposable()));
        this.myProcessTree.setCellRenderer((TreeCellRenderer)((Object)this.myCellRenderer));
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                if (AndroidProcessChooserDialog.this.isOKActionEnabled()) {
                    AndroidProcessChooserDialog.this.doOKAction();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myProcessTree);
        this.myProcessTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && AndroidProcessChooserDialog.this.isOKActionEnabled()) {
                    AndroidProcessChooserDialog.this.doOKAction();
                }
            }
        });
        this.doUpdateTree(showAllProcesses);
        this.init();
    }

    private void setupDebuggerSelection(boolean showDebuggerSelection, @Nullable String lastSelectedDebuggerId) {
        if (!showDebuggerSelection) {
            this.myDebuggerLabel.setVisible(false);
            this.myDebuggerTypeCombo.setVisible(false);
            return;
        }
        AndroidDebugger selectedDebugger = null;
        AndroidDebugger defaultDebugger = null;
        LinkedList androidDebuggers = Lists.newLinkedList();
        for (AndroidDebugger androidDebugger : (AndroidDebugger[])AndroidDebugger.EP_NAME.getExtensions()) {
            if (!androidDebugger.supportsProject(this.myProject)) continue;
            androidDebuggers.add(androidDebugger);
            if (selectedDebugger == null && lastSelectedDebuggerId != null && androidDebugger.getId().equals(lastSelectedDebuggerId)) {
                selectedDebugger = androidDebugger;
                continue;
            }
            if (!androidDebugger.shouldBeDefault()) continue;
            defaultDebugger = androidDebugger;
        }
        if (selectedDebugger == null) {
            selectedDebugger = defaultDebugger;
        }
        androidDebuggers.sort((left, right) -> left.getId().compareTo(right.getId()));
        this.myDebuggerTypeCombo.setModel(new CollectionComboBoxModel((List)androidDebuggers));
        this.myDebuggerTypeCombo.setRenderer(new AndroidDebugger.Renderer());
        if (selectedDebugger != null) {
            this.myDebuggerTypeCombo.setSelectedItem(selectedDebugger);
        }
    }

    @NotNull
    private static String getPersistableName(@Nullable Client client) {
        String string = client == null ? "" : client.getClientData().getClientDescription();
        if (string == null) {
            AndroidProcessChooserDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String getPersistableName(@Nullable IDevice device) {
        String string = device == null ? "" : device.getName();
        if (string == null) {
            AndroidProcessChooserDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myProcessTree;
    }

    @Nullable
    protected String getHelpId() {
        return StudioHelpManagerImpl.STUDIO_HELP_PREFIX + "studio/debug/index.html";
    }

    protected void dispose() {
        super.dispose();
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
        AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this.myClientChangeListener);
    }

    private void updateTree() {
        final boolean showAllProcesses = this.myShowAllProcessesCheckBox.isSelected();
        this.myUpdatesQueue.queue(new Update((Object)this){

            public void run() {
                AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge(AndroidProcessChooserDialog.this.myProject);
                if (debugBridge != null && AdbService.isDdmsCorrupted(debugBridge)) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        Messages.showErrorDialog((Component)AndroidProcessChooserDialog.this.myContentPanel, (String)AndroidBundle.message("ddms.corrupted.error", new Object[0]));
                        AndroidProcessChooserDialog.this.close(1);
                    });
                    return;
                }
                AndroidProcessChooserDialog.this.doUpdateTree(showAllProcesses);
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
    }

    private List<IDevice> getDeviceList() {
        AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge(this.myProject);
        if (debugBridge == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(debugBridge.getDevices());
    }

    private void doUpdateTree(boolean showAllProcesses) {
        IDevice[] devices;
        AndroidDebugBridge debugBridge = AndroidSdkUtils.getDebugBridge(this.myProject);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultTreeModel model = new DefaultTreeModel(root);
        if (debugBridge == null) {
            this.myProcessTree.setModel((TreeModel)model);
            return;
        }
        Set<String> processNames = AndroidProcessChooserDialog.collectAllProcessNames(this.myProject);
        DefaultMutableTreeNode selectedDeviceNode = null;
        DefaultMutableTreeNode selectedClientNode = null;
        Object[] firstTreePath = null;
        for (IDevice device : devices = debugBridge.getDevices()) {
            DefaultMutableTreeNode deviceNode = new DefaultMutableTreeNode(device);
            root.add(deviceNode);
            String deviceName = device.getName();
            if (deviceName.equals(this.myLastSelectedDevice)) {
                selectedDeviceNode = deviceNode;
            }
            ArrayList clients = Lists.newArrayList((Object[])device.getClients());
            Collections.sort(clients, (c1, c2) -> {
                String n1 = StringUtil.notNullize((String)c1.getClientData().getClientDescription());
                String n2 = StringUtil.notNullize((String)c2.getClientData().getClientDescription());
                return n1.compareTo(n2);
            });
            for (Client client : clients) {
                String clientDescription = client.getClientData().getClientDescription();
                if (clientDescription == null || !showAllProcesses && !AndroidProcessChooserDialog.isRelatedProcess(processNames, clientDescription)) continue;
                DefaultMutableTreeNode clientNode = new DefaultMutableTreeNode(client);
                deviceNode.add(clientNode);
                if (clientDescription.equals(this.myLastSelectedProcess) && (selectedDeviceNode == null || deviceName.equals(this.myLastSelectedDevice))) {
                    selectedClientNode = clientNode;
                    selectedDeviceNode = deviceNode;
                }
                if (firstTreePath != null) continue;
                firstTreePath = new Object[]{root, deviceNode, clientNode};
            }
        }
        Object[] pathToSelect = selectedDeviceNode != null && selectedClientNode != null ? new Object[]{root, selectedDeviceNode, selectedClientNode} : (selectedDeviceNode != null ? new Object[]{root, selectedDeviceNode} : firstTreePath);
        this.myCellRenderer.setShowSerial(DeviceRenderer.shouldShowSerialNumbers(Arrays.asList(devices)));
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myProcessTree.setModel((TreeModel)model);
            if (pathToSelect != null) {
                this.myProcessTree.getSelectionModel().setSelectionPath(new TreePath(pathToSelect));
            } else {
                this.getOKAction().setEnabled(false);
            }
            TreeUtil.expandAll((JTree)this.myProcessTree);
        });
    }

    private static boolean isRelatedProcess(Set<String> processNames, String clientDescription) {
        String lc = clientDescription.toLowerCase();
        for (String processName : processNames) {
            if (!lc.startsWith(processName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Set<String> collectAllProcessNames(Project project) {
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        HashSet result = new HashSet();
        for (AndroidFacet facet : facets) {
            AndroidModel androidModel;
            XmlElement xmlElement;
            Manifest manifest;
            String packageName = AndroidCompileUtil.getAaptManifestPackage(facet);
            if (packageName != null) {
                result.add(packageName.toLowerCase());
            }
            if ((manifest = facet.getManifest()) != null && (xmlElement = manifest.getXmlElement()) != null) {
                AndroidProcessChooserDialog.collectProcessNames(xmlElement, (Set<String>)result);
            }
            if ((androidModel = facet.getAndroidModel()) == null) continue;
            result.addAll(androidModel.getAllApplicationIds());
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            AndroidProcessChooserDialog.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static void collectProcessNames(XmlElement xmlElement, final Set<String> result) {
        xmlElement.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                String value;
                if ("process".equals(attribute.getLocalName()) && (value = attribute.getValue()) != null) {
                    result.add(value.toLowerCase());
                }
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    protected void doOKAction() {
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        IDevice selectedDevice = this.getSelectedDevice();
        if (selectedDevice == null) {
            return;
        }
        this.mySelectedClient = this.getSelectedClient();
        if (this.mySelectedClient == null) {
            return;
        }
        this.myAndroidDebugger = (AndroidDebugger)this.myDebuggerTypeCombo.getSelectedItem();
        properties.setValue(DEBUGGABLE_DEVICE_PROPERTY, AndroidProcessChooserDialog.getPersistableName(selectedDevice));
        properties.setValue(DEBUGGABLE_PROCESS_PROPERTY, AndroidProcessChooserDialog.getPersistableName(this.mySelectedClient));
        properties.setValue(SHOW_ALL_PROCESSES_PROPERTY, Boolean.toString(this.myShowAllProcessesCheckBox.isSelected()));
        if (this.myAndroidDebugger != null) {
            properties.setValue(DEBUGGER_ID_PROPERTY, this.myAndroidDebugger.getId());
        }
        super.doOKAction();
    }

    @Nullable
    public Client getClient() {
        return this.mySelectedClient;
    }

    @NotNull
    public AndroidDebugger getAndroidDebugger() {
        assert (this.myShowDebuggerSelection) : "Cannot obtain debugger after constructing dialog w/o debugger selection combo";
        AndroidDebugger androidDebugger = this.myAndroidDebugger;
        if (androidDebugger == null) {
            AndroidProcessChooserDialog.$$$reportNull$$$0(4);
        }
        return androidDebugger;
    }

    protected String getDimensionServiceKey() {
        return "AndroidProcessChooserDialog";
    }

    @Nullable
    private IDevice getSelectedDevice() {
        TreePath selectionPath = this.myProcessTree.getSelectionPath();
        if (selectionPath == null || selectionPath.getPathCount() < 2) {
            return null;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selectionPath.getPathComponent(1);
        Object obj = selectedNode.getUserObject();
        return obj instanceof IDevice ? (IDevice)obj : null;
    }

    @Nullable
    private Client getSelectedClient() {
        TreePath selectionPath = this.myProcessTree.getSelectionPath();
        if (selectionPath == null || selectionPath.getPathCount() < 3) {
            return null;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selectionPath.getPathComponent(2);
        Object obj = selectedNode.getUserObject();
        return obj instanceof Client ? (Client)obj : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/actions/AndroidProcessChooserDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/actions/AndroidProcessChooserDialog";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistableName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllProcessNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidDebugger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JLabel jLabel;
        JBCheckBox jBCheckBox;
        Tree tree;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Select a process to attach to:");
        jBLabel.setDisplayedMnemonic('S');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(250, 300), null));
        this.myProcessTree = tree = new Tree();
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        jBScrollPane.setViewportView((Component)tree);
        this.myShowAllProcessesCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Show all processes");
        jBCheckBox.setMnemonic('A');
        jBCheckBox.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myDebuggerLabel = jLabel = new JLabel();
        jLabel.setText("Debugger:");
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDebuggerTypeCombo = jComboBox = new JComboBox();
        ((Component)jComboBox).setEnabled(true);
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jBLabel.setLabelFor((Component)jBScrollPane);
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private static class MyProcessTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final TreeSpeedSearch mySpeedSearch;
        private boolean myShowSerial;
        private DeviceNamePropertiesProvider myDeviceNamePropertiesProvider;

        MyProcessTreeCellRenderer(@NotNull TreeSpeedSearch treeSpeedSearch, boolean showSerial, @NotNull DeviceNamePropertiesProvider deviceNamePropertiesProvider) {
            if (treeSpeedSearch == null) {
                MyProcessTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if (deviceNamePropertiesProvider == null) {
                MyProcessTreeCellRenderer.$$$reportNull$$$0(1);
            }
            this.mySpeedSearch = treeSpeedSearch;
            this.myShowSerial = showSerial;
            this.myDeviceNamePropertiesProvider = deviceNamePropertiesProvider;
        }

        public void setShowSerial(boolean showSerial) {
            this.myShowSerial = showSerial;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MyProcessTreeCellRenderer.$$$reportNull$$$0(2);
            }
            if (!(value instanceof DefaultMutableTreeNode)) {
                return;
            }
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof IDevice) {
                IDevice device = (IDevice)userObject;
                DeviceRenderer.renderDeviceName(device, this.myDeviceNamePropertiesProvider.get(device), (ColoredTextContainer)this, this.myShowSerial);
            } else if (userObject instanceof Client) {
                ClientData clientData = ((Client)userObject).getClientData();
                SimpleTextAttributes attr = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                SearchUtil.appendFragments((String)this.mySpeedSearch.getEnteredPrefix(), (String)clientData.getClientDescription(), (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)this);
                if (clientData.isValidUserId() && clientData.getUserId() != 0) {
                    this.append(" (user " + Integer.toString(clientData.getUserId()) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeSpeedSearch";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deviceNamePropertiesProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/actions/AndroidProcessChooserDialog$MyProcessTreeCellRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

