/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom;

import com.android.resources.ResourceType;
import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlName;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.attrs.ToolsAttributeDefinitionsImpl;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.converters.CompositeConverter;
import org.jetbrains.android.dom.converters.DimensionConverter;
import org.jetbrains.android.dom.converters.FlagConverter;
import org.jetbrains.android.dom.converters.FragmentClassConverter;
import org.jetbrains.android.dom.converters.IntegerConverter;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.converters.StaticEnumConverter;
import org.jetbrains.android.dom.layout.LayoutViewElement;
import org.jetbrains.android.dom.manifest.Action;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Category;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.Provider;
import org.jetbrains.android.dom.manifest.Receiver;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.dom.menu.MenuItem;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.xml.XmlResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDomUtil {
    public static final StaticEnumConverter BOOLEAN_CONVERTER = new StaticEnumConverter("true", "false");
    private static final Multimap<String, ResourceType> SPECIAL_RESOURCE_TYPES = ArrayListMultimap.create();
    private static final PackageClassConverter ACTIVITY_CONVERTER = new PackageClassConverter("android.app.Activity");
    private static final PackageClassConverter RECYCLER_VIEW_LAYOUT_MANAGER_CONVERTER = new PackageClassConverter(false, true, "android.support.v7.widget.RecyclerView.LayoutManager");
    private static final FragmentClassConverter FRAGMENT_CLASS_CONVERTER = new FragmentClassConverter();
    private static final ToolsAttributeDefinitionsImpl TOOLS_ATTRIBUTE_DEFINITIONS = new ToolsAttributeDefinitionsImpl();
    public static final List<String> AVAILABLE_FAMILIES = ImmutableList.of((Object)"sans-serif", (Object)"sans-serif-condensed", (Object)"serif", (Object)"monospace", (Object)"serif-monospace", (Object)"casual", (Object)"cursive", (Object)"sans-serif-smallcaps");

    private AndroidDomUtil() {
    }

    @Nullable
    public static ResourceType getResourceType(@NotNull AttributeFormat format) {
        if (format == null) {
            AndroidDomUtil.$$$reportNull$$$0(0);
        }
        switch (format) {
            case Color: {
                return ResourceType.COLOR;
            }
            case Dimension: {
                return ResourceType.DIMEN;
            }
            case String: {
                return ResourceType.STRING;
            }
            case Float: 
            case Integer: {
                return ResourceType.INTEGER;
            }
            case Fraction: {
                return ResourceType.FRACTION;
            }
            case Boolean: {
                return ResourceType.BOOL;
            }
        }
        return null;
    }

    @Nullable
    public static ResolvingConverter<String> getStringConverter(@NotNull AttributeFormat format, @NotNull String[] values) {
        if (format == null) {
            AndroidDomUtil.$$$reportNull$$$0(1);
        }
        if (values == null) {
            AndroidDomUtil.$$$reportNull$$$0(2);
        }
        switch (format) {
            case Enum: {
                return new StaticEnumConverter(values);
            }
            case Boolean: {
                return BOOLEAN_CONVERTER;
            }
            case Integer: {
                return IntegerConverter.INSTANCE;
            }
            case Dimension: {
                return DimensionConverter.INSTANCE;
            }
        }
        return null;
    }

    @Nullable
    public static ResourceReferenceConverter getResourceReferenceConverter(@NotNull AttributeDefinition attr) {
        if (attr == null) {
            AndroidDomUtil.$$$reportNull$$$0(3);
        }
        boolean containsReference = false;
        boolean containsNotReference = false;
        EnumSet<ResourceType> resourceTypes = EnumSet.noneOf(ResourceType.class);
        Set<AttributeFormat> formats = attr.getFormats();
        for (AttributeFormat format : formats) {
            ResourceType type;
            if (format == AttributeFormat.Reference) {
                containsReference = true;
            } else {
                containsNotReference = true;
            }
            if ((type = AndroidDomUtil.getResourceType(format)) == null) continue;
            resourceTypes.add(type);
        }
        resourceTypes.addAll(AndroidDomUtil.getSpecialResourceTypes(attr.getName()));
        if (containsReference) {
            if (resourceTypes.contains(ResourceType.COLOR)) {
                resourceTypes.add(ResourceType.DRAWABLE);
            }
            if (resourceTypes.contains(ResourceType.DRAWABLE)) {
                resourceTypes.add(ResourceType.MIPMAP);
            }
            if (resourceTypes.isEmpty()) {
                resourceTypes.addAll(AndroidResourceUtil.REFERRABLE_RESOURCE_TYPES);
            }
        }
        if (!resourceTypes.isEmpty()) {
            ResourceReferenceConverter converter = new ResourceReferenceConverter(resourceTypes, attr);
            converter.setAllowLiterals(containsNotReference);
            return converter;
        }
        return null;
    }

    @Nullable
    public static Converter getSpecificConverter(@NotNull XmlName attrName, DomElement context) {
        if (attrName == null) {
            AndroidDomUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            return null;
        }
        XmlTag xmlTag = context.getXmlTag();
        if (xmlTag == null) {
            return null;
        }
        String localName = attrName.getLocalName();
        String tagName = xmlTag.getName();
        if ("http://schemas.android.com/apk/res/android".equals(attrName.getNamespaceKey())) {
            if (context instanceof XmlResourceElement) {
                if ("configure".equals(localName) && "appwidget-provider".equals(tagName)) {
                    return ACTIVITY_CONVERTER;
                }
                if ("fragment".equals(localName)) {
                    return FRAGMENT_CLASS_CONVERTER;
                }
            } else if ((context instanceof LayoutViewElement || context instanceof MenuItem) && "onClick".equals(localName)) {
                return context instanceof LayoutViewElement ? OnClickConverter.CONVERTER_FOR_LAYOUT : OnClickConverter.CONVERTER_FOR_MENU;
            }
        } else if (localName.equals("layoutManager") && tagName.equals("android.support.v7.widget.RecyclerView")) {
            return RECYCLER_VIEW_LAYOUT_MANAGER_CONVERTER;
        }
        return null;
    }

    @Nullable
    public static ResolvingConverter getConverter(@NotNull AttributeDefinition attr) {
        if (attr == null) {
            AndroidDomUtil.$$$reportNull$$$0(5);
        }
        Set<AttributeFormat> formats = attr.getFormats();
        CompositeConverter.Builder compositeBuilder = new CompositeConverter.Builder();
        String[] values = attr.getValues();
        boolean containsUnsupportedFormats = false;
        if ("fontFamily".equals(attr.getName())) {
            compositeBuilder.addConverter(new StaticEnumConverter(AVAILABLE_FAMILIES).setContainsAllValues(false));
        }
        for (AttributeFormat format : formats) {
            ResolvingConverter<String> converter = AndroidDomUtil.getStringConverter(format, values);
            if (converter != null) {
                compositeBuilder.addConverter(converter);
                continue;
            }
            containsUnsupportedFormats = true;
        }
        if (formats.contains((Object)AttributeFormat.Flag)) {
            return new FlagConverter(compositeBuilder.build(), values);
        }
        ResourceReferenceConverter resConverter = AndroidDomUtil.getResourceReferenceConverter(attr);
        if (resConverter == null && formats.contains((Object)AttributeFormat.Enum)) {
            resConverter = new ResourceReferenceConverter(EnumSet.of(ResourceType.INTEGER), attr);
            resConverter.setQuiet(true);
        }
        ResolvingConverter<String> stringConverter = compositeBuilder.build();
        if (resConverter != null) {
            resConverter.setAdditionalConverter(stringConverter, containsUnsupportedFormats);
            return resConverter;
        }
        return stringConverter;
    }

    @NotNull
    public static Collection<ResourceType> getSpecialResourceTypes(String attrName) {
        Collection type = SPECIAL_RESOURCE_TYPES.get((Object)attrName);
        if (!type.isEmpty()) {
            Collection collection = type;
            if (collection == null) {
                AndroidDomUtil.$$$reportNull$$$0(6);
            }
            return collection;
        }
        if (attrName.endsWith("Animation")) {
            ImmutableList immutableList = ImmutableList.of((Object)ResourceType.ANIM);
            if (immutableList == null) {
                AndroidDomUtil.$$$reportNull$$$0(7);
            }
            return immutableList;
        }
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            AndroidDomUtil.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    static void addSpecialResourceType(ResourceType type, String ... attrs) {
        for (String attr : attrs) {
            SPECIAL_RESOURCE_TYPES.put((Object)attr, (Object)type);
        }
    }

    public static boolean containsAction(@NotNull IntentFilter filter, @NotNull String name) {
        if (filter == null) {
            AndroidDomUtil.$$$reportNull$$$0(9);
        }
        if (name == null) {
            AndroidDomUtil.$$$reportNull$$$0(10);
        }
        for (Action action : filter.getActions()) {
            if (!name.equals(action.getName().getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsCategory(@NotNull IntentFilter filter, @NotNull String name) {
        if (filter == null) {
            AndroidDomUtil.$$$reportNull$$$0(11);
        }
        if (name == null) {
            AndroidDomUtil.$$$reportNull$$$0(12);
        }
        for (Category category : filter.getCategories()) {
            if (!name.equals(category.getName().getValue())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Activity getActivityDomElementByClass(@NotNull List<Activity> activities, PsiClass c) {
        if (activities == null) {
            AndroidDomUtil.$$$reportNull$$$0(13);
        }
        for (Activity activity : activities) {
            PsiClass activityClass = (PsiClass)activity.getActivityClass().getValue();
            if (!c.getManager().areElementsEquivalent((PsiElement)c, (PsiElement)activityClass)) continue;
            return activity;
        }
        return null;
    }

    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull AndroidFacet facet, @NotNull XmlAttribute attribute) {
        Set bindingAttributes;
        Module module;
        DataBindingProjectComponent dataBindingComponent;
        AttributeDefinitions attrDefs;
        if (facet == null) {
            AndroidDomUtil.$$$reportNull$$$0(14);
        }
        if (attribute == null) {
            AndroidDomUtil.$$$reportNull$$$0(15);
        }
        String localName = attribute.getLocalName();
        String namespace = attribute.getNamespace();
        boolean isFramework = namespace.equals("http://schemas.android.com/apk/res/android");
        if (!isFramework && "http://schemas.android.com/tools".equals(namespace)) {
            isFramework = true;
            AttributeDefinition toolsAttr = TOOLS_ATTRIBUTE_DEFINITIONS.getAttrDefByName(localName);
            if (toolsAttr != null) {
                return toolsAttr;
            }
        }
        AttributeDefinition definition = null;
        ResourceManager manager = ModuleResourceManagers.getInstance(facet).getResourceManager(isFramework ? "android" : null);
        if (manager != null && (attrDefs = manager.getAttributeDefinitions()) != null) {
            definition = attrDefs.getAttrDefByName(localName);
        }
        if (definition == null && (dataBindingComponent = (DataBindingProjectComponent)(module = facet.getModule()).getProject().getComponent(DataBindingProjectComponent.class)) != null && (bindingAttributes = dataBindingComponent.getBindingAdapterAttributes(module).collect(Collectors.toSet())).contains(attribute.getName())) {
            definition = new AttributeDefinition(localName);
        }
        return definition;
    }

    @NotNull
    public static Collection<String> removeUnambiguousNames(@NotNull Map<String, PsiClass> viewClassMap) {
        if (viewClassMap == null) {
            AndroidDomUtil.$$$reportNull$$$0(16);
        }
        HashMap class2Name = new HashMap();
        for (String tagName : viewClassMap.keySet()) {
            String qName;
            String prevTagName;
            PsiClass viewClass = viewClassMap.get(tagName);
            if (AndroidUtils.isAbstract(viewClass) || (prevTagName = (String)class2Name.get(qName = viewClass.getQualifiedName())) != null && tagName.indexOf(46) != -1) continue;
            class2Name.put(qName, tagName);
        }
        Collection<String> collection = class2Name.values();
        if (collection == null) {
            AndroidDomUtil.$$$reportNull$$$0(17);
        }
        return collection;
    }

    @Nullable
    public static AndroidResourceReferenceBase getAndroidResourceReference(@Nullable GenericAttributeValue<ResourceValue> attribute, boolean localOnly) {
        if (attribute == null) {
            return null;
        }
        ResourceValue resValue = (ResourceValue)attribute.getValue();
        if (resValue == null || localOnly && resValue.getNamespace() != null) {
            return null;
        }
        XmlAttributeValue value = attribute.getXmlAttributeValue();
        if (value == null) {
            return null;
        }
        for (PsiReference reference : value.getReferences()) {
            if (!(reference instanceof AndroidResourceReferenceBase)) continue;
            return (AndroidResourceReferenceBase)reference;
        }
        return null;
    }

    @Nullable
    public static AndroidAttributeValue<PsiClass> findComponentDeclarationInManifest(@NotNull PsiClass aClass) {
        AndroidFacet facet;
        if (aClass == null) {
            AndroidDomUtil.$$$reportNull$$$0(18);
        }
        if ((facet = AndroidFacet.getInstance((PsiElement)aClass)) == null) {
            return null;
        }
        boolean isActivity = AndroidDomUtil.isInheritor(aClass, "android.app.Activity");
        boolean isService = AndroidDomUtil.isInheritor(aClass, "android.app.Service");
        boolean isReceiver = AndroidDomUtil.isInheritor(aClass, "android.content.BroadcastReceiver");
        boolean isProvider = AndroidDomUtil.isInheritor(aClass, "android.content.ContentProvider");
        if (!(isActivity || isService || isReceiver || isProvider)) {
            return null;
        }
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return null;
        }
        Application application = manifest.getApplication();
        if (application == null) {
            return null;
        }
        if (isActivity) {
            for (Activity activity : application.getActivities()) {
                AndroidAttributeValue<PsiClass> activityClass = activity.getActivityClass();
                if (activityClass.getValue() != aClass) continue;
                return activityClass;
            }
        } else if (isService) {
            for (Service service : application.getServices()) {
                AndroidAttributeValue<PsiClass> serviceClass = service.getServiceClass();
                if (serviceClass.getValue() != aClass) continue;
                return serviceClass;
            }
        } else if (isReceiver) {
            for (Receiver receiver : application.getReceivers()) {
                AndroidAttributeValue<PsiClass> receiverClass = receiver.getReceiverClass();
                if (receiverClass.getValue() != aClass) continue;
                return receiverClass;
            }
        } else {
            for (Provider provider : application.getProviders()) {
                AndroidAttributeValue<PsiClass> providerClass = provider.getProviderClass();
                if (providerClass.getValue() != aClass) continue;
                return providerClass;
            }
        }
        return null;
    }

    public static boolean isInheritor(@NotNull PsiClass aClass, @NotNull String baseClassQName) {
        Project project;
        PsiClass baseClass;
        if (aClass == null) {
            AndroidDomUtil.$$$reportNull$$$0(19);
        }
        if (baseClassQName == null) {
            AndroidDomUtil.$$$reportNull$$$0(20);
        }
        return (baseClass = JavaPsiFacade.getInstance((Project)(project = aClass.getProject())).findClass(baseClassQName, aClass.getResolveScope())) != null && aClass.isInheritor(baseClass, true);
    }

    static {
        AndroidDomUtil.addSpecialResourceType(ResourceType.STRING, "label", "description", "title");
        AndroidDomUtil.addSpecialResourceType(ResourceType.DRAWABLE, "icon", "src");
        AndroidDomUtil.addSpecialResourceType(ResourceType.COLOR, "src");
        AndroidDomUtil.addSpecialResourceType(ResourceType.STYLE, "theme", "style");
        AndroidDomUtil.addSpecialResourceType(ResourceType.ANIM, "animation");
        AndroidDomUtil.addSpecialResourceType(ResourceType.ID, "id", "layout_toRightOf", "layout_toLeftOf", "layout_above", "layout_below", "layout_alignBaseline", "layout_alignLeft", "layout_alignTop", "layout_alignRight", "layout_alignBottom", "layout_alignStart", "layout_alignEnd", "layout_toStartOf", "layout_toEndOf", "checkedButton", "accessibilityTraversalBefore", "accessibilityTraversalAfter", "labelFor", "layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf", "layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", "layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", "layout_constraintBaseline_toBaselineOf");
        AndroidDomUtil.addSpecialResourceType(ResourceType.LAYOUT, "listitem", "layout");
        AndroidDomUtil.addSpecialResourceType(ResourceType.FONT, "fontFamily");
        AndroidDomUtil.addSpecialResourceType(ResourceType.ID, "destination");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/AndroidDomUtil";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activities";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewClassMap";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassQName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/AndroidDomUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecialResourceTypes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "removeUnambiguousNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResourceType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStringConverter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResourceReferenceConverter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSpecificConverter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConverter";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "containsAction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containsCategory";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getActivityDomElementByClass";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeDefinition";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeUnambiguousNames";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findComponentDeclarationInManifest";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isInheritor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

