/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.model.AndroidModel;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.android.AndroidApplicationPackageRenameProcessor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPackageConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s;
    }

    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value, PsiElement element, ConvertContext context) {
        String s = value.getStringValue();
        PsiReference[] psiReferenceArray = s != null ? new MyPackageReferenceSet(s, element).getPsiReferences() : PsiReference.EMPTY_ARRAY;
        if (psiReferenceArray == null) {
            AndroidPackageConverter.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/AndroidPackageConverter", "createReferences"));
    }

    private static class MyPsiPackageReference
    extends PsiPackageReference {
        private final MyPackageReferenceSet myReferenceSet;
        private final TextRange myTextRange;

        MyPsiPackageReference(MyPackageReferenceSet referenceSet, TextRange textRange, int index) {
            super((PackageReferenceSet)referenceSet, textRange, index);
            this.myReferenceSet = referenceSet;
            this.myTextRange = textRange;
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.myElement});
            if (resolveResultArray == null) {
                MyPsiPackageReference.$$$reportNull$$$0(0);
            }
            return resolveResultArray;
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            ResolveResult[] results;
            if (element == null) {
                MyPsiPackageReference.$$$reportNull$$$0(1);
            }
            for (ResolveResult result : results = this.doMultiResolve()) {
                if (!this.getElement().getManager().areElementsEquivalent(result.getElement(), element)) continue;
                return true;
            }
            return false;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                MyPsiPackageReference.$$$reportNull$$$0(2);
            }
            return this.myElement;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                MyPsiPackageReference.$$$reportNull$$$0(3);
            }
            if (!(element instanceof PsiPackage) || !(this.myElement instanceof XmlAttributeValue)) {
                throw new IncorrectOperationException("Cannot bind to " + element);
            }
            String newPackageName = ((PsiPackage)element).getQualifiedName();
            String basePackage = ((XmlAttributeValue)this.myElement).getValue();
            String oldPackageName = this.myElement.getText().substring(this.myReferenceSet.myStartInElement, this.myTextRange.getEndOffset());
            PsiFile file = this.myElement.getContainingFile();
            if (!basePackage.isEmpty() && file instanceof XmlFile) {
                AndroidApplicationPackageRenameProcessor.processAllAttributesToUpdate((XmlFile)file, basePackage, oldPackageName, newPackageName, new Processor<Pair<GenericAttributeValue, String>>(){

                    public boolean process(Pair<GenericAttributeValue, String> pair) {
                        ((GenericAttributeValue)pair.getFirst()).setStringValue((String)pair.getSecond());
                        return true;
                    }
                });
            }
            return this.myElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/dom/converters/AndroidPackageConverter$MyPsiPackageReference";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/dom/converters/AndroidPackageConverter$MyPsiPackageReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyPackageReferenceSet
    extends PackageReferenceSet {
        final int myStartInElement;

        MyPackageReferenceSet(String s, PsiElement element) {
            this(s, element, ElementManipulators.getOffsetInElement((PsiElement)element));
        }

        MyPackageReferenceSet(String str, PsiElement element, int startInElement) {
            super(str, element, startInElement);
            this.myStartInElement = startInElement;
        }

        @NotNull
        protected PsiPackageReference createReference(TextRange range, int index) {
            AndroidModel androidModel;
            AndroidFacet facet = AndroidFacet.getInstance(this.getElement());
            if (facet != null && ((androidModel = facet.getAndroidModel()) != null && androidModel.overridesManifestPackage() || facet.isLibraryProject())) {
                PsiPackageReference psiPackageReference = new PsiPackageReference((PackageReferenceSet)this, range, index);
                if (psiPackageReference == null) {
                    MyPackageReferenceSet.$$$reportNull$$$0(0);
                }
                return psiPackageReference;
            }
            MyPsiPackageReference myPsiPackageReference = new MyPsiPackageReference(this, range, index);
            if (myPsiPackageReference == null) {
                MyPackageReferenceSet.$$$reportNull$$$0(1);
            }
            return myPsiPackageReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/AndroidPackageConverter$MyPackageReferenceSet", "createReference"));
        }
    }
}

