/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstrumentationTargetPackageConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    @Nullable
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s;
    }

    @Nullable
    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray;
        Module module = context.getModule();
        if (element != null && module != null) {
            PsiReference[] psiReferenceArray2 = new PsiReference[1];
            psiReferenceArray = psiReferenceArray2;
            psiReferenceArray2[0] = new MyReference(element, module);
        } else {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
        }
        if (psiReferenceArray == null) {
            InstrumentationTargetPackageConverter.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/InstrumentationTargetPackageConverter", "createReferences"));
    }

    private static class MyReference
    extends PsiReferenceBase<PsiElement> {
        private final Module myModule;

        MyReference(@NotNull PsiElement element, @NotNull Module module) {
            if (element == null) {
                MyReference.$$$reportNull$$$0(0);
            }
            if (module == null) {
                MyReference.$$$reportNull$$$0(1);
            }
            super(element, true);
            this.myModule = module;
        }

        @Nullable
        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new ResolveCache.Resolver(){

                public PsiElement resolve(@NotNull PsiReference reference, boolean incompleteCode) {
                    if (reference == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return this.resolveInner();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/android/dom/converters/InstrumentationTargetPackageConverter$MyReference$1", "resolve"));
                }
            }, false, false);
        }

        @Nullable
        private PsiElement resolveInner() {
            final String value = this.getValue();
            if (value.isEmpty()) {
                return null;
            }
            final Ref result = Ref.create();
            this.processApkPackageAttrs(new Processor<GenericAttributeValue<String>>(){

                public boolean process(GenericAttributeValue<String> domValue) {
                    XmlAttributeValue xmlValue;
                    if (value.equals(domValue.getValue()) && (xmlValue = domValue.getXmlAttributeValue()) != null) {
                        result.set((Object)xmlValue);
                        return false;
                    }
                    return true;
                }
            });
            return (PsiElement)result.get();
        }

        @NotNull
        public Object[] getVariants() {
            HashSet result = new HashSet();
            this.processApkPackageAttrs(new Processor<GenericAttributeValue<String>>((Set)result){
                final /* synthetic */ Set val$result;
                {
                    this.val$result = set;
                }

                public boolean process(GenericAttributeValue<String> domValue) {
                    String value = (String)domValue.getValue();
                    if (value != null && !value.isEmpty()) {
                        this.val$result.add(value);
                    }
                    return true;
                }
            });
            Object[] objectArray = ArrayUtil.toStringArray((Collection)result);
            if (objectArray == null) {
                MyReference.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        private void processApkPackageAttrs(@NotNull Processor<GenericAttributeValue<String>> processor) {
            if (processor == null) {
                MyReference.$$$reportNull$$$0(3);
            }
            for (Module depModule : ModuleRootManager.getInstance((Module)this.myModule).getDependencies()) {
                GenericAttributeValue<String> packageAttr;
                Manifest manifest;
                AndroidFacet depFacet = AndroidFacet.getInstance(depModule);
                if (depFacet == null || !depFacet.isAppProject() || (manifest = depFacet.getManifest()) == null || (packageAttr = manifest.getPackage()) == null || processor.process(packageAttr)) continue;
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/dom/converters/InstrumentationTargetPackageConverter$MyReference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/dom/converters/InstrumentationTargetPackageConverter$MyReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processApkPackageAttrs";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

