/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.AndroidTextUtils;
import com.android.tools.idea.model.MergedManifest;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ExtendClass;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.converters.CompleteNonModuleClass;
import org.jetbrains.android.dom.converters.CreateMissingClassQuickFix;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageClassConverter
extends ResolvingConverter<PsiClass>
implements CustomReferenceConverter<PsiClass> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.dom.converters.PackageClassConverter");
    private final boolean myUseManifestBasePackage;
    private final String[] myExtendClassesNames;
    private final boolean myCompleteNonModuleClass;

    public PackageClassConverter(boolean useManifestBasePackage, boolean completeNonModuleClasses, String ... extendClassesNames) {
        this.myUseManifestBasePackage = useManifestBasePackage;
        this.myCompleteNonModuleClass = completeNonModuleClasses;
        this.myExtendClassesNames = extendClassesNames;
    }

    public PackageClassConverter(String ... extendClassesNames) {
        this(false, false, extendClassesNames);
    }

    public PackageClassConverter() {
        this(false, false, ArrayUtil.EMPTY_STRING_ARRAY);
    }

    @NotNull
    public Collection<? extends PsiClass> getVariants(ConvertContext context) {
        List list = Collections.emptyList();
        if (list == null) {
            PackageClassConverter.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    private String getManifestPackage(@NotNull ConvertContext context) {
        Module module;
        DomElement domElement;
        Manifest manifest;
        String manifestPackage;
        if (context == null) {
            PackageClassConverter.$$$reportNull$$$0(1);
        }
        String string = manifestPackage = (manifest = (Manifest)(domElement = context.getInvocationElement()).getParentOfType(Manifest.class, true)) != null ? (String)manifest.getPackage().getValue() : null;
        if (manifestPackage == null && this.myUseManifestBasePackage && (module = context.getModule()) != null) {
            manifestPackage = MergedManifest.get(module).getPackage();
        }
        return manifestPackage;
    }

    public PsiClass fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
        PsiClass psiClass;
        if (context == null) {
            PackageClassConverter.$$$reportNull$$$0(2);
        }
        if (s == null) {
            return null;
        }
        String manifestPackage = this.getManifestPackage(context);
        s = s.replace('$', '.');
        String className = null;
        if (manifestPackage != null) {
            className = s.startsWith(".") ? manifestPackage + s : manifestPackage + "." + s;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)context.getPsiManager().getProject());
        Module module = context.getModule();
        GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : context.getInvocationElement().getResolveScope();
        PsiClass psiClass2 = psiClass = className != null ? facade.findClass(className, scope) : null;
        if (psiClass == null) {
            psiClass = facade.findClass(s, scope);
        }
        return psiClass;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiClass> value, final PsiElement element, ConvertContext context) {
        boolean isTestFile;
        String[] stringArray;
        assert (element instanceof XmlAttributeValue);
        XmlAttributeValue attrValue = (XmlAttributeValue)element;
        String strValue = attrValue.getValue();
        final boolean startsWithPoint = strValue.startsWith(".");
        final int start = attrValue.getValueTextRange().getStartOffset() - attrValue.getTextRange().getStartOffset();
        DomElement domElement = context.getInvocationElement();
        final String manifestPackage = this.getManifestPackage(context);
        ExtendClass extendClassAnnotation = (ExtendClass)domElement.getAnnotation(ExtendClass.class);
        if (extendClassAnnotation != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = extendClassAnnotation.value();
        } else {
            stringArray = this.myExtendClassesNames;
        }
        final String[] extendClassesNames = stringArray;
        final boolean inModuleOnly = !this.myCompleteNonModuleClass && domElement.getAnnotation(CompleteNonModuleClass.class) == null;
        AndroidFacet facet = AndroidFacet.getInstance(context);
        VirtualFile file = element.getContainingFile().getVirtualFile();
        boolean bl = isTestFile = facet != null && file != null && IdeaSourceProvider.isTestFile(facet, file);
        if (strValue.isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PackageClassConverter.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        final ArrayList result = new ArrayList();
        final Module module = context.getModule();
        class CustomConsumer
        implements Consumer<Integer> {
            int myPartStart = 0;
            private boolean myIsPackage = true;

            CustomConsumer() {
            }

            public void consume(Integer index) {
                if (index > this.myPartStart) {
                    TextRange range = new TextRange(start + this.myPartStart, start + index);
                    MyReference reference = new MyReference(element, range, manifestPackage, startsWithPoint, start, this.myIsPackage, module, extendClassesNames, inModuleOnly, isTestFile);
                    result.add(reference);
                }
                this.myPartStart = index + 1;
            }
        }
        CustomConsumer consumer = new CustomConsumer();
        AndroidTextUtils.forEachOccurrence((String)strValue, (char)'.', (Consumer)consumer);
        consumer.myIsPackage = false;
        AndroidTextUtils.forEachOccurrence((String)strValue, (char)'$', (int)consumer.myPartStart, (Consumer)consumer);
        consumer.consume(strValue.length());
        PsiReference[] psiReferenceArray = result.toArray(new PsiReference[result.size()]);
        if (psiReferenceArray == null) {
            PackageClassConverter.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    @Nullable
    public static String getQualifiedName(@NotNull PsiClass aClass) {
        PsiElement parent;
        if (aClass == null) {
            PackageClassConverter.$$$reportNull$$$0(5);
        }
        if ((parent = aClass.getParent()) instanceof PsiClass) {
            String parentQName = PackageClassConverter.getQualifiedName((PsiClass)parent);
            if (parentQName == null) {
                return null;
            }
            return parentQName + "$" + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    @Nullable
    private static String getName(@NotNull PsiClass aClass) {
        PsiElement parent;
        if (aClass == null) {
            PackageClassConverter.$$$reportNull$$$0(6);
        }
        if ((parent = aClass.getParent()) instanceof PsiClass) {
            String parentName = PackageClassConverter.getName((PsiClass)parent);
            if (parentName == null) {
                return null;
            }
            return parentName + "$" + aClass.getName();
        }
        return aClass.getName();
    }

    @Nullable
    public String toString(@Nullable PsiClass psiClass, ConvertContext context) {
        DomElement domElement = context.getInvocationElement();
        Manifest manifest = (Manifest)domElement.getParentOfType(Manifest.class, true);
        String packageName = manifest == null ? null : (String)manifest.getPackage().getValue();
        return PackageClassConverter.classToString(psiClass, packageName, "");
    }

    @Nullable
    public static String getPackageName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PackageClassConverter.$$$reportNull$$$0(7);
        }
        return JavaHierarchyUtil.getPackageName((PsiClass)psiClass);
    }

    @Nullable
    private static String classToString(PsiClass psiClass, String basePackageName, String prefix) {
        if (psiClass == null) {
            return null;
        }
        String qName = PackageClassConverter.getQualifiedName(psiClass);
        if (qName == null) {
            return null;
        }
        PsiFile file = psiClass.getContainingFile();
        if (file instanceof PsiClassOwner) {
            String name;
            PsiClassOwner psiFile = (PsiClassOwner)file;
            if (Comparing.equal((String)psiFile.getPackageName(), (String)basePackageName)) {
                String name2 = PackageClassConverter.getName(psiClass);
                if (name2 != null) {
                    String dottedName = '.' + name2;
                    if (dottedName.startsWith(prefix)) {
                        return dottedName;
                    }
                    if (name2.startsWith(prefix)) {
                        return name2;
                    }
                }
            } else if (basePackageName != null && qName.startsWith(basePackageName + ".") && (name = qName.substring(basePackageName.length())).startsWith(prefix)) {
                return name;
            }
        }
        return qName;
    }

    @NotNull
    public static Collection<PsiClass> findInheritors(@NotNull Project project, @Nullable Module module, @NotNull String className, boolean inModuleOnly) {
        PsiClass base;
        if (project == null) {
            PackageClassConverter.$$$reportNull$$$0(8);
        }
        if (className == null) {
            PackageClassConverter.$$$reportNull$$$0(9);
        }
        if ((base = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project))) != null) {
            GlobalSearchScope scope = inModuleOnly && module != null ? GlobalSearchScope.moduleWithDependenciesScope((Module)module) : GlobalSearchScope.allScope((Project)project);
            Query query = ClassInheritorsSearch.search((PsiClass)base, (SearchScope)scope, (boolean)true);
            Collection collection = query.findAll();
            if (collection == null) {
                PackageClassConverter.$$$reportNull$$$0(10);
            }
            return collection;
        }
        ArrayList<PsiClass> arrayList = new ArrayList<PsiClass>();
        if (arrayList == null) {
            PackageClassConverter.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/converters/PackageClassConverter";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/converters/PackageClassConverter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findInheritors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getManifestPackage";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findInheritors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyReference
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider,
    LocalQuickFixProvider {
        private final int myStart;
        private final String myBasePackage;
        private final boolean myStartsWithPoint;
        private final boolean myIsPackage;
        @Nullable
        private final Module myModule;
        private final String[] myExtendsClasses;
        private final boolean myCompleteOnlyModuleClasses;
        private final boolean myIncludeTests;

        MyReference(PsiElement element, TextRange range, String basePackage, boolean startsWithPoint, int start, boolean isPackage, @Nullable Module module, String[] extendsClasses, boolean completeOnlyModuleClasses, boolean includeTests) {
            super(element, range, true);
            this.myBasePackage = basePackage;
            this.myStartsWithPoint = startsWithPoint;
            this.myStart = start;
            this.myIsPackage = isPackage;
            this.myModule = module;
            this.myExtendsClasses = extendsClasses;
            this.myCompleteOnlyModuleClasses = completeOnlyModuleClasses;
            this.myIncludeTests = includeTests;
        }

        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new ResolveCache.Resolver(){

                @Nullable
                public PsiElement resolve(@NotNull PsiReference reference, boolean incompleteCode) {
                    if (reference == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return this.resolveInner();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/android/dom/converters/PackageClassConverter$MyReference$1", "resolve"));
                }
            }, false, false);
        }

        @Nullable
        private PsiElement resolveInner() {
            String absName;
            String value = this.getCurrentValue();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myElement.getProject());
            if (!this.myStartsWithPoint) {
                PsiPackage element;
                PsiPackage psiPackage = this.myIsPackage ? facade.findPackage(value) : (element = facade.findClass(value, this.myModule != null ? this.myModule.getModuleWithDependenciesAndLibrariesScope(this.myIncludeTests) : this.myElement.getResolveScope()));
                if (element != null) {
                    return element;
                }
            }
            if ((absName = this.getAbsoluteName(value)) != null) {
                return this.myIsPackage ? facade.findPackage(absName) : facade.findClass(absName, this.myModule != null ? this.myModule.getModuleWithDependenciesAndLibrariesScope(this.myIncludeTests) : this.myElement.getResolveScope());
            }
            return null;
        }

        @NotNull
        private String getCurrentValue() {
            int end = this.getRangeInElement().getEndOffset();
            String string = this.myElement.getText().substring(this.myStart, end).replace('$', '.');
            if (string == null) {
                MyReference.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        private String getAbsoluteName(String value) {
            if (this.myBasePackage == null) {
                return null;
            }
            return this.myBasePackage + (this.myStartsWithPoint ? "" : ".") + value;
        }

        @NotNull
        public Object[] getVariants() {
            if (this.myExtendsClasses != null) {
                ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
                for (String extendsClass : this.myExtendsClasses) {
                    classes.addAll(PackageClassConverter.findInheritors(this.myElement.getProject(), this.myModule, extendsClass, this.myCompleteOnlyModuleClasses));
                }
                ArrayList<LookupElementBuilder> result = new ArrayList<LookupElementBuilder>(classes.size());
                int n = classes.size();
                for (int i = 0; i < n; ++i) {
                    String prefix;
                    PsiClass psiClass = (PsiClass)classes.get(i);
                    String name = PackageClassConverter.classToString(psiClass, this.myBasePackage, prefix = this.myElement.getText().substring(this.myStart, this.getRangeInElement().getStartOffset()));
                    if (name == null || !name.startsWith(prefix)) continue;
                    name = name.substring(prefix.length());
                    result.add(JavaLookupElementBuilder.forClass((PsiClass)psiClass, (String)name, (boolean)true));
                }
                Object[] objectArray = ArrayUtil.toObjectArray(result);
                if (objectArray == null) {
                    MyReference.$$$reportNull$$$0(1);
                }
                return objectArray;
            }
            if (EMPTY_ARRAY == null) {
                MyReference.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                MyReference.$$$reportNull$$$0(3);
            }
            if (element instanceof PsiClass || element instanceof PsiPackage) {
                String newName;
                if (this.myIsPackage && this.myBasePackage != null && AndroidUtils.isPackagePrefix(this.getCurrentValue(), this.myBasePackage)) {
                    return super.bindToElement(element);
                }
                if (element instanceof PsiClass) {
                    newName = PackageClassConverter.classToString((PsiClass)element, this.myBasePackage, "");
                    if (this.myBasePackage != null && AndroidUtils.isPackagePrefix(this.myBasePackage, this.getCurrentValue()) && newName != null && !newName.startsWith(this.myBasePackage)) {
                        newName = this.myBasePackage + (newName.startsWith(".") ? "" : ".") + newName;
                    }
                } else {
                    newName = MyReference.packageToString((PsiPackage)element, this.myBasePackage, this.resolve() != null);
                }
                assert (newName != null);
                ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myElement);
                TextRange range = new TextRange(this.myStart, this.getRangeInElement().getEndOffset());
                if (manipulator != null) {
                    return manipulator.handleContentChange(this.myElement, range, newName);
                }
                return element;
            }
            LOG.error("PackageClassConverter resolved to " + element.getClass());
            return super.bindToElement(element);
        }

        private static String packageToString(PsiPackage psiPackage, String basePackageName, boolean isFullQualified) {
            String qName = psiPackage.getQualifiedName();
            return basePackageName != null && AndroidUtils.isPackagePrefix(basePackageName, qName) && !isFullQualified ? qName.substring(basePackageName.length()) : qName;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = this.myIsPackage ? "Unresolved package ''{0}''" : "Unresolved class ''{0}''";
            if (string == null) {
                MyReference.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public LocalQuickFix[] getQuickFixes() {
            if (this.myIsPackage || this.myModule == null) {
                if (LocalQuickFix.EMPTY_ARRAY == null) {
                    MyReference.$$$reportNull$$$0(5);
                }
                return LocalQuickFix.EMPTY_ARRAY;
            }
            String value = this.getCurrentValue();
            if (this.myStartsWithPoint && this.myBasePackage != null) {
                value = this.getAbsoluteName(value);
            }
            if (value == null) {
                if (LocalQuickFix.EMPTY_ARRAY == null) {
                    MyReference.$$$reportNull$$$0(6);
                }
                return LocalQuickFix.EMPTY_ARRAY;
            }
            int dot = value.lastIndexOf(46);
            if (dot == -1) {
                if (LocalQuickFix.EMPTY_ARRAY == null) {
                    MyReference.$$$reportNull$$$0(7);
                }
                return LocalQuickFix.EMPTY_ARRAY;
            }
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myModule.getProject()).findPackage(value.substring(0, dot));
            if (aPackage == null) {
                if (LocalQuickFix.EMPTY_ARRAY == null) {
                    MyReference.$$$reportNull$$$0(8);
                }
                return LocalQuickFix.EMPTY_ARRAY;
            }
            String baseClassFqcn = this.myExtendsClasses.length == 0 ? null : this.myExtendsClasses[0];
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new CreateMissingClassQuickFix(aPackage, value.substring(dot + 1), this.myModule, baseClassFqcn)};
            if (localQuickFixArray == null) {
                MyReference.$$$reportNull$$$0(9);
            }
            return localQuickFixArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/dom/converters/PackageClassConverter$MyReference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentValue";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/dom/converters/PackageClassConverter$MyReference";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuickFixes";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

