/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.download;

import com.android.tools.idea.IdeInfo;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;

public class AndroidProfilerDownloader {
    private static final Logger LOG = Logger.getInstance(AndroidProfilerDownloader.class);

    public static boolean makeSureProfilerIsInPlace() {
        if (IdeInfo.getInstance().isAndroidStudio()) {
            return true;
        }
        File pluginDir = AndroidProfilerDownloader.getPluginDir();
        if (pluginDir.exists()) {
            return true;
        }
        DownloadableFileService service = DownloadableFileService.getInstance();
        String fileName = "android-profiler-3.1.2.zip";
        DownloadableFileDescription description = service.createFileDescription("https://download.jetbrains.com/idea/android-profiler/3.1.2/" + fileName, fileName);
        FileDownloader downloader = service.createDownloader(Collections.singletonList(description), "Download Android Profiler");
        try {
            Path tempDir = Files.createTempDirectory("android-profiler-download", new FileAttribute[0]);
            List list = downloader.download(tempDir.toFile());
            File file = (File)((Pair)list.get((int)0)).first;
            ZipUtil.extract((File)file, (File)pluginDir, null);
            FileUtil.delete((File)tempDir.toFile());
            return true;
        }
        catch (IOException e) {
            LOG.warn("Can't download Android profiler", (Throwable)e);
            FileUtil.delete((File)pluginDir);
            Notifications.Bus.notify((Notification)new Notification("Android", "Can't download Android profiler", "Check logs for details", NotificationType.ERROR));
            return false;
        }
    }

    private static File getPluginDir() {
        return new File(PathManager.getSystemPath(), "android/profiler/3.1.2");
    }

    public static File getHostDir(String hostReleaseDir) {
        String path = StringUtil.trimStart((String)hostReleaseDir, (String)"plugins/android");
        return new File(AndroidProfilerDownloader.getPluginDir(), path);
    }
}

