/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.lint.detector.api.Issue;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintUtil {
    @NonNls
    static final String ATTR_VALUE_VERTICAL = "vertical";
    @NonNls
    static final String ATTR_VALUE_WRAP_CONTENT = "wrap_content";
    @NonNls
    static final String ATTR_LAYOUT_HEIGHT = "layout_height";
    @NonNls
    static final String ATTR_LAYOUT_WIDTH = "layout_width";
    @NonNls
    static final String ATTR_ORIENTATION = "orientation";

    private AndroidLintUtil() {
    }

    @Nullable
    public static Pair<AndroidLintInspectionBase, HighlightDisplayLevel> getHighlightLevelAndInspection(@NotNull Project project, @NotNull Issue issue, @NotNull PsiElement context) {
        String inspectionShortName;
        if (project == null) {
            AndroidLintUtil.$$$reportNull$$$0(0);
        }
        if (issue == null) {
            AndroidLintUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            AndroidLintUtil.$$$reportNull$$$0(2);
        }
        if ((inspectionShortName = AndroidLintInspectionBase.getInspectionShortNameByIssue(project, issue)) == null) {
            return null;
        }
        HighlightDisplayKey key = HighlightDisplayKey.find((String)inspectionShortName);
        if (key == null) {
            return null;
        }
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)context.getProject()).getCurrentProfile();
        if (!profile.isToolEnabled(key, context) && issue.isEnabledByDefault()) {
            return null;
        }
        AndroidLintInspectionBase inspection = (AndroidLintInspectionBase)profile.getUnwrappedTool(inspectionShortName, context);
        if (inspection == null) {
            return null;
        }
        HighlightDisplayLevel errorLevel = profile.getErrorLevel(key, context);
        return Pair.create((Object)((Object)inspection), (Object)(errorLevel != null ? errorLevel : HighlightDisplayLevel.WARNING));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "issue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/android/inspections/lint/AndroidLintUtil";
        objectArray[2] = "getHighlightLevelAndInspection";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

