/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.tools.idea.sdk.AndroidSdks;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleResourceManagers {
    private final Module myModule;
    private SystemResourceManager myPublicSystemResourceManager;
    private SystemResourceManager myFullSystemResourceManager;
    private LocalResourceManager myLocalResourceManager;

    @NotNull
    public static ModuleResourceManagers getInstance(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ModuleResourceManagers.$$$reportNull$$$0(0);
        }
        ModuleResourceManagers moduleResourceManagers = (ModuleResourceManagers)ModuleServiceManager.getService((Module)facet.getModule(), ModuleResourceManagers.class);
        if (moduleResourceManagers == null) {
            ModuleResourceManagers.$$$reportNull$$$0(1);
        }
        return moduleResourceManagers;
    }

    private ModuleResourceManagers(final @NotNull Module module) {
        if (module == null) {
            ModuleResourceManagers.$$$reportNull$$$0(2);
        }
        this.myModule = module;
        MessageBusConnection connection = module.getMessageBus().connect((Disposable)module);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
            private Sdk myPrevSdk = null;

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ModuleResourceManagers.this.myLocalResourceManager = null;
                Sdk newSdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (!(ModuleResourceManagers.this.myPublicSystemResourceManager == null && ModuleResourceManagers.this.myFullSystemResourceManager == null || Objects.equals(this.myPrevSdk, newSdk))) {
                    ModuleResourceManagers.this.myPublicSystemResourceManager = null;
                    ModuleResourceManagers.this.myFullSystemResourceManager = null;
                }
                this.myPrevSdk = newSdk;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/android/resourceManagers/ModuleResourceManagers$1", "rootsChanged"));
            }
        });
    }

    @Nullable
    public ResourceManager getResourceManager(@Nullable String resourcePackage) {
        return this.getResourceManager(resourcePackage, null);
    }

    @Nullable
    public ResourceManager getResourceManager(@Nullable String resourcePackage, @Nullable PsiElement contextElement) {
        if ("android".equals(resourcePackage)) {
            return this.getSystemResourceManager();
        }
        if (contextElement != null && AndroidSdks.getInstance().isInAndroidSdk(contextElement)) {
            return this.getSystemResourceManager();
        }
        return this.getLocalResourceManager();
    }

    @NotNull
    public LocalResourceManager getLocalResourceManager() {
        if (this.myLocalResourceManager == null) {
            this.myLocalResourceManager = new LocalResourceManager(this.getFacet());
        }
        LocalResourceManager localResourceManager = this.myLocalResourceManager;
        if (localResourceManager == null) {
            ModuleResourceManagers.$$$reportNull$$$0(3);
        }
        return localResourceManager;
    }

    @NotNull
    private AndroidFacet getFacet() {
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        assert (facet != null);
        AndroidFacet androidFacet = facet;
        if (androidFacet == null) {
            ModuleResourceManagers.$$$reportNull$$$0(4);
        }
        return androidFacet;
    }

    @Nullable
    public SystemResourceManager getSystemResourceManager() {
        return this.getSystemResourceManager(true);
    }

    @Nullable
    public SystemResourceManager getSystemResourceManager(boolean publicOnly) {
        AndroidPlatform platform;
        if (publicOnly) {
            AndroidPlatform platform2;
            if (this.myPublicSystemResourceManager == null && (platform2 = ((AndroidFacetConfiguration)this.getFacet().getConfiguration()).getAndroidPlatform()) != null) {
                this.myPublicSystemResourceManager = new SystemResourceManager(this.myModule.getProject(), platform2, true);
            }
            return this.myPublicSystemResourceManager;
        }
        if (this.myFullSystemResourceManager == null && (platform = ((AndroidFacetConfiguration)this.getFacet().getConfiguration()).getAndroidPlatform()) != null) {
            this.myFullSystemResourceManager = new SystemResourceManager(this.myModule.getProject(), platform, false);
        }
        return this.myFullSystemResourceManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/ModuleResourceManagers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/ModuleResourceManagers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalResourceManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

