/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.Predicate;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.AndroidIdIndex;
import org.jetbrains.android.AndroidValueResourcesIndex;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.dom.wrappers.FileResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.ResourceEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceManager {
    protected final Project myProject;

    protected ResourceManager(@NotNull Project project) {
        if (project == null) {
            ResourceManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public abstract Multimap<String, VirtualFile> getAllResourceDirs();

    @NotNull
    public abstract List<VirtualFile> getResourceDirs();

    public abstract boolean isResourceDir(@NotNull VirtualFile var1);

    @Nullable
    public abstract AttributeDefinitions getAttributeDefinitions();

    private void processFileResources(boolean withDependencies, @NotNull ResourceFolderType folderType, @NotNull FileResourceProcessor processor) {
        Multimap<String, VirtualFile> resDirs;
        if (folderType == null) {
            ResourceManager.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            ResourceManager.$$$reportNull$$$0(2);
        }
        if (withDependencies) {
            resDirs = this.getAllResourceDirs();
        } else {
            resDirs = HashMultimap.create();
            resDirs.putAll(null, this.getResourceDirs());
        }
        for (Map.Entry entry : resDirs.asMap().entrySet()) {
            for (VirtualFile resSubdir : AndroidResourceUtil.getResourceSubdirs(folderType, (Collection)entry.getValue())) {
                ResourceFolderType resType = ResourceFolderType.getFolderType((String)resSubdir.getName());
                if (resType == null) continue;
                assert (folderType.equals((Object)resType));
                String resTypeName = resType.getName();
                for (VirtualFile resFile : resSubdir.getChildren()) {
                    String resName = AndroidCommonUtils.getResourceName((String)resTypeName, (String)resFile.getName());
                    if (resFile.isDirectory() || !this.isResourcePublic(resTypeName, resName)) continue;
                    processor.process(resFile, resName, (String)entry.getKey());
                }
            }
        }
    }

    @NotNull
    public VirtualFile[] getResourceOverlayDirs() {
        if (VirtualFile.EMPTY_ARRAY == null) {
            ResourceManager.$$$reportNull$$$0(3);
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    protected boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        if (type == null) {
            ResourceManager.$$$reportNull$$$0(4);
        }
        if (name == null) {
            ResourceManager.$$$reportNull$$$0(5);
        }
        return true;
    }

    @NotNull
    private List<VirtualFile> getResourceSubdirs(@NotNull ResourceFolderType resourceType) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(6);
        }
        List<VirtualFile> list = AndroidResourceUtil.getResourceSubdirs(resourceType, this.getAllResourceDirs().values());
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull ResourceFolderType resourceType) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(8);
        }
        List<PsiFile> list = this.findResourceFiles(resourceType, null, true, true);
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull ResourceFolderType resourceFolderType, @Nullable String resName1, boolean distinguishDelimitersInName, boolean withDependencies) {
        if (resourceFolderType == null) {
            ResourceManager.$$$reportNull$$$0(10);
        }
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        this.processFileResources(withDependencies, resourceFolderType, (resFile, resName, libraryName) -> {
            PsiFile file;
            if ((resName1 == null || AndroidUtils.equal(resName1, resName, distinguishDelimitersInName)) && (file = AndroidPsiUtils.getPsiFileSafely(this.myProject, resFile)) != null) {
                result.add(file);
            }
        });
        ArrayList<PsiFile> arrayList = result;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    protected Multimap<String, XmlFile> findResourceFilesByLibraryName(@NotNull ResourceFolderType folderType) {
        if (folderType == null) {
            ResourceManager.$$$reportNull$$$0(12);
        }
        HashMultimap result = HashMultimap.create();
        this.processFileResources(true, folderType, (arg_0, arg_1, arg_2) -> this.lambda$findResourceFilesByLibraryName$1((Multimap)result, arg_0, arg_1, arg_2));
        HashMultimap hashMultimap = result;
        if (hashMultimap == null) {
            ResourceManager.$$$reportNull$$$0(13);
        }
        return hashMultimap;
    }

    @NotNull
    List<Pair<Resources, VirtualFile>> getResourceElements() {
        ArrayList<Pair<Resources, VirtualFile>> result = new ArrayList<Pair<Resources, VirtualFile>>();
        for (VirtualFile file : this.getAllValueResourceFiles()) {
            Resources element = AndroidUtils.loadDomElement(this.myProject, file, Resources.class);
            if (element == null) continue;
            result.add((Pair<Resources, VirtualFile>)Pair.create((Object)element, (Object)file));
        }
        ArrayList<Pair<Resources, VirtualFile>> arrayList = result;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private Set<VirtualFile> getAllValueResourceFiles() {
        HashSet files = new HashSet();
        for (VirtualFile valueResourceDir : this.getResourceSubdirs(ResourceFolderType.VALUES)) {
            for (VirtualFile valueResourceFile : valueResourceDir.getChildren()) {
                if (valueResourceFile.isDirectory() || !valueResourceFile.getFileType().equals(StdFileTypes.XML)) continue;
                files.add(valueResourceFile);
            }
        }
        HashSet hashSet = files;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(15);
        }
        return hashSet;
    }

    List<ResourceElement> getPublicValueResources(@NotNull ResourceType resourceType) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(16);
        }
        ArrayList<ResourceElement> result = new ArrayList<ResourceElement>();
        List<Pair<Resources, VirtualFile>> resourceFiles = this.getResourceElements();
        for (Pair<Resources, VirtualFile> pair : resourceFiles) {
            Resources resources = (Resources)pair.getFirst();
            ApplicationManager.getApplication().runReadAction(() -> {
                if (resourceType == null) {
                    ResourceManager.$$$reportNull$$$0(58);
                }
                if (!resources.isValid() || this.myProject.isDisposed()) {
                    return;
                }
                List<ResourceElement> valueResources = AndroidResourceUtil.getValueResourcesFromElement(resourceType, resources);
                for (ResourceElement valueResource : valueResources) {
                    String resName = (String)valueResource.getName().getValue();
                    if (resName == null || !this.isResourcePublic(resourceType.getName(), resName)) continue;
                    result.add(valueResource);
                }
            });
        }
        return result;
    }

    @Nullable
    public String getValueResourceType(@NotNull XmlTag tag) {
        ResourceFolderType fileResType;
        if (tag == null) {
            ResourceManager.$$$reportNull$$$0(17);
        }
        if (ResourceFolderType.VALUES == (fileResType = this.getFileResourceFolderType(tag.getContainingFile()))) {
            return tag.getName();
        }
        return null;
    }

    @Nullable
    public ResourceFolderType getFileResourceFolderType(final @NotNull PsiFile file) {
        if (file == null) {
            ResourceManager.$$$reportNull$$$0(18);
        }
        return (ResourceFolderType)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ResourceFolderType>(){

            @Nullable
            public ResourceFolderType compute() {
                PsiDirectory dir = file.getContainingDirectory();
                if (dir == null) {
                    return null;
                }
                PsiDirectory possibleResDir = dir.getParentDirectory();
                if (possibleResDir == null || !ResourceManager.this.isResourceDir(possibleResDir.getVirtualFile())) {
                    return null;
                }
                return ResourceFolderType.getFolderType((String)dir.getName());
            }
        });
    }

    @Nullable
    public String getFileResourceType(@NotNull PsiFile file) {
        ResourceFolderType folderType;
        if (file == null) {
            ResourceManager.$$$reportNull$$$0(19);
        }
        return (folderType = this.getFileResourceFolderType(file)) == null ? null : folderType.getName();
    }

    @NotNull
    private Set<String> getFileResourcesNames(@NotNull ResourceFolderType resourceType) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(20);
        }
        HashSet result = new HashSet();
        this.processFileResources(true, resourceType, (arg_0, arg_1, arg_2) -> ResourceManager.lambda$getFileResourcesNames$3((Set)result, arg_0, arg_1, arg_2));
        HashSet hashSet = result;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    @NotNull
    private Collection<String> getValueResourceNames(@NotNull ResourceType resourceType) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(22);
        }
        HashSet result = new HashSet();
        boolean attr = ResourceType.ATTR == resourceType;
        for (ResourceEntry entry : this.getValueResourceEntries(resourceType)) {
            String name = entry.getName();
            if (attr && name.startsWith("android:")) continue;
            result.add(name);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(23);
        }
        return hashSet;
    }

    @NotNull
    public Collection<ResourceEntry> getValueResourceEntries(@NotNull ResourceType resourceType) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(24);
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        ResourceEntry typeMarkerEntry = AndroidValueResourcesIndex.createTypeMarkerKey(resourceType.getName());
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        HashMap file2resourceSet = new HashMap();
        index.processValues(AndroidValueResourcesIndex.INDEX_ID, (Object)typeMarkerEntry, null, (arg_0, arg_1) -> ResourceManager.lambda$getValueResourceEntries$4((Map)file2resourceSet, arg_0, arg_1), scope);
        ArrayList<ResourceEntry> result = new ArrayList<ResourceEntry>();
        for (VirtualFile file : this.getAllValueResourceFiles()) {
            Set entries = (Set)file2resourceSet.get(file);
            if (entries == null) continue;
            for (ResourceEntry entry : entries) {
                if (!this.isResourcePublic(entry.getType(), entry.getName())) continue;
                result.add(entry);
            }
        }
        ArrayList<ResourceEntry> arrayList = result;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    public Collection<String> getResourceNames(@NotNull ResourceType type) {
        if (type == null) {
            ResourceManager.$$$reportNull$$$0(26);
        }
        Collection<String> collection = this.getResourceNames(type, false);
        if (collection == null) {
            ResourceManager.$$$reportNull$$$0(27);
        }
        return collection;
    }

    @NotNull
    public Collection<String> getResourceNames(@NotNull ResourceType resourceType, boolean publicOnly) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(28);
        }
        HashSet result = new HashSet();
        result.addAll(this.getValueResourceNames(resourceType));
        List folders = FolderTypeRelationship.getRelatedFolders((ResourceType)resourceType);
        if (!folders.isEmpty()) {
            for (ResourceFolderType folderType : folders) {
                if (folderType == ResourceFolderType.VALUES) continue;
                result.addAll(this.getFileResourcesNames(folderType));
            }
        }
        if (resourceType == ResourceType.ID) {
            result.addAll(this.getIds(true));
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(29);
        }
        return hashSet;
    }

    @NotNull
    public List<XmlAttributeValue> findIdDeclarations(@NotNull String id) {
        if (id == null) {
            ResourceManager.$$$reportNull$$$0(30);
        }
        if (!this.isResourcePublic(ResourceType.ID.getName(), id)) {
            List<XmlAttributeValue> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(31);
            }
            return list;
        }
        Collection files = FileBasedIndex.getInstance().getContainingFiles(AndroidIdIndex.INDEX_ID, (Object)("+" + id), GlobalSearchScope.allScope((Project)this.myProject));
        List<XmlAttributeValue> list = this.findIdUsagesFromFiles((Set<VirtualFile>)new HashSet(files), (Predicate<XmlAttributeValue>)((Predicate)attributeValue -> {
            if (id == null) {
                ResourceManager.$$$reportNull$$$0(57);
            }
            if (AndroidResourceUtil.isIdDeclaration(attributeValue)) {
                String idInAttr = AndroidResourceUtil.getResourceNameByReferenceText(attributeValue.getValue());
                return id.equals(idInAttr);
            }
            return false;
        }));
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    public List<XmlAttributeValue> findConstraintReferencedIds(@NotNull String id) {
        if (id == null) {
            ResourceManager.$$$reportNull$$$0(33);
        }
        if (!this.isResourcePublic(ResourceType.ID.getName(), id)) {
            List<XmlAttributeValue> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(34);
            }
            return list;
        }
        Collection files = FileBasedIndex.getInstance().getContainingFiles(AndroidIdIndex.INDEX_ID, (Object)("," + id), GlobalSearchScope.allScope((Project)this.myProject));
        List<XmlAttributeValue> list = this.findIdUsagesFromFiles((Set<VirtualFile>)new HashSet(files), (Predicate<XmlAttributeValue>)((Predicate)attributeValue -> {
            String ids;
            if (id == null) {
                ResourceManager.$$$reportNull$$$0(55);
            }
            if (AndroidResourceUtil.isConstraintReferencedIds(attributeValue) && (ids = attributeValue.getValue()) != null) {
                return Arrays.stream(ids.split(",")).anyMatch(s -> {
                    if (id == null) {
                        ResourceManager.$$$reportNull$$$0(56);
                    }
                    return s.equals(id);
                });
            }
            return false;
        }));
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(35);
        }
        return list;
    }

    private List<XmlAttributeValue> findIdUsagesFromFiles(@NotNull Set<VirtualFile> fileSet, final @NotNull Predicate<XmlAttributeValue> condition) {
        if (fileSet == null) {
            ResourceManager.$$$reportNull$$$0(36);
        }
        if (condition == null) {
            ResourceManager.$$$reportNull$$$0(37);
        }
        final ArrayList<XmlAttributeValue> usages = new ArrayList<XmlAttributeValue>();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile subdir : this.getResourceSubdirsToSearchIds()) {
            for (VirtualFile file : subdir.getChildren()) {
                PsiFile psiFile;
                if (!fileSet.contains(file) || !((psiFile = psiManager.findFile(file)) instanceof XmlFile)) continue;
                psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlAttributeValue(XmlAttributeValue attributeValue) {
                        if (condition.apply((Object)attributeValue)) {
                            usages.add(attributeValue);
                        }
                    }
                });
            }
        }
        return usages;
    }

    @NotNull
    public Collection<String> getIds(boolean declarationsOnly) {
        if (this.myProject.isDisposed()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(38);
            }
            return list;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        FileBasedIndex index = FileBasedIndex.getInstance();
        HashMap file2idEntries = new HashMap();
        index.processValues(AndroidIdIndex.INDEX_ID, (Object)"$", null, (arg_0, arg_1) -> ResourceManager.lambda$getIds$8((Map)file2idEntries, arg_0, arg_1), scope);
        HashSet result = new HashSet();
        for (VirtualFile resSubdir : this.getResourceSubdirsToSearchIds()) {
            for (VirtualFile resFile : resSubdir.getChildren()) {
                Set idEntries = (Set)file2idEntries.get(resFile);
                if (idEntries == null) continue;
                for (String idEntry : idEntries) {
                    if (idEntry.startsWith("+")) {
                        idEntry = idEntry.substring(1);
                    } else if (declarationsOnly) continue;
                    if (!this.isResourcePublic(ResourceType.ID.getName(), idEntry)) continue;
                    result.add(idEntry);
                }
            }
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(39);
        }
        return hashSet;
    }

    @NotNull
    private List<VirtualFile> getResourceSubdirsToSearchIds() {
        ArrayList<VirtualFile> resSubdirs = new ArrayList<VirtualFile>();
        for (ResourceFolderType type : FolderTypeRelationship.getIdGeneratingFolderTypes()) {
            resSubdirs.addAll(this.getResourceSubdirs(type));
        }
        ArrayList<VirtualFile> arrayList = resSubdirs;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    public List<ResourceElement> findValueResources(@NotNull String resType, @NotNull String resName) {
        if (resType == null) {
            ResourceManager.$$$reportNull$$$0(41);
        }
        if (resName == null) {
            ResourceManager.$$$reportNull$$$0(42);
        }
        return this.findValueResources(resType, resName, true);
    }

    @NotNull
    public List<ResourceElement> findValueResources(@NotNull String resourceType, @NotNull String resourceName, boolean distinguishDelimitersInName) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(43);
        }
        if (resourceName == null) {
            ResourceManager.$$$reportNull$$$0(44);
        }
        List<ValueResourceInfoImpl> resources = this.findValueResourceInfos(resourceType, resourceName, distinguishDelimitersInName, false);
        ArrayList<ResourceElement> result = new ArrayList<ResourceElement>();
        for (ValueResourceInfoImpl resource : resources) {
            ResourceElement domElement = resource.computeDomElement();
            if (domElement == null) continue;
            result.add(domElement);
        }
        ArrayList<ResourceElement> arrayList = result;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(45);
        }
        return arrayList;
    }

    public void collectLazyResourceElements(@NotNull String resType, @NotNull String resName, boolean withAttrs, @NotNull PsiElement context, @NotNull Collection<PsiElement> elements) {
        ResourceFolderType folderType;
        if (resType == null) {
            ResourceManager.$$$reportNull$$$0(46);
        }
        if (resName == null) {
            ResourceManager.$$$reportNull$$$0(47);
        }
        if (context == null) {
            ResourceManager.$$$reportNull$$$0(48);
        }
        if (elements == null) {
            ResourceManager.$$$reportNull$$$0(49);
        }
        List<ValueResourceInfoImpl> valueResources = this.findValueResourceInfos(resType, resName, false, withAttrs);
        for (ValueResourceInfo valueResourceInfo : valueResources) {
            elements.add((PsiElement)new LazyValueResourceElementWrapper(valueResourceInfo, context));
        }
        if (resType.equals("id")) {
            elements.addAll(this.findIdDeclarations(resName));
        }
        if (elements.isEmpty() && (folderType = ResourceFolderType.getTypeByName((String)resType)) != null) {
            for (PsiFile file : this.findResourceFiles(folderType, resName, false, true)) {
                elements.add(new FileResourceElementWrapper(file));
            }
        }
    }

    @NotNull
    public List<ValueResourceInfoImpl> findValueResourceInfos(@NotNull String resourceType, @NotNull String resourceName, boolean distinguishDelimetersInName, boolean searchAttrs) {
        ResourceType type;
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(50);
        }
        if (resourceName == null) {
            ResourceManager.$$$reportNull$$$0(51);
        }
        ResourceType resourceType2 = type = resourceType.startsWith("+") ? ResourceType.ID : ResourceType.getEnum((String)resourceType);
        if (type == null || !AndroidResourceUtil.VALUE_RESOURCE_TYPES.contains(type) && (type != ResourceType.ATTR || !searchAttrs)) {
            List<ValueResourceInfoImpl> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(52);
            }
            return list;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        ArrayList<ValueResourceInfoImpl> result = new ArrayList<ValueResourceInfoImpl>();
        Set<VirtualFile> valueResourceFiles = this.getAllValueResourceFiles();
        FileBasedIndex.getInstance().processValues(AndroidValueResourcesIndex.INDEX_ID, (Object)AndroidValueResourcesIndex.createTypeNameMarkerKey(resourceType, resourceName), null, (file, infos) -> {
            if (resourceName == null) {
                ResourceManager.$$$reportNull$$$0(54);
            }
            for (AndroidValueResourcesIndex.MyResourceInfo info : infos) {
                String name = info.getResourceEntry().getName();
                if (!AndroidUtils.equal(resourceName, name, distinguishDelimetersInName) || !valueResourceFiles.contains(file)) continue;
                result.add(new ValueResourceInfoImpl(info.getResourceEntry().getName(), type, file, this.myProject, info.getOffset()));
            }
            return true;
        }, scope);
        ArrayList<ValueResourceInfoImpl> arrayList = result;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(53);
        }
        return arrayList;
    }

    private static /* synthetic */ boolean lambda$getIds$8(Map file2idEntries, VirtualFile file, Set value) {
        file2idEntries.put(file, value);
        return true;
    }

    private static /* synthetic */ boolean lambda$getValueResourceEntries$4(Map file2resourceSet, VirtualFile file, ImmutableSet infos) {
        for (AndroidValueResourcesIndex.MyResourceInfo info : infos) {
            Set resourcesInFile = (Set)file2resourceSet.get(file);
            if (resourcesInFile == null) {
                resourcesInFile = new HashSet();
                file2resourceSet.put(file, resourcesInFile);
            }
            resourcesInFile.add(info.getResourceEntry());
        }
        return true;
    }

    private static /* synthetic */ void lambda$getFileResourcesNames$3(Set result, VirtualFile resFile, String resName, String libraryName) {
        result.add(resName);
    }

    private /* synthetic */ void lambda$findResourceFilesByLibraryName$1(Multimap result, VirtualFile resFile, String resName, String libraryName) {
        PsiFile file = AndroidPsiUtils.getPsiFileSafely(this.myProject, resFile);
        if (file instanceof XmlFile) {
            result.put((Object)libraryName, (Object)((XmlFile)file));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 52: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 52: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/ResourceManager";
                break;
            }
            case 4: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: 
            case 16: 
            case 20: 
            case 22: 
            case 24: 
            case 28: 
            case 43: 
            case 50: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFolderType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 30: 
            case 33: 
            case 55: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resType";
                break;
            }
            case 42: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resName";
                break;
            }
            case 44: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/ResourceManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceOverlayDirs";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceSubdirs";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourceFiles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourceFilesByLibraryName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceElements";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValueResourceFiles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileResourcesNames";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueResourceNames";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueResourceEntries";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceNames";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "findIdDeclarations";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "findConstraintReferencedIds";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getIds";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceSubdirsToSearchIds";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueResources";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueResourceInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processFileResources";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 52: 
            case 53: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isResourcePublic";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getResourceSubdirs";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findResourceFiles";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findResourceFilesByLibraryName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPublicValueResources";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getValueResourceType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFileResourceFolderType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFileResourceType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFileResourcesNames";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getValueResourceNames";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getValueResourceEntries";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getResourceNames";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findIdDeclarations";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findConstraintReferencedIds";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findIdUsagesFromFiles";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findValueResources";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "collectLazyResourceElements";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findValueResourceInfos";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findValueResourceInfos$9";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findConstraintReferencedIds$7";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$6";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findIdDeclarations$5";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPublicValueResources$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 52: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface FileResourceProcessor {
        public void process(@NotNull VirtualFile var1, @NotNull String var2, @Nullable String var3);
    }
}

