/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.ConvertContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemResourceManager
extends ResourceManager {
    private final AndroidPlatform myPlatform;
    private final boolean myPublicOnly;

    public SystemResourceManager(@NotNull Project project, @NotNull AndroidPlatform androidPlatform, boolean publicOnly) {
        if (project == null) {
            SystemResourceManager.$$$reportNull$$$0(0);
        }
        if (androidPlatform == null) {
            SystemResourceManager.$$$reportNull$$$0(1);
        }
        super(project);
        this.myPlatform = androidPlatform;
        this.myPublicOnly = publicOnly;
    }

    @Override
    protected boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        if (type == null) {
            SystemResourceManager.$$$reportNull$$$0(2);
        }
        if (name == null) {
            SystemResourceManager.$$$reportNull$$$0(3);
        }
        return !this.myPublicOnly || this.myPlatform.getSdkData().getTargetData(this.myPlatform.getTarget()).isResourcePublic(type, name);
    }

    @Override
    @NotNull
    public Multimap<String, VirtualFile> getAllResourceDirs() {
        VirtualFile resDir = this.getResourceDir();
        HashMultimap result = HashMultimap.create();
        if (resDir != null) {
            result.put(null, (Object)resDir);
        }
        HashMultimap hashMultimap = result;
        if (hashMultimap == null) {
            SystemResourceManager.$$$reportNull$$$0(4);
        }
        return hashMultimap;
    }

    @Nullable
    private VirtualFile getResourceDir() {
        String resPath = this.myPlatform.getTarget().getPath(11);
        resPath = FileUtil.toSystemIndependentName((String)resPath);
        return LocalFileSystem.getInstance().findFileByPath(resPath);
    }

    @Override
    public boolean isResourceDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            SystemResourceManager.$$$reportNull$$$0(5);
        }
        return dir.equals(this.getResourceDir());
    }

    @Override
    @NotNull
    public List<VirtualFile> getResourceDirs() {
        VirtualFile dir = this.getResourceDir();
        List<Object> list = dir != null ? Collections.singletonList(dir) : Collections.emptyList();
        if (list == null) {
            SystemResourceManager.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public static SystemResourceManager getInstance(@NotNull ConvertContext context) {
        AndroidFacet facet;
        if (context == null) {
            SystemResourceManager.$$$reportNull$$$0(7);
        }
        return (facet = AndroidFacet.getInstance(context)) != null ? ModuleResourceManagers.getInstance(facet).getSystemResourceManager() : null;
    }

    @Override
    @Nullable
    public synchronized AttributeDefinitions getAttributeDefinitions() {
        return this.myPlatform.getSdkData().getTargetData(this.myPlatform.getTarget()).getPublicAttrDefs(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidPlatform";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/SystemResourceManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/SystemResourceManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResourceDirs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isResourcePublic";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isResourceDir";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

