/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseClassDialog
extends DialogWrapper
implements ListSelectionListener {
    private final JList<PsiClass> myList = new JBList();
    private final JScrollPane myComponent = ScrollPaneFactory.createScrollPane(this.myList);
    private final Predicate<PsiClass> myFilter;
    private String myResultClassName;

    private ChooseClassDialog(Module module, String title, boolean includeAll, @Nullable Predicate<PsiClass> filter, String ... classes) {
        super(module.getProject());
        this.myFilter = filter;
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (ChooseClassDialog.this.myList.getSelectedValue() != null) {
                    ChooseClassDialog.this.close(0);
                    return true;
                }
                return false;
            }
        }.installOn(this.myList);
        DefaultListModel model = new DefaultListModel();
        this.findClasses(module, includeAll, model, classes);
        this.myList.setModel(model);
        this.myList.setCellRenderer((ListCellRenderer<PsiClass>)new DefaultPsiElementCellRenderer());
        ListSelectionModel selectionModel = this.myList.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(this);
        new ListSpeedSearch(this.myList){

            protected boolean isMatchingElement(Object element, String pattern) {
                PsiClass psiClass = (PsiClass)element;
                assert (psiClass.getName() != null && psiClass.getQualifiedName() != null);
                return this.compare(psiClass.getName(), pattern) || this.compare(psiClass.getQualifiedName(), pattern);
            }
        };
        this.setTitle(title);
        this.setOKActionEnabled(false);
        this.init();
        Dimension size = this.myComponent.getPreferredSize();
        size.height = this.myList.getPreferredSize().height + 20;
        this.myComponent.setPreferredSize(size);
    }

    private void setSelectedClass(@NotNull String className) {
        if (className == null) {
            ChooseClassDialog.$$$reportNull$$$0(0);
        }
        ListModel<PsiClass> model = this.myList.getModel();
        for (int index = 0; index < this.myList.getModel().getSize(); ++index) {
            if (!className.equals(model.getElementAt(index).getQualifiedName())) continue;
            this.myList.setSelectedIndex(index);
            break;
        }
    }

    protected void findClasses(Module module, boolean includeAll, DefaultListModel model, String[] classes) {
        ArrayList<PsiClass> collection = new ArrayList<PsiClass>(classes.length);
        for (String className : classes) {
            for (PsiClass psiClass3 : ChooseClassDialog.findInheritors(module, className, includeAll)) {
                if (this.myFilter != null && !this.myFilter.test(psiClass3)) continue;
                collection.add(psiClass3);
            }
        }
        Collator collator = Collator.getInstance(Locale.US);
        collection.stream().sorted((psiClass1, psiClass2) -> collator.compare(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiClass1), SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiClass2))).forEach(psiClass -> model.addElement(psiClass));
    }

    private static Collection<PsiClass> findInheritors(Module module, String name, boolean includeAll) {
        PsiClass base = ChooseClassDialog.findClass(module, name);
        if (base != null) {
            Collection<Object> classes;
            GlobalSearchScope scope = includeAll ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false) : GlobalSearchScope.moduleScope((Module)module);
            try {
                classes = ClassInheritorsSearch.search((PsiClass)base, (SearchScope)scope, (boolean)true).findAll();
            }
            catch (IndexNotReadyException e) {
                classes = Collections.emptyList();
            }
            return classes;
        }
        return Collections.emptyList();
    }

    @Nullable
    public static PsiClass findClass(Module module, @Nullable String name) {
        PsiClass aClass;
        if (name == null) {
            return null;
        }
        Project project = module.getProject();
        try {
            aClass = JavaPsiFacade.getInstance((Project)project).findClass(name, GlobalSearchScope.allScope((Project)project));
        }
        catch (IndexNotReadyException e) {
            aClass = null;
        }
        return aClass;
    }

    @Nullable
    public static String openDialog(@NotNull Module module, @NotNull String title, @Nullable String currentValue, @Nullable Predicate<PsiClass> filter, String ... classes) {
        Project project;
        DumbService dumbService;
        if (module == null) {
            ChooseClassDialog.$$$reportNull$$$0(1);
        }
        if (title == null) {
            ChooseClassDialog.$$$reportNull$$$0(2);
        }
        if (classes == null) {
            ChooseClassDialog.$$$reportNull$$$0(3);
        }
        if ((dumbService = DumbService.getInstance((Project)(project = module.getProject()))).isDumb()) {
            dumbService.showDumbModeNotification(String.format("%1$s are not available while indices are updating.", title));
            return null;
        }
        ChooseClassDialog dialog = new ChooseClassDialog(module, title, true, filter, classes);
        if (currentValue != null) {
            dialog.setSelectedClass(currentValue);
        }
        if (!dialog.hasChoices()) {
            String emptyErrorTitle = "No " + title + " Found";
            String emptyErrorMessage = "You must first create one or more " + title + " in code";
            Messages.showErrorDialog((String)emptyErrorMessage, (String)emptyErrorTitle);
            return null;
        }
        return dialog.showAndGet() ? dialog.getClassName() : null;
    }

    @NotNull
    public static Predicate<PsiClass> getIsPublicAndUnrestrictedFilter() {
        Predicate<PsiClass> predicate = psiClass -> {
            PsiModifierList modifiers = psiClass.getModifierList();
            if (modifiers == null) {
                return false;
            }
            if (!modifiers.hasModifierProperty("public")) {
                return false;
            }
            for (PsiAnnotation annotation : modifiers.getAnnotations()) {
                if (!Objects.equals(annotation.getQualifiedName(), "android.support.annotation.RestrictTo")) continue;
                return false;
            }
            return true;
        };
        if (predicate == null) {
            ChooseClassDialog.$$$reportNull$$$0(4);
        }
        return predicate;
    }

    @NotNull
    public static Predicate<PsiClass> qualifiedNameFilter(@NotNull Predicate<String> filter) {
        if (filter == null) {
            ChooseClassDialog.$$$reportNull$$$0(5);
        }
        Predicate<PsiClass> predicate = psiClass -> {
            String qualifiedName;
            if (filter == null) {
                ChooseClassDialog.$$$reportNull$$$0(9);
            }
            if ((qualifiedName = psiClass.getQualifiedName()) == null) {
                return false;
            }
            return filter.test(qualifiedName);
        };
        if (predicate == null) {
            ChooseClassDialog.$$$reportNull$$$0(6);
        }
        return predicate;
    }

    @NotNull
    public static Predicate<String> getIsUserDefinedFilter() {
        Predicate<String> predicate = qualifiedName -> !qualifiedName.startsWith("android.") && !qualifiedName.startsWith("android.support.") && !qualifiedName.startsWith("com.google.android.");
        if (predicate == null) {
            ChooseClassDialog.$$$reportNull$$$0(7);
        }
        return predicate;
    }

    @NotNull
    public static Predicate<PsiClass> getUserDefinedPublicAndUnrestrictedFilter() {
        Predicate<PsiClass> predicate = ChooseClassDialog.getIsPublicAndUnrestrictedFilter().and(ChooseClassDialog.qualifiedNameFilter(ChooseClassDialog.getIsUserDefinedFilter()));
        if (predicate == null) {
            ChooseClassDialog.$$$reportNull$$$0(8);
        }
        return predicate;
    }

    private boolean hasChoices() {
        return this.myList.getModel().getSize() > 0;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    protected JComponent createCenterPanel() {
        return this.myComponent;
    }

    public String getClassName() {
        return this.myResultClassName;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        PsiClass psiClass = this.myList.getSelectedValue();
        this.setOKActionEnabled(psiClass != null);
        this.myResultClassName = psiClass == null ? null : psiClass.getQualifiedName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/uipreview/ChooseClassDialog";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/uipreview/ChooseClassDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsPublicAndUnrestrictedFilter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedNameFilter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsUserDefinedFilter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserDefinedPublicAndUnrestrictedFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openDialog";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedNameFilter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$qualifiedNameFilter$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

