/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.CountryCodeQualifier;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.KeyboardStateQualifier;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.NavigationMethodQualifier;
import com.android.ide.common.resources.configuration.NavigationStateQualifier;
import com.android.ide.common.resources.configuration.NetworkCodeQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.ScreenDimensionQualifier;
import com.android.ide.common.resources.configuration.ScreenHeightQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenRatioQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.ScreenWidthQualifier;
import com.android.ide.common.resources.configuration.SmallestScreenWidthQualifier;
import com.android.ide.common.resources.configuration.TextInputMethodQualifier;
import com.android.ide.common.resources.configuration.TouchScreenQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.Density;
import com.android.resources.Keyboard;
import com.android.resources.KeyboardState;
import com.android.resources.LayoutDirection;
import com.android.resources.Navigation;
import com.android.resources.NavigationState;
import com.android.resources.NightMode;
import com.android.resources.ResourceEnum;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenSize;
import com.android.resources.TouchScreen;
import com.android.resources.UiMode;
import com.android.tools.idea.rendering.FlagManager;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.uipreview.InvalidOptionValueException;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeviceConfiguratorPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.uipreview.DeviceConfiguratorPanel");
    private JBList myAvailableQualifiersList;
    private JButton myAddQualifierButton;
    private JButton myRemoveQualifierButton;
    private JPanel myQualifierOptionsPanel;
    private final Map<String, MyQualifierEditor> myEditors = new HashMap();
    private final FolderConfiguration myAvailableQualifiersConfig = new FolderConfiguration();
    private final FolderConfiguration myChosenQualifiersConfig = new FolderConfiguration();
    private FolderConfiguration myActualQualifiersConfig = new FolderConfiguration();
    private JBList myChosenQualifiersList;
    private final DocumentListener myUpdatingDocumentListener = new DocumentAdapter(){

        protected void textChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                1.$$$reportNull$$$0(0);
            }
            DeviceConfiguratorPanel.this.applyEditors();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$1", "textChanged"));
        }
    };
    public final ListSelectionListener myUpdatingListListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            DeviceConfiguratorPanel.this.applyEditors();
        }
    };
    private static final Map<String, Icon> ourIcons = Maps.newHashMapWithExpectedSize((int)25);

    public DeviceConfiguratorPanel() {
        super(new BorderLayout());
        this.createUIComponents();
        this.createDefaultConfig(this.myAvailableQualifiersConfig);
        this.myChosenQualifiersConfig.reset();
        for (ResourceQualifier qualifier : this.myAvailableQualifiersConfig.getQualifiers()) {
            String name = qualifier.getShortName();
            if (qualifier instanceof CountryCodeQualifier) {
                this.myEditors.put(name, new MyCountryCodeEditor());
                continue;
            }
            if (qualifier instanceof NetworkCodeQualifier) {
                this.myEditors.put(name, new MyNetworkCodeEditor());
                continue;
            }
            if (qualifier instanceof KeyboardStateQualifier) {
                this.myEditors.put(name, new MyKeyboardStateEditor());
                continue;
            }
            if (qualifier instanceof NavigationMethodQualifier) {
                this.myEditors.put(name, new MyNavigationMethodEditor());
                continue;
            }
            if (qualifier instanceof NavigationStateQualifier) {
                this.myEditors.put(name, new MyNavigationStateEditor());
                continue;
            }
            if (qualifier instanceof DensityQualifier) {
                this.myEditors.put(name, new MyDensityEditor());
                continue;
            }
            if (qualifier instanceof ScreenDimensionQualifier) {
                this.myEditors.put(name, new MyScreenDimensionEditor());
                continue;
            }
            if (qualifier instanceof ScreenOrientationQualifier) {
                this.myEditors.put(name, new MyScreenOrientationEditor());
                continue;
            }
            if (qualifier instanceof ScreenRatioQualifier) {
                this.myEditors.put(name, new MyScreenRatioEditor());
                continue;
            }
            if (qualifier instanceof ScreenSizeQualifier) {
                this.myEditors.put(name, new MyScreenSizeEditor());
                continue;
            }
            if (qualifier instanceof TextInputMethodQualifier) {
                this.myEditors.put(name, new MyTextInputMethodEditor());
                continue;
            }
            if (qualifier instanceof TouchScreenQualifier) {
                this.myEditors.put(name, new MyTouchScreenEditor());
                continue;
            }
            if (qualifier instanceof VersionQualifier) {
                this.myEditors.put(name, new MyVersionEditor());
                continue;
            }
            if (qualifier instanceof NightModeQualifier) {
                this.myEditors.put(name, new MyNightModeEditor());
                continue;
            }
            if (qualifier instanceof UiModeQualifier) {
                this.myEditors.put(name, new MyUiModeEditor());
                continue;
            }
            if (qualifier instanceof LocaleQualifier) {
                this.myEditors.put(name, new MyLocaleEditor());
                continue;
            }
            if (qualifier instanceof SmallestScreenWidthQualifier) {
                this.myEditors.put(name, new MySmallestScreenWidthEditor());
                continue;
            }
            if (qualifier instanceof ScreenWidthQualifier) {
                this.myEditors.put(name, new MyScreenWidthEditor());
                continue;
            }
            if (qualifier instanceof ScreenHeightQualifier) {
                this.myEditors.put(name, new MyScreenHeightEditor());
                continue;
            }
            if (qualifier instanceof LayoutDirectionQualifier) {
                this.myEditors.put(name, new MyLayoutDirectionEditor());
                continue;
            }
            LOG.info("Missing editor for qualifier " + qualifier);
        }
        for (String name : this.myEditors.keySet()) {
            MyQualifierEditor editor = this.myEditors.get(name);
            this.myQualifierOptionsPanel.add((Component)editor.getComponent(), name);
        }
        this.myAvailableQualifiersList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (value instanceof ResourceQualifier) {
                    ResourceQualifier qualifier = (ResourceQualifier)value;
                    this.append(qualifier.getShortName());
                    this.setIcon(DeviceConfiguratorPanel.getResourceIcon(qualifier));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$3", "customizeCellRenderer"));
            }
        });
        this.myChosenQualifiersList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (value instanceof ResourceQualifier) {
                    ResourceQualifier qualifier = DeviceConfiguratorPanel.this.getActualQualifier((ResourceQualifier)value);
                    String shortDisplayValue = qualifier.getShortDisplayValue();
                    if (shortDisplayValue != null && !shortDisplayValue.isEmpty()) {
                        this.append(shortDisplayValue);
                    } else {
                        this.append(qualifier.getShortName() + " (?)");
                    }
                    this.setIcon(DeviceConfiguratorPanel.getResourceIcon(qualifier));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$4", "customizeCellRenderer"));
            }
        });
        this.myAddQualifierButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceQualifier selectedQualifier = (ResourceQualifier)DeviceConfiguratorPanel.this.myAvailableQualifiersList.getSelectedValue();
                if (selectedQualifier != null) {
                    int index = DeviceConfiguratorPanel.this.myAvailableQualifiersList.getSelectedIndex();
                    DeviceConfiguratorPanel.this.myAvailableQualifiersConfig.removeQualifier(selectedQualifier);
                    DeviceConfiguratorPanel.this.myChosenQualifiersConfig.addQualifier(selectedQualifier);
                    DeviceConfiguratorPanel.this.updateLists();
                    DeviceConfiguratorPanel.this.applyEditors();
                    if (index >= 0) {
                        DeviceConfiguratorPanel.this.myAvailableQualifiersList.setSelectedIndex(Math.min(index, DeviceConfiguratorPanel.this.myAvailableQualifiersList.getItemsCount() - 1));
                    }
                    DeviceConfiguratorPanel.this.myChosenQualifiersList.setSelectedValue((Object)selectedQualifier, true);
                }
            }
        });
        this.myRemoveQualifierButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceQualifier selectedQualifier = (ResourceQualifier)DeviceConfiguratorPanel.this.myChosenQualifiersList.getSelectedValue();
                if (selectedQualifier != null) {
                    int index = DeviceConfiguratorPanel.this.myChosenQualifiersList.getSelectedIndex();
                    DeviceConfiguratorPanel.this.myChosenQualifiersConfig.removeQualifier(selectedQualifier);
                    DeviceConfiguratorPanel.this.myAvailableQualifiersConfig.addQualifier(selectedQualifier);
                    DeviceConfiguratorPanel.this.updateLists();
                    DeviceConfiguratorPanel.this.applyEditors();
                    if (index >= 0) {
                        DeviceConfiguratorPanel.this.myChosenQualifiersList.setSelectedIndex(Math.min(index, DeviceConfiguratorPanel.this.myChosenQualifiersList.getItemsCount() - 1));
                    }
                }
            }
        });
        this.myAvailableQualifiersList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DeviceConfiguratorPanel.this.updateButtons();
            }
        });
        this.myChosenQualifiersList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DeviceConfiguratorPanel.this.updateButtons();
                DeviceConfiguratorPanel.this.updateQualifierEditor();
            }
        });
    }

    @Nullable
    private static Icon getResourceIcon(ResourceQualifier qualifier) {
        return ourIcons.get(qualifier.getName());
    }

    public void init(@NotNull FolderConfiguration config) {
        if (config == null) {
            DeviceConfiguratorPanel.$$$reportNull$$$0(0);
        }
        this.myChosenQualifiersConfig.set(config);
        this.myAvailableQualifiersConfig.substract(config);
        for (ResourceQualifier qualifier : config.getQualifiers()) {
            MyQualifierEditor editor = this.myEditors.get(qualifier.getShortName());
            if (editor == null) continue;
            editor.reset(qualifier);
        }
    }

    protected void createDefaultConfig(FolderConfiguration config) {
        config.createDefault();
    }

    public abstract void applyEditors();

    public void updateAll() {
        this.updateLists();
        this.updateButtons();
        this.updateQualifierEditor();
        this.applyEditors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doApplyEditors() throws InvalidOptionValueException {
        try {
            FolderConfiguration newConfig = new FolderConfiguration();
            for (ResourceQualifier qualifier : this.myChosenQualifiersConfig.getQualifiers()) {
                MyQualifierEditor editor = this.myEditors.get(qualifier.getShortName());
                if (editor == null) continue;
                newConfig.addQualifier(editor.apply());
            }
            this.myActualQualifiersConfig = newConfig;
        }
        finally {
            this.myAvailableQualifiersList.repaint();
            this.myChosenQualifiersList.repaint();
        }
    }

    public DocumentListener getUpdatingDocumentListener() {
        return this.myUpdatingDocumentListener;
    }

    private ResourceQualifier getActualQualifier(ResourceQualifier qualifier) {
        for (ResourceQualifier qualifier1 : this.myActualQualifiersConfig.getQualifiers()) {
            if (!Comparing.equal((String)qualifier1.getShortName(), (String)qualifier.getShortName())) continue;
            return qualifier1;
        }
        return qualifier;
    }

    private void updateQualifierEditor() {
        ResourceQualifier selectedQualifier = (ResourceQualifier)this.myChosenQualifiersList.getSelectedValue();
        if (selectedQualifier != null && this.myEditors.containsKey(selectedQualifier.getShortName())) {
            CardLayout layout = (CardLayout)this.myQualifierOptionsPanel.getLayout();
            layout.show(this.myQualifierOptionsPanel, selectedQualifier.getShortName());
            this.myQualifierOptionsPanel.setVisible(true);
        } else {
            this.myQualifierOptionsPanel.setVisible(false);
        }
    }

    private void updateButtons() {
        this.myAddQualifierButton.setEnabled(this.myAvailableQualifiersList.getSelectedIndex() >= 0);
        this.myRemoveQualifierButton.setEnabled(this.myChosenQualifiersList.getSelectedIndex() >= 0);
    }

    private void updateLists() {
        Object qualifier = this.myAvailableQualifiersList.getSelectedValue();
        Object[] availableQualifiers = this.filterUnsupportedQualifiers(this.myAvailableQualifiersConfig.getQualifiers());
        this.myAvailableQualifiersList.setModel((ListModel)new CollectionListModel(availableQualifiers));
        this.myAvailableQualifiersList.setSelectedValue(qualifier, true);
        if (this.myAvailableQualifiersList.getSelectedValue() == null && this.myAvailableQualifiersList.getItemsCount() > 0) {
            this.myAvailableQualifiersList.setSelectedIndex(0);
        }
        qualifier = this.myChosenQualifiersList.getSelectedValue();
        Object[] chosenQualifiers = this.filterUnsupportedQualifiers(this.myChosenQualifiersConfig.getQualifiers());
        this.myChosenQualifiersList.setModel((ListModel)new CollectionListModel(chosenQualifiers));
        this.myChosenQualifiersList.setSelectedValue(qualifier, true);
        if (this.myChosenQualifiersList.getSelectedValue() == null && this.myChosenQualifiersList.getItemsCount() > 0) {
            this.myChosenQualifiersList.setSelectedIndex(0);
        }
    }

    private ResourceQualifier[] filterUnsupportedQualifiers(ResourceQualifier[] qualifiers) {
        ArrayList<ResourceQualifier> result = new ArrayList<ResourceQualifier>();
        for (ResourceQualifier qualifier : qualifiers) {
            if (!this.myEditors.containsKey(qualifier.getShortName())) continue;
            result.add(qualifier);
        }
        return result.toArray(new ResourceQualifier[result.size()]);
    }

    public FolderConfiguration getConfiguration() {
        return this.myActualQualifiersConfig;
    }

    private void createUIComponents() {
        this.myQualifierOptionsPanel = new JPanel(new CardLayout());
        final JPanel leftPanel = new JPanel(new BorderLayout(JBUI.scale((int)5), JBUI.scale((int)5)));
        this.myAvailableQualifiersList = new JBList();
        this.myAvailableQualifiersList.setMinimumSize((Dimension)JBUI.size((int)10, (int)10));
        JBLabel label = new JBLabel(AndroidBundle.message("android.layout.preview.edit.configuration.available.qualifiers.label", new Object[0]));
        label.setLabelFor((Component)this.myAvailableQualifiersList);
        leftPanel.add((Component)label, "North");
        leftPanel.add((Component)new JBScrollPane((Component)this.myAvailableQualifiersList, 20, 31), "Center");
        final JPanel rightPanel = new JPanel(new BorderLayout(JBUI.scale((int)5), JBUI.scale((int)5)));
        this.myChosenQualifiersList = new JBList();
        this.myChosenQualifiersList.setMinimumSize((Dimension)JBUI.size((int)10, (int)10));
        label = new JBLabel(AndroidBundle.message("android.layout.preview.edit.configuration.choosen.qualifiers.label", new Object[0]));
        label.setLabelFor((Component)this.myChosenQualifiersList);
        rightPanel.add((Component)label, "North");
        rightPanel.add((Component)new JBScrollPane((Component)this.myChosenQualifiersList, 20, 31), "Center");
        final JPanel buttonsPanel = new JPanel((LayoutManager)new VerticalFlowLayout(1, 0, 0, true, false));
        this.myAddQualifierButton = new JButton(">>");
        buttonsPanel.add(this.myAddQualifierButton);
        this.myRemoveQualifierButton = new JButton("<<");
        buttonsPanel.add(this.myRemoveQualifierButton);
        int gap = 5;
        JPanel listsPanel = new JPanel((LayoutManager)new AbstractLayoutManager(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Dimension preferredLayoutSize(Container target) {
                Object object = target.getTreeLock();
                synchronized (object) {
                    Dimension leftPref = leftPanel.getPreferredSize();
                    Dimension rightPref = rightPanel.getPreferredSize();
                    Dimension middlePref = buttonsPanel.getPreferredSize();
                    Insets insets = target.getInsets();
                    int width = leftPref.width + middlePref.width + rightPref.width + insets.left + insets.right + 10;
                    int height = Math.max(leftPref.height, Math.max(rightPref.height, middlePref.height)) + insets.top + insets.bottom;
                    return new Dimension(width, height);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void layoutContainer(Container target) {
                Object object = target.getTreeLock();
                synchronized (object) {
                    Insets insets = target.getInsets();
                    int top = insets.top;
                    int bottom = target.getHeight() - insets.bottom;
                    int left = insets.left;
                    int right = target.getWidth() - insets.right;
                    int middleWidth = buttonsPanel.getPreferredSize().width + 10;
                    int listWidth = (right - left - middleWidth) / 2;
                    int height = bottom - top;
                    leftPanel.setSize(listWidth, height);
                    rightPanel.setSize(listWidth, height);
                    buttonsPanel.setSize(middleWidth, height);
                    leftPanel.setBounds(left, top, listWidth, height);
                    rightPanel.setBounds(right - listWidth, top, listWidth, height);
                    buttonsPanel.setBounds(left + listWidth + 5, top, middleWidth - 10, height);
                }
            }
        });
        listsPanel.add(leftPanel);
        listsPanel.add(buttonsPanel);
        listsPanel.add(rightPanel);
        this.add((Component)listsPanel, "Center");
        this.add((Component)this.myQualifierOptionsPanel, "East");
    }

    public JBList getAvailableQualifiersList() {
        return this.myAvailableQualifiersList;
    }

    static {
        ourIcons.put("UI Mode", AndroidIcons.Configs.Dock);
        ourIcons.put("Night Mode", AndroidIcons.Configs.Night);
        ourIcons.put("Screen Dimension", AndroidIcons.Configs.Dimension);
        ourIcons.put("Density", AndroidIcons.Configs.Dpi);
        ourIcons.put("Screen Height", AndroidIcons.Configs.Height);
        ourIcons.put("Keyboard State", AndroidIcons.Configs.Keyboard);
        ourIcons.put("Locale", AndroidIcons.Configs.Locale);
        ourIcons.put("Mobile Country Code", AndroidIcons.Configs.Mcc);
        ourIcons.put("Mobile Network Code", AndroidIcons.Configs.Mnc);
        ourIcons.put("Navigation State", AndroidIcons.Configs.Navpad);
        ourIcons.put("Navigation Method", AndroidIcons.Configs.NavpadMethod);
        ourIcons.put("Screen Orientation", AndroidIcons.Configs.Orientation);
        ourIcons.put("Screen Ratio", AndroidIcons.Configs.Ratio);
        ourIcons.put("Screen Size", AndroidIcons.Configs.Size);
        ourIcons.put("Smallest Screen Width", AndroidIcons.Configs.SmallestWidth);
        ourIcons.put("Screen Width", AndroidIcons.Configs.Width);
        ourIcons.put("Text Input Method", AndroidIcons.Configs.TextInput);
        ourIcons.put("Touch Screen", AndroidIcons.Configs.Touch);
        ourIcons.put("Layout Direction", AndroidIcons.Configs.LayoutDirection);
        ourIcons.put("Platform Version", AndroidIcons.Targets);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/android/uipreview/DeviceConfiguratorPanel", "init"));
    }

    private class MyScreenHeightEditor
    extends MySizeEditorBase<ScreenHeightQualifier> {
        private MyScreenHeightEditor() {
            super("Screen height:");
        }

        @Override
        protected int getValue(@NotNull ScreenHeightQualifier qualifier) {
            if (qualifier == null) {
                MyScreenHeightEditor.$$$reportNull$$$0(0);
            }
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected ScreenHeightQualifier createQualifier(int value) {
            ScreenHeightQualifier screenHeightQualifier = new ScreenHeightQualifier(value);
            if (screenHeightQualifier == null) {
                MyScreenHeightEditor.$$$reportNull$$$0(1);
            }
            return screenHeightQualifier;
        }

        @Override
        protected String getErrorMessage() {
            return "Incorrect screen height";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenHeightEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenHeightEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createQualifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyScreenWidthEditor
    extends MySizeEditorBase<ScreenWidthQualifier> {
        private MyScreenWidthEditor() {
            super("Screen width:");
        }

        @Override
        protected int getValue(@NotNull ScreenWidthQualifier qualifier) {
            if (qualifier == null) {
                MyScreenWidthEditor.$$$reportNull$$$0(0);
            }
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected ScreenWidthQualifier createQualifier(int value) {
            ScreenWidthQualifier screenWidthQualifier = new ScreenWidthQualifier(value);
            if (screenWidthQualifier == null) {
                MyScreenWidthEditor.$$$reportNull$$$0(1);
            }
            return screenWidthQualifier;
        }

        @Override
        protected String getErrorMessage() {
            return "Incorrect screen width";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenWidthEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenWidthEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createQualifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MySmallestScreenWidthEditor
    extends MySizeEditorBase<SmallestScreenWidthQualifier> {
        private MySmallestScreenWidthEditor() {
            super("Smallest screen width:");
        }

        @Override
        protected int getValue(@NotNull SmallestScreenWidthQualifier qualifier) {
            if (qualifier == null) {
                MySmallestScreenWidthEditor.$$$reportNull$$$0(0);
            }
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected SmallestScreenWidthQualifier createQualifier(int value) {
            SmallestScreenWidthQualifier smallestScreenWidthQualifier = new SmallestScreenWidthQualifier(value);
            if (smallestScreenWidthQualifier == null) {
                MySmallestScreenWidthEditor.$$$reportNull$$$0(1);
            }
            return smallestScreenWidthQualifier;
        }

        @Override
        protected String getErrorMessage() {
            return "Incorrect smallest screen width";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MySmallestScreenWidthEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MySmallestScreenWidthEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createQualifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private abstract class MySizeEditorBase<T extends ResourceQualifier>
    extends MyQualifierEditor<T> {
        private final JTextField myTextField;
        private String myLabelText;

        protected MySizeEditorBase(String labelText) {
            this.myTextField = new JTextField(3);
            this.myLabelText = labelText;
        }

        @Override
        JComponent getComponent() {
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel(this.myLabelText);
            panel.add((Component)label);
            label.setLabelFor((Component)this.myTextField);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel.add(this.myTextField);
            return panel;
        }

        @Override
        void reset(@NotNull T qualifier) {
            if (qualifier == null) {
                MySizeEditorBase.$$$reportNull$$$0(0);
            }
            this.myTextField.setText(Integer.toString(this.getValue(qualifier)));
        }

        protected abstract int getValue(@NotNull T var1);

        @NotNull
        protected abstract T createQualifier(int var1);

        protected abstract String getErrorMessage();

        @Override
        @NotNull
        T apply() throws InvalidOptionValueException {
            T t;
            try {
                int value = Integer.parseInt(this.myTextField.getText().trim());
                if (value < 0) {
                    throw new InvalidOptionValueException(this.getErrorMessage());
                }
                t = this.createQualifier(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidOptionValueException(this.getErrorMessage());
            }
            if (t == null) {
                MySizeEditorBase.$$$reportNull$$$0(1);
            }
            return t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MySizeEditorBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MySizeEditorBase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyLocaleEditor
    extends MyQualifierEditor<LocaleQualifier> {
        private final JBList myLanguageList;
        private final JBList myRegionList;
        private JBCheckBox myShowAllRegions;
        private JBLabel myWarningsLabel;

        private MyLocaleEditor() {
            this.myLanguageList = new JBList();
            this.myRegionList = new JBList();
        }

        @Override
        JComponent getComponent() {
            JPanel pane = new JPanel(new GridBagLayout());
            pane.setBorder((Border)JBUI.Borders.empty((int)0, (int)20, (int)0, (int)0));
            this.myShowAllRegions = new JBCheckBox("Show All Regions", false);
            this.myWarningsLabel = new JBLabel("BCP 47 tags (3-letter languages or regions) will only match on API 21");
            this.myWarningsLabel.setIcon(AllIcons.General.BalloonWarning);
            this.myWarningsLabel.setVisible(false);
            JBLabel languageLabel = new JBLabel("Language:");
            JBLabel languageTip = new JBLabel("Tip: Type in list to filter");
            JBLabel regionLabel = new JBLabel("Specific Region Only:");
            SortedListModel languageModel = new SortedListModel((Comparator)new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    int delta = s1.length() - s2.length();
                    if (delta != 0) {
                        return delta;
                    }
                    return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
                }
            });
            languageModel.addAll((Collection)LocaleManager.getLanguageCodes((boolean)true));
            this.myLanguageList.setModel((ListModel)languageModel);
            this.myLanguageList.setSelectionMode(0);
            this.myLanguageList.setCellRenderer(FlagManager.get().getLanguageCodeCellRenderer());
            JBScrollPane scroll = new JBScrollPane((Component)this.myLanguageList);
            JComponent languagePane = ListWithFilter.wrap((JList)this.myLanguageList, (JScrollPane)scroll, FlagManager.getLanguageNameMapper());
            languageLabel.setLabelFor((Component)this.myLanguageList);
            languageTip.setFont((Font)JBUI.Fonts.miniFont());
            this.myRegionList.setSelectionMode(0);
            this.myRegionList.setCellRenderer(FlagManager.get().getRegionCodeCellRenderer());
            this.updateRegionList(null);
            JBScrollPane regionPane = new JBScrollPane((Component)this.myRegionList);
            Insets insets = new Insets(0, 20, 0, 0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            pane.add((Component)languageLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = insets;
            pane.add((Component)regionLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            pane.add((Component)languagePane, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = insets;
            pane.add((Component)regionPane, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            pane.add((Component)languageTip, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = insets;
            pane.add((Component)this.myShowAllRegions, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 21;
            pane.add((Component)this.myWarningsLabel, gridBagConstraints);
            this.myLanguageList.addListSelectionListener(DeviceConfiguratorPanel.this.myUpdatingListListener);
            this.myRegionList.addListSelectionListener(DeviceConfiguratorPanel.this.myUpdatingListListener);
            this.myLanguageList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    MyLocaleEditor.this.updateRegionList((String)MyLocaleEditor.this.myLanguageList.getSelectedValue());
                }
            });
            this.myShowAllRegions.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    MyLocaleEditor.this.updateRegionList((String)MyLocaleEditor.this.myLanguageList.getSelectedValue());
                }
            });
            return pane;
        }

        private void updateRegionList(@Nullable String languageCode) {
            final Ref preferred = new Ref(null);
            SortedListModel regionModel = new SortedListModel((Comparator)new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    if (s1.equals("__")) {
                        return -1;
                    }
                    if (s2.equals("__")) {
                        return 1;
                    }
                    if (s1.equals(preferred.get())) {
                        return -1;
                    }
                    if (s2.equals(preferred.get())) {
                        return 1;
                    }
                    int delta = s1.length() - s2.length();
                    if (delta != 0) {
                        return delta;
                    }
                    return String.CASE_INSENSITIVE_ORDER.compare(s1, s2);
                }
            });
            regionModel.add((Object)"__");
            if (!this.myShowAllRegions.isSelected() && languageCode != null) {
                preferred.set((Object)LocaleManager.getLanguageRegion((String)languageCode));
                List relevant = LocaleManager.getRelevantRegions((String)languageCode);
                for (String code : relevant) {
                    regionModel.add((Object)code);
                }
            } else {
                for (String code : LocaleManager.getRegionCodes((boolean)true)) {
                    regionModel.add((Object)code);
                }
            }
            this.myRegionList.setModel((ListModel)regionModel);
            if (languageCode != null && regionModel.getSize() > 0) {
                this.myRegionList.setSelectedIndex(0);
            }
        }

        @Override
        void reset(@NotNull LocaleQualifier qualifier) {
            if (qualifier == null) {
                MyLocaleEditor.$$$reportNull$$$0(0);
            }
            if (qualifier.isValid() && !qualifier.hasFakeValue()) {
                String language = qualifier.getLanguage();
                String region = qualifier.getRegion();
                ListModel languageModel = this.myLanguageList.getModel();
                ListModel regionModel = this.myRegionList.getModel();
                int n = languageModel.getSize();
                for (int i = 0; i < n; ++i) {
                    if (!language.equals(languageModel.getElementAt(i))) continue;
                    this.myLanguageList.setSelectedIndex(i);
                    break;
                }
                if (region != null) {
                    int i;
                    boolean found = false;
                    int n2 = regionModel.getSize();
                    for (i = 0; i < n2; ++i) {
                        if (!region.equals(regionModel.getElementAt(i))) continue;
                        this.myRegionList.setSelectedIndex(i);
                        found = true;
                        break;
                    }
                    if (!found && !this.myShowAllRegions.isSelected()) {
                        this.myShowAllRegions.setSelected(true);
                        n2 = regionModel.getSize();
                        for (i = 0; i < n2; ++i) {
                            if (!region.equals(regionModel.getElementAt(i))) continue;
                            this.myRegionList.setSelectedIndex(i);
                            break;
                        }
                    }
                } else {
                    this.myRegionList.setSelectedIndex(-1);
                }
            } else {
                this.myLanguageList.setSelectedIndex(-1);
                this.myRegionList.setSelectedIndex(-1);
            }
        }

        @Override
        @NotNull
        LocaleQualifier apply() throws InvalidOptionValueException {
            String selectedLanguage = (String)this.myLanguageList.getSelectedValue();
            if (selectedLanguage == null) {
                throw new InvalidOptionValueException("Select a language tag");
            }
            String selectedRegion = (String)this.myRegionList.getSelectedValue();
            if ("__".equals(selectedRegion)) {
                selectedRegion = null;
            }
            this.myWarningsLabel.setVisible(selectedLanguage.length() > 2 || selectedRegion != null && selectedRegion.length() > 2);
            LocaleQualifier localeQualifier = new LocaleQualifier(null, selectedLanguage, selectedRegion, null);
            if (localeQualifier == null) {
                MyLocaleEditor.$$$reportNull$$$0(1);
            }
            return localeQualifier;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyLocaleEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyLocaleEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyUiModeEditor
    extends MyEnumBasedEditor<UiModeQualifier, UiMode> {
        private MyUiModeEditor() {
            super(UiMode.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("UI mode:" == null) {
                MyUiModeEditor.$$$reportNull$$$0(0);
            }
            return "UI mode:";
        }

        @Override
        protected UiMode getValue(@NotNull UiModeQualifier qualifier) {
            if (qualifier == null) {
                MyUiModeEditor.$$$reportNull$$$0(1);
            }
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected UiModeQualifier getQualifier(@NotNull UiMode value) {
            if (value == null) {
                MyUiModeEditor.$$$reportNull$$$0(2);
            }
            UiModeQualifier uiModeQualifier = new UiModeQualifier(value);
            if (uiModeQualifier == null) {
                MyUiModeEditor.$$$reportNull$$$0(3);
            }
            return uiModeQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify UI mode" == null) {
                MyUiModeEditor.$$$reportNull$$$0(4);
            }
            return "Specify UI mode";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyUiModeEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCaption";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyUiModeEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifier";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyNightModeEditor
    extends MyEnumBasedEditor<NightModeQualifier, NightMode> {
        protected MyNightModeEditor() {
            super(NightMode.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Night mode:" == null) {
                MyNightModeEditor.$$$reportNull$$$0(0);
            }
            return "Night mode:";
        }

        @Override
        protected NightMode getValue(@NotNull NightModeQualifier qualifier) {
            if (qualifier == null) {
                MyNightModeEditor.$$$reportNull$$$0(1);
            }
            return qualifier.getValue();
        }

        @Override
        @NotNull
        protected NightModeQualifier getQualifier(@NotNull NightMode value) {
            if (value == null) {
                MyNightModeEditor.$$$reportNull$$$0(2);
            }
            NightModeQualifier nightModeQualifier = new NightModeQualifier(value);
            if (nightModeQualifier == null) {
                MyNightModeEditor.$$$reportNull$$$0(3);
            }
            return nightModeQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify night mode" == null) {
                MyNightModeEditor.$$$reportNull$$$0(4);
            }
            return "Specify night mode";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNightModeEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCaption";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNightModeEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifier";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyVersionEditor
    extends MyQualifierEditor<VersionQualifier> {
        private final JTextField myTextField;

        private MyVersionEditor() {
            this.myTextField = new JTextField(3);
        }

        @Override
        JComponent getComponent() {
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel("Platform API level:");
            panel.add((Component)label);
            label.setLabelFor((Component)this.myTextField);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel.add(this.myTextField);
            return panel;
        }

        @Override
        void reset(@NotNull VersionQualifier qualifier) {
            if (qualifier == null) {
                MyVersionEditor.$$$reportNull$$$0(0);
            }
            this.myTextField.setText(Integer.toString(qualifier.getVersion()));
        }

        @Override
        @NotNull
        VersionQualifier apply() throws InvalidOptionValueException {
            VersionQualifier versionQualifier;
            block3: {
                try {
                    int apiLevel = Integer.parseInt(this.myTextField.getText().trim());
                    if (apiLevel < 0) {
                        throw new InvalidOptionValueException("Incorrect API level");
                    }
                    versionQualifier = new VersionQualifier(apiLevel);
                    if (versionQualifier != null) break block3;
                }
                catch (NumberFormatException e) {
                    throw new InvalidOptionValueException("Incorrect API level");
                }
                MyVersionEditor.$$$reportNull$$$0(1);
            }
            return versionQualifier;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyVersionEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyVersionEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyScreenDimensionEditor
    extends MyQualifierEditor<ScreenDimensionQualifier> {
        private final JTextField mySizeField1;
        private final JTextField mySizeField2;

        private MyScreenDimensionEditor() {
            this.mySizeField1 = new JTextField();
            this.mySizeField2 = new JTextField();
        }

        @Override
        JComponent getComponent() {
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel("Screen dimension in dp:");
            label.setLabelFor((Component)this.mySizeField1);
            panel.add((Component)label);
            panel.add(this.mySizeField1);
            panel.add(this.mySizeField2);
            this.mySizeField1.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            this.mySizeField2.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            return panel;
        }

        @Override
        void reset(@NotNull ScreenDimensionQualifier qualifier) {
            int value2;
            int value1;
            if (qualifier == null) {
                MyScreenDimensionEditor.$$$reportNull$$$0(0);
            }
            if ((value1 = qualifier.getValue1()) >= 0) {
                this.mySizeField1.setText(Integer.toString(value1));
            }
            if ((value2 = qualifier.getValue2()) >= 0) {
                this.mySizeField2.setText(Integer.toString(value2));
            }
        }

        @Override
        @NotNull
        ScreenDimensionQualifier apply() throws InvalidOptionValueException {
            ScreenDimensionQualifier screenDimensionQualifier;
            block3: {
                try {
                    int size1 = Integer.parseInt(this.mySizeField1.getText());
                    int size2 = Integer.parseInt(this.mySizeField2.getText());
                    if (size1 <= 0 || size2 <= 0) {
                        throw new InvalidOptionValueException("Incorrect screen dimension");
                    }
                    screenDimensionQualifier = new ScreenDimensionQualifier(size1, size2);
                    if (screenDimensionQualifier != null) break block3;
                }
                catch (NumberFormatException e) {
                    LOG.debug((Throwable)e);
                    throw new InvalidOptionValueException("Incorrect screen dimension");
                }
                MyScreenDimensionEditor.$$$reportNull$$$0(1);
            }
            return screenDimensionQualifier;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenDimensionEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenDimensionEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyLayoutDirectionEditor
    extends MyEnumBasedEditor<LayoutDirectionQualifier, LayoutDirection> {
        private MyLayoutDirectionEditor() {
            super(LayoutDirection.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Layout direction:" == null) {
                MyLayoutDirectionEditor.$$$reportNull$$$0(0);
            }
            return "Layout direction:";
        }

        @Override
        @NotNull
        protected LayoutDirection getValue(@NotNull LayoutDirectionQualifier qualifier) {
            if (qualifier == null) {
                MyLayoutDirectionEditor.$$$reportNull$$$0(1);
            }
            LayoutDirection layoutDirection = qualifier.getValue();
            if (layoutDirection == null) {
                MyLayoutDirectionEditor.$$$reportNull$$$0(2);
            }
            return layoutDirection;
        }

        @Override
        @NotNull
        protected LayoutDirectionQualifier getQualifier(@NotNull LayoutDirection value) {
            if (value == null) {
                MyLayoutDirectionEditor.$$$reportNull$$$0(3);
            }
            LayoutDirectionQualifier layoutDirectionQualifier = new LayoutDirectionQualifier(value);
            if (layoutDirectionQualifier == null) {
                MyLayoutDirectionEditor.$$$reportNull$$$0(4);
            }
            return layoutDirectionQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify layout direction" == null) {
                MyLayoutDirectionEditor.$$$reportNull$$$0(5);
            }
            return "Specify layout direction";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyLayoutDirectionEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCaption";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyLayoutDirectionEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifier";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyNavigationMethodEditor
    extends MyEnumBasedEditor<NavigationMethodQualifier, Navigation> {
        private MyNavigationMethodEditor() {
            super(Navigation.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Navigation method:" == null) {
                MyNavigationMethodEditor.$$$reportNull$$$0(0);
            }
            return "Navigation method:";
        }

        @Override
        @NotNull
        protected Navigation getValue(@NotNull NavigationMethodQualifier qualifier) {
            if (qualifier == null) {
                MyNavigationMethodEditor.$$$reportNull$$$0(1);
            }
            Navigation navigation = qualifier.getValue();
            if (navigation == null) {
                MyNavigationMethodEditor.$$$reportNull$$$0(2);
            }
            return navigation;
        }

        @Override
        @NotNull
        protected NavigationMethodQualifier getQualifier(@NotNull Navigation value) {
            if (value == null) {
                MyNavigationMethodEditor.$$$reportNull$$$0(3);
            }
            NavigationMethodQualifier navigationMethodQualifier = new NavigationMethodQualifier(value);
            if (navigationMethodQualifier == null) {
                MyNavigationMethodEditor.$$$reportNull$$$0(4);
            }
            return navigationMethodQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify navigation method" == null) {
                MyNavigationMethodEditor.$$$reportNull$$$0(5);
            }
            return "Specify navigation method";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationMethodEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCaption";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationMethodEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifier";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyNavigationStateEditor
    extends MyEnumBasedEditor<NavigationStateQualifier, NavigationState> {
        private MyNavigationStateEditor() {
            super(NavigationState.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Navigation state:" == null) {
                MyNavigationStateEditor.$$$reportNull$$$0(0);
            }
            return "Navigation state:";
        }

        @Override
        @NotNull
        protected NavigationState getValue(@NotNull NavigationStateQualifier qualifier) {
            if (qualifier == null) {
                MyNavigationStateEditor.$$$reportNull$$$0(1);
            }
            NavigationState navigationState = qualifier.getValue();
            if (navigationState == null) {
                MyNavigationStateEditor.$$$reportNull$$$0(2);
            }
            return navigationState;
        }

        @Override
        @NotNull
        protected NavigationStateQualifier getQualifier(@NotNull NavigationState value) {
            if (value == null) {
                MyNavigationStateEditor.$$$reportNull$$$0(3);
            }
            NavigationStateQualifier navigationStateQualifier = new NavigationStateQualifier(value);
            if (navigationStateQualifier == null) {
                MyNavigationStateEditor.$$$reportNull$$$0(4);
            }
            return navigationStateQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify navigation state" == null) {
                MyNavigationStateEditor.$$$reportNull$$$0(5);
            }
            return "Specify navigation state";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationStateEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCaption";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNavigationStateEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifier";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyTextInputMethodEditor
    extends MyEnumBasedEditor<TextInputMethodQualifier, Keyboard> {
        private MyTextInputMethodEditor() {
            super(Keyboard.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Text input method:" == null) {
                MyTextInputMethodEditor.$$$reportNull$$$0(0);
            }
            return "Text input method:";
        }

        @Override
        @NotNull
        protected Keyboard getValue(@NotNull TextInputMethodQualifier qualifier) {
            if (qualifier == null) {
                MyTextInputMethodEditor.$$$reportNull$$$0(1);
            }
            Keyboard keyboard = qualifier.getValue();
            if (keyboard == null) {
                MyTextInputMethodEditor.$$$reportNull$$$0(2);
            }
            return keyboard;
        }

        @Override
        @NotNull
        protected TextInputMethodQualifier getQualifier(@NotNull Keyboard value) {
            if (value == null) {
                MyTextInputMethodEditor.$$$reportNull$$$0(3);
            }
            TextInputMethodQualifier textInputMethodQualifier = new TextInputMethodQualifier(value);
            if (textInputMethodQualifier == null) {
                MyTextInputMethodEditor.$$$reportNull$$$0(4);
            }
            return textInputMethodQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify text input method" == null) {
                MyTextInputMethodEditor.$$$reportNull$$$0(5);
            }
            return "Specify text input method";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTextInputMethodEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCaption";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTextInputMethodEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifier";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyKeyboardStateEditor
    extends MyEnumBasedEditor<KeyboardStateQualifier, KeyboardState> {
        private MyKeyboardStateEditor() {
            super(KeyboardState.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Keyboard state:" == null) {
                MyKeyboardStateEditor.$$$reportNull$$$0(0);
            }
            return "Keyboard state:";
        }

        @Override
        @NotNull
        protected KeyboardState getValue(@NotNull KeyboardStateQualifier qualifier) {
            if (qualifier == null) {
                MyKeyboardStateEditor.$$$reportNull$$$0(1);
            }
            KeyboardState keyboardState = qualifier.getValue();
            if (keyboardState == null) {
                MyKeyboardStateEditor.$$$reportNull$$$0(2);
            }
            return keyboardState;
        }

        @Override
        @NotNull
        protected KeyboardStateQualifier getQualifier(@NotNull KeyboardState value) {
            if (value == null) {
                MyKeyboardStateEditor.$$$reportNull$$$0(3);
            }
            KeyboardStateQualifier keyboardStateQualifier = new KeyboardStateQualifier(value);
            if (keyboardStateQualifier == null) {
                MyKeyboardStateEditor.$$$reportNull$$$0(4);
            }
            return keyboardStateQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify keyboard state" == null) {
                MyKeyboardStateEditor.$$$reportNull$$$0(5);
            }
            return "Specify keyboard state";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyKeyboardStateEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCaption";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyKeyboardStateEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifier";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyTouchScreenEditor
    extends MyEnumBasedEditor<TouchScreenQualifier, TouchScreen> {
        private MyTouchScreenEditor() {
            super(TouchScreen.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Touch screen:" == null) {
                MyTouchScreenEditor.$$$reportNull$$$0(0);
            }
            return "Touch screen:";
        }

        @Override
        @NotNull
        protected TouchScreen getValue(@NotNull TouchScreenQualifier qualifier) {
            if (qualifier == null) {
                MyTouchScreenEditor.$$$reportNull$$$0(1);
            }
            TouchScreen touchScreen = qualifier.getValue();
            if (touchScreen == null) {
                MyTouchScreenEditor.$$$reportNull$$$0(2);
            }
            return touchScreen;
        }

        @Override
        @NotNull
        protected TouchScreenQualifier getQualifier(@NotNull TouchScreen value) {
            if (value == null) {
                MyTouchScreenEditor.$$$reportNull$$$0(3);
            }
            TouchScreenQualifier touchScreenQualifier = new TouchScreenQualifier(value);
            if (touchScreenQualifier == null) {
                MyTouchScreenEditor.$$$reportNull$$$0(4);
            }
            return touchScreenQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify touch screen" == null) {
                MyTouchScreenEditor.$$$reportNull$$$0(5);
            }
            return "Specify touch screen";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTouchScreenEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCaption";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyTouchScreenEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifier";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyDensityEditor
    extends MyEnumBasedEditor<DensityQualifier, Density> {
        private MyDensityEditor() {
            super(Density.class);
        }

        @Override
        protected ComboBoxModel createModel() {
            return new DensityComboBoxModel();
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Density:" == null) {
                MyDensityEditor.$$$reportNull$$$0(0);
            }
            return "Density:";
        }

        @Override
        @NotNull
        protected Density getValue(@NotNull DensityQualifier qualifier) {
            if (qualifier == null) {
                MyDensityEditor.$$$reportNull$$$0(1);
            }
            Density density = qualifier.getValue();
            if (density == null) {
                MyDensityEditor.$$$reportNull$$$0(2);
            }
            return density;
        }

        @Override
        @NotNull
        protected DensityQualifier getQualifier(@NotNull Density value) {
            if (value == null) {
                MyDensityEditor.$$$reportNull$$$0(3);
            }
            DensityQualifier densityQualifier = new DensityQualifier(value);
            if (densityQualifier == null) {
                MyDensityEditor.$$$reportNull$$$0(4);
            }
            return densityQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify density" == null) {
                MyDensityEditor.$$$reportNull$$$0(5);
            }
            return "Specify density";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyDensityEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCaption";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyDensityEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifier";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DensityComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final List<Density> myList = new ArrayList<Density>();
        private Density mySelected = null;

        DensityComboBoxModel() {
            for (Density density : Density.values()) {
                if (!density.isRecommended()) continue;
                this.myList.add(density);
            }
            this.mySelected = this.myList.get(0);
        }

        @Override
        public int getSize() {
            return this.myList.size();
        }

        @Override
        public Density getElementAt(int index) {
            return this.myList.get(index);
        }

        @Override
        public void setSelectedItem(Object item) {
            Density e = (Density)item;
            this.setSelectedItem(e);
        }

        public void setSelectedItem(Density item) {
            this.mySelected = item;
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public Density getSelectedItem() {
            return this.mySelected;
        }
    }

    private class MyScreenRatioEditor
    extends MyEnumBasedEditor<ScreenRatioQualifier, ScreenRatio> {
        private MyScreenRatioEditor() {
            super(ScreenRatio.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Screen ratio:" == null) {
                MyScreenRatioEditor.$$$reportNull$$$0(0);
            }
            return "Screen ratio:";
        }

        @Override
        @NotNull
        protected ScreenRatio getValue(@NotNull ScreenRatioQualifier qualifier) {
            if (qualifier == null) {
                MyScreenRatioEditor.$$$reportNull$$$0(1);
            }
            ScreenRatio screenRatio = qualifier.getValue();
            if (screenRatio == null) {
                MyScreenRatioEditor.$$$reportNull$$$0(2);
            }
            return screenRatio;
        }

        @Override
        @NotNull
        protected ScreenRatioQualifier getQualifier(@NotNull ScreenRatio value) {
            if (value == null) {
                MyScreenRatioEditor.$$$reportNull$$$0(3);
            }
            ScreenRatioQualifier screenRatioQualifier = new ScreenRatioQualifier(value);
            if (screenRatioQualifier == null) {
                MyScreenRatioEditor.$$$reportNull$$$0(4);
            }
            return screenRatioQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify screen ratio" == null) {
                MyScreenRatioEditor.$$$reportNull$$$0(5);
            }
            return "Specify screen ratio";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenRatioEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCaption";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenRatioEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifier";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyScreenOrientationEditor
    extends MyEnumBasedEditor<ScreenOrientationQualifier, ScreenOrientation> {
        private MyScreenOrientationEditor() {
            super(ScreenOrientation.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Screen orientation:" == null) {
                MyScreenOrientationEditor.$$$reportNull$$$0(0);
            }
            return "Screen orientation:";
        }

        @Override
        @NotNull
        protected ScreenOrientation getValue(@NotNull ScreenOrientationQualifier qualifier) {
            if (qualifier == null) {
                MyScreenOrientationEditor.$$$reportNull$$$0(1);
            }
            ScreenOrientation screenOrientation = qualifier.getValue();
            if (screenOrientation == null) {
                MyScreenOrientationEditor.$$$reportNull$$$0(2);
            }
            return screenOrientation;
        }

        @Override
        @NotNull
        protected ScreenOrientationQualifier getQualifier(@NotNull ScreenOrientation value) {
            if (value == null) {
                MyScreenOrientationEditor.$$$reportNull$$$0(3);
            }
            ScreenOrientationQualifier screenOrientationQualifier = new ScreenOrientationQualifier(value);
            if (screenOrientationQualifier == null) {
                MyScreenOrientationEditor.$$$reportNull$$$0(4);
            }
            return screenOrientationQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify screen orientation" == null) {
                MyScreenOrientationEditor.$$$reportNull$$$0(5);
            }
            return "Specify screen orientation";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenOrientationEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCaption";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenOrientationEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifier";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyScreenSizeEditor
    extends MyEnumBasedEditor<ScreenSizeQualifier, ScreenSize> {
        private MyScreenSizeEditor() {
            super(ScreenSize.class);
        }

        @Override
        @NotNull
        protected String getCaption() {
            if ("Screen size:" == null) {
                MyScreenSizeEditor.$$$reportNull$$$0(0);
            }
            return "Screen size:";
        }

        @Override
        @NotNull
        protected ScreenSize getValue(@NotNull ScreenSizeQualifier qualifier) {
            if (qualifier == null) {
                MyScreenSizeEditor.$$$reportNull$$$0(1);
            }
            ScreenSize screenSize = qualifier.getValue();
            if (screenSize == null) {
                MyScreenSizeEditor.$$$reportNull$$$0(2);
            }
            return screenSize;
        }

        @Override
        @NotNull
        protected ScreenSizeQualifier getQualifier(@NotNull ScreenSize value) {
            if (value == null) {
                MyScreenSizeEditor.$$$reportNull$$$0(3);
            }
            ScreenSizeQualifier screenSizeQualifier = new ScreenSizeQualifier(value);
            if (screenSizeQualifier == null) {
                MyScreenSizeEditor.$$$reportNull$$$0(4);
            }
            return screenSizeQualifier;
        }

        @Override
        @NotNull
        protected String getErrorMessage() {
            if ("Specify screen size" == null) {
                MyScreenSizeEditor.$$$reportNull$$$0(5);
            }
            return "Specify screen size";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenSizeEditor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCaption";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyScreenSizeEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifier";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getQualifier";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private abstract class MyEnumBasedEditor<T extends ResourceQualifier, U extends Enum<U>>
    extends MyQualifierEditor<T> {
        private final JComboBox myComboBox;
        private final Class<U> myEnumClass;

        protected MyEnumBasedEditor(Class<U> enumClass) {
            if (enumClass == null) {
                MyEnumBasedEditor.$$$reportNull$$$0(0);
            }
            this.myComboBox = new JComboBox();
            this.myEnumClass = enumClass;
        }

        @Override
        JComponent getComponent() {
            this.myComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceConfiguratorPanel.this.applyEditors();
                }
            });
            this.myComboBox.setRenderer(new ListCellRendererWrapper(){

                public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    if (value instanceof ResourceEnum) {
                        this.setText(((ResourceEnum)value).getShortDisplayValue());
                    }
                }
            });
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel(this.getCaption());
            label.setLabelFor((Component)this.myComboBox);
            this.myComboBox.setModel(this.createModel());
            panel.add((Component)label);
            panel.add(this.myComboBox);
            return panel;
        }

        protected ComboBoxModel createModel() {
            return new EnumComboBoxModel(this.myEnumClass);
        }

        @NotNull
        protected abstract String getCaption();

        @Override
        void reset(@NotNull T qualifier) {
            U value;
            if (qualifier == null) {
                MyEnumBasedEditor.$$$reportNull$$$0(1);
            }
            if ((value = this.getValue(qualifier)) != null) {
                this.myComboBox.setSelectedItem(value);
            } else if (this.myComboBox.getItemCount() > 0) {
                this.myComboBox.setSelectedIndex(0);
            }
        }

        protected abstract U getValue(@NotNull T var1);

        @NotNull
        protected abstract T getQualifier(@NotNull U var1);

        @NotNull
        protected abstract String getErrorMessage();

        @Override
        @NotNull
        T apply() throws InvalidOptionValueException {
            Enum selectedItem = (Enum)this.myComboBox.getSelectedItem();
            if (selectedItem == null) {
                throw new InvalidOptionValueException(this.getErrorMessage());
            }
            T t = this.getQualifier(selectedItem);
            if (t == null) {
                MyEnumBasedEditor.$$$reportNull$$$0(2);
            }
            return t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyEnumBasedEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyEnumBasedEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyNetworkCodeEditor
    extends MyQualifierEditor<NetworkCodeQualifier> {
        private final JTextField myTextField;

        private MyNetworkCodeEditor() {
            this.myTextField = new JTextField(3);
        }

        @Override
        JComponent getComponent() {
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel("<html><body>Mobile network code<br>(1-3 digits):</body></html>");
            panel.add((Component)label);
            label.setLabelFor((Component)this.myTextField);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel.add(this.myTextField);
            return panel;
        }

        @Override
        void reset(@NotNull NetworkCodeQualifier qualifier) {
            if (qualifier == null) {
                MyNetworkCodeEditor.$$$reportNull$$$0(0);
            }
            this.myTextField.setText(Integer.toString(qualifier.getCode()));
        }

        @Override
        @NotNull
        NetworkCodeQualifier apply() throws InvalidOptionValueException {
            NetworkCodeQualifier networkCodeQualifier;
            block3: {
                try {
                    int code = Integer.parseInt(this.myTextField.getText());
                    if (code <= 0 || code >= 1000) {
                        throw new InvalidOptionValueException("Incorrect network code");
                    }
                    networkCodeQualifier = new NetworkCodeQualifier(code);
                    if (networkCodeQualifier != null) break block3;
                }
                catch (NumberFormatException e) {
                    throw new InvalidOptionValueException("Network code must be a number");
                }
                MyNetworkCodeEditor.$$$reportNull$$$0(1);
            }
            return networkCodeQualifier;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNetworkCodeEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyNetworkCodeEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyCountryCodeEditor
    extends MyQualifierEditor<CountryCodeQualifier> {
        private final JTextField myTextField;

        private MyCountryCodeEditor() {
            this.myTextField = new JTextField(3);
        }

        @Override
        JComponent getComponent() {
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            JBLabel label = new JBLabel("<html><body>Mobile country code<br>(3 digits):</body></html>");
            label.setLabelFor((Component)this.myTextField);
            this.myTextField.setColumns(3);
            this.myTextField.getDocument().addDocumentListener(DeviceConfiguratorPanel.this.myUpdatingDocumentListener);
            panel.add((Component)label);
            panel.add(this.myTextField);
            return panel;
        }

        @Override
        void reset(@NotNull CountryCodeQualifier qualifier) {
            if (qualifier == null) {
                MyCountryCodeEditor.$$$reportNull$$$0(0);
            }
            this.myTextField.setText(Integer.toString(qualifier.getCode()));
        }

        @Override
        @NotNull
        CountryCodeQualifier apply() throws InvalidOptionValueException {
            CountryCodeQualifier countryCodeQualifier;
            block4: {
                if (this.myTextField.getText().length() != 3) {
                    throw new InvalidOptionValueException("Country code must contain 3 digits");
                }
                try {
                    int code = Integer.parseInt(this.myTextField.getText());
                    if (code < 100 || code > 999) {
                        throw new InvalidOptionValueException("Incorrect country code");
                    }
                    countryCodeQualifier = new CountryCodeQualifier(code);
                    if (countryCodeQualifier != null) break block4;
                }
                catch (NumberFormatException e) {
                    throw new InvalidOptionValueException("Country code must be a number");
                }
                MyCountryCodeEditor.$$$reportNull$$$0(1);
            }
            return countryCodeQualifier;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyCountryCodeEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/uipreview/DeviceConfiguratorPanel$MyCountryCodeEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class MyQualifierEditor<T extends ResourceQualifier> {
        private MyQualifierEditor() {
        }

        abstract JComponent getComponent();

        abstract void reset(@NotNull T var1);

        @NotNull
        abstract T apply() throws InvalidOptionValueException;
    }
}

