/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.chrome.ChromeSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JSDebuggerUiUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.debugger.wip.ChromeExtensionUtil;
import com.jetbrains.debugger.wip.ChromeLocalConnectedTabsService;
import com.jetbrains.debugger.wip.ChromeLocalVmConnection;
import com.jetbrains.debugger.wip.PageConnection;
import com.jetbrains.debugger.wip.WipLocalVmConnection;
import com.jetbrains.debugger.wip.WipRemoteVmConnectionKt;
import com.jetbrains.debugger.wip.WipVmBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.MessagingLogger;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.page.PageKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0005H\u0002J\u001e\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0014J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u001a2\u0006\u0010/\u001a\u000200H\u0002J6\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u0001062\f\u00107\u001a\b\u0012\u0004\u0012\u000209082\f\u0010:\u001a\b\u0012\u0004\u0012\u00020(0'H\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006;"}, d2={"Lcom/jetbrains/debugger/wip/ChromeLocalVmConnection;", "Lcom/jetbrains/debugger/wip/WipLocalVmConnection;", "url", "Lcom/intellij/util/Url;", "reloadReusedPage", "", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "runProfile", "Lcom/intellij/execution/configurations/RunProfile;", "(Lcom/intellij/util/Url;ZLcom/intellij/ide/browsers/WebBrowser;Lcom/intellij/execution/configurations/RunProfile;)V", "getBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "newPageRequested", "getReloadReusedPage", "()Z", "reusedExistingBrowserInstance", "getRunProfile", "()Lcom/intellij/execution/configurations/RunProfile;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "setSession", "(Lcom/intellij/xdebugger/XDebugSession;)V", "connect", "", "connectRetryingAsync", "Lorg/jetbrains/concurrency/Promise;", "Lio/netty/channel/Channel;", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "address", "Ljava/net/SocketAddress;", "retryOnFail", "createChannelHandler", "Lio/netty/channel/ChannelHandler;", "Ljava/net/InetSocketAddress;", "vmResult", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lorg/jetbrains/wip/WipVm;", "getUserDataPath", "", "port", "", "launchBrowserAndOpen", "remoteDebuggingPort", "project", "Lcom/intellij/openapi/project/Project;", "launchBrowserOnNewPortAndOpen", "processPageConnections", "context", "Lio/netty/channel/ChannelHandlerContext;", "debugMessageQueue", "Lorg/jetbrains/debugger/MessagingLogger;", "pageConnections", "", "Lcom/jetbrains/debugger/wip/PageConnection;", "result", "intellij.javascript.chrome.connector"})
public class ChromeLocalVmConnection
extends WipLocalVmConnection {
    private boolean reusedExistingBrowserInstance;
    private boolean newPageRequested;
    @Nullable
    private XDebugSession session;
    private final boolean reloadReusedPage;
    @NotNull
    private final WebBrowser browser;
    @Nullable
    private final RunProfile runProfile;

    @Nullable
    public final XDebugSession getSession() {
        return this.session;
    }

    public final void setSession(@Nullable XDebugSession xDebugSession) {
        this.session = xDebugSession;
    }

    /*
     * WARNING - void declaration
     */
    public final void connect(@NotNull XDebugSession session) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        this.session = session;
        Project project = session.getProject();
        int savedPort = PropertiesComponent.getInstance().getInt("js.chrome.debugger.port." + this.getBrowser().getId(), -1);
        if (savedPort > 0) {
            void f;
            this.reusedExistingBrowserInstance = true;
            InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), savedPort);
            AsyncPromise result = new AsyncPromise();
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            result.onSuccess((Consumer)new Consumer<WipVm>(this, (Ref.ObjectRef)f, address){
                final /* synthetic */ ChromeLocalVmConnection this$0;
                final /* synthetic */ Ref.ObjectRef $f;
                final /* synthetic */ InetSocketAddress $address;

                public final void accept(@NotNull WipVm it) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                    ScheduledFuture scheduledFuture = (ScheduledFuture)this.$f.element;
                    if (scheduledFuture != null) {
                        scheduledFuture.cancel(true);
                    }
                    ChromeLocalVmConnection.access$connectionSucceeded(this.this$0, it, this.$address);
                }
                {
                    this.this$0 = chromeLocalVmConnection;
                    this.$f = objectRef;
                    this.$address = inetSocketAddress;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)this.connectRetryingAsync(this.createBootstrap(address, (AsyncPromise<WipVm>)result), address, true).onSuccess((Consumer)new Consumer<Channel>(this, (Ref.ObjectRef)f, project){
                final /* synthetic */ ChromeLocalVmConnection this$0;
                final /* synthetic */ Ref.ObjectRef $f;
                final /* synthetic */ Project $project;

                public final void accept(Channel it) {
                    this.$f.element = (ScheduledFuture)it.eventLoop().schedule(new Runnable(this, it){
                        final /* synthetic */ connect.2 this$0;
                        final /* synthetic */ Channel $it;

                        public final void run() {
                            this.$it.close();
                            ChromeLocalVmConnection chromeLocalVmConnection = this.this$0.this$0;
                            Project project = this.this$0.$project;
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                            ChromeLocalVmConnection.access$launchBrowserOnNewPortAndOpen(chromeLocalVmConnection, project);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$it = channel;
                        }
                    }, 500L, TimeUnit.MILLISECONDS);
                }
                {
                    this.this$0 = chromeLocalVmConnection;
                    this.$f = objectRef;
                    this.$project = project;
                }
            }).onError((Consumer)new Consumer<Throwable>(this, savedPort, project){
                final /* synthetic */ ChromeLocalVmConnection this$0;
                final /* synthetic */ int $savedPort;
                final /* synthetic */ Project $project;

                public final void accept(Throwable it) {
                    Project project = this.$project;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                    ChromeLocalVmConnection.access$launchBrowserAndOpen(this.this$0, this.$savedPort, project);
                }
                {
                    this.this$0 = chromeLocalVmConnection;
                    this.$savedPort = n;
                    this.$project = project;
                }
            }), (String)"connectRetryingAsync(cre\u2026dPort, project)\n        }");
        } else {
            Project project2 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            this.launchBrowserOnNewPortAndOpen(project2);
        }
    }

    private final Promise<Channel> connectRetryingAsync(Bootstrap bootstrap, SocketAddress address, boolean retryOnFail) {
        AsyncPromise result = new AsyncPromise();
        ChannelFuture channelFuture = bootstrap.connect(address);
        channelFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(this, result, retryOnFail, bootstrap, address){
            final /* synthetic */ ChromeLocalVmConnection this$0;
            final /* synthetic */ AsyncPromise $result;
            final /* synthetic */ boolean $retryOnFail;
            final /* synthetic */ Bootstrap $bootstrap;
            final /* synthetic */ SocketAddress $address;

            public final void operationComplete(ChannelFuture it) {
                ChannelFuture channelFuture = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it");
                if (!channelFuture.isDone()) {
                    this.$result.setError("GenericFutureListener was called without done state.");
                    return;
                }
                if (it.isSuccess()) {
                    Channel channel = it.channel();
                    this.$result.setResult((Object)channel);
                } else if (this.$retryOnFail) {
                    new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.this$0).addRequest(new Runnable(this){
                        final /* synthetic */ connectRetryingAsync.1 this$0;

                        public final void run() {
                            ChromeLocalVmConnection.access$connectRetryingAsync(this.this$0.this$0, this.this$0.$bootstrap, this.this$0.$address, false).processed((Promise)this.this$0.$result);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }, 300);
                } else {
                    Throwable throwable = it.cause();
                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it.cause()");
                    this.$result.setError(throwable);
                }
            }
            {
                this.this$0 = chromeLocalVmConnection;
                this.$result = asyncPromise;
                this.$retryOnFail = bl;
                this.$bootstrap = bootstrap;
                this.$address = socketAddress;
            }
        });
        return (Promise)result;
    }

    private final void launchBrowserOnNewPortAndOpen(Project project) {
        int port = NetUtils.findAvailableSocketPort();
        int oldPort = PropertiesComponent.getInstance().getInt("js.chrome.debugger.port." + this.getBrowser().getId(), -1);
        if (oldPort > 0) {
            Logger logger = Logger.getInstance(ChromeLocalVmConnection.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("Chrome debug port changed from " + oldPort + " to " + port + '.');
        }
        PropertiesComponent.getInstance().setValue("js.chrome.debugger.port." + this.getBrowser().getId(), port, -1);
        this.launchBrowserAndOpen(port, project);
    }

    /*
     * WARNING - void declaration
     */
    private final void launchBrowserAndOpen(int remoteDebuggingPort, Project project) {
        void $receiver$iv;
        Object userDataPath;
        List additionalParameters = new ArrayList();
        additionalParameters.add("--remote-debugging-port=" + remoteDebuggingPort);
        BrowserSpecificSettings browserSpecificSettings = this.getBrowser().getSpecificSettings();
        if (!(browserSpecificSettings instanceof ChromeSettings)) {
            browserSpecificSettings = null;
        }
        ChromeSettings chromeSettings = (ChromeSettings)browserSpecificSettings;
        if (chromeSettings == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Browser is not Chrome. Must be checked in Run configuration."));
        }
        ChromeSettings chromeSettings2 = chromeSettings;
        if (!chromeSettings2.isUseCustomProfile()) {
            userDataPath = this.getUserDataPath(remoteDebuggingPort);
            additionalParameters.add("--user-data-dir=" + (String)userDataPath);
            additionalParameters.add("--no-first-run");
            additionalParameters.add("--disable-fre");
        }
        additionalParameters.add("--no-default-browser-check");
        additionalParameters.add("about:blank");
        userDataPath = additionalParameters;
        boolean bl = true;
        Project project2 = project;
        WebBrowser webBrowser = this.getBrowser();
        String string = null;
        String string2 = null;
        BrowserLauncher browserLauncher = BrowserLauncher.Companion.getInstance();
        void thisCollection$iv = $receiver$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        browserLauncher.browseUsingPath(string2, string, webBrowser, project2, bl, stringArray2);
        this.reusedExistingBrowserInstance = false;
        Promise openPromise = RemoteVmConnection.open$default((RemoteVmConnection)this, (InetSocketAddress)new InetSocketAddress(InetAddress.getLoopbackAddress(), remoteDebuggingPort), null, (int)2, null);
        new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project).addRequest(new Runnable(this, openPromise, remoteDebuggingPort, project){
            final /* synthetic */ ChromeLocalVmConnection this$0;
            final /* synthetic */ Promise $openPromise;
            final /* synthetic */ int $remoteDebuggingPort;
            final /* synthetic */ Project $project;

            public final void run() {
                if (Promises.isPending((Promise)this.$openPromise)) {
                    ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
                    String string = applicationNamesInfo.getProductName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ApplicationNamesInfo.getInstance().productName");
                    String string2 = string;
                    Locale locale = Locale.US;
                    Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
                    Locale locale2 = locale;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.toLowerCase(locale2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
                    String productName = string4;
                    String message = JSDebuggerBundle.message((String)"js.debug.waiting.for.chrome.remote.debug.port", (Object[])new Object[]{this.$remoteDebuggingPort, productName});
                    Notification notification = JSDebuggerUiUtil.INSTANCE.getNOTIFICATION_GROUP().createNotification(null, null, message, NotificationType.WARNING, (NotificationListener)new ChromeExtensionUtil.ExtLinkListener(this.this$0.getBrowser(), this.$project));
                    notification.notify(this.$project);
                    this.$openPromise.onProcessed((Consumer)new Consumer<WipVm>(notification){
                        final /* synthetic */ Notification $notification;

                        public final void accept(WipVm it) {
                            this.$notification.expire();
                        }
                        {
                            this.$notification = notification;
                        }
                    });
                }
            }
            {
                this.this$0 = chromeLocalVmConnection;
                this.$openPromise = promise2;
                this.$remoteDebuggingPort = n;
                this.$project = project;
            }
        }, 9000);
    }

    private final String getUserDataPath(int port) {
        File userDataDir = new File(PathManager.getConfigPath(), "chrome-user-data-" + port);
        if (!userDataDir.exists()) {
            userDataDir.mkdir();
        }
        String string = userDataDir.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"userDataDir.absolutePath");
        return string;
    }

    @Override
    @NotNull
    protected ChannelHandler createChannelHandler(@NotNull InetSocketAddress address, @NotNull AsyncPromise<WipVm> vmResult) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull(vmResult, (String)"vmResult");
        return (ChannelHandler)new SimpleChannelInboundHandlerAdapter<FullHttpResponse>(this, address, vmResult){
            private final long startTimeMillis;
            final /* synthetic */ ChromeLocalVmConnection this$0;
            final /* synthetic */ InetSocketAddress $address;
            final /* synthetic */ AsyncPromise $vmResult;

            public void channelActive(@NotNull ChannelHandlerContext context) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                super.channelActive(context);
                this.this$0.sendGetJson(this.$address, context, (AsyncPromise<WipVm>)this.$vmResult);
            }

            protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull FullHttpResponse message) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                try {
                    if (ChromeLocalVmConnection.access$getReusedExistingBrowserInstance$p(this.this$0)) {
                        ByteBuf byteBuf = message.content();
                        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"message.content()");
                        if (this.this$0.connectToPage(context, this.$address, byteBuf, (AsyncPromise<WipVm>)this.$vmResult)) {
                            context.pipeline().remove((ChannelHandler)this);
                            if (this.this$0.getReloadReusedPage() && !ChromeLocalVmConnection.access$getNewPageRequested$p(this.this$0)) {
                                this.$vmResult.onSuccess((Consumer)new Consumer<WipVm>(this){
                                    final /* synthetic */ createChannelHandler.1 this$0;

                                    public final void accept(@NotNull WipVm it) {
                                        Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                                        if (Intrinsics.areEqual((Object)it.getCurrentUrl(), (Object)this.this$0.this$0.getUrl())) {
                                            WipVm vm = it;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)it.getCommandProcessor().send((Request)PageKt.Reload$default(true, null, 2, null)).thenAsync((Function)new Function<T, Promise<SUB_RESULT>>(this, vm){
                                                final /* synthetic */ createChannelHandler.messageReceived.1 this$0;
                                                final /* synthetic */ WipVm $vm;

                                                @Nullable
                                                public final Promise<Unit> fun(Unit it) {
                                                    Promise promise2;
                                                    XDebugSession xDebugSession = this.this$0.this$0.this$0.getSession();
                                                    if (xDebugSession != null) {
                                                        XDebugSession xDebugSession2;
                                                        XDebugSession it2 = xDebugSession2 = xDebugSession;
                                                        WipCommandProcessor wipCommandProcessor = this.$vm.getCommandProcessor();
                                                        XDebugSession xDebugSession3 = this.this$0.this$0.this$0.getSession();
                                                        if (xDebugSession3 == null) {
                                                            Intrinsics.throwNpe();
                                                        }
                                                        promise2 = wipCommandProcessor.send((Request)DebuggerKt.SetSkipAllPauses(xDebugSession3.areBreakpointsMuted()));
                                                    } else {
                                                        promise2 = null;
                                                    }
                                                    return promise2;
                                                }
                                                {
                                                    this.this$0 = var1_1;
                                                    this.$vm = wipVm;
                                                }
                                            }), (String)"it.commandProcessor.send\u2026))) }\n                  }");
                                        } else {
                                            WipVmBootstrap wipVmBootstrap = new WipVmBootstrap(it);
                                            Url url = this.this$0.this$0.getUrl();
                                            if (url == null) {
                                                Intrinsics.throwNpe();
                                            }
                                            wipVmBootstrap.navigate(url);
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                });
                            }
                            return;
                        }
                    }
                    if (!ChromeLocalVmConnection.access$getReusedExistingBrowserInstance$p(this.this$0)) {
                        ChromeLocalVmConnection.access$setNewPageRequested$p(this.this$0, true);
                    }
                    if (ChromeLocalVmConnection.access$getNewPageRequested$p(this.this$0)) {
                        ByteBuf byteBuf = message.content();
                        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"message.content()");
                        if (!this.this$0.connectToPage(context, this.$address, byteBuf, (AsyncPromise<WipVm>)this.$vmResult) && System.currentTimeMillis() - this.startTimeMillis < (long)5000) {
                            context.executor().schedule(new Runnable(this, context){
                                final /* synthetic */ createChannelHandler.1 this$0;
                                final /* synthetic */ ChannelHandlerContext $context;

                                public final void run() {
                                    this.this$0.this$0.sendGetJson(this.this$0.$address, this.$context, (AsyncPromise<WipVm>)this.this$0.$vmResult);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$context = channelHandlerContext;
                                }
                            }, 100L, TimeUnit.MILLISECONDS);
                        } else {
                            context.pipeline().remove((ChannelHandler)this);
                        }
                    } else {
                        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/json/new?about:blank");
                        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)WipRemoteVmConnectionKt.toHttpHeaderHostField(this.$address));
                        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT, (Object)"*/*");
                        ChannelFuture channelFuture = context.channel().writeAndFlush((Object)request);
                        Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"context.channel().writeAndFlush(request)");
                        ChannelFuture $receiver$iv = channelFuture;
                        $receiver$iv.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(this){
                            final /* synthetic */ createChannelHandler.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void operationComplete(ChannelFuture it) {
                                ChannelFuture channelFuture = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it");
                                ChannelFuture it2 = channelFuture;
                                if (!it2.isSuccess()) {
                                    AsyncPromise asyncPromise = this.this$0.$vmResult;
                                    Throwable throwable = it2.cause();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it.cause()");
                                    asyncPromise.setError(throwable);
                                }
                            }
                        });
                        ChromeLocalVmConnection.access$setNewPageRequested$p(this.this$0, true);
                    }
                }
                catch (Throwable e) {
                    this.$vmResult.setError(e);
                }
            }

            public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
                this.$vmResult.setError(cause);
                context.close();
            }
            {
                this.this$0 = $outer;
                this.$address = $captured_local_variable$1;
                this.$vmResult = $captured_local_variable$2;
                this.startTimeMillis = System.currentTimeMillis();
            }
        };
    }

    @Override
    protected boolean processPageConnections(@NotNull ChannelHandlerContext context, @Nullable MessagingLogger debugMessageQueue, @NotNull List<PageConnection> pageConnections, @NotNull AsyncPromise<WipVm> result) {
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull(pageConnections, (String)"pageConnections");
                Intrinsics.checkParameterIsNotNull(result, (String)"result");
                if (!this.newPageRequested) break block6;
                for (PageConnection p : CollectionsKt.reversed((Iterable)pageConnections)) {
                    if (!Intrinsics.areEqual((Object)p.getUrl(), (Object)"about:blank")) continue;
                    if (p.getWebSocketDebuggerUrl() == null) {
                        String string = JSDebuggerBundle.message((String)"js.debug.another.debugger.attached", (Object[])new Object[0]);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JSDebuggerBundle.message\u2026other.debugger.attached\")");
                        result.setError(string);
                        return false;
                    }
                    if (this.runProfile != null) {
                        ((ChromeLocalConnectedTabsService)ServiceManager.getService(ChromeLocalConnectedTabsService.class)).addTabToReuse(this.runProfile, p);
                    }
                    this.connectDebugger(p.getUrl(), p.getWebSocketDebuggerUrl(), context, result, debugMessageQueue, Intrinsics.areEqual((Object)p.getType(), (Object)"node"));
                    if (this.getUrl() != null) {
                        result.onSuccess((Consumer)new Consumer<WipVm>(this){
                            final /* synthetic */ ChromeLocalVmConnection this$0;

                            public final void accept(@NotNull WipVm it) {
                                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                                new WipVmBootstrap(it).navigate(this.this$0.getUrl());
                            }
                            {
                                this.this$0 = chromeLocalVmConnection;
                            }
                        });
                    }
                    return false;
                }
                break block7;
            }
            if (this.runProfile == null) break block7;
            for (PageConnection p : pageConnections) {
                PageConnection pageConnection = ((ChromeLocalConnectedTabsService)ServiceManager.getService(ChromeLocalConnectedTabsService.class)).getTabToReuse(this.runProfile);
                if (!Intrinsics.areEqual((Object)p.getId(), (Object)(pageConnection != null ? pageConnection.getId() : null))) continue;
                if (p.getWebSocketDebuggerUrl() == null) {
                    String string = JSDebuggerBundle.message((String)"js.debug.another.debugger.attached", (Object[])new Object[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JSDebuggerBundle.message\u2026other.debugger.attached\")");
                    result.setError(string);
                    return false;
                }
                this.connectDebugger(p.getUrl(), p.getWebSocketDebuggerUrl(), context, result, debugMessageQueue, Intrinsics.areEqual((Object)p.getType(), (Object)"node"));
                return false;
            }
        }
        return true;
    }

    public final boolean getReloadReusedPage() {
        return this.reloadReusedPage;
    }

    @NotNull
    public WebBrowser getBrowser() {
        return this.browser;
    }

    @Nullable
    public final RunProfile getRunProfile() {
        return this.runProfile;
    }

    public ChromeLocalVmConnection(@Nullable Url url, boolean reloadReusedPage, @NotNull WebBrowser browser, @Nullable RunProfile runProfile) {
        Intrinsics.checkParameterIsNotNull((Object)browser, (String)"browser");
        super(url);
        this.reloadReusedPage = reloadReusedPage;
        this.browser = browser;
        this.runProfile = runProfile;
    }

    public /* synthetic */ ChromeLocalVmConnection(Url url, boolean bl, WebBrowser webBrowser, RunProfile runProfile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(url, bl, webBrowser, runProfile);
    }

    public static final /* synthetic */ void access$connectionSucceeded(ChromeLocalVmConnection $this, @NotNull WipVm it, @NotNull InetSocketAddress address) {
        $this.connectionSucceeded((Vm)it, address);
    }

    public static final /* synthetic */ void access$launchBrowserOnNewPortAndOpen(ChromeLocalVmConnection $this, @NotNull Project project) {
        $this.launchBrowserOnNewPortAndOpen(project);
    }

    public static final /* synthetic */ void access$launchBrowserAndOpen(ChromeLocalVmConnection $this, int remoteDebuggingPort, @NotNull Project project) {
        $this.launchBrowserAndOpen(remoteDebuggingPort, project);
    }

    @NotNull
    public static final /* synthetic */ Promise access$connectRetryingAsync(ChromeLocalVmConnection $this, @NotNull Bootstrap bootstrap, @NotNull SocketAddress address, boolean retryOnFail) {
        return $this.connectRetryingAsync(bootstrap, address, retryOnFail);
    }

    public static final /* synthetic */ boolean access$getReusedExistingBrowserInstance$p(ChromeLocalVmConnection $this) {
        return $this.reusedExistingBrowserInstance;
    }

    public static final /* synthetic */ void access$setReusedExistingBrowserInstance$p(ChromeLocalVmConnection $this, boolean bl) {
        $this.reusedExistingBrowserInstance = bl;
    }

    public static final /* synthetic */ boolean access$getNewPageRequested$p(ChromeLocalVmConnection $this) {
        return $this.newPageRequested;
    }

    public static final /* synthetic */ void access$setNewPageRequested$p(ChromeLocalVmConnection $this, boolean bl) {
        $this.newPageRequested = bl;
    }
}

