/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nwjs;

import com.google.common.io.Files;
import com.google.gson.stream.JsonReader;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.URLUtil;
import com.jetbrains.nwjs.NwjsProcessState;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PACKAGE_JSON", "", "SKIPPED_CONSOLE_MESSAGE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getMainUrl", "reader", "Ljava/io/Reader;", "getMainUrlFromManifest", "parent", "Ljava/io/File;", "parseRawUrl", "Lcom/intellij/util/Url;", "url", "parentPath", "intellij.javascript.chrome.connector"})
public final class NwjsProcessStateKt {
    private static final Logger LOG = Logger.getInstance(NwjsProcessState.class);
    private static final Pattern SKIPPED_CONSOLE_MESSAGE_PATTERN = Pattern.compile("^\\[\\d+:\\d+/\\d+:[A-Z]+:CONSOLE");
    @NotNull
    public static final String PACKAGE_JSON = "package.json";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getMainUrl(Reader reader) {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                if (Intrinsics.areEqual((Object)jsonReader.nextName(), (Object)"main")) {
                    String string = jsonReader.nextString();
                    return string;
                }
                jsonReader.skipValue();
            }
        }
        finally {
            reader.close();
        }
        return null;
    }

    private static final String getMainUrlFromManifest(File parent) {
        File file = new File(parent, PACKAGE_JSON);
        if (file.exists()) {
            BufferedReader bufferedReader = Files.newReader((File)file, (Charset)CharsetToolkit.UTF8_CHARSET);
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferedReader, (String)"Files.newReader(file, CharsetToolkit.UTF8_CHARSET)");
            return NwjsProcessStateKt.getMainUrl(bufferedReader);
        }
        throw (Throwable)new ExecutionException("Manifest file not found, package.json not exists");
    }

    private static final Url parseRawUrl(String url, String parentPath) {
        if (url == null) {
            throw (Throwable)new ExecutionException("Cannot get main URL");
        }
        String absoluteUrl = URLUtil.containsScheme((String)url) || SourceResolver.Companion.isAbsolute(url) ? url : "file://" + parentPath + '/' + url;
        Url parsedUrl = Urls.parseEncoded((String)absoluteUrl);
        if (parsedUrl == null) {
            throw (Throwable)new ExecutionException("Cannot parse main URL: " + absoluteUrl);
        }
        if (parsedUrl.isInLocalFileSystem()) {
            Path path = Paths.get(parsedUrl.getPath(), new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(parsedUrl.path)");
            if (!PathKt.isFile((Path)path)) {
                throw (Throwable)new ExecutionException("Main file not valid");
            }
        }
        return parsedUrl;
    }

    @Nullable
    public static final /* synthetic */ String access$getMainUrlFromManifest(@NotNull File parent) {
        return NwjsProcessStateKt.getMainUrlFromManifest(parent);
    }

    @NotNull
    public static final /* synthetic */ Url access$parseRawUrl(@Nullable String url, @NotNull String parentPath) {
        return NwjsProcessStateKt.parseRawUrl(url, parentPath);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Pattern access$getSKIPPED_CONSOLE_MESSAGE_PATTERN$p() {
        return SKIPPED_CONSOLE_MESSAGE_PATTERN;
    }
}

