/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.runner;

import com.google.gson.stream.JsonReader;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.LocalFileSystemFileFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.Url;
import com.jetbrains.plugins.meteor.runner.MeteorFileFinderKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u001cJ\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u00032\u0006\u0010 \u001a\u00020\u00062\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/plugins/meteor/runner/MeteorFileFinder;", "Lcom/intellij/javascript/debugger/LocalFileSystemFileFinder;", "workDir", "", "(Ljava/lang/String;)V", "isopacksDir", "Ljava/io/File;", "getIsopacksDir$intellij_javascript_chrome_connector", "()Ljava/io/File;", "localPackagesExists", "Lcom/intellij/util/ThreeState;", "meteorDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "virtualDir", "doFindFile", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "findByName", "", "sourceContent", "script", "Lorg/jetbrains/debugger/Script;", "findFileForLocalPackage", "findFileForMeteorSpecificUrl", "findFileInWorkingDirectory", "path", "findFileInWorkingDirectory$intellij_javascript_chrome_connector", "isOnlySourceMappedBreakpoints", "file", "readSourceRoot", "buildInfo", "packageName", "intellij.javascript.chrome.connector"})
public final class MeteorFileFinder
extends LocalFileSystemFileFinder {
    private final VirtualFile virtualDir;
    private final VirtualFile meteorDir;
    @NotNull
    private final File isopacksDir;
    private ThreeState localPackagesExists;

    @NotNull
    public final File getIsopacksDir$intellij_javascript_chrome_connector() {
        return this.isopacksDir;
    }

    @Nullable
    protected VirtualFile doFindFile(@NotNull Url url, @NotNull Project project, boolean findByName, @Nullable String sourceContent, @Nullable Script script) {
        VirtualFile virtualFile;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        VirtualFile file = super.doFindFile(url, project, findByName, sourceContent, script);
        if (file == null) {
            file = this.findFileForMeteorSpecificUrl(url);
        }
        if (file == null && this.virtualDir != null) {
            String string = url.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.path");
            virtualFile = this.findFileInWorkingDirectory$intellij_javascript_chrome_connector(string);
        } else {
            virtualFile = file;
        }
        return virtualFile;
    }

    @Nullable
    public final VirtualFile findFileInWorkingDirectory$intellij_javascript_chrome_connector(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        int i = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        while (i != -1) {
            String subPath;
            VirtualFile file;
            boolean bl;
            String string = path;
            int n = i + 1;
            int n2 = path.length();
            Intrinsics.checkExpressionValueIsNotNull((Object)string.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            boolean bl2 = bl = this.virtualDir != null;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            VirtualFile virtualFile = this.virtualDir;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            if ((file = virtualFile.findFileByRelativePath(subPath)) != null) {
                return file;
            }
            i = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)(i + 2), (boolean)false, (int)4, null);
        }
        return null;
    }

    public boolean isOnlySourceMappedBreakpoints(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        boolean result = super.isOnlySourceMappedBreakpoints(file);
        return !result && this.meteorDir != null ? !VfsUtilCore.isAncestor((VirtualFile)this.meteorDir, (VirtualFile)file, (boolean)true) : result;
    }

    private final VirtualFile findFileForMeteorSpecificUrl(Url url) {
        try {
            String scriptPath = url.getPath();
            String urlString = url.toString();
            String meteorDirSlashedName = '/' + MeteorFileFinderKt.access$getDOT_METEOR$p() + '/';
            String string = scriptPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scriptPath");
            int index = StringsKt.lastIndexOf$default((CharSequence)string, (String)meteorDirSlashedName, (int)0, (boolean)false, (int)6, null);
            if (index != -1 && StringsKt.startsWith$default((String)scriptPath, (String)"local/build/programs/server/app/", (int)(index + meteorDirSlashedName.length()), (boolean)false, (int)4, null)) {
                String string2 = scriptPath;
                int n = 0;
                int n2 = index + 1;
                String string3 = string2.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String sourceRoot = string3;
                JavaScriptDebugProcessKt.getLOG().assertTrue(StringsKt.startsWith$default((String)urlString, (String)MeteorFileFinderKt.access$getMETEOR_LOCAL_PACKAGE_SOURCE_PREFIX$p(), (boolean)false, (int)2, null));
                string2 = urlString;
                n = MeteorFileFinderKt.access$getMETEOR_LOCAL_PACKAGE_SOURCE_PREFIX$p().length();
                StringBuilder stringBuilder = new StringBuilder().append(sourceRoot);
                LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                String string4 = string2;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                String string6 = string5;
                return localFileSystem.findFileByPath(stringBuilder.append(string6).toString());
            }
            return this.findFileForLocalPackage(url);
        }
        catch (Exception e) {
            JavaScriptDebugProcessKt.getLOG().warn((Throwable)e);
            return null;
        }
    }

    private final VirtualFile findFileForLocalPackage(Url url) {
        int i;
        CharSequence charSequence;
        StringBuilder stringBuilder;
        int n;
        String urlString = url.toString();
        String packageName = null;
        String packageFileName = null;
        int prefixLength = -1;
        if (StringsKt.startsWith$default((String)urlString, (String)MeteorFileFinderKt.access$getMETEOR_LOCAL_PACKAGE_SOURCE_PREFIX$p(), (boolean)false, (int)2, null)) {
            String fileName;
            String string = fileName = PathUtil.getFileName((String)url.getPath());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
            int dotIndex = StringsKt.indexOf$default((CharSequence)string, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dotIndex > 0) {
                String string2;
                int firstUnderscoreIndex = StringsKt.indexOf$default((CharSequence)fileName, (char)'_', (int)0, (boolean)false, (int)4, null);
                if (firstUnderscoreIndex > 0 && firstUnderscoreIndex < dotIndex) {
                    string2 = fileName;
                    n = 0;
                    String string3 = string2.substring(n, dotIndex);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    packageFileName = string3;
                    string2 = fileName;
                    n = 0;
                    stringBuilder = new StringBuilder();
                    String string4 = string2.substring(n, firstUnderscoreIndex);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    charSequence = string4;
                    string2 = fileName;
                    n = firstUnderscoreIndex + 1;
                    stringBuilder = stringBuilder.append((String)charSequence).append(':');
                    String string5 = string2.substring(n, dotIndex);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    charSequence = string5;
                    packageName = stringBuilder.append((String)charSequence).toString();
                } else {
                    string2 = fileName;
                    n = 0;
                    String string6 = string2.substring(n, dotIndex);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    packageName = packageFileName = string6;
                }
                prefixLength = MeteorFileFinderKt.access$getMETEOR_LOCAL_PACKAGE_SOURCE_PREFIX$p().length() - 1;
                if (StringsKt.startsWith$default((String)urlString, (String)MeteorFileFinderKt.access$getPACKAGES_PREFIX$p(), (int)MeteorFileFinderKt.access$getMETEOR_LOCAL_PACKAGE_SOURCE_PREFIX$p().length(), (boolean)false, (int)4, null)) {
                    Character c = StringsKt.getOrNull((CharSequence)urlString, (int)((prefixLength += MeteorFileFinderKt.access$getPACKAGES_PREFIX$p().length()) + 1 + packageName.length()));
                    if (c != null && c.charValue() == '/' && (StringsKt.startsWith$default((String)urlString, (String)packageFileName, (int)(prefixLength + 1), (boolean)false, (int)4, null) || StringsKt.startsWith$default((String)urlString, (String)packageName, (int)(prefixLength + 1), (boolean)false, (int)4, null))) {
                        prefixLength += packageName.length() + 1;
                    }
                }
            }
        } else if (!SourceResolver.Companion.isAbsolute(urlString) && (i = StringsKt.indexOf$default((CharSequence)urlString, (char)'/', (int)0, (boolean)false, (int)6, null)) > 0) {
            String packageNameCandidate;
            String firstUnderscoreIndex = urlString;
            int n2 = 0;
            String string = firstUnderscoreIndex;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string.substring(n2, i);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            packageName = packageNameCandidate = string7;
        }
        if (packageName == null) {
            return null;
        }
        File isopacksDir = this.isopacksDir;
        if (this.localPackagesExists == ThreeState.UNSURE) {
            ThreeState threeState = ThreeState.fromBoolean((boolean)isopacksDir.exists());
            Intrinsics.checkExpressionValueIsNotNull((Object)threeState, (String)"ThreeState.fromBoolean(isopacksDir.exists())");
            this.localPackagesExists = threeState;
        }
        if (this.localPackagesExists == ThreeState.NO) {
            return null;
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        String string = packageFileName;
        if (string == null) {
            string = StringsKt.replace$default((String)packageName, (char)':', (char)'_', (boolean)false, (int)4, null);
        }
        File buildInfo = new File(isopacksDir, stringBuilder2.append(string).append(File.separatorChar).append("isopack-buildinfo.json").toString());
        if (!buildInfo.exists()) {
            return null;
        }
        String string8 = this.readSourceRoot(buildInfo, packageName);
        if (string8 == null) {
            return null;
        }
        String sourceRoot = string8;
        if (SystemInfo.isWindows && sourceRoot.length() > 4 && sourceRoot.charAt(0) == '/' && sourceRoot.charAt(2) == '/') {
            String string9 = sourceRoot;
            n = 2;
            stringBuilder = new StringBuilder().append(sourceRoot.charAt(1)).append(':');
            String string10 = string9;
            if (string10 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string11 = string10.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"(this as java.lang.String).substring(startIndex)");
            charSequence = string11;
            sourceRoot = stringBuilder.append((String)charSequence).toString();
        }
        if (prefixLength == -1) {
            prefixLength = packageName.length();
        }
        String string12 = urlString;
        charSequence = new StringBuilder().append(sourceRoot);
        stringBuilder = LocalFileSystem.getInstance();
        String string13 = string12;
        if (string13 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string14 = string13.substring(prefixLength);
        Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"(this as java.lang.String).substring(startIndex)");
        String string15 = string14;
        return stringBuilder.findFileByPath(((StringBuilder)charSequence).append(string15).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final String readSourceRoot(File buildInfo, String packageName) {
        sourceRoot = null;
        var4_4 = buildInfo;
        var12_5 = v0;
        var11_6 = v0;
        var13_7 /* !! */  = new FileInputStream((File)var4_4);
        var4_4 = var13_7 /* !! */ ;
        var5_8 = Charsets.UTF_8;
        var13_7 /* !! */  = new InputStreamReader((InputStream)var4_4, (Charset)var5_8);
        var12_5((Reader)var13_7 /* !! */ );
        var4_4 = (Closeable)var11_6;
        var5_8 = null;
        try {
            reader = (JsonReader)var4_4;
            if (MeteorFileFinderKt.access$readUntilName(reader, "pluginProviderPackageMap")) {
                v1 = packageName;
                if (v1 == null) {
                    Intrinsics.throwNpe();
                }
                if (MeteorFileFinderKt.access$readUntilName(reader, v1)) {
                    reader.beginObject();
                    kind = null;
                    block10: while (reader.hasNext()) {
                        if (reader.nextName() != null) {
                            switch (var8_13.hashCode()) {
                                case -1111500899: {
                                    if (!var8_13.equals("sourceRoot")) ** break;
                                    break;
                                }
                                case 3292052: {
                                    if (!var8_13.equals("kind")) ** break;
                                    kind = reader.nextString();
                                    continue block10;
                                }
                            }
                            sourceRoot = reader.nextString();
                            continue;
                        }
                        reader.skipValue();
                    }
                    if (Intrinsics.areEqual((Object)"local", (Object)kind) ^ true) {
                        var10_14 = null;
                        return var10_14;
                    }
                }
            }
            var6_9 = Unit.INSTANCE;
        }
        catch (Throwable var6_10) {
            var5_8 = var6_10;
            throw var6_10;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var4_4, (Throwable)var5_8);
        }
        return sourceRoot;
    }

    public MeteorFileFinder(@NotNull String workDir) {
        Intrinsics.checkParameterIsNotNull((Object)workDir, (String)"workDir");
        super(false, 1, null);
        this.localPackagesExists = ThreeState.UNSURE;
        this.isopacksDir = new File(workDir, MeteorFileFinderKt.access$getDOT_METEOR$p() + File.separatorChar + "local" + File.separatorChar + "isopacks");
        VirtualFile virtualFile = this.virtualDir = LocalFileSystem.getInstance().findFileByPath(workDir);
        this.meteorDir = virtualFile != null ? virtualFile.findChild(MeteorFileFinderKt.access$getDOT_METEOR$p()) : null;
        JavaScriptDebugProcessKt.getLOG().assertTrue(this.virtualDir != null);
        JavaScriptDebugProcessKt.getLOG().assertTrue(this.meteorDir != null);
    }
}

