/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.debugger.JSDebuggerUiUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.jetbrains.plugins.reactnative.PackagerState;
import com.jetbrains.plugins.reactnative.ReactNativePackager;
import com.jetbrains.plugins.reactnative.ReactNativePackagerBeforeRunTask;
import com.jetbrains.plugins.reactnative.ReactNativePackagerConfigurationEditor;
import com.jetbrains.plugins.reactnative.ReactNativeProgramRunnerKt;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import icons.JavaScriptLanguageIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\nH\u0016J*\u0010\u000e\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativePackagerBeforeRunTaskProvider;", "Lcom/intellij/execution/BeforeRunTaskProvider;", "Lcom/jetbrains/plugins/reactnative/ReactNativePackagerBeforeRunTask;", "()V", "configureTask", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "task", "createTask", "runConfiguration", "executeTask", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getIcon", "Ljavax/swing/Icon;", "getId", "Lcom/intellij/openapi/util/Key;", "getName", "", "isConfigurable", "Companion", "intellij.javascript.reactNativeDebugger"})
public final class ReactNativePackagerBeforeRunTaskProvider
extends BeforeRunTaskProvider<ReactNativePackagerBeforeRunTask> {
    @NotNull
    private static final Key<ReactNativePackagerBeforeRunTask> ID;
    public static final Companion Companion;

    @NotNull
    public Key<ReactNativePackagerBeforeRunTask> getId() {
        Key<ReactNativePackagerBeforeRunTask> key = ID;
        Intrinsics.checkExpressionValueIsNotNull(key, (String)"ID");
        return key;
    }

    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.Logos.Jsx_16;
    }

    @NotNull
    public String getName() {
        return "Start React Native Bundler";
    }

    @Nullable
    public ReactNativePackagerBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        Intrinsics.checkParameterIsNotNull((Object)runConfiguration, (String)"runConfiguration");
        return runConfiguration instanceof ReactNativeRunConfiguration ? new ReactNativePackagerBeforeRunTask() : null;
    }

    public boolean executeTask(@Nullable DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull ReactNativePackagerBeforeRunTask task) {
        PackagerState packagerState;
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Project project = env.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"env.project");
        ReactNativePackager reactNativePackager = ReactNativePackager.Companion.getInstance(project);
        RunConfiguration runConfiguration = configuration;
        if (!(runConfiguration instanceof ReactNativeRunConfiguration)) {
            runConfiguration = null;
        }
        if ((packagerState = reactNativePackager.startPackager((ReactNativeRunConfiguration)runConfiguration)) == null) {
            JSDebuggerUiUtil.INSTANCE.getNOTIFICATION_GROUP().createNotification("Cannot start React Native Bundler. Please ensure it's configured properly in \"" + this.getName() + "\" before launch task " + "of \"" + configuration.getName() + "\" run configuration.", MessageType.ERROR).notify(env.getProject());
            return false;
        }
        ProcessHandler packagerProcess = packagerState.getProcess();
        if (!packagerState.getAlreadyStarted()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(packagerProcess, env){
                final /* synthetic */ ProcessHandler $packagerProcess;
                final /* synthetic */ ExecutionEnvironment $env;

                public final void run() {
                    ReactNativeProgramRunnerKt.showHelperProcessRunContent("react-native start", this.$packagerProcess, this.$env);
                    this.$packagerProcess.startNotify();
                }
                {
                    this.$packagerProcess = processHandler;
                    this.$env = executionEnvironment;
                }
            });
        }
        return true;
    }

    public boolean isConfigurable() {
        return true;
    }

    @NotNull
    public Promise<Boolean> configureTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ReactNativePackagerBeforeRunTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Project project = configuration.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"configuration.project");
        ReactNativePackagerConfigurationEditor dialog = new ReactNativePackagerConfigurationEditor(project);
        dialog.show();
        return Promises.resolvedPromise((Object)false);
    }

    static {
        Companion = new Companion(null);
        ID = Key.create((String)"ReactNativePackager");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativePackagerBeforeRunTaskProvider$Companion;", "", "()V", "ID", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/plugins/reactnative/ReactNativePackagerBeforeRunTask;", "kotlin.jvm.PlatformType", "getID$intellij_javascript_reactNativeDebugger", "()Lcom/intellij/openapi/util/Key;", "intellij.javascript.reactNativeDebugger"})
    public static final class Companion {
        @NotNull
        public final Key<ReactNativePackagerBeforeRunTask> getID$intellij_javascript_reactNativeDebugger() {
            return ID;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

