/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.actions.StopProcessAction;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.plugins.reactnative.ProcessRunnerFactory;
import com.jetbrains.plugins.reactnative.ReactNativePackagerKt;
import com.jetbrains.plugins.reactnative.ViewerProcessRunnerFactory;
import icons.JavaScriptLanguageIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a8\u0006\u000f"}, d2={"chromeDebugUrl", "Lcom/intellij/util/Url;", "packagerPort", "", "reactNativePackageToNodeArgument", "", "reactNativePackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "showHelperProcessRunContent", "Lcom/intellij/execution/ui/ConsoleView;", "header", "runHandler", "Lcom/intellij/execution/process/ProcessHandler;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "intellij.javascript.reactNativeDebugger"})
public final class ReactNativeProgramRunnerKt {
    @NotNull
    public static final ConsoleView showHelperProcessRunContent(@NotNull String header, @NotNull ProcessHandler runHandler, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
        Intrinsics.checkParameterIsNotNull((Object)runHandler, (String)"runHandler");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        ProcessRunnerFactory processRunnerFactory = (ProcessRunnerFactory)runHandler.getUserData(ReactNativePackagerKt.getPROCESS_RUNNER_FACTORY());
        if (processRunnerFactory == null) {
            processRunnerFactory = ViewerProcessRunnerFactory.INSTANCE;
        }
        ProcessRunnerFactory processRunnerFactory2 = processRunnerFactory;
        Project project = environment.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"environment.project");
        ConsoleView consoleView = processRunnerFactory2.createConsoleView(project, runHandler);
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)consoleView.getComponent(), "Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ReactNativeRunner", (ActionGroup)toolbarActions, false);
        toolbar.setTargetComponent(consoleView.getComponent());
        ActionToolbar actionToolbar = toolbar;
        Intrinsics.checkExpressionValueIsNotNull((Object)actionToolbar, (String)"toolbar");
        panel.add((Component)actionToolbar.getComponent(), "West");
        RunContentDescriptor runDescriptor = new RunContentDescriptor((ExecutionConsole)consoleView, runHandler, (JComponent)panel, header, JavaScriptLanguageIcons.Logos.Jsx_16);
        AnAction[] anActionArray = consoleView.createConsoleActions();
        toolbarActions.addAll(Arrays.copyOf(anActionArray, anActionArray.length));
        toolbarActions.add((AnAction)new StopProcessAction("Stop process", "Stop process", runHandler));
        toolbarActions.add((AnAction)new CloseAction(environment.getExecutor(), runDescriptor, environment.getProject()));
        consoleView.attachToProcess(runHandler);
        ExecutionManager executionManager = ExecutionManager.getInstance((Project)environment.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)executionManager, (String)"ExecutionManager.getInstance(environment.project)");
        executionManager.getContentManager().showRunContent(environment.getExecutor(), runDescriptor);
        return consoleView;
    }

    @NotNull
    public static final Url chromeDebugUrl(int packagerPort) {
        int n = packagerPort;
        int n2 = 10;
        StringBuilder stringBuilder = new StringBuilder().append("localhost:");
        String string = Integer.toString(n, CharsKt.checkRadix((int)n2));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
        String string2 = string;
        return Urls.newHttpUrl((String)stringBuilder.append(string2).toString(), (String)"/debugger-ui");
    }

    @NotNull
    public static final String reactNativePackageToNodeArgument(@NotNull NodePackage reactNativePackage) {
        Intrinsics.checkParameterIsNotNull((Object)reactNativePackage, (String)"reactNativePackage");
        return reactNativePackage.getSystemDependentPath() + (reactNativePackage.nameMatches("react-native") ? "/local-cli/cli.js" : "");
    }
}

