/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.util;

import com.jetbrains.rider.util.ILoggerFactory;
import com.jetbrains.rider.util.LogLevel;
import com.jetbrains.rider.util.Logger;
import com.jetbrains.rider.util.LoggerKt;
import com.jetbrains.rider.util.PlatformDependentKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/util/ConsoleLoggerFactory;", "Lcom/jetbrains/rider/util/ILoggerFactory;", "()V", "levelToLogStderr", "Lcom/jetbrains/rider/util/LogLevel;", "getLevelToLogStderr", "()Lcom/jetbrains/rider/util/LogLevel;", "setLevelToLogStderr", "(Lcom/jetbrains/rider/util/LogLevel;)V", "minLevelToLog", "getMinLevelToLog", "setMinLevelToLog", "getLogger", "Lcom/jetbrains/rider/util/Logger;", "category", "", "rd-core"})
public final class ConsoleLoggerFactory
implements ILoggerFactory {
    @NotNull
    private static LogLevel minLevelToLog;
    @Nullable
    private static LogLevel levelToLogStderr;
    public static final ConsoleLoggerFactory INSTANCE;

    @NotNull
    public final LogLevel getMinLevelToLog() {
        return minLevelToLog;
    }

    public final void setMinLevelToLog(@NotNull LogLevel logLevel) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)logLevel), (String)"<set-?>");
        minLevelToLog = logLevel;
    }

    @Nullable
    public final LogLevel getLevelToLogStderr() {
        return levelToLogStderr;
    }

    public final void setLevelToLogStderr(@Nullable LogLevel logLevel) {
        levelToLogStderr = logLevel;
    }

    @Override
    @NotNull
    public Logger getLogger(@NotNull String category) {
        Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
        return new Logger(category){
            final /* synthetic */ String $category;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void log(@NotNull LogLevel level, @Nullable Object message, @Nullable Throwable throwable) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
                if (!this.isEnabled(level)) {
                    return;
                }
                String msg = LoggerKt.defaultLogFormat(this.$category, level, message, throwable);
                LogLevel logLevel = ConsoleLoggerFactory.INSTANCE.getLevelToLogStderr();
                if (logLevel != null) {
                    LogLevel logLevel2 = logLevel;
                    LogLevel it = logLevel2;
                    if (level.compareTo((Enum)it) > 0) {
                        PlatformDependentKt.printlnError(msg);
                        return;
                    }
                }
                System.out.println((Object)msg);
            }

            public boolean isEnabled(@NotNull LogLevel level) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
                return level.compareTo((Enum)ConsoleLoggerFactory.INSTANCE.getMinLevelToLog()) >= 0;
            }
            {
                this.$category = $captured_local_variable$0;
            }
        };
    }

    private ConsoleLoggerFactory() {
    }

    static {
        ConsoleLoggerFactory consoleLoggerFactory;
        INSTANCE = consoleLoggerFactory = new ConsoleLoggerFactory();
        minLevelToLog = LogLevel.Debug;
        levelToLogStderr = LogLevel.Warn;
    }
}

