/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.flat.FlatToggleButton;
import com.android.tools.adtui.model.FilterModel;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.SearchTextField;
import com.intellij.util.Alarm;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class FilterComponent
extends JPanel {
    static final String OPEN_AND_FOCUS_ACTION = "OpenAndFocusSearchAction";
    static final String CLOSE_ACTION = "CloseSearchAction";
    static final KeyStroke FILTER_KEY_STROKE = KeyStroke.getKeyStroke(70, SystemInfo.isMac ? 256 : 128);
    private static final String REGEX = "Regex";
    private static final String MATCH_CASE = "Match Case";
    private final FilterModel myModel;
    private JCheckBox myRegexCheckBox;
    private JCheckBox myMatchCaseCheckBox;
    private final SearchTextField myFilter;
    private final Alarm myUpdateAlarm = new Alarm();
    private final int myDelayMs;

    public FilterComponent(int textFieldWidth, int historySize, int delayMs) {
        super(new TabularLayout("4px," + textFieldWidth + "px,5px,Fit,5px,Fit", "Fit"));
        this.myDelayMs = delayMs;
        this.myModel = new FilterModel();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                super.componentShown(e);
                FilterComponent.this.requestFocusInWindow();
            }
        });
        this.myFilter = new SearchTextField(){

            protected Runnable createItemChosenCallback(JList list) {
                Runnable callback = super.createItemChosenCallback(list);
                return () -> {
                    callback.run();
                    FilterComponent.this.filter();
                };
            }

            protected Component getPopupLocationComponent() {
                return FilterComponent.this.getPopupLocationComponent();
            }

            protected void onFocusLost() {
                this.addCurrentTextToHistory();
                super.onFocusLost();
            }
        };
        this.myFilter.getTextEditor().addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    FilterComponent.this.myFilter.addCurrentTextToHistory();
                    FilterComponent.this.filter();
                } else if (e.getKeyCode() == 27) {
                    FilterComponent.this.onEscape(e);
                }
            }
        });
        this.myFilter.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FilterComponent.this.onChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FilterComponent.this.onChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FilterComponent.this.onChange();
            }
        });
        this.myFilter.setHistorySize(historySize);
        this.add((Component)this.myFilter, new TabularLayout.Constraint(0, 1));
        this.myMatchCaseCheckBox = new JCheckBox(MATCH_CASE);
        this.myMatchCaseCheckBox.setMnemonic(67);
        this.myMatchCaseCheckBox.setDisplayedMnemonicIndex(MATCH_CASE.indexOf(67));
        this.myMatchCaseCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FilterComponent.this.myModel.setIsMatchCase(e.getStateChange() == 1);
            }
        });
        this.add((Component)this.myMatchCaseCheckBox, new TabularLayout.Constraint(0, 3));
        this.myRegexCheckBox = new JCheckBox(REGEX);
        this.myRegexCheckBox.setMnemonic(71);
        this.myRegexCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FilterComponent.this.myModel.setIsRegex(e.getStateChange() == 1);
            }
        });
        this.add((Component)this.myRegexCheckBox, new TabularLayout.Constraint(0, 5));
    }

    protected JComponent getPopupLocationComponent() {
        return this.myFilter;
    }

    public JTextField getTextEditor() {
        return this.myFilter.getTextEditor();
    }

    private void onChange() {
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(() -> this.filter(), this.myDelayMs);
    }

    public void reset() {
        this.myFilter.reset();
    }

    protected void onEscape(KeyEvent e) {
    }

    public String getFilter() {
        return this.myFilter.getText();
    }

    public void setSelectedItem(String filter) {
        this.myFilter.setSelectedItem(filter);
    }

    public void setFilter(String filter) {
        this.myFilter.setText(filter);
    }

    public void selectText() {
        this.myFilter.selectText();
    }

    private void filter() {
        this.myModel.setFilterString(this.getFilter());
    }

    @NotNull
    public FilterModel getModel() {
        FilterModel filterModel = this.myModel;
        if (filterModel == null) {
            FilterComponent.$$$reportNull$$$0(0);
        }
        return filterModel;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.myFilter.requestFocusInWindow();
    }

    public void dispose() {
        this.myUpdateAlarm.cancelAllRequests();
    }

    JCheckBox getMatchCaseCheckBox() {
        return this.myMatchCaseCheckBox;
    }

    JCheckBox getRegexCheckBox() {
        return this.myRegexCheckBox;
    }

    public void addOnFilterChange(@NotNull BiConsumer<Pattern, FilterModel> callback) {
        if (callback == null) {
            FilterComponent.$$$reportNull$$$0(1);
        }
        this.myModel.addOnFilterChange(callback);
    }

    public static void configureKeyBindingAndFocusBehaviors(final @NotNull JComponent containerComponent, final @NotNull FilterComponent filterComponent, final @NotNull JToggleButton showHideButton) {
        if (containerComponent == null) {
            FilterComponent.$$$reportNull$$$0(2);
        }
        if (filterComponent == null) {
            FilterComponent.$$$reportNull$$$0(3);
        }
        if (showHideButton == null) {
            FilterComponent.$$$reportNull$$$0(4);
        }
        showHideButton.addActionListener(event -> {
            if (filterComponent == null) {
                FilterComponent.$$$reportNull$$$0(6);
            }
            if (showHideButton == null) {
                FilterComponent.$$$reportNull$$$0(7);
            }
            if (containerComponent == null) {
                FilterComponent.$$$reportNull$$$0(8);
            }
            filterComponent.setVisible(showHideButton.isSelected());
            filterComponent.setFilter("");
            if (showHideButton.isSelected()) {
                filterComponent.requestFocusInWindow();
            }
            containerComponent.revalidate();
        });
        InputMap inputMap = containerComponent.getInputMap(1);
        ActionMap actionMap = containerComponent.getActionMap();
        inputMap.put(FILTER_KEY_STROKE, OPEN_AND_FOCUS_ACTION);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), CLOSE_ACTION);
        actionMap.put(OPEN_AND_FOCUS_ACTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!showHideButton.isSelected()) {
                    showHideButton.doClick(0);
                } else {
                    filterComponent.requestFocusInWindow();
                }
            }
        });
        actionMap.put(CLOSE_ACTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!showHideButton.isSelected()) {
                    return;
                }
                showHideButton.doClick(0);
                containerComponent.requestFocusInWindow();
            }
        });
    }

    @NotNull
    public static FlatToggleButton createFilterToggleButton() {
        FlatToggleButton filterButton = new FlatToggleButton("", StudioIcons.Common.FILTER);
        filterButton.setToolTipText(String.format("Filter (%s)", KeymapUtil.getKeystrokeText((KeyStroke)FILTER_KEY_STROKE)));
        FlatToggleButton flatToggleButton = filterButton;
        if (flatToggleButton == null) {
            FilterComponent.$$$reportNull$$$0(5);
        }
        return flatToggleButton;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/FilterComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerComponent";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterComponent";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showHideButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/FilterComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilterToggleButton";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addOnFilterChange";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "configureKeyBindingAndFocusBehaviors";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$configureKeyBindingAndFocusBehaviors$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

