/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.SimpleEventRenderer;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.KeyboardAction;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.JBFont;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;

public class KeyboardEventRenderer<E>
implements SimpleEventRenderer<E> {
    private static final JBFont FONT = JBFont.create((Font)new Font(null, 1, 11));
    private static final int ROUND_ARC = 5;
    private static final int POINT_HEIGHT_OFFSET = 5;
    private static final int PADDING = 2;
    private static final int BORDER_MARGIN = 2;
    private static final JBColor BACKGROUND_COLOR = new JBColor(9997198, 0x999A9A);
    private static final JBColor TEXT_COLOR = new JBColor(0xFAFAFA, 0x313335);
    private static final Map<String, Icon> KEYBOARD_ICON_LOOKUP;

    @NotNull
    private static Icon load(String path) {
        Icon icon = IconLoader.getIcon((String)path, KeyboardEventRenderer.class);
        if (icon == null) {
            KeyboardEventRenderer.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @Override
    public void draw(Component parent, Graphics2D g2d, AffineTransform transform, double length, EventAction<E> action) {
        boolean drawString;
        if (!(action instanceof KeyboardAction)) {
            return;
        }
        KeyboardAction keyAction = (KeyboardAction)action;
        boolean bl = drawString = !KEYBOARD_ICON_LOOKUP.containsKey(keyAction.getData().toString());
        if (drawString) {
            this.drawString(parent, g2d, transform, keyAction);
        } else {
            this.drawIcon(parent, g2d, transform, keyAction);
        }
    }

    private void drawString(Component parent, Graphics2D g2d, AffineTransform transform, KeyboardAction action) {
        Color currentColor = g2d.getColor();
        Font currentFont = g2d.getFont();
        AffineTransform originalTransform = g2d.getTransform();
        g2d.setFont((Font)FONT);
        FontMetrics metrics = g2d.getFontMetrics();
        String textToDraw = action.getData().toString();
        int width = metrics.stringWidth(textToDraw);
        int height = metrics.getHeight();
        int paddedHeight = height + 2;
        int pointWidth = width + 5;
        transform.translate((double)(-width) / 2.0, 0.0);
        g2d.transform(transform);
        for (int margin : Arrays.asList(2, 0)) {
            g2d.setColor((Color)(margin == 0 ? BACKGROUND_COLOR : parent.getBackground()));
            Polygon polygon = new Polygon();
            polygon.addPoint(-2 - margin, paddedHeight);
            polygon.addPoint(pointWidth + margin, paddedHeight);
            polygon.addPoint(pointWidth / 2, paddedHeight + 5 + margin);
            g2d.fillRoundRect(-2 - margin, 2 - margin, width + 2 + 5 + margin * 2, height + 2 + margin * 2, 5, 5);
            g2d.fillPolygon(polygon);
        }
        g2d.setColor((Color)TEXT_COLOR);
        g2d.drawString(textToDraw, 1, height);
        g2d.setColor(currentColor);
        g2d.setFont(currentFont);
        g2d.setTransform(originalTransform);
    }

    private void drawIcon(Component parent, Graphics2D g2d, AffineTransform transform, KeyboardAction action) {
        ImageIcon icon = SimpleEventRenderer.createImageIconWithBackgroundBorder(KEYBOARD_ICON_LOOKUP.get(action.getData().toString()), 2, parent.getBackground());
        AffineTransform originalTransform = g2d.getTransform();
        g2d.transform(transform);
        icon.paintIcon(parent, g2d, -icon.getIconWidth() / 2, 0);
        g2d.setTransform(originalTransform);
    }

    static {
        HashMap keyboardIcons = new HashMap();
        keyboardIcons.put("KEYCODE_BACK", KeyboardEventRenderer.load("/icons/events/back-button.png"));
        keyboardIcons.put("KEYCODE_VOLUME_DOWN", KeyboardEventRenderer.load("/icons/events/volume-down.png"));
        keyboardIcons.put("KEYCODE_VOLUME_UP", KeyboardEventRenderer.load("/icons/events/volume-up.png"));
        KEYBOARD_ICON_LOOKUP = keyboardIcons;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/KeyboardEventRenderer", "load"));
    }
}

