/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.ui.TextAccessor;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextAccessors {
    private TextAccessors() {
    }

    @Nullable
    public static TextAccessor getTextAccessor(@NotNull JComponent component) {
        if (component == null) {
            TextAccessors.$$$reportNull$$$0(0);
        }
        if (component instanceof TextAccessor) {
            return (TextAccessor)component;
        }
        if (component instanceof JTextComponent) {
            return new JTextComponentTextAccessor(component);
        }
        if (component instanceof JLabel) {
            return new JLabelTextAccessor((JLabel)component);
        }
        if (component instanceof AbstractButton) {
            return new AbstractButtonTextAccessor((AbstractButton)component);
        }
        if (component instanceof ActionButton) {
            return new ActionButtonTextAccessor((ActionButton)component);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/adtui/TextAccessors", "getTextAccessor"));
    }

    private static class ActionButtonTextAccessor
    implements TextAccessor {
        private final ActionButton myComponent;

        ActionButtonTextAccessor(ActionButton component) {
            this.myComponent = component;
        }

        public String getText() {
            return this.myComponent.getAction().getTemplatePresentation().getText();
        }

        public void setText(String text) {
            this.myComponent.getAction().getTemplatePresentation().setText(text);
        }
    }

    private static class AbstractButtonTextAccessor
    implements TextAccessor {
        private final AbstractButton myComponent;

        AbstractButtonTextAccessor(AbstractButton component) {
            this.myComponent = component;
        }

        public String getText() {
            return this.myComponent.getText();
        }

        public void setText(String text) {
            this.myComponent.setText(text);
        }
    }

    private static class JLabelTextAccessor
    implements TextAccessor {
        private final JLabel myComponent;

        JLabelTextAccessor(JLabel component) {
            this.myComponent = component;
        }

        public String getText() {
            return this.myComponent.getText();
        }

        public void setText(String text) {
            this.myComponent.setText(text);
        }
    }

    private static class JTextComponentTextAccessor
    implements TextAccessor {
        private final JComponent myComponent;

        JTextComponentTextAccessor(JComponent component) {
            this.myComponent = component;
        }

        public String getText() {
            return ((JTextComponent)this.myComponent).getText();
        }

        public void setText(String text) {
            ((JTextComponent)this.myComponent).setText(text);
        }
    }
}

