/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.TreeWalker;
import com.intellij.util.Producer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TooltipComponent
extends AnimatedComponent {
    private static final int TOOLTIP_BORDER_SIZE = 10;
    @NotNull
    private final Component myContent;
    @NotNull
    private final Component myOwner;
    @NotNull
    private final Producer<Boolean> myIsOwnerDisplayable;
    @Nullable
    private Point myLastPoint;
    private final ComponentListener myParentListener;
    @Nullable
    private Class<? extends JLayeredPane> myPreferredParentClass;

    public TooltipComponent(@NotNull Component content, @NotNull Component owner, @Nullable Class<? extends JLayeredPane> preferredParentClass) {
        if (content == null) {
            TooltipComponent.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            TooltipComponent.$$$reportNull$$$0(1);
        }
        this(content, owner, preferredParentClass, (Producer<Boolean>)((Producer)owner::isDisplayable));
    }

    TooltipComponent(@NotNull Component content, @NotNull Component owner, @Nullable Class<? extends JLayeredPane> preferredParentClass, @NotNull Producer<Boolean> isOwnerDisplayable) {
        if (content == null) {
            TooltipComponent.$$$reportNull$$$0(2);
        }
        if (owner == null) {
            TooltipComponent.$$$reportNull$$$0(3);
        }
        if (isOwnerDisplayable == null) {
            TooltipComponent.$$$reportNull$$$0(4);
        }
        this.myContent = content;
        this.myOwner = owner;
        this.myIsOwnerDisplayable = isOwnerDisplayable;
        this.myPreferredParentClass = preferredParentClass;
        this.add(content);
        this.removeFromParent();
        owner.addHierarchyListener(event -> SwingUtilities.invokeLater(() -> {
            if (!((Boolean)this.myIsOwnerDisplayable.produce()).booleanValue()) {
                this.removeFromParent();
            }
        }));
        this.myParentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TooltipComponent.this.setBounds();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                TooltipComponent.this.setBounds();
            }
        };
    }

    private void recomputeParent() {
        if (!((Boolean)this.myIsOwnerDisplayable.produce()).booleanValue()) {
            this.removeFromParent();
            return;
        }
        JLayeredPane layeredPane = null;
        for (Component c : new TreeWalker(this.myOwner).ancestors()) {
            if (c instanceof JLayeredPane) {
                layeredPane = (JLayeredPane)c;
                if (c.getClass() != this.myPreferredParentClass) continue;
                break;
            }
            if (!(c instanceof RootPaneContainer)) continue;
            layeredPane = ((RootPaneContainer)((Object)c)).getLayeredPane();
        }
        if (layeredPane == this.getParent()) {
            return;
        }
        this.removeFromParent();
        if (layeredPane != null) {
            this.setParent(layeredPane);
        }
    }

    private void removeFromParent() {
        this.setVisible(false);
        if (this.getParent() != null) {
            this.getParent().removeComponentListener(this.myParentListener);
            this.getParent().remove(this);
        }
    }

    private void setParent(@NotNull JLayeredPane parent) {
        if (parent == null) {
            TooltipComponent.$$$reportNull$$$0(5);
        }
        this.setVisible(true);
        parent.add((Component)this, JLayeredPane.POPUP_LAYER);
        parent.addComponentListener(this.myParentListener);
        this.setBounds();
    }

    private void setBounds() {
        Container parent = this.getParent();
        if (parent == null) {
            return;
        }
        this.setBounds(0, 0, parent.getWidth(), parent.getHeight());
    }

    public void registerListenersOn(Component component) {
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                this.handleMove(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TooltipComponent.this.myLastPoint = null;
                if (TooltipComponent.this.isVisible()) {
                    TooltipComponent.this.removeFromParent();
                }
                TooltipComponent.this.opaqueRepaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.handleMove(e);
            }

            private void handleMove(MouseEvent e) {
                if (!TooltipComponent.this.isVisible()) {
                    Rectangle oldBounds = TooltipComponent.this.myContent.getBounds();
                    Dimension preferredSize = TooltipComponent.this.getPreferredSize();
                    TooltipComponent.this.myContent.setBounds(oldBounds.x, oldBounds.y, preferredSize.width, preferredSize.height);
                    TooltipComponent.this.recomputeParent();
                }
                TooltipComponent.this.myLastPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), TooltipComponent.this);
                TooltipComponent.this.opaqueRepaint();
            }
        };
        component.addMouseMotionListener(adapter);
        component.addMouseListener(adapter);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = this.myContent.getPreferredSize();
        Dimension minSize = this.myContent.getMinimumSize();
        return new Dimension(Math.max(preferredSize.width, minSize.width), Math.max(preferredSize.height, minSize.height));
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        if (!this.myContent.isVisible()) {
            return;
        }
        assert (this.myLastPoint != null);
        Dimension preferredSize = this.getPreferredSize();
        int x = Math.max(Math.min(this.myLastPoint.x + 10, dim.width - preferredSize.width - 10), 10);
        int y = Math.max(Math.min(this.myLastPoint.y + 10, dim.height - preferredSize.height - 10), 10);
        this.myContent.setBounds(x, y, preferredSize.width, preferredSize.height);
        g.setColor(Color.WHITE);
        g.fillRect(x, y, preferredSize.width, preferredSize.height);
        g.setStroke(new BasicStroke(1.0f));
        int lines = 4;
        int[] alphas = new int[]{40, 30, 20, 10};
        RoundRectangle2D.Float rect = new RoundRectangle2D.Float();
        for (int i = 0; i < lines; ++i) {
            g.setColor(new Color(0, 0, 0, alphas[i]));
            rect.setRoundRect(x - 1 - i, y - 1 - i, preferredSize.width + 1 + i * 2, preferredSize.height + 1 + i * 2, i * 2 + 2, i * 2 + 2);
            g.draw(rect);
        }
        this.myContent.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isOwnerDisplayable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/TooltipComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setParent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

