/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.linechart;

import com.android.tools.adtui.chart.linechart.LineChartReducer;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.model.SeriesData;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class DefaultLineChartReducer
implements LineChartReducer {
    private static final float EPS = 1.0E-6f;
    private static int PATH_ITERATOR_COORDS_COUNT = 6;

    DefaultLineChartReducer() {
    }

    @Override
    public List<SeriesData<Long>> reduceData(@NotNull List<SeriesData<Long>> dataList, @NotNull LineConfig config) {
        if (dataList == null) {
            DefaultLineChartReducer.$$$reportNull$$$0(0);
        }
        if (config == null) {
            DefaultLineChartReducer.$$$reportNull$$$0(1);
        }
        ArrayList<SeriesData<Long>> reduced = new ArrayList<SeriesData<Long>>();
        for (SeriesData<Long> data : dataList) {
            while (reduced.size() >= 2) {
                SeriesData preLast = (SeriesData)reduced.get(reduced.size() - 2);
                SeriesData last = (SeriesData)reduced.get(reduced.size() - 1);
                if (!((Long)preLast.value).equals(last.value) || !config.isStepped() && !((Long)last.value).equals(data.value)) break;
                reduced.remove(reduced.size() - 1);
            }
            reduced.add(data);
        }
        return reduced;
    }

    @Override
    @NotNull
    public Path2D reducePath(@NotNull Path2D path, @NotNull LineConfig config) {
        if (path == null) {
            DefaultLineChartReducer.$$$reportNull$$$0(2);
        }
        if (config == null) {
            DefaultLineChartReducer.$$$reportNull$$$0(3);
        }
        if (path.getCurrentPoint() == null) {
            Path2D path2D = path;
            if (path2D == null) {
                DefaultLineChartReducer.$$$reportNull$$$0(4);
            }
            return path2D;
        }
        Path2D.Float resultPath = new Path2D.Float();
        float[] coords = new float[PATH_ITERATOR_COORDS_COUNT];
        float pixel = -1.0f;
        float minX = -1.0f;
        float minY = -1.0f;
        float maxX = -1.0f;
        float maxY = -1.0f;
        float curX = -1.0f;
        float curY = -1.0f;
        int minIndex = -1;
        int maxIndex = -1;
        int curIndex = 0;
        PathIterator iterator = path.getPathIterator(null);
        while (!iterator.isDone()) {
            int segType = iterator.currentSegment(coords);
            assert (segType == 0 || segType == 1);
            float previousX = curX;
            float previousY = curY;
            curX = coords[0];
            curY = coords[1];
            if (curIndex > 0 && curX < previousX) break;
            if (curIndex == 0 || curX >= pixel) {
                if (curIndex > 0) {
                    DefaultLineChartReducer.addMinMaxPoints(resultPath, config, minIndex, minX, minY, maxIndex, maxX, maxY);
                    DefaultLineChartReducer.addToResultPath(resultPath, config, previousX, previousY);
                }
                pixel = (float)Math.floor(curX) + 1.0f;
                minX = maxX = curX;
                minY = maxY = curY;
                minIndex = maxIndex = curIndex;
                DefaultLineChartReducer.addToResultPath(resultPath, config, curX, curY);
            } else {
                if (minY > curY) {
                    minIndex = curIndex;
                    minX = curX;
                    minY = curY;
                }
                if (maxY <= curY) {
                    maxIndex = curIndex;
                    maxX = curX;
                    maxY = curY;
                }
            }
            iterator.next();
            ++curIndex;
        }
        DefaultLineChartReducer.addMinMaxPoints(resultPath, config, minIndex, minX, minY, maxIndex, maxX, maxY);
        DefaultLineChartReducer.addToResultPath(resultPath, config, curX, curY);
        if (config.isStepped() && (resultPath.getCurrentPoint() == null || DefaultLineChartReducer.equals((float)resultPath.getCurrentPoint().getY(), curY))) {
            DefaultLineChartReducer.addToPath(resultPath, curX, curY);
        }
        Path2D.Float float_ = resultPath;
        if (float_ == null) {
            DefaultLineChartReducer.$$$reportNull$$$0(5);
        }
        return float_;
    }

    private static void addMinMaxPoints(@NotNull Path2D path, @NotNull LineConfig config, int minIndex, float minX, float minY, int maxIndex, float maxX, float maxY) {
        if (path == null) {
            DefaultLineChartReducer.$$$reportNull$$$0(6);
        }
        if (config == null) {
            DefaultLineChartReducer.$$$reportNull$$$0(7);
        }
        if (minIndex < maxIndex) {
            DefaultLineChartReducer.addToResultPath(path, config, minX, minY, maxX, maxY);
        } else {
            DefaultLineChartReducer.addToResultPath(path, config, maxX, maxY, minX, minY);
        }
    }

    private static void addToResultPath(@NotNull Path2D path, @NotNull LineConfig config, float ... coords) {
        if (path == null) {
            DefaultLineChartReducer.$$$reportNull$$$0(8);
        }
        if (config == null) {
            DefaultLineChartReducer.$$$reportNull$$$0(9);
        }
        assert (coords.length % 2 == 0);
        for (int i = 0; i < coords.length; i += 2) {
            float x = coords[i];
            float y = coords[i + 1];
            if (config.isStepped()) {
                DefaultLineChartReducer.addToSteppedLinePath(path, x, y);
                continue;
            }
            DefaultLineChartReducer.addToPath(path, x, y);
        }
    }

    private static void addToSteppedLinePath(@NotNull Path2D path, float x, float y) {
        if (path == null) {
            DefaultLineChartReducer.$$$reportNull$$$0(10);
        }
        if (path.getCurrentPoint() == null) {
            path.moveTo(x, y);
        } else if (!DefaultLineChartReducer.equals(y, (float)path.getCurrentPoint().getY())) {
            DefaultLineChartReducer.addToPath(path, x, (float)path.getCurrentPoint().getY());
            DefaultLineChartReducer.addToPath(path, x, y);
        }
    }

    private static void addToPath(@NotNull Path2D path, float x, float y) {
        if (path == null) {
            DefaultLineChartReducer.$$$reportNull$$$0(11);
        }
        if (path.getCurrentPoint() == null) {
            path.moveTo(x, y);
        } else if (!DefaultLineChartReducer.equals((float)path.getCurrentPoint().getX(), x) || !DefaultLineChartReducer.equals((float)path.getCurrentPoint().getY(), y)) {
            path.lineTo(x, y);
        }
    }

    private static boolean equals(float a, float b) {
        return Math.abs(a - b) <= 1.0E-6f;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataList";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/chart/linechart/DefaultLineChartReducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/chart/linechart/DefaultLineChartReducer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "reducePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reduceData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reducePath";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addMinMaxPoints";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addToResultPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addToSteppedLinePath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addToPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

