/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.statechart;

import com.android.tools.adtui.MouseAdapterComponent;
import com.android.tools.adtui.chart.statechart.DefaultStateChartReducer;
import com.android.tools.adtui.chart.statechart.StateChartConfig;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.EnumColors;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StateChartModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StateChart<E extends Enum<E>>
extends MouseAdapterComponent<Long> {
    private static final int TEXT_PADDING = 3;
    private StateChartModel<E> myModel;
    @NotNull
    private EnumColors<E> mColors;
    private float mHeightGap;
    @NotNull
    private final HashMap<Rectangle2D.Float, E> mValues;
    @NotNull
    private RenderMode mRenderMode;
    @NotNull
    private StateChartConfig<E> myConfig;
    private boolean myRender;

    public StateChart(@NotNull StateChartModel<E> model, @NotNull Map<E, Color> colors) {
        if (model == null) {
            StateChart.$$$reportNull$$$0(0);
        }
        if (colors == null) {
            StateChart.$$$reportNull$$$0(1);
        }
        this(model, new EnumColors<E>(colors));
    }

    public StateChart(@NotNull StateChartModel<E> model, @NotNull EnumColors<E> enumColors) {
        if (model == null) {
            StateChart.$$$reportNull$$$0(2);
        }
        if (enumColors == null) {
            StateChart.$$$reportNull$$$0(3);
        }
        this(model, enumColors, new StateChartConfig(new DefaultStateChartReducer()));
    }

    public StateChart(@NotNull StateChartModel<E> model, @NotNull Map<E, Color> colors, @NotNull StateChartConfig<E> config) {
        if (model == null) {
            StateChart.$$$reportNull$$$0(4);
        }
        if (colors == null) {
            StateChart.$$$reportNull$$$0(5);
        }
        if (config == null) {
            StateChart.$$$reportNull$$$0(6);
        }
        this(model, new EnumColors<E>(colors), config);
    }

    public StateChart(@NotNull StateChartModel<E> model, @NotNull EnumColors<E> enumColors, @NotNull StateChartConfig<E> config) {
        if (model == null) {
            StateChart.$$$reportNull$$$0(7);
        }
        if (enumColors == null) {
            StateChart.$$$reportNull$$$0(8);
        }
        if (config == null) {
            StateChart.$$$reportNull$$$0(9);
        }
        super(config.getRectangleHeightRatio(), config.getRectangleMouseOverHeightRatio());
        this.mColors = enumColors;
        this.mValues = new HashMap();
        this.mRenderMode = RenderMode.BAR;
        this.myConfig = config;
        this.myRender = true;
        this.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        this.setModel(model);
        this.setHeightGap(this.myConfig.getHeightGap());
    }

    public void setModel(@NotNull StateChartModel<E> model) {
        if (model == null) {
            StateChart.$$$reportNull$$$0(10);
        }
        if (this.myModel != null) {
            this.myModel.removeDependencies(this.myAspectObserver);
        }
        this.myModel = model;
        this.myModel.addDependency(this.myAspectObserver).onChange(StateChartModel.Aspect.STATE_CHART, this::modelChanged);
        this.modelChanged();
    }

    private void modelChanged() {
        this.myRender = true;
        this.opaqueRepaint();
    }

    public void setRenderMode(RenderMode mode) {
        this.mRenderMode = mode;
    }

    public void setHeightGap(float gap) {
        this.mHeightGap = gap;
    }

    @NotNull
    public EnumColors<E> getColors() {
        EnumColors<E> enumColors = this.mColors;
        if (enumColors == null) {
            StateChart.$$$reportNull$$$0(11);
        }
        return enumColors;
    }

    protected void render() {
        long renderTime = System.nanoTime();
        List<RangedSeries<E>> series = this.myModel.getSeries();
        int seriesSize = series.size();
        if (seriesSize == 0) {
            return;
        }
        float height = 1.0f / (float)seriesSize;
        float gap = height * this.mHeightGap;
        this.setHeightFactor(height);
        this.mValues.clear();
        int seriesIndex = 0;
        long rectCount = 0L;
        Set pastRectangleKeys = this.getRectangleKeys();
        for (RangedSeries<E> data : series) {
            double min = data.getXRange().getMin();
            double max = data.getXRange().getMax();
            float startHeight = 1.0f - height * (float)(seriesIndex + 1);
            long previousX = -1L;
            Enum previousValue = null;
            for (SeriesData<E> seriesData : data.getSeries()) {
                long x = seriesData.x;
                Enum value = (Enum)seriesData.value;
                if (value.equals(previousValue)) continue;
                if (previousValue != null && (double)x >= min) {
                    Rectangle2D.Float rect = this.setRectangleData(rectCount, Math.max(min, (double)previousX), Math.min(max, (double)x), min, max, startHeight + gap * 0.5f, gap);
                    pastRectangleKeys.remove(rectCount);
                    this.mValues.put(rect, previousValue);
                    ++rectCount;
                }
                previousValue = value;
                previousX = x;
                if (!((double)previousX >= max)) continue;
                break;
            }
            if ((double)previousX < max && previousValue != null) {
                Rectangle2D.Float rect = this.setRectangleData(rectCount, Math.max(min, (double)previousX), max, min, max, startHeight + gap * 0.5f, gap);
                pastRectangleKeys.remove(rectCount);
                this.mValues.put(rect, previousValue);
                ++rectCount;
            }
            ++seriesIndex;
        }
        for (Long key : pastRectangleKeys) {
            this.mValues.remove(this.getRectangle(key));
            this.removeRectangle(key);
        }
        this.addDebugInfo("Render time: %.2fms", Float.valueOf((float)(System.nanoTime() - renderTime) / 1000000.0f));
    }

    @Override
    protected void draw(Graphics2D g2d, Dimension dim) {
        if (this.myRender) {
            this.render();
            this.myRender = false;
        }
        long drawTime = System.nanoTime();
        g2d.setFont(this.getFont());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        assert (this.getRectangleCount() == this.mValues.size());
        ArrayList<Shape> transformedShapes = new ArrayList<Shape>(this.getRectangleCount());
        ArrayList<E> transformedValues = new ArrayList<E>(this.getRectangleCount());
        AffineTransform scale = AffineTransform.getScaleInstance(dim.getWidth(), dim.getHeight());
        for (Long key : this.getRectangleKeys()) {
            transformedShapes.add(scale.createTransformedShape(this.getRectangle(key)));
            transformedValues.add(this.mValues.get(this.getRectangle(key)));
        }
        this.myConfig.getReducer().reduce(transformedShapes, transformedValues);
        assert (transformedShapes.size() == transformedValues.size());
        block5: for (int i = 0; i < transformedShapes.size(); ++i) {
            Shape shape = (Shape)transformedShapes.get(i);
            Enum value = (Enum)transformedValues.get(i);
            g2d.setColor(this.mColors.getColor(value));
            switch (this.mRenderMode) {
                case BAR: {
                    g2d.fill(shape);
                    continue block5;
                }
                case TEXT: {
                    Rectangle2D rect = shape.getBounds2D();
                    g2d.draw(new Line2D.Double(rect.getX(), rect.getY(), rect.getX(), rect.getY() + rect.getHeight()));
                    String text = AdtUiUtils.shrinkToFit(value.toString(), this.mDefaultFontMetrics, (float)rect.getWidth() - 6.0f);
                    if (text.isEmpty()) continue block5;
                    g2d.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
                    g2d.drawString(text, (float)(rect.getX() + 3.0), (float)(rect.getY() + rect.getHeight() - 3.0));
                }
            }
        }
        this.addDebugInfo("Draw time: %.2fms", Float.valueOf((float)(System.nanoTime() - drawTime) / 1000000.0f));
        this.addDebugInfo("# of drawn rects: %d", transformedShapes.size());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumColors";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/chart/statechart/StateChart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/chart/statechart/StateChart";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getColors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum RenderMode {
        BAR,
        TEXT;

    }
}

