/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public final class AdtUiUtils {
    public static final JBFont DEFAULT_FONT = JBFont.create((Font)new Font(null, 0, 10));
    public static final Color DEFAULT_FONT_COLOR = JBColor.foreground();
    public static final Color DEFAULT_BORDER_COLOR = new JBColor((Color)Gray._201, (Color)Gray._40);
    public static final Border DEFAULT_TOP_BORDER = BorderFactory.createMatteBorder(1, 0, 0, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_LEFT_BORDER = BorderFactory.createMatteBorder(0, 1, 0, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_BOTTOM_BORDER = BorderFactory.createMatteBorder(0, 0, 1, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_RIGHT_BORDER = BorderFactory.createMatteBorder(0, 0, 0, 1, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_HORIZONTAL_BORDERS = BorderFactory.createMatteBorder(1, 0, 1, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_VERTICAL_BORDERS = BorderFactory.createMatteBorder(0, 1, 0, 1, DEFAULT_BORDER_COLOR);
    public static final GridBagConstraints GBC_FULL = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 256, 1, new Insets(0, 0, 0, 0), 0, 0);

    private AdtUiUtils() {
    }

    public static String shrinkToFit(String text, FontMetrics metrics, float availableSpace) {
        return AdtUiUtils.shrinkToFit(text, s -> (float)metrics.stringWidth((String)s) <= availableSpace);
    }

    public static String shrinkToFit(String text, Predicate<String> textFitPredicate) {
        if (textFitPredicate.test(text)) {
            return text;
        }
        if (!textFitPredicate.test("...")) {
            return "";
        }
        int smallestLength = 0;
        int largestLength = text.length();
        int bestLength = smallestLength;
        do {
            int midLength;
            if (textFitPredicate.test(text.substring(0, midLength = smallestLength + (largestLength - smallestLength) / 2) + "...")) {
                bestLength = midLength;
                smallestLength = midLength + 1;
                continue;
            }
            largestLength = midLength - 1;
        } while (smallestLength <= largestLength);
        return text.substring(0, bestLength) + "...";
    }

    public static int unscale(int i) {
        return Math.round((float)i / JBUI.scale((float)1.0f));
    }

    public static Color overlayColor(int backgroundRgb, int foregroundRbg, float foregroundOpacity) {
        Color background = new Color(backgroundRgb);
        Color forground = new Color(foregroundRbg);
        return new Color(Math.round((float)background.getRed() * (1.0f - foregroundOpacity) + (float)forground.getRed() * foregroundOpacity), Math.round((float)background.getGreen() * (1.0f - foregroundOpacity) + (float)forground.getGreen() * foregroundOpacity), Math.round((float)background.getBlue() * (1.0f - foregroundOpacity) + (float)forground.getBlue() * foregroundOpacity));
    }
}

