/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.flat;

import com.android.tools.adtui.flat.FlatUiUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;

class FlatButtonUI
extends BasicButtonUI {
    private final MouseAdapter myAdapter = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            FlatButtonUI.this.myHover = true;
            e.getComponent().repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            FlatButtonUI.this.myHover = false;
            e.getComponent().repaint();
        }
    };
    private boolean myHover;

    FlatButtonUI() {
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setOpaque(false);
        b.setBorder(BorderFactory.createEmptyBorder(JBUI.scale((int)4), JBUI.scale((int)4), JBUI.scale((int)5), JBUI.scale((int)5)));
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addMouseListener(this.myAdapter);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.removeMouseListener(this.myAdapter);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (this.myHover || b.isSelected() || b.isFocusOwner()) {
            FlatUiUtils.paintBackground(g, c);
        }
        super.paint(g, c);
    }
}

