/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.instructions;

import com.android.tools.adtui.instructions.RenderInstruction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconInstruction
extends RenderInstruction {
    @NotNull
    private final Icon myIcon;
    private final int myPadding;
    @Nullable
    private final Color myBgColor;
    @NotNull
    private final Dimension mySize;

    public IconInstruction(@NotNull Icon icon, int padding, @Nullable Color bgColor) {
        if (icon == null) {
            IconInstruction.$$$reportNull$$$0(0);
        }
        this.myIcon = icon;
        this.myPadding = padding;
        this.myBgColor = bgColor;
        this.mySize = new Dimension(this.myIcon.getIconWidth() + 2 * this.myPadding, this.myIcon.getIconHeight() + 2 * this.myPadding);
    }

    @Override
    @NotNull
    public Dimension getSize() {
        Dimension dimension = this.mySize;
        if (dimension == null) {
            IconInstruction.$$$reportNull$$$0(1);
        }
        return dimension;
    }

    @Override
    public void render(@NotNull JComponent c, @NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
        if (c == null) {
            IconInstruction.$$$reportNull$$$0(2);
        }
        if (g2d == null) {
            IconInstruction.$$$reportNull$$$0(3);
        }
        if (bounds == null) {
            IconInstruction.$$$reportNull$$$0(4);
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        assert (this.mySize.height <= bounds.height && this.mySize.width <= bounds.width);
        if (this.myBgColor != null) {
            g2d.setColor(this.myBgColor);
            g2d.fillRoundRect(bounds.x, bounds.y, this.mySize.width, this.mySize.height, 5, 5);
        }
        this.myIcon.paintIcon(c, g2d, bounds.x + this.myPadding, bounds.y + this.myPadding);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/instructions/IconInstruction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2d";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/instructions/IconInstruction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

