/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.instructions;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.instructions.InstructionsRenderer;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.EaseOutModel;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstructionsPanel
extends JPanel {
    @Nullable
    private final EaseOutModel myEaseOutModel;
    @Nullable
    private AspectObserver myObserver;
    @Nullable
    private Consumer<InstructionsPanel> myEaseOutCompletionCallback;

    private InstructionsPanel(@NotNull Builder builder) {
        if (builder == null) {
            InstructionsPanel.$$$reportNull$$$0(0);
        }
        super(new TabularLayout("*,Fit,*", "*,Fit,*"));
        this.setOpaque(false);
        this.setBackground(builder.myBackgroundColor);
        this.setForeground(builder.myForegroundColor);
        InstructionsComponent component = new InstructionsComponent(builder);
        this.add((Component)component, new TabularLayout.Constraint(1, 1));
        this.myEaseOutModel = builder.myEaseOutModel;
        this.myEaseOutCompletionCallback = builder.myEaseOutCompletionCallback;
        if (this.myEaseOutModel != null) {
            this.myObserver = new AspectObserver();
            this.myEaseOutModel.addDependency(this.myObserver).onChange(EaseOutModel.Aspect.EASING, this::modelChanged);
        }
    }

    private void modelChanged() {
        if (this.myEaseOutCompletionCallback == null) {
            return;
        }
        assert (this.myEaseOutModel != null);
        if (this.myEaseOutModel.getPercentageComplete() >= 1.0f) {
            this.myEaseOutCompletionCallback.accept(this);
            this.myEaseOutCompletionCallback = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/adtui/instructions/InstructionsPanel", "<init>"));
    }

    public static final class Builder {
        private static final Color INSTRUCTIONS_BACKGROUND = new JBColor(new Color(-666483130, true), new Color(-655956250, true));
        private static final Color INSTRUCTIONS_FOREGROUND = new JBColor(new Color(0xFFFFFF), new Color(0));
        public static final int DEFAULT_PADDING_PX = JBUI.scale((int)12);
        private int myArcWidth;
        private int myArcHeight;
        private int myHorizontalPadding;
        private int myVerticalPadding;
        @Nullable
        private Color myBackgroundColor;
        @NotNull
        private Color myForegroundColor;
        private InstructionsRenderer.HorizontalAlignment myAlignment;
        @Nullable
        private EaseOutModel myEaseOutModel;
        @Nullable
        private Consumer<InstructionsPanel> myEaseOutCompletionCallback;
        @NotNull
        private final List<RenderInstruction> myInstructions;

        public Builder(RenderInstruction ... instructions) {
            if (instructions == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myHorizontalPadding = DEFAULT_PADDING_PX;
            this.myVerticalPadding = DEFAULT_PADDING_PX;
            this.myBackgroundColor = INSTRUCTIONS_BACKGROUND;
            this.myForegroundColor = INSTRUCTIONS_FOREGROUND;
            this.myAlignment = InstructionsRenderer.HorizontalAlignment.CENTER;
            this.myInstructions = Arrays.asList(instructions);
        }

        @NotNull
        public Builder setColors(@NotNull Color foregroundColor, @Nullable Color backgroundColor) {
            if (foregroundColor == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myForegroundColor = foregroundColor;
            this.myBackgroundColor = backgroundColor;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder setAlignment(@NotNull InstructionsRenderer.HorizontalAlignment alignment) {
            if (alignment == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myAlignment = alignment;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder setPaddings(int horizontalPadding, int verticalPadding) {
            this.myHorizontalPadding = horizontalPadding;
            this.myVerticalPadding = verticalPadding;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder setBackgroundCornerRadius(int arcWidth, int arcHeight) {
            this.myArcWidth = arcWidth;
            this.myArcHeight = arcHeight;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder setEaseOut(@NotNull EaseOutModel easeOutModel, @Nullable Consumer<InstructionsPanel> easeOutCompletionCallback) {
            if (easeOutModel == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.myEaseOutModel = easeOutModel;
            this.myEaseOutCompletionCallback = easeOutCompletionCallback;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public InstructionsPanel build() {
            InstructionsPanel instructionsPanel = new InstructionsPanel(this);
            if (instructionsPanel == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return instructionsPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instructions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foregroundColor";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/instructions/InstructionsPanel$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "alignment";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "easeOutModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/instructions/InstructionsPanel$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setColors";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setAlignment";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setPaddings";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setBackgroundCornerRadius";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setEaseOut";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setColors";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setAlignment";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setEaseOut";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InstructionsComponent
    extends AnimatedComponent {
        private final int myHorizontalPadding;
        private final int myVerticalPadding;
        private final int myArcWidth;
        private final int myArcHeight;
        private float myAlpha;
        @Nullable
        private EaseOutModel myEaseOutModel;
        @NotNull
        private final InstructionsRenderer myRenderer;

        InstructionsComponent(@NotNull Builder builder) {
            if (builder == null) {
                InstructionsComponent.$$$reportNull$$$0(0);
            }
            this.myEaseOutModel = builder.myEaseOutModel;
            this.myHorizontalPadding = builder.myHorizontalPadding;
            this.myVerticalPadding = builder.myVerticalPadding;
            this.myArcWidth = builder.myArcWidth;
            this.myArcHeight = builder.myArcHeight;
            this.myRenderer = new InstructionsRenderer(builder.myInstructions, builder.myAlignment);
            this.myAlpha = 1.0f;
            if (this.myEaseOutModel != null) {
                this.myEaseOutModel.addDependency(this.myAspectObserver).onChange(EaseOutModel.Aspect.EASING, this::modelChanged);
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.delegateMouseEvent(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.delegateMouseEvent(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.delegateMouseEvent(e);
                }
            });
        }

        private void delegateMouseEvent(@NotNull MouseEvent event) {
            if (event == null) {
                InstructionsComponent.$$$reportNull$$$0(1);
            }
            event.translatePoint(-this.myHorizontalPadding, -this.myVerticalPadding);
            Point position = event.getPoint();
            Point cursor = new Point(this.myRenderer.getStartX(0), 0);
            for (RenderInstruction instruction : this.myRenderer.getInstructions()) {
                Rectangle bounds = instruction.getBounds(this.myRenderer, cursor);
                if (bounds.contains(position)) {
                    event.translatePoint(-bounds.x, -bounds.y);
                    instruction.handleMouseEvent(event);
                    break;
                }
                instruction.moveCursor(this.myRenderer, cursor);
            }
        }

        private void modelChanged() {
            if (this.myAlpha <= 0.0f) {
                return;
            }
            assert (this.myEaseOutModel != null);
            this.myAlpha = 1.0f - this.myEaseOutModel.getPercentageComplete();
            this.opaqueRepaint();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension renderSize = this.myRenderer.getRenderSize();
            return new Dimension(renderSize.width + 2 * this.myHorizontalPadding, renderSize.height + 2 * this.myVerticalPadding);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        protected void draw(Graphics2D g2d, Dimension dim) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setComposite(AlphaComposite.getInstance(3, this.myAlpha));
            Color background = this.getBackground();
            if (background != null) {
                g2d.setColor(this.getBackground());
                Dimension size = this.getPreferredSize();
                g2d.fillRoundRect(0, 0, size.width, size.height, this.myArcWidth, this.myArcHeight);
            }
            g2d.translate(this.myHorizontalPadding, this.myVerticalPadding);
            this.myRenderer.draw(this, g2d);
            g2d.translate(-this.myHorizontalPadding, -this.myVerticalPadding);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/instructions/InstructionsPanel$InstructionsComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "delegateMouseEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

