/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.updater;

import com.android.tools.adtui.model.StopwatchTimer;
import com.android.tools.adtui.model.updater.Updatable;
import com.google.common.annotations.VisibleForTesting;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Updater
implements StopwatchTimer.TickHandler {
    public static final float DEFAULT_LERP_FRACTION = 0.99f;
    public static final float DEFAULT_LERP_THRESHOLD_PERCENTAGE = 0.001f;
    private final List<Updatable> mComponents;
    private List<Updatable> mToRegister;
    private List<Updatable> mToUnregister;
    private final StopwatchTimer mTimer;
    private boolean mReset;
    private boolean mUpdating;

    public Updater(@NotNull StopwatchTimer timer) {
        if (timer == null) {
            Updater.$$$reportNull$$$0(0);
        }
        this.mComponents = new LinkedList<Updatable>();
        this.mToRegister = new LinkedList<Updatable>();
        this.mToUnregister = new LinkedList<Updatable>();
        this.mUpdating = false;
        this.mTimer = timer;
        this.mTimer.setHandler(this);
        this.mTimer.start();
    }

    @VisibleForTesting
    public StopwatchTimer getTimer() {
        return this.mTimer;
    }

    public void register(Updatable updatable) {
        if (this.mUpdating) {
            this.mToRegister.add(updatable);
        } else {
            this.mComponents.add(updatable);
        }
    }

    public void register(@NotNull List<Updatable> updatables) {
        if (updatables == null) {
            Updater.$$$reportNull$$$0(1);
        }
        for (Updatable updatable : updatables) {
            this.register(updatable);
        }
    }

    public void unregister(@NotNull Updatable updatable) {
        if (updatable == null) {
            Updater.$$$reportNull$$$0(2);
        }
        if (this.mUpdating) {
            this.mToUnregister.add(updatable);
        } else {
            this.mComponents.remove(updatable);
        }
    }

    public void stop() {
        if (this.mTimer.isRunning()) {
            this.mTimer.stop();
        }
    }

    public boolean isRunning() {
        return this.mTimer.isRunning();
    }

    public void reset() {
        this.mReset = true;
    }

    @Override
    public void onTick(long elapsedNs) {
        this.mUpdating = true;
        if (this.mReset) {
            this.mComponents.forEach(Updatable::reset);
            this.mReset = false;
        }
        this.mComponents.forEach(component -> component.update(elapsedNs));
        this.mComponents.forEach(Updatable::postUpdate);
        this.mUpdating = false;
        this.mToUnregister.forEach(this::unregister);
        this.mToRegister.forEach(this::register);
        this.mToUnregister.clear();
        this.mToRegister.clear();
    }

    public static float lerp(float from, float to, float fraction, long frameLengthNs, float threshold) {
        if (Math.abs(to - from) < threshold) {
            return to;
        }
        double length = (double)frameLengthNs / 1.0E9;
        float q = (float)Math.pow(1.0f - fraction, length);
        return from * q + to * (1.0f - q);
    }

    public static double lerp(double from, double to, float fraction, long frameLengthNs, double threshold) {
        if (Math.abs(to - from) < threshold) {
            return to;
        }
        double length = (double)frameLengthNs / 1.0E9;
        double q = Math.pow(1.0f - fraction, length);
        return from * q + to * (1.0 - q);
    }

    public static double lerp(double a, double b, float factor) {
        return a * (double)(1.0f - factor) + b * (double)factor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatables";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatable";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/model/updater/Updater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unregister";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

