/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ptable;

import com.android.tools.adtui.ptable.PNameRenderer;
import com.android.tools.adtui.ptable.PTableCellEditor;
import com.android.tools.adtui.ptable.PTableCellEditorProvider;
import com.android.tools.adtui.ptable.PTableCellRendererProvider;
import com.android.tools.adtui.ptable.PTableDefaultCellRendererProvider;
import com.android.tools.adtui.ptable.PTableGroupItem;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.adtui.ptable.PTableModel;
import com.android.tools.adtui.ptable.StarState;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PTable
extends JBTable
implements DataProvider,
DeleteProvider,
CutProvider,
CopyProvider,
PasteProvider {
    private final CopyPasteManager myCopyPasteManager;
    private PTableModel myModel;
    private PTableCellRendererProvider myRendererProvider;
    private PTableCellEditorProvider myEditorProvider;
    private int myMouseHoverRow;
    private int myMouseHoverCol;
    private Point myMouseHoverPoint;

    public PTable(@NotNull PTableModel model) {
        if (model == null) {
            PTable.$$$reportNull$$$0(0);
        }
        this(model, CopyPasteManager.getInstance());
    }

    public PTable(@NotNull PTableModel model, @NotNull CopyPasteManager copyPasteManager) {
        if (model == null) {
            PTable.$$$reportNull$$$0(1);
        }
        if (copyPasteManager == null) {
            PTable.$$$reportNull$$$0(2);
        }
        super((TableModel)model);
        this.myCopyPasteManager = copyPasteManager;
        this.myMouseHoverPoint = new Point(-1, -1);
        this.myRendererProvider = new PTableDefaultCellRendererProvider();
        this.setMaxItemsForSizeCalculation(5);
        this.setShowColumns(false);
        this.setAutoResizeMode(3);
        this.setSelectionMode(0);
        this.setShowVerticalLines(true);
        this.setIntercellSpacing(new Dimension(0, 1));
        this.setGridColor(UIUtil.getSlightlyDarkerColor((Color)this.getBackground()));
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.addMouseListener(new MouseTableListener());
        HoverListener hoverListener = new HoverListener();
        this.addMouseMotionListener(hoverListener);
        this.addMouseListener(hoverListener);
        this.addKeyListener(new PTableKeyListener(this));
        this.resetDefaultFocusTraversalKeys();
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy(this));
    }

    public void setModel(@NotNull TableModel model) {
        if (model == null) {
            PTable.$$$reportNull$$$0(3);
        }
        this.myModel = (PTableModel)model;
        super.setModel(model);
    }

    public PTableModel getModel() {
        return (PTableModel)super.getModel();
    }

    public void setRendererProvider(@NotNull PTableCellRendererProvider rendererProvider) {
        if (rendererProvider == null) {
            PTable.$$$reportNull$$$0(4);
        }
        this.myRendererProvider = rendererProvider;
    }

    public void setEditorProvider(PTableCellEditorProvider editorProvider) {
        this.myEditorProvider = editorProvider;
    }

    public boolean surrendersFocusOnKeyStroke() {
        return false;
    }

    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Object value = this.getValueAt(row, column);
        boolean isSelected = this.isCellSelected(row, column);
        return editor.getTableCellEditorComponent((JTable)((Object)this), value, isSelected, row, column);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        PTableItem value = (PTableItem)this.getValueAt(row, column);
        if (column == 0) {
            return this.myRendererProvider.getNameCellRenderer(value);
        }
        TableCellRenderer renderer = value.getCellRenderer();
        if (renderer != null) {
            return renderer;
        }
        return this.myRendererProvider.getValueCellRenderer(value);
    }

    public PTableCellEditor getCellEditor(int row, int column) {
        PTableItem value = (PTableItem)this.getValueAt(row, column);
        if (value != null && this.myEditorProvider != null) {
            return this.myEditorProvider.getCellEditor(value, column);
        }
        return null;
    }

    public boolean isHover(int row, int col) {
        return row == this.myMouseHoverRow && col == this.myMouseHoverCol;
    }

    @NotNull
    public Point getHoverPosition() {
        Point point = this.myMouseHoverPoint;
        if (point == null) {
            PTable.$$$reportNull$$$0(5);
        }
        return point;
    }

    public void setUI(TableUI ui) {
        super.setUI(ui);
        ActionMap actionMap = this.getActionMap();
        InputMap focusedInputMap = this.getInputMap(0);
        InputMap ancestorInputMap = this.getInputMap(1);
        focusedInputMap.put(KeyStroke.getKeyStroke(10, 0), "smartEnter");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(10, 0));
        actionMap.put("smartEnter", new MyEnterAction(false));
        focusedInputMap.put(KeyStroke.getKeyStroke(32, 0), "toggleEditor");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(32, 0));
        actionMap.put("toggleEditor", new MyEnterAction(true));
        ancestorInputMap.remove(KeyStroke.getKeyStroke(39, 0));
        ancestorInputMap.remove(KeyStroke.getKeyStroke(227, 0));
        focusedInputMap.put(KeyStroke.getKeyStroke(39, 0), "expandCurrentRight");
        focusedInputMap.put(KeyStroke.getKeyStroke(227, 0), "expandCurrentRight");
        actionMap.put("expandCurrentRight", new MyExpandCurrentAction(true));
        ancestorInputMap.remove(KeyStroke.getKeyStroke(37, 0));
        ancestorInputMap.remove(KeyStroke.getKeyStroke(226, 0));
        focusedInputMap.put(KeyStroke.getKeyStroke(37, 0), "collapseCurrentLeft");
        focusedInputMap.put(KeyStroke.getKeyStroke(226, 0), "collapseCurrentLeft");
        actionMap.put("collapseCurrentLeft", new MyExpandCurrentAction(false));
        focusedInputMap.put(KeyStroke.getKeyStroke(33, 0), "pageUp");
        actionMap.put("pageUp", new MyPageUpAction());
        focusedInputMap.put(KeyStroke.getKeyStroke(34, 0), "pageDown");
        actionMap.put("pageDown", new MyPageDownAction());
        focusedInputMap.put(KeyStroke.getKeyStroke(36, 0), "home");
        actionMap.put("home", new MyHomeAction());
        focusedInputMap.put(KeyStroke.getKeyStroke(35, 0), "end");
        actionMap.put("end", new MyEndAction());
    }

    private void toggleTreeNode(int row) {
        PTableItem item = (PTableItem)this.getValueAt(row, 0);
        int index = this.convertRowIndexToModel(row);
        if (item.isExpanded()) {
            this.myModel.collapse(index);
        } else {
            this.myModel.expand(index);
        }
    }

    private void toggleStar(int row) {
        PTableItem item = (PTableItem)this.getValueAt(row, 0);
        StarState state = item.getStarState();
        if (state != StarState.NOT_STAR_ABLE) {
            item.setStarState(state.opposite());
        }
    }

    private void selectRow(int row) {
        this.getSelectionModel().setSelectionInterval(row, row);
        TableUtil.scrollSelectionToVisible((JTable)((Object)this));
    }

    private void quickEdit(int row) {
        PTableCellEditor editor = this.getCellEditor(row, 0);
        if (editor == null) {
            return;
        }
        if (editor.isBooleanEditor()) {
            this.startEditing(row, null);
        }
    }

    private void startEditing(int row, @Nullable Runnable afterActivation) {
        PTableCellEditor editor = this.getCellEditor(row, 0);
        if (editor == null) {
            return;
        }
        PTableItem item = (PTableItem)this.getValueAt(row, 0);
        if (item == null || !this.editCellAt(row, item.getColumnToEdit())) {
            return;
        }
        JComponent preferredComponent = this.getComponentToFocus(editor);
        if (preferredComponent == null) {
            return;
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
            preferredComponent.requestFocusInWindow();
            editor.activate();
            if (afterActivation != null) {
                afterActivation.run();
            }
        });
    }

    @Nullable
    private JComponent getComponentToFocus(PTableCellEditor editor) {
        JComponent preferredComponent = editor.getPreferredFocusComponent();
        if (preferredComponent == null) {
            preferredComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)((JComponent)this.editorComp));
        }
        if (preferredComponent == null) {
            return null;
        }
        return preferredComponent;
    }

    public void restoreSelection(int previousSelectedRow, @Nullable PTableItem previousSelectedItem) {
        int selectedRow = 0;
        if (previousSelectedItem != null) {
            PTableItem item;
            PTableItem pTableItem = item = previousSelectedRow >= 0 && previousSelectedRow < this.getRowCount() ? (PTableItem)this.getValueAt(previousSelectedRow, 0) : null;
            if (Objects.equals(item, previousSelectedItem)) {
                selectedRow = previousSelectedRow;
            } else {
                for (int row = 0; row < this.getRowCount(); ++row) {
                    item = (PTableItem)this.getValueAt(row, 0);
                    if (!item.equals(previousSelectedItem)) continue;
                    selectedRow = row;
                    break;
                }
            }
        }
        if (selectedRow < this.getRowCount()) {
            this.addRowSelectionInterval(selectedRow, selectedRow);
        }
    }

    @Nullable
    public PTableItem getSelectedItem() {
        int selectedRow = this.getSelectedRow();
        if (this.isEditing() || selectedRow == -1) {
            return null;
        }
        return (PTableItem)this.getValueAt(selectedRow, 0);
    }

    @Nullable
    public PTableItem getItemAt(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return null;
        }
        return (PTableItem)this.getValueAt(rowIndex, 0);
    }

    @Nullable
    private PTableItem getSelectedNonGroupItem() {
        PTableItem item = this.getSelectedItem();
        return item instanceof PTableGroupItem ? null : item;
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            PTable.$$$reportNull$$$0(6);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(7);
        }
        return this.getSelectedNonGroupItem() != null;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(8);
        }
        return true;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        PTableItem item;
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(9);
        }
        if ((item = this.getSelectedNonGroupItem()) == null) {
            return;
        }
        this.myCopyPasteManager.setContents((Transferable)new StringSelection(item.getValue()));
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(10);
        }
        return this.getSelectedNonGroupItem() != null;
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(11);
        }
        return true;
    }

    public void performCut(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(12);
        }
        if (this.getSelectedNonGroupItem() == null) {
            return;
        }
        this.performCopy(dataContext);
        this.deleteElement(dataContext);
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(13);
        }
        return this.getSelectedItem() != null;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        PTableItem item;
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(14);
        }
        if ((item = this.getSelectedItem()) == null) {
            return;
        }
        if (item instanceof PTableGroupItem) {
            ((PTableGroupItem)item).deleteGroupValues(dataContext);
        } else {
            item.setValue(null);
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(15);
        }
        if (this.getSelectedNonGroupItem() == null) {
            return false;
        }
        Transferable transferable = this.myCopyPasteManager.getContents();
        return transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(16);
        }
        return true;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        PTableItem item;
        if (dataContext == null) {
            PTable.$$$reportNull$$$0(17);
        }
        if ((item = this.getSelectedNonGroupItem()) == null) {
            return;
        }
        Transferable transferable = this.myCopyPasteManager.getContents();
        if (transferable == null || !transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        try {
            item.setValue(transferable.getTransferData(DataFlavor.stringFlavor));
        }
        catch (UnsupportedFlavorException | IOException exception) {
            Logger.getInstance(PTable.class).warn((Throwable)exception);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyPasteManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rendererProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/ptable/PTable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/ptable/PTable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHoverPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setRendererProvider";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCutEnabled";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isCutVisible";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performCut";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isPastePossible";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isPasteEnabled";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "performPaste";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private final PTable myTable;

        private MyFocusTraversalPolicy(@NotNull PTable table) {
            if (table == null) {
                MyFocusTraversalPolicy.$$$reportNull$$$0(0);
            }
            this.myTable = table;
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            Component after = super.getComponentAfter(aContainer, aComponent);
            if (after != null && after != this.myTable) {
                return after;
            }
            return this.myTable.isEditing() ? this.editNextEditableCell(true) : null;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            Component before = super.getComponentBefore(aContainer, aComponent);
            if (before != null && before != this.myTable) {
                return before;
            }
            return this.myTable.isEditing() ? this.editNextEditableCell(false) : null;
        }

        private Component editNextEditableCell(boolean forwards) {
            int rows = this.myTable.getRowCount();
            int row = this.myTable.getEditingRow();
            int col = this.myTable.getEditingColumn();
            int next = forwards ? 1 : -1;
            int wrapped = forwards ? 0 : 1;
            int rowIterations = 0;
            while (rowIterations < rows) {
                if ((col = Math.floorMod(col + next, 2)) == wrapped) {
                    row = Math.floorMod(row + next, rows);
                    ++rowIterations;
                }
                if (!this.myTable.isCellEditable(row, col)) continue;
                this.myTable.setRowSelectionInterval(row, row);
                this.myTable.startEditing(row, null);
                return this.myTable.getEditorComponent();
            }
            return null;
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return this.myTable;
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            return this.myTable;
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/android/tools/adtui/ptable/PTable$MyFocusTraversalPolicy", "<init>"));
        }
    }

    private static class PTableKeyListener
    extends KeyAdapter {
        private final PTable myTable;

        private PTableKeyListener(@NotNull PTable table) {
            if (table == null) {
                PTableKeyListener.$$$reportNull$$$0(0);
            }
            this.myTable = table;
        }

        @Override
        public void keyTyped(@NotNull KeyEvent event) {
            if (event == null) {
                PTableKeyListener.$$$reportNull$$$0(1);
            }
            int row = this.myTable.getSelectedRow();
            if (this.myTable.isEditing() || row == -1 || event.getKeyChar() == '\t') {
                return;
            }
            this.myTable.startEditing(row, () -> {
                if (event == null) {
                    PTableKeyListener.$$$reportNull$$$0(2);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (event == null) {
                        PTableKeyListener.$$$reportNull$$$0(3);
                    }
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
                        Component textEditor;
                        if (event == null) {
                            PTableKeyListener.$$$reportNull$$$0(4);
                        }
                        if (!((textEditor = IdeFocusManager.findInstance().getFocusOwner()) instanceof JTextComponent)) {
                            return;
                        }
                        KeyEvent keyEvent = new KeyEvent(textEditor, event.getID(), event.getWhen(), event.getModifiers(), event.getKeyCode(), event.getKeyChar());
                        textEditor.dispatchEvent(keyEvent);
                    });
                });
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/ptable/PTable$PTableKeyListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "keyTyped";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$keyTyped$2";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$null$1";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$null$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class HoverListener
    extends MouseAdapter {
        private int myPreviousHoverRow = -1;
        private int myPreviousHoverCol = -1;

        private HoverListener() {
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event) {
            if (event == null) {
                HoverListener.$$$reportNull$$$0(0);
            }
            PTable.this.myMouseHoverPoint = event.getPoint();
            PTable.this.myMouseHoverRow = PTable.this.rowAtPoint(event.getPoint());
            if (PTable.this.myMouseHoverRow >= 0) {
                PTable.this.myMouseHoverCol = PTable.this.columnAtPoint(event.getPoint());
            }
            if (this.myPreviousHoverRow != -1 && (this.myPreviousHoverRow != PTable.this.myMouseHoverRow || this.myPreviousHoverCol != PTable.this.myMouseHoverCol)) {
                PTable.this.repaint(PTable.this.getCellRect(this.myPreviousHoverRow, this.myPreviousHoverCol, true));
                this.myPreviousHoverRow = -1;
            }
            if (PTable.this.myMouseHoverCol < 0) {
                return;
            }
            PTable.this.repaint(PTable.this.getCellRect(PTable.this.myMouseHoverRow, PTable.this.myMouseHoverCol, true));
            Rectangle rectRightColumn = PTable.this.getCellRect(PTable.this.myMouseHoverRow, PTable.this.convertColumnIndexToView(1), false);
            if (rectRightColumn.contains(event.getX(), event.getY())) {
                PTableItem item = (PTableItem)PTable.this.getValueAt(PTable.this.myMouseHoverRow, 0);
                item.mouseMoved(PTable.this, event, rectRightColumn);
            }
            this.myPreviousHoverRow = PTable.this.myMouseHoverRow;
            this.myPreviousHoverCol = PTable.this.myMouseHoverCol;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (PTable.this.myMouseHoverRow != -1 && PTable.this.myMouseHoverCol != -1) {
                Rectangle cellRect = PTable.this.getCellRect(PTable.this.myMouseHoverRow, 1, true);
                PTable.this.myMouseHoverRow = (PTable.this.myMouseHoverCol = -1);
                PTable.this.repaint(cellRect);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/ptable/PTable$HoverListener", "mouseMoved"));
        }
    }

    private class MouseTableListener
    extends MouseAdapter {
        private MouseTableListener() {
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            Rectangle rectRightColumn;
            int row;
            if (event == null) {
                MouseTableListener.$$$reportNull$$$0(0);
            }
            if ((row = PTable.this.rowAtPoint(event.getPoint())) == -1) {
                return;
            }
            PTableItem item = (PTableItem)PTable.this.getValueAt(row, 0);
            Rectangle rectLeftColumn = PTable.this.getCellRect(row, PTable.this.convertColumnIndexToView(0), false);
            if (rectLeftColumn.contains(event.getX(), event.getY())) {
                int x = event.getX() - rectLeftColumn.x;
                int y = event.getY() - rectLeftColumn.y;
                PNameRenderer nameRenderer = PTable.this.myRendererProvider.getNameCellRenderer(item);
                if (nameRenderer.hitTestTreeNodeIcon(item, x, y) && item.hasChildren()) {
                    PTable.this.toggleTreeNode(row);
                    return;
                }
                if (nameRenderer.hitTestStarIcon(x, y)) {
                    PTable.this.toggleStar(row);
                    return;
                }
            }
            if ((rectRightColumn = PTable.this.getCellRect(row, PTable.this.convertColumnIndexToView(1), false)).contains(event.getX(), event.getY())) {
                item.mousePressed(PTable.this, event, rectRightColumn);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/ptable/PTable$MouseTableListener", "mousePressed"));
        }
    }

    private class MyEndAction
    extends AbstractAction {
        private MyEndAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = PTable.this.getSelectedRow();
            if (PTable.this.isEditing() || selectedRow == -1) {
                return;
            }
            PTable.this.selectRow(PTable.this.getRowCount() - 1);
        }
    }

    private class MyHomeAction
    extends AbstractAction {
        private MyHomeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = PTable.this.getSelectedRow();
            if (PTable.this.isEditing() || selectedRow == -1) {
                return;
            }
            PTable.this.selectRow(0);
        }
    }

    private class MyPageDownAction
    extends AbstractAction {
        private MyPageDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = PTable.this.getSelectedRow();
            if (PTable.this.isEditing() || selectedRow == -1) {
                return;
            }
            int visibleHeight = (int)PTable.this.getVisibleRect().getHeight();
            int rowHeight = PTable.this.getRowHeight();
            if (visibleHeight <= 0 || rowHeight <= 0) {
                return;
            }
            int movement = visibleHeight / rowHeight;
            PTable.this.selectRow(Math.min(selectedRow + movement, PTable.this.getRowCount() - 1));
        }
    }

    private class MyPageUpAction
    extends AbstractAction {
        private MyPageUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = PTable.this.getSelectedRow();
            if (PTable.this.isEditing() || selectedRow == -1) {
                return;
            }
            int visibleHeight = (int)PTable.this.getVisibleRect().getHeight();
            int rowHeight = PTable.this.getRowHeight();
            if (visibleHeight <= 0 || rowHeight <= 0) {
                return;
            }
            int movement = visibleHeight / rowHeight;
            PTable.this.selectRow(Math.max(0, selectedRow - movement));
        }
    }

    private class MyExpandCurrentAction
    extends AbstractAction {
        private final boolean myExpand;

        MyExpandCurrentAction(boolean expand) {
            this.myExpand = expand;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = PTable.this.getSelectedRow();
            if (PTable.this.isEditing() || selectedRow == -1) {
                return;
            }
            PTableItem item = (PTableItem)PTable.this.getValueAt(selectedRow, 0);
            int index = PTable.this.convertRowIndexToModel(selectedRow);
            if (this.myExpand) {
                if (item.hasChildren() && !item.isExpanded()) {
                    PTable.this.myModel.expand(index);
                    PTable.this.selectRow(selectedRow);
                }
            } else if (item.isExpanded()) {
                PTable.this.myModel.collapse(index);
                PTable.this.selectRow(selectedRow);
            } else if (item.getParent() != null) {
                PTable.this.selectRow(PTable.this.myModel.getParent(index));
            }
        }
    }

    private class MyEnterAction
    extends AbstractAction {
        private final boolean myToggleOnly;

        MyEnterAction(boolean toggleOnly) {
            this.myToggleOnly = toggleOnly;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = PTable.this.getSelectedRow();
            if (PTable.this.isEditing() || selectedRow == -1) {
                return;
            }
            PTableItem item = (PTableItem)PTable.this.getValueAt(selectedRow, 0);
            if (item.hasChildren()) {
                PTable.this.toggleTreeNode(selectedRow);
                PTable.this.selectRow(selectedRow);
            } else if (this.myToggleOnly) {
                PTable.this.quickEdit(selectedRow);
            } else {
                PTable.this.startEditing(selectedRow, null);
            }
        }
    }
}

