/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.validation;

import com.google.common.base.Strings;
import com.intellij.icons.AllIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Validator<T> {
    @NotNull
    public Result validate(@NotNull T var1);

    public static final class Result {
        public static final Result OK = new Result(Severity.OK, "");
        @NotNull
        private final Severity mySeverity;
        @NotNull
        private final String myMessage;

        public Result(@NotNull Severity severity, @NotNull String message) {
            if (severity == null) {
                Result.$$$reportNull$$$0(0);
            }
            if (message == null) {
                Result.$$$reportNull$$$0(1);
            }
            this.mySeverity = severity;
            this.myMessage = message;
        }

        @NotNull
        public static Result fromNullableMessage(@Nullable String errorMessage) {
            Result result = Strings.isNullOrEmpty((String)errorMessage) ? OK : new Result(Severity.ERROR, errorMessage);
            if (result == null) {
                Result.$$$reportNull$$$0(2);
            }
            return result;
        }

        @NotNull
        public static Result fromThrowable(@NotNull Throwable throwable) {
            String errorMessage;
            if (throwable == null) {
                Result.$$$reportNull$$$0(3);
            }
            if ((errorMessage = throwable.getMessage()) == null) {
                errorMessage = "Error (" + throwable.getClass().getSimpleName() + ")";
            }
            Result result = Result.fromNullableMessage(errorMessage);
            if (result == null) {
                Result.$$$reportNull$$$0(4);
            }
            return result;
        }

        @NotNull
        public Severity getSeverity() {
            Severity severity = this.mySeverity;
            if (severity == null) {
                Result.$$$reportNull$$$0(5);
            }
            return severity;
        }

        @NotNull
        public String getMessage() {
            String string = this.myMessage;
            if (string == null) {
                Result.$$$reportNull$$$0(6);
            }
            return string;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Result other = (Result)obj;
            return this.mySeverity == other.mySeverity && this.myMessage.equals(other.myMessage);
        }

        public int hashCode() {
            return this.myMessage.hashCode() * 31 + this.mySeverity.ordinal();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/validation/Validator$Result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "throwable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/validation/Validator$Result";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromNullableMessage";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromThrowable";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeverity";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fromThrowable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Severity {
        OK(null),
        INFO(AllIcons.General.BalloonInformation),
        WARNING(AllIcons.General.BalloonWarning),
        ERROR(AllIcons.General.BalloonError);

        @Nullable
        private final Icon myIcon;

        private Severity(Icon icon) {
            this.myIcon = icon;
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }
    }
}

