/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.webp;

import com.android.tools.adtui.webp.WebpMetadata;
import com.android.tools.adtui.webp.WebpNativeLibHelper;
import com.google.webp.libwebp;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebpImageReaderSpi
extends ImageReaderSpi {
    private static final byte[] RIFF_HEADER = new byte[]{82, 73, 70, 70};
    private static final byte[] WEBP_HEADER = new byte[]{87, 69, 66, 80};
    private static final int MAX_FILE_SIZE = 0x6400000;

    WebpImageReaderSpi() {
        this.vendorName = "Google LLC";
        this.version = WebpNativeLibHelper.getDecoderVersion();
        this.suffixes = WebpMetadata.WEBP_SUFFIXES;
        this.names = WebpMetadata.WEBP_FORMAT_NAMES;
        this.MIMETypes = WebpMetadata.WEBP_MIME_TYPES;
        this.pluginClassName = WebpReader.class.getName();
        this.inputTypes = new Class[]{ImageInputStream.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDecodeInput(@NotNull Object source) throws IOException {
        if (source == null) {
            WebpImageReaderSpi.$$$reportNull$$$0(0);
        }
        assert (source instanceof ImageInputStream);
        ImageInputStream stream = (ImageInputStream)source;
        long length = stream.length();
        if (length > 0x6400000L) {
            return false;
        }
        stream.mark();
        try {
            byte[] header = new byte[12];
            int bytesRead = stream.read(header, 0, 12);
            boolean bl = bytesRead == 12 && WebpImageReaderSpi.arrayEquals(header, 0, RIFF_HEADER.length, RIFF_HEADER) && WebpImageReaderSpi.arrayEquals(header, 8, WEBP_HEADER.length, WEBP_HEADER) && WebpNativeLibHelper.loadNativeLibraryIfNeeded();
            return bl;
        }
        finally {
            try {
                stream.reset();
            }
            catch (IOException e) {
                Logger.getInstance(WebpImageReaderSpi.class).error((Throwable)e);
            }
        }
    }

    private static boolean arrayEquals(@NotNull byte[] a1, int offset, int len, @NotNull byte[] a2) {
        if (a1 == null) {
            WebpImageReaderSpi.$$$reportNull$$$0(1);
        }
        if (a2 == null) {
            WebpImageReaderSpi.$$$reportNull$$$0(2);
        }
        for (int i = 0; i < len; ++i) {
            if (a1[offset + i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public ImageReader createReaderInstance(Object extension) throws IOException {
        WebpNativeLibHelper.requireNativeLibrary();
        WebpReader webpReader = new WebpReader(this);
        if (webpReader == null) {
            WebpImageReaderSpi.$$$reportNull$$$0(3);
        }
        return webpReader;
    }

    @Override
    @NotNull
    public String getDescription(Locale locale) {
        if ("Webp Image Decoder" == null) {
            WebpImageReaderSpi.$$$reportNull$$$0(4);
        }
        return "Webp Image Decoder";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/webp/WebpImageReaderSpi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/webp/WebpImageReaderSpi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createReaderInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canDecodeInput";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "arrayEquals";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WebpReader
    extends ImageReader {
        private static final String UNABLE_TO_READ_WEBP_IMAGE = "Unable to read WebP image";
        @Nullable
        private byte[] myInputBytes;
        private final int[] myWidthOut = new int[1];
        private final int[] myHeightOut = new int[1];
        private int myError;

        WebpReader(ImageReaderSpi originatingProvider) {
            super(originatingProvider);
        }

        @Override
        public void dispose() {
            this.myInputBytes = null;
        }

        @Override
        public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
            super.setInput(input, seekForwardOnly, ignoreMetadata);
            this.myInputBytes = null;
            this.myError = 0;
        }

        @Override
        public int getNumImages(boolean allowSearch) throws IOException {
            return this.myInputBytes == null ? 0 : 1;
        }

        private void loadInfoIfNeeded() throws IOException {
            if (this.input != null && this.myInputBytes == null) {
                this.myInputBytes = WebpReader.readStreamFully((ImageInputStream)this.input);
                this.myError = libwebp.WebPGetInfo((byte[])this.myInputBytes, (long)this.myInputBytes.length, (int[])this.myWidthOut, (int[])this.myHeightOut);
            }
        }

        @NotNull
        private static byte[] readStreamFully(@NotNull ImageInputStream stream) throws IOException {
            int idx;
            if (stream == null) {
                WebpReader.$$$reportNull$$$0(0);
            }
            if (stream.length() != -1L) {
                byte[] bytes = new byte[(int)stream.length()];
                stream.readFully(bytes);
                if (bytes == null) {
                    WebpReader.$$$reportNull$$$0(1);
                }
                return bytes;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(0x100000);
            int bufferSize = 16384;
            byte[] bytes = new byte[16384];
            for (idx = 0; idx < 6400; ++idx) {
                int read = stream.read(bytes, 0, 16384);
                buffer.write(bytes, 0, read);
                if (read != 16384) break;
            }
            if (idx == 6400) {
                throw new IOException("webp image too large");
            }
            byte[] byArray = buffer.toByteArray();
            if (byArray == null) {
                WebpReader.$$$reportNull$$$0(2);
            }
            return byArray;
        }

        @Override
        public int getWidth(int imageIndex) throws IOException {
            this.loadInfoIfNeeded();
            if (this.myError != 0) {
                return this.myWidthOut[0];
            }
            throw new IOException(UNABLE_TO_READ_WEBP_IMAGE);
        }

        @Override
        public int getHeight(int imageIndex) throws IOException {
            this.loadInfoIfNeeded();
            if (this.myError != 0) {
                return this.myHeightOut[0];
            }
            throw new IOException(UNABLE_TO_READ_WEBP_IMAGE);
        }

        @Override
        @Nullable
        public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
            return null;
        }

        @Override
        @Nullable
        public IIOMetadata getStreamMetadata() throws IOException {
            return null;
        }

        @Override
        @Nullable
        public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
            return null;
        }

        @Override
        @NotNull
        public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
            this.loadInfoIfNeeded();
            if (this.myError == 0) {
                throw new IOException(UNABLE_TO_READ_WEBP_IMAGE);
            }
            assert (this.myInputBytes != null);
            byte[] argb = libwebp.WebPDecodeARGB((byte[])this.myInputBytes, (long)this.myInputBytes.length, (int[])this.myWidthOut, (int[])this.myHeightOut);
            BufferedImage bi = new BufferedImage(this.myWidthOut[0], this.myHeightOut[0], 2);
            int[] a = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
            IntBuffer intBuf = ByteBuffer.wrap(argb).asIntBuffer();
            assert (a.length == intBuf.remaining());
            intBuf.get(a);
            BufferedImage bufferedImage = bi;
            if (bufferedImage == null) {
                WebpReader.$$$reportNull$$$0(3);
            }
            return bufferedImage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/webp/WebpImageReaderSpi$WebpReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/webp/WebpImageReaderSpi$WebpReader";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readStreamFully";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "readStreamFully";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

