/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.util.io.TarUtil;
import com.jetbrains.plugins.remotesdk.RemoteUpload;
import com.jetbrains.plugins.remotesdk.RemoteUploadKt;
import com.jetbrains.plugins.remotesdk.transport.SshUtil;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import java.awt.Component;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0+H\u0014J&\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u00101\u001a\u00020\tH\u0002J\u001c\u00102\u001a\b\u0012\u0004\u0012\u000204032\f\u00105\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0014J\b\u00106\u001a\u00020\u000bH\u0014J.\u00107\u001a\u00020\u000b2\u0006\u00108\u001a\u0002092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u00101\u001a\u00020\t2\u0006\u0010;\u001a\u00020\u000bH\u0002J\u0010\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020>H\u0014J\n\u0010?\u001a\u0006\u0012\u0002\b\u00030@J&\u0010A\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u00108\u001a\u0002092\u0006\u0010B\u001a\u00020\tH\u0002J0\u0010C\u001a\u00020-2\u0006\u00108\u001a\u0002092\u0016\u0010D\u001a\u0012\u0012\u0004\u0012\u00020F0Ej\b\u0012\u0004\u0012\u00020F`G2\u0006\u00101\u001a\u00020\tH\u0002J&\u0010H\u001a\u00020-2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u00108\u001a\u0002092\u0006\u0010B\u001a\u00020\tH\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR(\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0016R\u001a\u0010%\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006I"}, d2={"Lcom/jetbrains/plugins/remotesdk/RemoteUpload;", "", "credentials", "Lcom/intellij/remote/RemoteSdkCredentials;", "project", "Lcom/intellij/openapi/project/Project;", "component", "Ljava/awt/Component;", "title", "", "cancellable", "", "isModal", "pathsToUpload", "", "(Lcom/intellij/remote/RemoteSdkCredentials;Lcom/intellij/openapi/project/Project;Ljava/awt/Component;Ljava/lang/String;ZZLjava/util/Collection;)V", "getComponent", "()Ljava/awt/Component;", "getCredentials", "()Lcom/intellij/remote/RemoteSdkCredentials;", "helpersPath", "getHelpersPath", "()Ljava/lang/String;", "process", "Lcom/intellij/openapi/progress/Task;", "progressIndicator", "Lcom/intellij/openapi/progress/StandardProgressIndicator;", "getProject", "()Lcom/intellij/openapi/project/Project;", "relativePathsMap", "", "getRelativePathsMap", "()Ljava/util/Map;", "setRelativePathsMap", "(Ljava/util/Map;)V", "remotePath", "getTitle", "uploadOnSnapshot", "getUploadOnSnapshot", "()Z", "setUploadOnSnapshot", "(Z)V", "createFileFilter", "Lcom/google/common/base/Predicate;", "doUploadFilesToRemote", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "localHelpersRoots", "remoteHelpersRoot", "getExcludedHelpersPaths", "", "Lcom/jetbrains/plugins/webDeployment/config/ExcludedPath;", "helpersPaths", "helpersArchiveCopyEnabled", "helpersUpdateNeeded", "connection", "Lcom/intellij/ssh/channels/SftpChannel;", "helpersRoots", "updateOnSnapshot", "onUploadError", "e", "Lcom/intellij/ssh/SshTransportException;", "upload", "Ljava/util/concurrent/Future;", "uploadCompressedTar", "remoteDirectory", "uploadFiles", "files", "Ljava/util/ArrayList;", "Ljava/io/File;", "Lkotlin/collections/ArrayList;", "uploadPerFile", "intellij.remoteRun"})
public class RemoteUpload {
    private final String remotePath;
    @Nullable
    private Map<String, String> relativePathsMap;
    private boolean uploadOnSnapshot;
    private final Task process;
    private final StandardProgressIndicator progressIndicator;
    @NotNull
    private final RemoteSdkCredentials credentials;
    @Nullable
    private final Project project;
    @Nullable
    private final Component component;
    @NotNull
    private final String title;
    private final Collection<String> pathsToUpload;

    @Nullable
    public final Map<String, String> getRelativePathsMap() {
        return this.relativePathsMap;
    }

    public final void setRelativePathsMap(@Nullable Map<String, String> map) {
        this.relativePathsMap = map;
    }

    public final boolean getUploadOnSnapshot() {
        return this.uploadOnSnapshot;
    }

    public final void setUploadOnSnapshot(boolean bl) {
        this.uploadOnSnapshot = bl;
    }

    @NotNull
    public final String getHelpersPath() {
        String string = this.credentials.getHelpersPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"credentials.helpersPath");
        return string;
    }

    @NotNull
    public final Future<?> upload() {
        if (this.process instanceof Task.Backgroundable) {
            ProgressManager progressManager = ProgressManager.getInstance();
            if (progressManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.progress.impl.ProgressManagerImpl");
            }
            Future future = ((ProgressManagerImpl)progressManager).runProcessWithProgressAsynchronously((Task.Backgroundable)this.process, (ProgressIndicator)this.progressIndicator, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)future, (String)"(ProgressManager.getInst\u2026 progressIndicator, null)");
            return future;
        }
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(new Runnable(this){
            final /* synthetic */ RemoteUpload this$0;

            public final void run() {
                RemoteUpload.access$getProcess$p(this.this$0).run((ProgressIndicator)new EmptyProgressIndicator());
            }
            {
                this.this$0 = remoteUpload;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.runAsy\u2026gressIndicator())\n      }");
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean helpersUpdateNeeded(SftpChannel connection, Collection<String> helpersRoots, String remoteHelpersRoot, boolean updateOnSnapshot) {
        boolean bl;
        PerformanceWatcher.Snapshot snapshot;
        block18: {
            snapshot = PerformanceWatcher.takeSnapshot();
            Iterable $receiver$iv = helpersRoots;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    String path = (String)element$iv;
                    try {
                        RemoteFileObject versionFile;
                        String relativePath;
                        RemoteFileObject helpersDir = connection.file(remoteHelpersRoot);
                        if (!helpersDir.exists()) {
                            return true;
                        }
                        Map<String, String> map = this.relativePathsMap;
                        String string = relativePath = map != null ? map.get(path) : null;
                        if (relativePath != null) {
                            RemoteFileObject singleFile = helpersDir.child(relativePath);
                            if (!singleFile.exists()) {
                                return true;
                            }
                            if (!singleFile.isDir()) {
                                return false;
                            }
                        }
                        if ((versionFile = helpersDir.child(RemoteUploadKt.access$getVERSION_FILE$p())).exists()) {
                            Closeable closeable = versionFile.inputStream();
                            Throwable throwable = null;
                            try {
                                InputStream it = (InputStream)closeable;
                                char[] cArray = FileUtil.loadText((Reader)new InputStreamReader(it), (int)((int)versionFile.size()));
                                Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"FileUtil.loadText(InputS\u2026rsionFile.size().toInt())");
                                char[] cArray2 = cArray;
                                String content = new String(cArray2);
                                String localContent = RemoteUploadKt.access$getLocalVersion();
                                RemoteUploadKt.access$getLOG$p().info("Remote helpers version is " + content + ", local helpers version is " + localContent);
                                CharSequence charSequence = content;
                                if (charSequence.length() > 0) {
                                    boolean bl2 = Intrinsics.areEqual((Object)localContent, (Object)content) ^ true || StringsKt.endsWith$default((String)localContent, (String)".SNAPSHOT", (boolean)false, (int)2, null) && updateOnSnapshot;
                                    return bl2;
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                        return true;
                    }
                    catch (Exception e) {
                        RemoteUploadKt.access$getLOG$p().info("Failed to retrieve helpers version file", (Throwable)e);
                        if (!true) continue;
                        bl = true;
                        break block18;
                    }
                }
                bl = false;
            }
        }
        boolean result = bl;
        snapshot.logResponsivenessSinceCreation("Helpers version check");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doUploadFilesToRemote(ProgressIndicator indicator, Collection<String> localHelpersRoots, String remoteHelpersRoot) {
        block6: {
            RemoteUploadKt.access$getLOG$p().info("Uploading helpers to " + this.remotePath);
            try {
                indicator.setFraction(0.0);
                SftpChannel connection = ConnectionBuilder.openSftpChannel$default((ConnectionBuilder)RemoteCredentialsUtil.connectionBuilder$default((RemoteCredentials)((RemoteCredentials)this.credentials), null, null, (int)3, null), (int)0, (int)1, null);
                if (!this.helpersUpdateNeeded(connection, localHelpersRoots, remoteHelpersRoot, this.uploadOnSnapshot)) break block6;
                PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
                try {
                    if (!this.helpersArchiveCopyEnabled() || !this.uploadCompressedTar(localHelpersRoots, connection, remoteHelpersRoot)) {
                        this.uploadPerFile(localHelpersRoots, connection, remoteHelpersRoot);
                    }
                    RemoteUploadKt.access$getLOG$p().info("Helpers upload successfully completed");
                }
                finally {
                    snapshot.logResponsivenessSinceCreation("Helpers uploaded");
                }
            }
            catch (SshTransportException e) {
                this.onUploadError(e);
            }
        }
    }

    private final void uploadPerFile(Collection<String> pathsToUpload, SftpChannel connection, String remoteDirectory) {
        for (String root : pathsToUpload) {
            File file = new File(root);
            Map<String, String> map = this.relativePathsMap;
            if (map == null || (map = map.get(root)) == null) {
                map = "";
            }
            connection.uploadFileOrDir(file, remoteDirectory, (String)((Object)map));
        }
    }

    @NotNull
    protected Predicate<String> createFileFilter() {
        return createFileFilter.1.INSTANCE;
    }

    protected void onUploadError(@NotNull SshTransportException e) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)e), (String)"e");
        RemoteUploadKt.access$getLOG$p().warn((Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean uploadCompressedTar(Collection<String> pathsToUpload, SftpChannel connection, String remoteDirectory) {
        try {
            File tempDirectory = FileUtil.createTempDirectory((String)"upload-helpers", (String)"");
            File tarFile = new File(tempDirectory, "helpers.tar.gz");
            try (TarArchiveOutputStream tos = TarUtil.getTarGzOutputStream((File)tarFile);){
                for (String root : pathsToUpload) {
                    Predicate<String> f = this.createFileFilter();
                    TarUtil.addFileOrDirRecursively((TarArchiveOutputStream)tos, null, (File)new File(root), (String)"", (FileFilter)new FileFilter(f, root){
                        final /* synthetic */ Predicate $f;
                        final /* synthetic */ String $root;

                        public final boolean accept(File path) {
                            return this.$f.apply((Object)FileUtil.getRelativePath((File)new File(this.$root), (File)path));
                        }
                        {
                            this.$f = predicate;
                            this.$root = string;
                        }
                    }, null);
                }
                File versionFile = new File(tempDirectory, RemoteUploadKt.access$getVERSION_FILE$p());
                RemoteUploadKt.access$writeHelpersVersionContent(new FileOutputStream(versionFile));
                TarUtil.addFileToTar((TarArchiveOutputStream)tos, (File)versionFile, (String)versionFile.getName(), null, null);
            }
            this.uploadFiles(connection, CollectionsKt.arrayListOf((Object[])new File[]{tarFile}), remoteDirectory);
            try {
                SshUtil.untar(this.credentials, new RemoteFile(remoteDirectory, tarFile.getName()).getPath(), remoteDirectory);
            }
            catch (RemoteSdkException e) {
                RemoteUploadKt.access$getLOG$p().error("Can't extract helpers archive", (Throwable)e);
                boolean bl = false;
                tarFile.delete();
                return bl;
            }
            finally {
                tarFile.delete();
            }
            return true;
        }
        catch (IOException e) {
            RemoteUploadKt.access$getLOG$p().error("Couldn't create helpers zip file", (Throwable)e);
            return false;
        }
    }

    private final void uploadFiles(SftpChannel connection, ArrayList<File> files, String remoteHelpersRoot) {
        Iterator<File> iterator = files.iterator();
        while (iterator.hasNext()) {
            File file;
            File file2 = file = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            String string = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
            connection.uploadFileOrDir(file2, remoteHelpersRoot, string);
        }
    }

    protected boolean helpersArchiveCopyEnabled() {
        return false;
    }

    @NotNull
    protected List<ExcludedPath> getExcludedHelpersPaths(@NotNull Collection<String> helpersPaths) {
        Intrinsics.checkParameterIsNotNull(helpersPaths, (String)"helpersPaths");
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"Lists.newArrayList()");
        return arrayList;
    }

    @NotNull
    public final RemoteSdkCredentials getCredentials() {
        return this.credentials;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Component getComponent() {
        return this.component;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public RemoteUpload(@NotNull RemoteSdkCredentials credentials, @Nullable Project project, @Nullable Component component, @NotNull String title, boolean cancellable, boolean isModal, @NotNull Collection<String> pathsToUpload) {
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull(pathsToUpload, (String)"pathsToUpload");
        this.credentials = credentials;
        this.project = project;
        this.component = component;
        this.title = title;
        this.pathsToUpload = pathsToUpload;
        String string = this.credentials.getHelpersPath();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.remotePath = string;
        this.process = RemoteUploadKt.createTask(this.project, this.title, cancellable, isModal, new Progressive(this){
            final /* synthetic */ RemoteUpload this$0;

            public final void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                RemoteUpload.access$doUploadFilesToRemote(this.this$0, indicator, RemoteUpload.access$getPathsToUpload$p(this.this$0), RemoteUpload.access$getRemotePath$p(this.this$0));
            }
            {
                this.this$0 = remoteUpload;
            }
        });
        this.progressIndicator = this.process instanceof Task.Backgroundable ? (StandardProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)this.process) : (StandardProgressIndicator)new EmptyProgressIndicator();
    }

    @NotNull
    public static final /* synthetic */ Task access$getProcess$p(RemoteUpload $this) {
        return $this.process;
    }

    public static final /* synthetic */ void access$doUploadFilesToRemote(RemoteUpload $this, @NotNull ProgressIndicator indicator, @NotNull Collection localHelpersRoots, @NotNull String remoteHelpersRoot) {
        $this.doUploadFilesToRemote(indicator, localHelpersRoots, remoteHelpersRoot);
    }

    @NotNull
    public static final /* synthetic */ Collection access$getPathsToUpload$p(RemoteUpload $this) {
        return $this.pathsToUpload;
    }

    @NotNull
    public static final /* synthetic */ String access$getRemotePath$p(RemoteUpload $this) {
        return $this.remotePath;
    }
}

