/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.ui.ClickListener;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkUIUtil;
import com.jetbrains.plugins.remotesdk.ui.StatusPanel;
import com.jetbrains.plugins.webDeployment.WDBundle;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.concurrent.TimeUnit;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001aF\u0010\b\u001a\u00020\t2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "doTestConnection", "", "project", "Lcom/intellij/openapi/project/Project;", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "useReferencedCredentials", "", "statusPanel", "Lcom/jetbrains/plugins/remotesdk/ui/StatusPanel;", "validator", "Ljava/lang/Runnable;", "hostLabel", "Ljavax/swing/JLabel;", "hostUrl", "testConnectionCallBack", "intellij.remoteRun"})
@JvmName(name="CreateRemoteSdkUIUtil")
public final class CreateRemoteSdkUIUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkUIUtil");

    public static final void useReferencedCredentials(@Nullable Project project, @NotNull StatusPanel statusPanel, @Nullable Runnable validator, @Nullable RemoteCredentials credentials, @NotNull JLabel hostLabel, @NotNull JLabel hostUrl, @Nullable Runnable testConnectionCallBack) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)statusPanel), (String)"statusPanel");
        Intrinsics.checkParameterIsNotNull((Object)hostLabel, (String)"hostLabel");
        Intrinsics.checkParameterIsNotNull((Object)hostUrl, (String)"hostUrl");
        if (credentials != null) {
            hostUrl.setVisible(true);
            hostLabel.setVisible(true);
            String credentialsString = StringUtil.isNotEmpty((String)credentials.getUserName()) && StringUtil.isNotEmpty((String)credentials.getHost()) ? RemoteCredentialsHolder.getCredentialsString((RemoteCredentials)credentials) : "";
            hostUrl.setText("<html><a href=\"#\">" + credentialsString);
            hostUrl.setCursor(Cursor.getPredefinedCursor(12));
            for (MouseListener ml : hostUrl.getMouseListeners()) {
                hostUrl.removeMouseListener(ml);
            }
            new ClickListener(statusPanel, testConnectionCallBack, project, credentials, validator, hostLabel){
                final /* synthetic */ StatusPanel $statusPanel;
                final /* synthetic */ Runnable $testConnectionCallBack;
                final /* synthetic */ Project $project;
                final /* synthetic */ RemoteCredentials $credentials;
                final /* synthetic */ Runnable $validator;
                final /* synthetic */ JLabel $hostLabel;

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    if (clickCount == 1) {
                        StatusPanel.Action testConnectionAction = this.$statusPanel.progress("Testing connection...");
                        Runnable runnable = this.$testConnectionCallBack;
                        if (runnable != null) {
                            runnable.run();
                        }
                        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, testConnectionAction){
                            final /* synthetic */ useReferencedCredentials.1 this$0;
                            final /* synthetic */ StatusPanel.Action $testConnectionAction;

                            public final void run() {
                                if (CreateRemoteSdkUIUtil.access$doTestConnection(this.this$0.$project, this.this$0.$credentials)) {
                                    this.$testConnectionAction.doneWithResult(WDBundle.message((String)"connection.to.successful", (Object[])new Object[]{this.this$0.$credentials.getHost()}));
                                } else {
                                    this.$testConnectionAction.failed(WDBundle.message((String)"connection.to.failed", (Object[])new Object[]{this.this$0.$credentials.getHost(), ""}));
                                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                                        final /* synthetic */ useReferencedCredentials.onClick.1 this$0;

                                        public final void run() {
                                            block0: {
                                                Runnable runnable = this.this$0.this$0.$validator;
                                                if (runnable == null) break block0;
                                                runnable.run();
                                            }
                                        }
                                        {
                                            this.this$0 = var1_1;
                                        }
                                    }, ModalityState.stateForComponent((Component)this.this$0.$hostLabel));
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                this.$testConnectionAction = action;
                            }
                        });
                        return true;
                    }
                    return false;
                }
                {
                    this.$statusPanel = $captured_local_variable$0;
                    this.$testConnectionCallBack = $captured_local_variable$1;
                    this.$project = $captured_local_variable$2;
                    this.$credentials = $captured_local_variable$3;
                    this.$validator = $captured_local_variable$4;
                    this.$hostLabel = $captured_local_variable$5;
                }
            }.installOn((Component)hostUrl);
        } else {
            hostUrl.setVisible(false);
            hostLabel.setVisible(false);
        }
    }

    private static final boolean doTestConnection(Project project, RemoteCredentials credentials) {
        try {
            return RemoteSdkUtil.doTestConnection(project, credentials, 10L, TimeUnit.SECONDS);
        }
        catch (RuntimeException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    public static final /* synthetic */ boolean access$doTestConnection(@Nullable Project project, @NotNull RemoteCredentials credentials) {
        return CreateRemoteSdkUIUtil.doTestConnection(project, credentials);
    }
}

