/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.datastore.DataStoreDatabase;
import com.android.tools.datastore.DeviceId;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.datastore.service.CpuService;
import com.android.tools.datastore.service.EnergyService;
import com.android.tools.datastore.service.EventService;
import com.android.tools.datastore.service.MemoryService;
import com.android.tools.datastore.service.NetworkService;
import com.android.tools.datastore.service.ProfilerService;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.EventServiceGrpc;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import com.android.tools.profiler.proto.ProfilerServiceGrpc;
import com.google.wireless.android.sdk.stats.AndroidProfilerDbStats;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.diagnostic.Logger;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class DataStoreService
implements DataStoreTable.DataStoreTableErrorCallback {
    private static final long REPORT_INITIAL_DELAY = TimeUnit.MINUTES.toMillis(15L);
    private static final long REPORT_PERIOD = TimeUnit.HOURS.toMillis(1L);
    private final String myDatastoreDirectory;
    private final Map<BackingNamespace, DataStoreDatabase> myDatabases;
    private final ServerBuilder myServerBuilder;
    private final Server myServer;
    private final List<ServicePassThrough> myServices;
    private final Consumer<Runnable> myFetchExecutor;
    @NotNull
    private Consumer<Throwable> myNoPiiExceptionHanlder;
    private ProfilerService myProfilerService;
    private final ServerInterceptor myInterceptor;
    private final Map<DeviceId, DataStoreClient> myConnectedClients;
    private final Timer myReportTimer;

    private static final Logger getLogger() {
        return Logger.getInstance((String)DataStoreService.class.getCanonicalName());
    }

    public DataStoreService(@NotNull String serviceName, @NotNull String datastoreDirectory, @NotNull Consumer<Runnable> fetchExecutor) {
        if (serviceName == null) {
            DataStoreService.$$$reportNull$$$0(0);
        }
        if (datastoreDirectory == null) {
            DataStoreService.$$$reportNull$$$0(1);
        }
        if (fetchExecutor == null) {
            DataStoreService.$$$reportNull$$$0(2);
        }
        this(serviceName, datastoreDirectory, fetchExecutor, null);
    }

    public DataStoreService(@NotNull String serviceName, @NotNull String datastoreDirectory, @NotNull Consumer<Runnable> fetchExecutor, ServerInterceptor interceptor) {
        if (serviceName == null) {
            DataStoreService.$$$reportNull$$$0(3);
        }
        if (datastoreDirectory == null) {
            DataStoreService.$$$reportNull$$$0(4);
        }
        if (fetchExecutor == null) {
            DataStoreService.$$$reportNull$$$0(5);
        }
        this.myDatabases = new HashMap<BackingNamespace, DataStoreDatabase>();
        this.myServices = new ArrayList<ServicePassThrough>();
        this.myConnectedClients = new HashMap<DeviceId, DataStoreClient>();
        this.myFetchExecutor = fetchExecutor;
        this.myInterceptor = interceptor;
        this.myDatastoreDirectory = datastoreDirectory;
        this.myServerBuilder = InProcessServerBuilder.forName((String)serviceName).directExecutor();
        this.myNoPiiExceptionHanlder = t -> DataStoreService.getLogger().error(t);
        this.createPollers();
        this.myServer = this.myServerBuilder.build();
        try {
            this.myServer.start();
        }
        catch (IOException ex) {
            DataStoreService.getLogger().error(ex.getMessage());
        }
        this.myReportTimer = new Timer("DataStoreReportTimer");
        this.myReportTimer.schedule((TimerTask)new ReportTimerTask(), REPORT_INITIAL_DELAY, REPORT_PERIOD);
        DataStoreTable.addDataStoreErrorCallback(this);
    }

    public void setNoPiiExceptionHanlder(@NotNull Consumer<Throwable> noPiiExceptionHanlder) {
        if (noPiiExceptionHanlder == null) {
            DataStoreService.$$$reportNull$$$0(6);
        }
        this.myNoPiiExceptionHanlder = noPiiExceptionHanlder;
    }

    public void createPollers() {
        this.myProfilerService = new ProfilerService(this, this.myFetchExecutor);
        this.registerService(this.myProfilerService);
        this.registerService(new EventService(this, this.myFetchExecutor));
        this.registerService(new CpuService(this, this.myFetchExecutor));
        this.registerService(new MemoryService(this, this.myFetchExecutor));
        this.registerService(new NetworkService(this, this.myFetchExecutor));
        this.registerService(new EnergyService(this, this.myFetchExecutor));
    }

    @NotNull
    DataStoreDatabase createDatabase(@NotNull String dbPath, @NotNull DataStoreDatabase.Characteristic characteristic, Consumer<Throwable> noPiiExceptionHandler) {
        if (dbPath == null) {
            DataStoreService.$$$reportNull$$$0(7);
        }
        if (characteristic == null) {
            DataStoreService.$$$reportNull$$$0(8);
        }
        DataStoreDatabase dataStoreDatabase = new DataStoreDatabase(dbPath, characteristic, noPiiExceptionHandler);
        if (dataStoreDatabase == null) {
            DataStoreService.$$$reportNull$$$0(9);
        }
        return dataStoreDatabase;
    }

    void registerService(@NotNull ServicePassThrough service) {
        if (service == null) {
            DataStoreService.$$$reportNull$$$0(10);
        }
        this.myServices.add(service);
        List<BackingNamespace> namespaces = service.getBackingNamespaces();
        namespaces.forEach(namespace -> {
            if (service == null) {
                DataStoreService.$$$reportNull$$$0(20);
            }
            assert (!namespace.myNamespace.isEmpty());
            DataStoreDatabase db = this.myDatabases.computeIfAbsent((BackingNamespace)namespace, backingNamespace -> this.createDatabase(this.myDatastoreDirectory + backingNamespace.myNamespace, backingNamespace.myCharacteristic, this.myNoPiiExceptionHanlder));
            service.setBackingStore((BackingNamespace)namespace, db.getConnection());
        });
        if (this.myInterceptor != null) {
            this.myServerBuilder.addService(ServerInterceptors.intercept((ServerServiceDefinition)service.bindService(), (ServerInterceptor[])new ServerInterceptor[]{this.myInterceptor}));
        } else {
            this.myServerBuilder.addService(service.bindService());
        }
    }

    public void connect(@NotNull ManagedChannel channel) {
        if (channel == null) {
            DataStoreService.$$$reportNull$$$0(11);
        }
        this.myProfilerService.startMonitoring((Channel)channel);
    }

    public void disconnect(@NotNull DeviceId deviceId) {
        if (deviceId == null) {
            DataStoreService.$$$reportNull$$$0(12);
        }
        if (this.myConnectedClients.containsKey(deviceId)) {
            DataStoreClient client = this.myConnectedClients.remove(deviceId);
            client.shutdownNow();
            this.myProfilerService.stopMonitoring(client.getChannel());
        }
    }

    public void shutdown() {
        this.myReportTimer.cancel();
        this.myServer.shutdownNow();
        for (DataStoreClient client : this.myConnectedClients.values()) {
            client.shutdownNow();
        }
        this.myConnectedClients.clear();
        this.myDatabases.forEach((name, db) -> db.disconnect());
        DataStoreTable.removeDataStoreErrorCallback(this);
    }

    List<ServicePassThrough> getRegisteredServices() {
        return this.myServices;
    }

    public void setConnectedClients(@NotNull DeviceId deviceId, @NotNull Channel channel) {
        if (deviceId == null) {
            DataStoreService.$$$reportNull$$$0(13);
        }
        if (channel == null) {
            DataStoreService.$$$reportNull$$$0(14);
        }
        if (!this.myConnectedClients.containsKey(deviceId)) {
            this.myConnectedClients.put(deviceId, new DataStoreClient(channel));
        }
    }

    public CpuServiceGrpc.CpuServiceBlockingStub getCpuClient(@NotNull DeviceId deviceId) {
        if (deviceId == null) {
            DataStoreService.$$$reportNull$$$0(15);
        }
        return this.myConnectedClients.containsKey(deviceId) ? this.myConnectedClients.get(deviceId).getCpuClient() : null;
    }

    public EventServiceGrpc.EventServiceBlockingStub getEventClient(@NotNull DeviceId deviceId) {
        if (deviceId == null) {
            DataStoreService.$$$reportNull$$$0(16);
        }
        return this.myConnectedClients.containsKey(deviceId) ? this.myConnectedClients.get(deviceId).getEventClient() : null;
    }

    public NetworkServiceGrpc.NetworkServiceBlockingStub getNetworkClient(@NotNull DeviceId deviceId) {
        if (deviceId == null) {
            DataStoreService.$$$reportNull$$$0(17);
        }
        return this.myConnectedClients.containsKey(deviceId) ? this.myConnectedClients.get(deviceId).getNetworkClient() : null;
    }

    public MemoryServiceGrpc.MemoryServiceBlockingStub getMemoryClient(@NotNull DeviceId deviceId) {
        if (deviceId == null) {
            DataStoreService.$$$reportNull$$$0(18);
        }
        return this.myConnectedClients.containsKey(deviceId) ? this.myConnectedClients.get(deviceId).getMemoryClient() : null;
    }

    public ProfilerServiceGrpc.ProfilerServiceBlockingStub getProfilerClient(@NotNull DeviceId deviceId) {
        if (deviceId == null) {
            DataStoreService.$$$reportNull$$$0(19);
        }
        return this.myConnectedClients.containsKey(deviceId) ? this.myConnectedClients.get(deviceId).getProfilerClient() : null;
    }

    @Override
    public void onDataStoreError(Throwable t) {
        this.myNoPiiExceptionHanlder.accept(t);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "datastoreDirectory";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fetchExecutor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noPiiExceptionHanlder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "characteristic";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/DataStoreService";
                break;
            }
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/DataStoreService";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDatabase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setNoPiiExceptionHanlder";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDatabase";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerService";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "disconnect";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setConnectedClients";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCpuClient";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getEventClient";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNetworkClient";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getMemoryClient";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getProfilerClient";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerService$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class ReportTimerTask
    extends TimerTask {
        private final long myStartTime = System.nanoTime();

        private ReportTimerTask() {
        }

        @Override
        public void run() {
            AndroidProfilerDbStats.Builder dbStats = AndroidProfilerDbStats.newBuilder();
            dbStats.setAgeSec((int)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.myStartTime));
            this.collectReport(dbStats);
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ANDROID_PROFILER_DB_STATS).setAndroidProfilerDbStats(dbStats);
            UsageTracker.getInstance().log(event);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void collectReport(AndroidProfilerDbStats.Builder dbStats) {
            try {
                File dbFile = new File(DataStoreService.this.myDatastoreDirectory, BackingNamespace.DEFAULT_SHARED_NAMESPACE.myNamespace);
                dbStats.setTotalDiskMb((int)(dbFile.length() / 1024L / 1024L));
                Iterator iterator = DataStoreService.this.myDatabases.values().iterator();
                block37: while (iterator.hasNext()) {
                    DataStoreDatabase db = (DataStoreDatabase)iterator.next();
                    Statement tableStatement = db.getConnection().createStatement();
                    Throwable throwable = null;
                    try {
                        ResultSet tableResults = tableStatement.executeQuery("SELECT name FROM sqlite_master WHERE type='table'");
                        Throwable throwable2 = null;
                        try {
                            while (true) {
                                Statement sizeStatement;
                                block46: {
                                    if (!tableResults.next()) continue block37;
                                    String tableName = tableResults.getString(1);
                                    sizeStatement = db.getConnection().createStatement();
                                    Throwable throwable3 = null;
                                    try {
                                        try (ResultSet sizeResult = sizeStatement.executeQuery(String.format("SELECT COUNT(*) FROM %s", tableName));){
                                            int tableSize = sizeResult.getInt(1);
                                            dbStats.addTablesBuilder().setName(tableName).setNumRecords(tableSize).build();
                                        }
                                        if (sizeStatement == null) continue;
                                        if (throwable3 == null) break block46;
                                    }
                                    catch (Throwable throwable4) {
                                        try {
                                            throwable3 = throwable4;
                                            throw throwable4;
                                        }
                                        catch (Throwable throwable5) {
                                            if (sizeStatement == null) throw throwable5;
                                            if (throwable3 != null) {
                                                try {
                                                    sizeStatement.close();
                                                    throw throwable5;
                                                }
                                                catch (Throwable throwable6) {
                                                    throwable3.addSuppressed(throwable6);
                                                    throw throwable5;
                                                }
                                            }
                                            sizeStatement.close();
                                            throw throwable5;
                                        }
                                    }
                                    try {
                                        sizeStatement.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable3.addSuppressed(throwable7);
                                    }
                                    continue;
                                }
                                sizeStatement.close();
                            }
                        }
                        catch (Throwable throwable8) {
                            throwable2 = throwable8;
                            throw throwable8;
                        }
                        finally {
                            if (tableResults == null) continue;
                            if (throwable2 != null) {
                                try {
                                    tableResults.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable2.addSuppressed(throwable9);
                                }
                                continue;
                            }
                            tableResults.close();
                        }
                    }
                    catch (Throwable throwable10) {
                        throwable = throwable10;
                        throw throwable10;
                    }
                    finally {
                        if (tableStatement == null) continue;
                        if (throwable != null) {
                            try {
                                tableStatement.close();
                            }
                            catch (Throwable throwable11) {
                                throwable.addSuppressed(throwable11);
                            }
                            continue;
                        }
                        tableStatement.close();
                    }
                }
                return;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static class DataStoreClient {
        @NotNull
        private final Channel myChannel;
        @NotNull
        private final ProfilerServiceGrpc.ProfilerServiceBlockingStub myProfilerClient;
        @NotNull
        private final MemoryServiceGrpc.MemoryServiceBlockingStub myMemoryClient;
        @NotNull
        private final CpuServiceGrpc.CpuServiceBlockingStub myCpuClient;
        @NotNull
        private final NetworkServiceGrpc.NetworkServiceBlockingStub myNetworkClient;
        @NotNull
        private final EventServiceGrpc.EventServiceBlockingStub myEventClient;

        DataStoreClient(@NotNull Channel channel) {
            if (channel == null) {
                DataStoreClient.$$$reportNull$$$0(0);
            }
            this.myChannel = channel;
            this.myProfilerClient = ProfilerServiceGrpc.newBlockingStub((Channel)channel);
            this.myMemoryClient = MemoryServiceGrpc.newBlockingStub((Channel)channel);
            this.myCpuClient = CpuServiceGrpc.newBlockingStub((Channel)channel);
            this.myNetworkClient = NetworkServiceGrpc.newBlockingStub((Channel)channel);
            this.myEventClient = EventServiceGrpc.newBlockingStub((Channel)channel);
        }

        @NotNull
        public Channel getChannel() {
            Channel channel = this.myChannel;
            if (channel == null) {
                DataStoreClient.$$$reportNull$$$0(1);
            }
            return channel;
        }

        @NotNull
        public ProfilerServiceGrpc.ProfilerServiceBlockingStub getProfilerClient() {
            ProfilerServiceGrpc.ProfilerServiceBlockingStub profilerServiceBlockingStub = this.myProfilerClient;
            if (profilerServiceBlockingStub == null) {
                DataStoreClient.$$$reportNull$$$0(2);
            }
            return profilerServiceBlockingStub;
        }

        @NotNull
        public MemoryServiceGrpc.MemoryServiceBlockingStub getMemoryClient() {
            MemoryServiceGrpc.MemoryServiceBlockingStub memoryServiceBlockingStub = this.myMemoryClient;
            if (memoryServiceBlockingStub == null) {
                DataStoreClient.$$$reportNull$$$0(3);
            }
            return memoryServiceBlockingStub;
        }

        @NotNull
        public CpuServiceGrpc.CpuServiceBlockingStub getCpuClient() {
            CpuServiceGrpc.CpuServiceBlockingStub cpuServiceBlockingStub = this.myCpuClient;
            if (cpuServiceBlockingStub == null) {
                DataStoreClient.$$$reportNull$$$0(4);
            }
            return cpuServiceBlockingStub;
        }

        @NotNull
        public NetworkServiceGrpc.NetworkServiceBlockingStub getNetworkClient() {
            NetworkServiceGrpc.NetworkServiceBlockingStub networkServiceBlockingStub = this.myNetworkClient;
            if (networkServiceBlockingStub == null) {
                DataStoreClient.$$$reportNull$$$0(5);
            }
            return networkServiceBlockingStub;
        }

        @NotNull
        public EventServiceGrpc.EventServiceBlockingStub getEventClient() {
            EventServiceGrpc.EventServiceBlockingStub eventServiceBlockingStub = this.myEventClient;
            if (eventServiceBlockingStub == null) {
                DataStoreClient.$$$reportNull$$$0(6);
            }
            return eventServiceBlockingStub;
        }

        public void shutdownNow() {
            if (this.myChannel instanceof ManagedChannel) {
                ((ManagedChannel)this.myChannel).shutdownNow();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "channel";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/datastore/DataStoreService$DataStoreClient";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/datastore/DataStoreService$DataStoreClient";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChannel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProfilerClient";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemoryClient";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCpuClient";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNetworkClient";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEventClient";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BackingNamespace {
        public static final BackingNamespace DEFAULT_SHARED_NAMESPACE = new BackingNamespace("default.sql", DataStoreDatabase.Characteristic.DURABLE);
        @NotNull
        public final String myNamespace;
        @NotNull
        public final DataStoreDatabase.Characteristic myCharacteristic;

        public BackingNamespace(@NotNull String namespace, @NotNull DataStoreDatabase.Characteristic characteristic) {
            if (namespace == null) {
                BackingNamespace.$$$reportNull$$$0(0);
            }
            if (characteristic == null) {
                BackingNamespace.$$$reportNull$$$0(1);
            }
            this.myNamespace = namespace;
            this.myCharacteristic = characteristic;
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.myNamespace, this.myCharacteristic});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BackingNamespace)) {
                return false;
            }
            BackingNamespace other = (BackingNamespace)obj;
            return this.myNamespace.equals(other.myNamespace) && this.myCharacteristic == other.myCharacteristic;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "namespace";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "characteristic";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/datastore/DataStoreService$BackingNamespace";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

