/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class ProfilerTimeline
extends AspectModel<Aspect>
implements Updatable {
    @VisibleForTesting
    public static final long DEFAULT_VIEW_LENGTH_US = TimeUnit.SECONDS.toMicros(30L);
    @NotNull
    private final Range myDataRangeUs = new Range(0.0, 0.0);
    @NotNull
    private final Range myViewRangeUs = new Range(0.0, 0.0);
    @NotNull
    private final Range mySelectionRangeUs = new Range();
    @NotNull
    private final Range myTooltipRangeUs = new Range();
    private boolean myStreaming;
    private float myStreamingFactor;
    private double myZoomLeft;
    private boolean myCanStream = true;
    private long myDataStartTimeNs;
    private long myDataLengthNs;
    private boolean myIsPaused = false;
    private long myPausedTime;

    public void setStreaming(boolean isStreaming) {
        if (!this.myCanStream && isStreaming) {
            isStreaming = false;
        }
        if (this.myStreaming == isStreaming) {
            return;
        }
        assert (this.myCanStream || !isStreaming);
        this.myStreaming = isStreaming;
        this.update(0L);
        this.changed(Aspect.STREAMING);
    }

    public boolean isStreaming() {
        return this.myStreaming && !this.myIsPaused;
    }

    public void setCanStream(boolean canStream) {
        this.myCanStream = canStream;
        if (!this.myCanStream && this.myStreaming) {
            this.setStreaming(false);
        }
    }

    public boolean canStream() {
        return this.myCanStream && !this.myIsPaused;
    }

    public void toggleStreaming() {
        this.myZoomLeft = 0.0;
        this.setStreaming(!this.isStreaming());
    }

    public boolean isPaused() {
        return this.myIsPaused;
    }

    public void setIsPaused(boolean paused) {
        this.myIsPaused = paused;
        if (this.myIsPaused) {
            this.myPausedTime = this.myDataLengthNs;
        }
    }

    @NotNull
    public Range getDataRange() {
        Range range = this.myDataRangeUs;
        if (range == null) {
            ProfilerTimeline.$$$reportNull$$$0(0);
        }
        return range;
    }

    @NotNull
    public Range getViewRange() {
        Range range = this.myViewRangeUs;
        if (range == null) {
            ProfilerTimeline.$$$reportNull$$$0(1);
        }
        return range;
    }

    public Range getSelectionRange() {
        return this.mySelectionRangeUs;
    }

    public Range getTooltipRange() {
        return this.myTooltipRangeUs;
    }

    public void update(long elapsedNs) {
        this.myDataLengthNs += elapsedNs;
        long maxTimelineTimeNs = this.myDataLengthNs;
        if (this.myIsPaused) {
            maxTimelineTimeNs = this.myPausedTime;
        }
        long deviceNowNs = this.myDataStartTimeNs + maxTimelineTimeNs;
        long deviceNowUs = TimeUnit.NANOSECONDS.toMicros(deviceNowNs);
        this.myDataRangeUs.setMax((double)deviceNowUs);
        double viewUs = this.myViewRangeUs.getLength();
        if (this.myStreaming) {
            this.myStreamingFactor = Updater.lerp((float)this.myStreamingFactor, (float)1.0f, (float)0.95f, (long)elapsedNs, (float)Float.MIN_VALUE);
            double min = Updater.lerp((double)this.myViewRangeUs.getMin(), (double)((double)deviceNowUs - viewUs), (float)this.myStreamingFactor);
            double max = Updater.lerp((double)this.myViewRangeUs.getMax(), (double)deviceNowUs, (float)this.myStreamingFactor);
            this.myViewRangeUs.set(min, max);
        } else {
            this.myStreamingFactor = 0.0f;
        }
        double left = Updater.lerp((double)this.myZoomLeft, (double)0.0, (float)0.95f, (long)elapsedNs, (double)(this.myViewRangeUs.getLength() * (double)1.0E-4f));
        this.zoom(this.myZoomLeft - left, this.myStreaming ? 1.0 : 0.5);
        this.myZoomLeft = left;
    }

    public void zoom(double deltaUs, double percent) {
        boolean isDataRangeCoverViewRange;
        if (deltaUs == 0.0) {
            return;
        }
        if (deltaUs < 0.0 && percent < 1.0) {
            this.setStreaming(false);
        }
        double minUs = this.myViewRangeUs.getMin() - deltaUs * percent;
        double maxUs = this.myViewRangeUs.getMax() + deltaUs * (1.0 - percent);
        boolean bl = isDataRangeCoverViewRange = this.myDataRangeUs.getMin() <= this.myViewRangeUs.getMin();
        if (isDataRangeCoverViewRange && minUs < this.myDataRangeUs.getMin()) {
            maxUs += this.myDataRangeUs.getMin() - minUs;
            minUs = this.myDataRangeUs.getMin();
        }
        if (maxUs > this.myDataRangeUs.getMax()) {
            minUs -= maxUs - this.myDataRangeUs.getMax();
            maxUs = this.myDataRangeUs.getMax();
        }
        if (isDataRangeCoverViewRange) {
            minUs = Math.max(minUs, this.myDataRangeUs.getMin());
        }
        this.myViewRangeUs.set(minUs, maxUs);
    }

    public void zoomOut() {
        this.myZoomLeft += this.myViewRangeUs.getLength() * (double)0.1f;
    }

    public void zoomIn() {
        this.myZoomLeft -= this.myViewRangeUs.getLength() * (double)0.1f;
    }

    public void resetZoom() {
        this.myZoomLeft = (double)DEFAULT_VIEW_LENGTH_US - this.myViewRangeUs.getLength();
    }

    public void pan(double deltaUs) {
        if (deltaUs < 0.0) {
            this.setStreaming(false);
        }
        if (this.myViewRangeUs.getMin() + deltaUs < this.myDataRangeUs.getMin()) {
            deltaUs = this.myDataRangeUs.getMin() - this.myViewRangeUs.getMin();
        } else if (this.myViewRangeUs.getMax() + deltaUs > this.myDataRangeUs.getMax()) {
            deltaUs = this.myDataRangeUs.getMax() - this.myViewRangeUs.getMax();
        }
        this.myViewRangeUs.shift(deltaUs);
    }

    public void reset(long startTimeNs, long lengthNs) {
        this.myDataStartTimeNs = startTimeNs;
        this.myDataLengthNs = lengthNs;
        this.myIsPaused = false;
        double startTimeUs = TimeUnit.NANOSECONDS.toMicros(this.myDataStartTimeNs);
        long deviceNowNs = this.myDataStartTimeNs + this.myDataLengthNs;
        long deviceNowUs = TimeUnit.NANOSECONDS.toMicros(deviceNowNs);
        this.myDataRangeUs.set(startTimeUs, (double)deviceNowUs);
        this.myViewRangeUs.set((double)(deviceNowUs - DEFAULT_VIEW_LENGTH_US), (double)deviceNowUs);
        this.setStreaming(true);
    }

    public long getDataStartTimeNs() {
        return this.myDataStartTimeNs;
    }

    public long convertToRelativeTimeUs(long absoluteTimeNs) {
        return TimeUnit.NANOSECONDS.toMicros(absoluteTimeNs - this.myDataStartTimeNs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/profilers/ProfilerTimeline";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewRange";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static enum Aspect {
        STREAMING;

    }
}

