/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.HNode;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureNode
implements HNode<CaptureNode> {
    private long myStartGlobal;
    private long myEndGlobal;
    private long myStartThread;
    private long myEndThread;
    @NotNull
    private final List<CaptureNode> myChildren;
    @NotNull
    private ClockType myClockType;
    private CaptureNode myParent;
    @NotNull
    private FilterType myFilterType;
    private int myDepth;
    @NotNull
    private final CaptureNodeModel myData;

    public CaptureNode(@NotNull CaptureNodeModel model) {
        if (model == null) {
            CaptureNode.$$$reportNull$$$0(0);
        }
        this.myFilterType = FilterType.UNINITIALIZED;
        this.myChildren = new ArrayList<CaptureNode>();
        this.myClockType = ClockType.GLOBAL;
        this.myDepth = 0;
        this.myData = model;
    }

    public void addChild(CaptureNode node) {
        this.myChildren.add(node);
        node.myParent = this;
    }

    @NotNull
    public List<CaptureNode> getChildren() {
        List<CaptureNode> list = this.myChildren;
        if (list == null) {
            CaptureNode.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public CaptureNodeModel getData() {
        CaptureNodeModel captureNodeModel = this.myData;
        if (captureNodeModel == null) {
            CaptureNode.$$$reportNull$$$0(2);
        }
        return captureNodeModel;
    }

    public int getChildCount() {
        return this.myChildren.size();
    }

    @NotNull
    public CaptureNode getChildAt(int index) {
        CaptureNode captureNode = this.myChildren.get(index);
        if (captureNode == null) {
            CaptureNode.$$$reportNull$$$0(3);
        }
        return captureNode;
    }

    @Nullable
    public CaptureNode getParent() {
        return this.myParent;
    }

    public long getStart() {
        return this.myClockType == ClockType.THREAD ? this.myStartThread : this.myStartGlobal;
    }

    public long getEnd() {
        return this.myClockType == ClockType.THREAD ? this.myEndThread : this.myEndGlobal;
    }

    public int getDepth() {
        return this.myDepth;
    }

    public void setStartGlobal(long startGlobal) {
        this.myStartGlobal = startGlobal;
    }

    public long getStartGlobal() {
        return this.myStartGlobal;
    }

    public void setEndGlobal(long endGlobal) {
        this.myEndGlobal = endGlobal;
    }

    public long getEndGlobal() {
        return this.myEndGlobal;
    }

    public void setStartThread(long startThread) {
        this.myStartThread = startThread;
    }

    public long getStartThread() {
        return this.myStartThread;
    }

    public void setEndThread(long endThread) {
        this.myEndThread = endThread;
    }

    public long getEndThread() {
        return this.myEndThread;
    }

    public void setClockType(@NotNull ClockType clockType) {
        if (clockType == null) {
            CaptureNode.$$$reportNull$$$0(4);
        }
        this.myClockType = clockType;
    }

    public double threadGlobalRatio() {
        long durationThread = this.myEndThread - this.myStartThread;
        long durationGlobal = this.myEndGlobal - this.myStartGlobal;
        return (double)durationThread / (double)durationGlobal;
    }

    @NotNull
    public ClockType getClockType() {
        ClockType clockType = this.myClockType;
        if (clockType == null) {
            CaptureNode.$$$reportNull$$$0(5);
        }
        return clockType;
    }

    public void setDepth(int depth) {
        this.myDepth = depth;
    }

    public boolean matchesToFilter(@Nullable Pattern filter) {
        return filter == null || filter.matcher(this.getData().getFullName()).matches();
    }

    @NotNull
    public FilterType getFilterType() {
        FilterType filterType = this.myFilterType;
        if (filterType == null) {
            CaptureNode.$$$reportNull$$$0(6);
        }
        return filterType;
    }

    public void setFilterType(@NotNull FilterType type) {
        if (type == null) {
            CaptureNode.$$$reportNull$$$0(7);
        }
        this.myFilterType = type;
    }

    public boolean isUnmatched() {
        return this.getFilterType() == FilterType.UNMATCH;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CaptureNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clockType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CaptureNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAt";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClockType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setClockType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setFilterType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum FilterType {
        UNINITIALIZED,
        EXACT_MATCH,
        MATCH,
        UNMATCH;

    }
}

