/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.FilterComponent;
import com.android.tools.adtui.FlatTabbedPane;
import com.android.tools.adtui.RangeTimeScrollBar;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.chart.hchart.HTreeChartVerticalScrollBar;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.flat.FlatToggleButton;
import com.android.tools.adtui.instructions.InstructionsPanel;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.JComboBoxView;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ViewBinder;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.cpu.BottomUpTreeModel;
import com.android.tools.profilers.cpu.CaptureModel;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CaptureNodeHRenderer;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuChartTooltipView;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.CpuTraceTreeSorter;
import com.android.tools.profilers.cpu.CpuTreeModel;
import com.android.tools.profilers.cpu.CpuTreeNode;
import com.android.tools.profilers.cpu.TopDownTreeModel;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.CppFunctionModel;
import com.android.tools.profilers.cpu.nodemodel.JavaMethodModel;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.google.common.collect.ImmutableMap;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CpuCaptureView {
    private static final Map<CaptureModel.Details.Type, String> TABS = ImmutableMap.of((Object)((Object)CaptureModel.Details.Type.CALL_CHART), (Object)"Call Chart", (Object)((Object)CaptureModel.Details.Type.FLAME_CHART), (Object)"Flame Chart", (Object)((Object)CaptureModel.Details.Type.TOP_DOWN), (Object)"Top Down", (Object)((Object)CaptureModel.Details.Type.BOTTOM_UP), (Object)"Bottom Up");
    private static final Map<CaptureModel.Details.Type, Consumer<FeatureTracker>> CAPTURE_TRACKERS = ImmutableMap.of((Object)((Object)CaptureModel.Details.Type.TOP_DOWN), FeatureTracker::trackSelectCaptureTopDown, (Object)((Object)CaptureModel.Details.Type.BOTTOM_UP), FeatureTracker::trackSelectCaptureBottomUp, (Object)((Object)CaptureModel.Details.Type.CALL_CHART), FeatureTracker::trackSelectCaptureCallChart, (Object)((Object)CaptureModel.Details.Type.FLAME_CHART), FeatureTracker::trackSelectCaptureFlameChart);
    private static final Comparator<DefaultMutableTreeNode> DEFAULT_SORT_ORDER = Collections.reverseOrder(new DoubleValueNodeComparator(CpuTreeNode::getTotal));
    @NotNull
    private final CpuProfilerStageView myView;
    private final JPanel myPanel;
    private final FlatTabbedPane myTabsPanel;
    @NotNull
    private FilterComponent myFilterComponent;
    @Nullable
    private CaptureDetailsView myDetailsView;
    @NotNull
    private final ViewBinder<CpuProfilerStageView, CaptureModel.Details, CaptureDetailsView> myBinder;

    CpuCaptureView(@NotNull CpuProfilerStageView view) {
        if (view == null) {
            CpuCaptureView.$$$reportNull$$$0(0);
        }
        this.myView = view;
        this.myTabsPanel = new FlatTabbedPane();
        for (String label : TABS.values()) {
            this.myTabsPanel.addTab(label, (Component)new JPanel(new BorderLayout()));
        }
        this.myTabsPanel.addChangeListener(this::setCaptureDetailToTab);
        ComboBox clockTypeCombo = new ComboBox();
        JComboBoxView<ClockType, CpuProfilerAspect> clockTypes = new JComboBoxView<ClockType, CpuProfilerAspect>((JComboBox<ClockType>)clockTypeCombo, ((CpuProfilerStage)view.getStage()).getAspect(), CpuProfilerAspect.CLOCK_TYPE, ((CpuProfilerStage)view.getStage())::getClockTypes, ((CpuProfilerStage)view.getStage())::getClockType, ((CpuProfilerStage)view.getStage())::setClockType);
        clockTypes.bind();
        clockTypeCombo.setRenderer(new ClockTypeCellRenderer());
        CpuCapture capture = ((CpuProfilerStage)this.myView.getStage()).getCapture();
        clockTypeCombo.setEnabled(capture != null && capture.isDualClock());
        this.myTabsPanel.setOpaque(false);
        this.myPanel = new JPanel((LayoutManager)new TabularLayout("*,Fit", "Fit,*"));
        JPanel toolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        toolbar.add((Component)clockTypeCombo);
        toolbar.add(this.myView.getSelectionTimeLabel());
        this.myFilterComponent = new FilterComponent(ProfilerLayout.FILTER_TEXT_FIELD_WIDTH, 5, 250);
        if (((CpuProfilerStage)view.getStage()).getStudioProfilers().getIdeServices().getFeatureConfig().isCpuCaptureFilterEnabled()) {
            FlatToggleButton filterButton = FilterComponent.createFilterToggleButton();
            toolbar.add((Component)new FlatSeparator());
            toolbar.add((Component)filterButton);
            this.myFilterComponent.addOnFilterChange((pattern, model) -> ((CpuProfilerStage)this.myView.getStage()).setCaptureFilter((Pattern)pattern));
            this.myFilterComponent.setVisible(false);
            this.myFilterComponent.setBorder(AdtUiUtils.DEFAULT_BOTTOM_BORDER);
            FilterComponent.configureKeyBindingAndFocusBehaviors((JComponent)this.myPanel, (FilterComponent)this.myFilterComponent, (JToggleButton)filterButton);
        }
        this.myPanel.add((Component)toolbar, new TabularLayout.Constraint(0, 1));
        this.myPanel.add((Component)this.myTabsPanel, new TabularLayout.Constraint(0, 0, 2, 2));
        this.myBinder = new ViewBinder();
        this.myBinder.bind(CaptureModel.TopDown.class, TopDownView::new);
        this.myBinder.bind(CaptureModel.BottomUp.class, BottomUpView::new);
        this.myBinder.bind(CaptureModel.CallChart.class, (x$0, x$1) -> new CallChartView((CpuProfilerStageView)((Object)x$0), (CaptureModel.CallChart)x$1));
        this.myBinder.bind(CaptureModel.FlameChart.class, FlameChartView::new);
        this.updateView();
    }

    void updateView() {
        CaptureModel.Details details;
        for (Component tab : this.myTabsPanel.getComponents()) {
            assert (tab instanceof JPanel);
            ((JPanel)tab).removeAll();
        }
        FilterComponent filterComponent = this.myFilterComponent;
        boolean searchHasFocus = filterComponent.isAncestorOf(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        if (filterComponent.getParent() != null) {
            filterComponent.getParent().remove((Component)filterComponent);
        }
        if ((details = ((CpuProfilerStage)this.myView.getStage()).getCaptureDetails()) == null) {
            return;
        }
        String detailsTypeString = TABS.get((Object)details.getType());
        int currentTabIndex = this.myTabsPanel.getSelectedIndex();
        if (currentTabIndex < 0 || !this.myTabsPanel.getTitleAt(currentTabIndex).equals(detailsTypeString)) {
            for (int i = 0; i < this.myTabsPanel.getTabCount(); ++i) {
                if (!this.myTabsPanel.getTitleAt(i).equals(detailsTypeString)) continue;
                this.myTabsPanel.setSelectedIndex(i);
                break;
            }
        }
        JPanel selectedTab = (JPanel)this.myTabsPanel.getSelectedComponent();
        this.myDetailsView = this.myBinder.build(this.myView, details);
        selectedTab.add((Component)filterComponent, "North");
        selectedTab.add((Component)this.myDetailsView.getComponent(), "Center");
        selectedTab.revalidate();
        if (searchHasFocus) {
            this.myFilterComponent.requestFocusInWindow();
        }
    }

    private void setCaptureDetailToTab(ChangeEvent event) {
        CaptureModel.Details.Type type = null;
        if (this.myTabsPanel.getSelectedIndex() >= 0) {
            String tabTitle = this.myTabsPanel.getTitleAt(this.myTabsPanel.getSelectedIndex());
            for (Map.Entry<CaptureModel.Details.Type, String> entry : TABS.entrySet()) {
                if (!tabTitle.equals(entry.getValue())) continue;
                type = entry.getKey();
            }
        }
        ((CpuProfilerStage)this.myView.getStage()).setCaptureDetails(type);
        FeatureTracker tracker = ((CpuProfilerStage)this.myView.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker();
        CAPTURE_TRACKERS.getOrDefault((Object)type, featureTracker -> {}).accept(tracker);
    }

    private static Logger getLog() {
        return Logger.getInstance(CpuCaptureView.class);
    }

    @Nullable
    private static CodeLocation getCodeLocation(@NotNull JTree tree) {
        if (tree == null) {
            CpuCaptureView.$$$reportNull$$$0(1);
        }
        if (tree.getSelectionPath() == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getSelectionPath().getLastPathComponent();
        return CpuCaptureView.modelToCodeLocation(((CpuTreeNode)node.getUserObject()).getMethodModel());
    }

    private static void expandTreeNodes(JTree tree) {
        int maxRowsToExpand = 8;
        int i = 0;
        while (i < tree.getRowCount() && i < maxRowsToExpand) {
            tree.expandRow(i++);
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private static CpuTreeNode getNode(Object value) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        return (CpuTreeNode)node.getUserObject();
    }

    private static HTreeChart<CaptureNode> setUpChart(@NotNull CaptureModel.Details.Type type, @NotNull Range globalRange, @NotNull Range range, @Nullable CaptureNode node, @NotNull CpuProfilerStageView stageView) {
        if (type == null) {
            CpuCaptureView.$$$reportNull$$$0(2);
        }
        if (globalRange == null) {
            CpuCaptureView.$$$reportNull$$$0(3);
        }
        if (range == null) {
            CpuCaptureView.$$$reportNull$$$0(4);
        }
        if (stageView == null) {
            CpuCaptureView.$$$reportNull$$$0(5);
        }
        HTreeChart.Orientation orientation = type == CaptureModel.Details.Type.CALL_CHART ? HTreeChart.Orientation.TOP_DOWN : HTreeChart.Orientation.BOTTOM_UP;
        HTreeChart chart = new HTreeChart(globalRange, range, orientation);
        chart.setHRenderer((HRenderer)new CaptureNodeHRenderer(type));
        chart.setRootVisible(false);
        chart.setHTree((HNode)node);
        CodeNavigator navigator = ((CpuProfilerStage)stageView.getStage()).getStudioProfilers().getIdeServices().getCodeNavigator();
        TreeChartNavigationHandler handler = new TreeChartNavigationHandler((HTreeChart<CaptureNode>)chart, navigator);
        chart.addMouseListener((MouseListener)handler);
        stageView.getIdeComponents().createContextMenuInstaller().installNavigationContextMenu((JComponent)chart, navigator, () -> handler.getCodeLocation());
        CpuChartTooltipView.install((HTreeChart<CaptureNode>)chart, stageView);
        return chart;
    }

    @Nullable
    private static CodeLocation modelToCodeLocation(CaptureNodeModel model) {
        if (model instanceof CppFunctionModel) {
            CppFunctionModel nativeFunction = (CppFunctionModel)model;
            return new CodeLocation.Builder(nativeFunction.getClassOrNamespace()).setMethodName(nativeFunction.getName()).setMethodParameters(nativeFunction.getParameters()).setNativeCode(true).build();
        }
        if (model instanceof JavaMethodModel) {
            JavaMethodModel javaMethod = (JavaMethodModel)model;
            return new CodeLocation.Builder(javaMethod.getClassName()).setMethodName(javaMethod.getName()).setMethodSignature(javaMethod.getSignature()).setNativeCode(false).build();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stageView";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCodeLocation";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpChart";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MethodNameRenderer
    extends CpuCaptureCellRenderer {
        private MethodNameRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MethodNameRenderer.$$$reportNull$$$0(0);
            }
            if (value instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)value).getUserObject() instanceof CpuTreeNode) {
                CpuTreeNode node = (CpuTreeNode)((DefaultMutableTreeNode)value).getUserObject();
                SimpleTextAttributes attributes = this.getTextAttributes(node);
                CaptureNodeModel model = node.getMethodModel();
                String classOrNamespace = "";
                if (model instanceof CppFunctionModel) {
                    classOrNamespace = ((CppFunctionModel)model).getClassOrNamespace();
                } else if (model instanceof JavaMethodModel) {
                    classOrNamespace = ((JavaMethodModel)model).getClassName();
                }
                if (model.getName().isEmpty()) {
                    this.setIcon(AllIcons.Debugger.ThreadSuspended);
                    this.append(classOrNamespace, attributes);
                } else {
                    this.setIcon(PlatformIcons.METHOD_ICON);
                    this.append(model.getName() + "()", attributes);
                    this.append(" (" + classOrNamespace + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            } else {
                this.append(value.toString());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/profilers/cpu/CpuCaptureView$MethodNameRenderer", "customizeCellRenderer"));
        }
    }

    private static class DoubleValueCellRendererWithSparkline
    extends DoubleValueCellRenderer {
        private Color mySparklineColor = ProfilerColors.CPU_CAPTURE_SPARKLINE;
        private double myPercentage = Double.NEGATIVE_INFINITY;

        DoubleValueCellRendererWithSparkline(Function<CpuTreeNode, Double> getter, boolean showPercentage, int alignment) {
            super(getter, showPercentage, alignment);
        }

        @Override
        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                DoubleValueCellRendererWithSparkline.$$$reportNull$$$0(0);
            }
            super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
            CpuTreeNode node = CpuCaptureView.getNode(value);
            if (node != null) {
                this.myPercentage = this.getGetter().apply(node) / CpuCaptureView.getNode(tree.getModel().getRoot()).getTotal();
            }
            this.mySparklineColor = selected ? ProfilerColors.CPU_CAPTURE_SPARKLINE_SELECTED : ProfilerColors.CPU_CAPTURE_SPARKLINE;
        }

        protected void paintComponent(Graphics g) {
            if (this.myPercentage > 0.0) {
                g.setColor(this.mySparklineColor);
                g.fillRect(ProfilerLayout.TABLE_COLUMN_CELL_SPARKLINE_LEFT_PADDING, ProfilerLayout.TABLE_COLUMN_CELL_SPARKLINE_TOP_BOTTOM_PADDING, (int)(this.myPercentage * (double)(this.getWidth() / 2 - ProfilerLayout.TABLE_COLUMN_CELL_SPARKLINE_LEFT_PADDING)), this.getHeight() - ProfilerLayout.TABLE_COLUMN_CELL_SPARKLINE_TOP_BOTTOM_PADDING * 2);
            }
            super.paintComponent(g);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/profilers/cpu/CpuCaptureView$DoubleValueCellRendererWithSparkline", "customizeCellRenderer"));
        }
    }

    private static class DoubleValueCellRenderer
    extends CpuCaptureCellRenderer {
        private final Function<CpuTreeNode, Double> myGetter;
        private final boolean myShowPercentage;
        private final int myAlignment;

        DoubleValueCellRenderer(Function<CpuTreeNode, Double> getter, boolean showPercentage, int alignment) {
            this.myGetter = getter;
            this.myShowPercentage = showPercentage;
            this.myAlignment = alignment;
            this.setTextAlign(alignment);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            CpuTreeNode node;
            if (tree == null) {
                DoubleValueCellRenderer.$$$reportNull$$$0(0);
            }
            if ((node = CpuCaptureView.getNode(value)) != null) {
                SimpleTextAttributes attributes = this.getTextAttributes(node);
                double v = this.myGetter.apply(node);
                if (this.myShowPercentage) {
                    CpuTreeNode root = CpuCaptureView.getNode(tree.getModel().getRoot());
                    this.append(String.format("%.2f", v / root.getTotal() * 100.0), attributes);
                } else {
                    this.append(String.format("%,.0f", v), attributes);
                }
            } else {
                this.append(value.toString());
            }
            if (this.myAlignment == 2) {
                this.setIpad(ProfilerLayout.TABLE_COLUMN_CELL_INSETS);
            } else {
                this.setIpad(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_CELL_INSETS);
            }
        }

        protected Function<CpuTreeNode, Double> getGetter() {
            return this.myGetter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/profilers/cpu/CpuCaptureView$DoubleValueCellRenderer", "customizeCellRenderer"));
        }
    }

    private static abstract class CpuCaptureCellRenderer
    extends ColoredTreeCellRenderer {
        private static final Map<CaptureNode.FilterType, SimpleTextAttributes> TEXT_ATTRIBUTES = ImmutableMap.builder().put((Object)CaptureNode.FilterType.MATCH, (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES).put((Object)CaptureNode.FilterType.EXACT_MATCH, (Object)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES).put((Object)CaptureNode.FilterType.UNMATCH, (Object)SimpleTextAttributes.GRAY_ATTRIBUTES).build();

        private CpuCaptureCellRenderer() {
        }

        @NotNull
        protected SimpleTextAttributes getTextAttributes(@NotNull CpuTreeNode node) {
            if (node == null) {
                CpuCaptureCellRenderer.$$$reportNull$$$0(0);
            }
            SimpleTextAttributes simpleTextAttributes = TEXT_ATTRIBUTES.get((Object)node.getFilterType());
            if (simpleTextAttributes == null) {
                CpuCaptureCellRenderer.$$$reportNull$$$0(1);
            }
            return simpleTextAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureView$CpuCaptureCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureView$CpuCaptureCellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTextAttributes";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DoubleValueNodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        private final Function<CpuTreeNode, Double> myGetter;

        DoubleValueNodeComparator(Function<CpuTreeNode, Double> getter) {
            this.myGetter = getter;
        }

        @Override
        public int compare(DefaultMutableTreeNode a, DefaultMutableTreeNode b) {
            CpuTreeNode o1 = (CpuTreeNode)a.getUserObject();
            CpuTreeNode o2 = (CpuTreeNode)b.getUserObject();
            return Double.compare(this.myGetter.apply(o1), this.myGetter.apply(o2));
        }
    }

    private static class NameValueNodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        private NameValueNodeComparator() {
        }

        @Override
        public int compare(DefaultMutableTreeNode a, DefaultMutableTreeNode b) {
            CpuTreeNode o1 = (CpuTreeNode)a.getUserObject();
            CpuTreeNode o2 = (CpuTreeNode)b.getUserObject();
            return o1.getMethodModel().getName().compareTo(o2.getMethodModel().getName());
        }
    }

    private static class TreeChartNavigationHandler
    extends MouseAdapter {
        @NotNull
        private final HTreeChart<CaptureNode> myChart;
        private Point myLastPopupPoint;

        TreeChartNavigationHandler(@NotNull HTreeChart<CaptureNode> chart, final @NotNull CodeNavigator navigator) {
            if (chart == null) {
                TreeChartNavigationHandler.$$$reportNull$$$0(0);
            }
            if (navigator == null) {
                TreeChartNavigationHandler.$$$reportNull$$$0(1);
            }
            this.myChart = chart;
            new DoubleClickListener(){

                protected boolean onDoubleClick(MouseEvent event) {
                    this.setLastPopupPoint(event);
                    CodeLocation codeLocation = this.getCodeLocation();
                    if (codeLocation != null && navigator.isNavigatable(codeLocation)) {
                        navigator.navigate(codeLocation);
                    }
                    return false;
                }
            }.installOn(chart);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handlePopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handlePopup(e);
        }

        private void handlePopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.setLastPopupPoint(e);
            }
        }

        private void setLastPopupPoint(MouseEvent e) {
            this.myLastPopupPoint = e.getPoint();
        }

        @Nullable
        private CodeLocation getCodeLocation() {
            CaptureNode n = (CaptureNode)this.myChart.getNodeAt(this.myLastPopupPoint);
            if (n == null) {
                return null;
            }
            return CpuCaptureView.modelToCodeLocation(n.getData());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "chart";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "navigator";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/profilers/cpu/CpuCaptureView$TreeChartNavigationHandler";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class FlameChartView
    extends CaptureDetailsView {
        @NotNull
        private final JPanel myPanel;
        @NotNull
        private final HTreeChart<CaptureNode> myChart;
        @NotNull
        private final AspectObserver myObserver;
        @NotNull
        private final CaptureModel.FlameChart myFlameChart;
        @NotNull
        private final Range myMasterRange;

        FlameChartView(CpuProfilerStageView stageView, @NotNull CaptureModel.FlameChart flameChart) {
            if (flameChart == null) {
                FlameChartView.$$$reportNull$$$0(0);
            }
            this.myFlameChart = flameChart;
            this.myMasterRange = new Range(flameChart.getRange());
            this.myChart = CpuCaptureView.setUpChart(CaptureModel.Details.Type.FLAME_CHART, flameChart.getRange(), this.myMasterRange, this.myFlameChart.getNode(), stageView);
            this.myObserver = new AspectObserver();
            if (this.myFlameChart.getNode() == null) {
                this.myPanel = FlameChartView.getNoDataForThread();
                return;
            }
            RangeTimeScrollBar horizontalScrollBar = new RangeTimeScrollBar(flameChart.getRange(), this.myMasterRange, TimeUnit.MICROSECONDS);
            horizontalScrollBar.setPreferredSize(new Dimension(horizontalScrollBar.getPreferredSize().width, 10));
            JPanel contentPanel = new JPanel(new BorderLayout());
            contentPanel.add((Component)this.myChart, "Center");
            contentPanel.add((Component)new HTreeChartVerticalScrollBar(this.myChart), "East");
            contentPanel.add((Component)horizontalScrollBar, "South");
            this.myPanel = new JPanel(new CardLayout());
            this.myPanel.add((Component)contentPanel, "Content");
            this.myPanel.add((Component)FlameChartView.getNoDataForRange(), "Empty content");
            this.myFlameChart.getAspect().addDependency(this.myObserver).onChange((Enum)CaptureModel.FlameChart.Aspect.NODE, this::nodeChanged);
            this.nodeChanged();
        }

        private void nodeChanged() {
            FlameChartView.switchCardLayout(this.myPanel, this.myFlameChart.getNode() == null);
            this.myChart.setHTree((HNode)this.myFlameChart.getNode());
            this.myMasterRange.set(this.myFlameChart.getRange());
        }

        @Override
        @NotNull
        JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                FlameChartView.$$$reportNull$$$0(1);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flameChart";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureView$FlameChartView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureView$FlameChartView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class CallChartView
    extends CaptureDetailsView {
        @NotNull
        private final JPanel myPanel;
        @NotNull
        private final CaptureModel.CallChart myCallChart;
        @NotNull
        private final HTreeChart<CaptureNode> myChart;
        private AspectObserver myObserver;

        private CallChartView(@NotNull CpuProfilerStageView stageView, @NotNull CaptureModel.CallChart callChart) {
            if (stageView == null) {
                CallChartView.$$$reportNull$$$0(0);
            }
            if (callChart == null) {
                CallChartView.$$$reportNull$$$0(1);
            }
            this.myCallChart = callChart;
            Range selectionRange = stageView.getTimeline().getSelectionRange();
            Range captureRange = ((CpuProfilerStage)stageView.getStage()).getCapture().getRange();
            this.myChart = CpuCaptureView.setUpChart(CaptureModel.Details.Type.CALL_CHART, captureRange, selectionRange, this.myCallChart.getNode(), stageView);
            if (this.myCallChart.getNode() == null) {
                this.myPanel = CallChartView.getNoDataForThread();
                return;
            }
            RangeTimeScrollBar horizontalScrollBar = new RangeTimeScrollBar(captureRange, selectionRange, TimeUnit.MICROSECONDS);
            horizontalScrollBar.setPreferredSize(new Dimension(horizontalScrollBar.getPreferredSize().width, 10));
            JPanel contentPanel = new JPanel(new BorderLayout());
            contentPanel.add((Component)this.myChart, "Center");
            contentPanel.add((Component)new HTreeChartVerticalScrollBar(this.myChart), "East");
            contentPanel.add((Component)horizontalScrollBar, "South");
            this.myPanel = new JPanel(new CardLayout());
            this.myPanel.add((Component)contentPanel, "Content");
            this.myPanel.add((Component)CallChartView.getNoDataForRange(), "Empty content");
            this.myObserver = new AspectObserver();
            this.myCallChart.getRange().addDependency(this.myObserver).onChange((Enum)Range.Aspect.RANGE, this::callChartRangeChanged);
            this.callChartRangeChanged();
        }

        private void callChartRangeChanged() {
            CaptureNode node = this.myCallChart.getNode();
            assert (node != null);
            Range intersection = this.myCallChart.getRange().getIntersection(new Range((double)node.getStart(), (double)node.getEnd()));
            CallChartView.switchCardLayout(this.myPanel, intersection.isEmpty() || intersection.getLength() == 0.0);
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                CallChartView.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stageView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callChart";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureView$CallChartView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureView$CallChartView";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class BottomUpView
    extends TreeView {
        BottomUpView(@NotNull CpuProfilerStageView view, @NotNull CaptureModel.BottomUp bottomUp) {
            if (view == null) {
                BottomUpView.$$$reportNull$$$0(0);
            }
            if (bottomUp == null) {
                BottomUpView.$$$reportNull$$$0(1);
            }
            super(view, bottomUp.getModel());
            final BottomUpTreeModel model = bottomUp.getModel();
            if (model == null) {
                return;
            }
            assert (this.myTree != null);
            this.myTree.setRootVisible(false);
            this.myTree.addTreeWillExpandListener(new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                    ((BottomUpTreeModel)myTree.getModel()).expand(node);
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                }
            });
            model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (type == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (type == TreeModelAdapter.EventType.NodesInserted && event.getTreePath().getPathCount() == 1) {
                        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
                        Object[] inserted = event.getChildren();
                        if (inserted != null && inserted.length == root.getChildCount()) {
                            myTree.expandPath(new TreePath(root));
                        }
                    }
                    CaptureDetailsView.switchCardLayout(myPanel, model.isEmpty());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "type";
                            break;
                        }
                    }
                    objectArray[1] = "com/android/tools/profilers/cpu/CpuCaptureView$BottomUpView$2";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "view";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bottomUp";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/profilers/cpu/CpuCaptureView$BottomUpView";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TopDownView
    extends TreeView {
        TopDownView(@NotNull CpuProfilerStageView view, @NotNull CaptureModel.TopDown topDown) {
            if (view == null) {
                TopDownView.$$$reportNull$$$0(0);
            }
            if (topDown == null) {
                TopDownView.$$$reportNull$$$0(1);
            }
            super(view, topDown.getModel());
            final TopDownTreeModel model = topDown.getModel();
            if (model == null) {
                return;
            }
            assert (this.myTree != null);
            CpuCaptureView.expandTreeNodes(this.myTree);
            model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (type == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    CaptureDetailsView.switchCardLayout(myPanel, model.isEmpty());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "type";
                            break;
                        }
                    }
                    objectArray[1] = "com/android/tools/profilers/cpu/CpuCaptureView$TopDownView$1";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "view";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "topDown";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/profilers/cpu/CpuCaptureView$TopDownView";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class TreeView
    extends CaptureDetailsView {
        @NotNull
        protected final JPanel myPanel;
        @NotNull
        private final AspectObserver myObserver;
        @Nullable
        protected final JTree myTree;
        @Nullable
        private final CpuTraceTreeSorter mySorter;

        protected TreeView(@NotNull CpuProfilerStageView stageView, @Nullable CpuTreeModel model) {
            if (stageView == null) {
                TreeView.$$$reportNull$$$0(0);
            }
            this.myObserver = new AspectObserver();
            if (model == null) {
                this.myPanel = TreeView.getNoDataForThread();
                this.myTree = null;
                this.mySorter = null;
                return;
            }
            this.myPanel = new JPanel(new CardLayout());
            this.myTree = new JTree();
            int defaultFontHeight = this.myTree.getFontMetrics(this.myTree.getFont()).getHeight();
            this.myTree.setRowHeight(defaultFontHeight + ProfilerLayout.ROW_HEIGHT_PADDING);
            this.myTree.setBorder(ProfilerLayout.TABLE_ROW_BORDER);
            this.myTree.setModel(model);
            this.mySorter = new CpuTraceTreeSorter(this.myTree);
            this.mySorter.setModel(model, DEFAULT_SORT_ORDER);
            this.myPanel.add((Component)this.createTableTree(), "Content");
            this.myPanel.add((Component)TreeView.getNoDataForRange(), "Empty content");
            CodeNavigator navigator = ((CpuProfilerStage)stageView.getStage()).getStudioProfilers().getIdeServices().getCodeNavigator();
            stageView.getIdeComponents().createContextMenuInstaller().installNavigationContextMenu(this.myTree, navigator, () -> CpuCaptureView.getCodeLocation(this.myTree));
            TreeView.switchCardLayout(this.myPanel, model.isEmpty());
            model.getAspect().addDependency(this.myObserver).onChange((Enum)CpuTreeModel.Aspect.TREE_MODEL, () -> this.mySorter.sort());
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                TreeView.$$$reportNull$$$0(1);
            }
            return jPanel;
        }

        @NotNull
        private JComponent createTableTree() {
            assert (this.myTree != null && this.mySorter != null);
            JComponent jComponent = new ColumnTreeBuilder(this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Name").setPreferredWidth(900).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_HEADER_BORDER).setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new MethodNameRenderer()).setComparator((Comparator)new NameValueNodeComparator())).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Total (\u03bcs)").setPreferredWidth(100).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setMinWidth(80).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRendererWithSparkline(CpuTreeNode::getTotal, false, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator((Comparator)new DoubleValueNodeComparator(CpuTreeNode::getTotal))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("%").setPreferredWidth(60).setMinWidth(60).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getTotal, true, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator((Comparator)new DoubleValueNodeComparator(CpuTreeNode::getTotal))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Self (\u03bcs)").setPreferredWidth(100).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setMinWidth(80).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getSelf, false, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator((Comparator)new DoubleValueNodeComparator(CpuTreeNode::getSelf))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("%").setPreferredWidth(60).setMinWidth(60).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getSelf, true, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator((Comparator)new DoubleValueNodeComparator(CpuTreeNode::getSelf))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Children (\u03bcs)").setPreferredWidth(100).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setMinWidth(80).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getChildrenTotal, false, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator((Comparator)new DoubleValueNodeComparator(CpuTreeNode::getChildrenTotal))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("%").setPreferredWidth(60).setMinWidth(60).setHeaderBorder(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER).setHeaderAlignment(4).setRenderer((ColoredTreeCellRenderer)new DoubleValueCellRenderer(CpuTreeNode::getChildrenTotal, true, 4)).setSortOrderPreference(SortOrder.DESCENDING).setComparator((Comparator)new DoubleValueNodeComparator(CpuTreeNode::getChildrenTotal))).setTreeSorter((ColumnTreeBuilder.TreeSorter)this.mySorter).setBorder(AdtUiUtils.DEFAULT_TOP_BORDER).setBackground(ProfilerColors.DEFAULT_BACKGROUND).setShowVerticalLines(true).setTableIntercellSpacing(new Dimension()).build();
            if (jComponent == null) {
                TreeView.$$$reportNull$$$0(2);
            }
            return jComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stageView";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuCaptureView$TreeView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuCaptureView$TreeView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTableTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ClockTypeCellRenderer
    extends ListCellRendererWrapper<ClockType> {
        private ClockTypeCellRenderer() {
        }

        public void customize(JList list, ClockType value, int index, boolean selected, boolean hasFocus) {
            switch (value) {
                case GLOBAL: {
                    this.setText("Wall Clock Time");
                    break;
                }
                case THREAD: {
                    this.setText("Thread Time");
                    break;
                }
                default: {
                    CpuCaptureView.getLog().warn("Unexpected clock type received.");
                }
            }
        }
    }

    private static abstract class CaptureDetailsView {
        protected static final String CARD_EMPTY_INFO = "Empty content";
        protected static final String CARD_CONTENT = "Content";

        private CaptureDetailsView() {
        }

        @NotNull
        abstract JComponent getComponent();

        protected static void switchCardLayout(@NotNull JPanel panel, boolean isEmpty) {
            if (panel == null) {
                CaptureDetailsView.$$$reportNull$$$0(0);
            }
            CardLayout cardLayout = (CardLayout)panel.getLayout();
            cardLayout.show(panel, isEmpty ? CARD_EMPTY_INFO : CARD_CONTENT);
        }

        protected static JPanel getNoDataForThread() {
            String message = "No data available for the selected thread.";
            JPanel panel = new JPanel(new BorderLayout());
            InstructionsPanel info = new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(ProfilerLayout.INFO_MESSAGE_HEADER_FONT, message)}).setColors(JBColor.foreground(), null).build();
            panel.add((Component)info, "Center");
            return panel;
        }

        protected static JComponent getNoDataForRange() {
            String message = "No data available for the selected time frame.";
            JPanel panel = new JPanel(new BorderLayout());
            InstructionsPanel info = new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(ProfilerLayout.INFO_MESSAGE_HEADER_FONT, message)}).setColors(JBColor.foreground(), null).build();
            panel.add((Component)info, "Center");
            return panel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/android/tools/profilers/cpu/CpuCaptureView$CaptureDetailsView", "switchCardLayout"));
        }
    }
}

