/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayeredPane;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

class CpuChartTooltipView
extends MouseAdapter {
    @NotNull
    private final HTreeChart<CaptureNode> myChart;
    @NotNull
    private final TooltipComponent myTooltipComponent;
    @NotNull
    private final JPanel myContent;
    @NotNull
    private final CpuProfilerStageView myStageView;

    private CpuChartTooltipView(@NotNull HTreeChart<CaptureNode> chart, @NotNull CpuProfilerStageView stageView) {
        if (chart == null) {
            CpuChartTooltipView.$$$reportNull$$$0(0);
        }
        if (stageView == null) {
            CpuChartTooltipView.$$$reportNull$$$0(1);
        }
        this.myStageView = stageView;
        this.myChart = chart;
        this.myContent = new JPanel((LayoutManager)new TabularLayout("*", "*"));
        this.myContent.setBorder(ProfilerLayout.TOOLTIP_BORDER);
        this.myContent.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        this.myTooltipComponent = new TooltipComponent((Component)this.myContent, chart, ProfilerLayeredPane.class);
        this.myTooltipComponent.registerListenersOn(chart);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.myTooltipComponent.setVisible(false);
        CaptureNode node = (CaptureNode)this.myChart.getNodeAt(e.getPoint());
        if (node != null) {
            this.showTooltip(node);
        }
    }

    private void showTooltip(@NotNull CaptureNode node) {
        if (node == null) {
            CpuChartTooltipView.$$$reportNull$$$0(2);
        }
        this.myTooltipComponent.setVisible(true);
        Range dataRange = this.myStageView.getTimeline().getDataRange();
        long start = (long)((double)node.getStart() - dataRange.getMin());
        long end = (long)((double)node.getEnd() - dataRange.getMin());
        this.myContent.removeAll();
        JLabel nameLabel = new JLabel(node.getData().getFullName());
        nameLabel.setFont(nameLabel.getFont().deriveFont(11.0f));
        nameLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        this.myContent.add((Component)nameLabel, new TabularLayout.Constraint(0, 0));
        JLabel durationLabel = new JLabel(String.format("%s - %s (%s)", TimeAxisFormatter.DEFAULT.getClockFormattedString(start), TimeAxisFormatter.DEFAULT.getClockFormattedString(end), TimeAxisFormatter.DEFAULT.getFormattedDuration(node.getDuration())));
        durationLabel.setFont(durationLabel.getFont().deriveFont(11.0f));
        durationLabel.setForeground(ProfilerColors.TOOLTIP_TIME_COLOR);
        durationLabel.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.myContent.add((Component)durationLabel, new TabularLayout.Constraint(1, 0));
    }

    static void install(@NotNull HTreeChart<CaptureNode> chart, @NotNull CpuProfilerStageView stageView) {
        if (chart == null) {
            CpuChartTooltipView.$$$reportNull$$$0(3);
        }
        if (stageView == null) {
            CpuChartTooltipView.$$$reportNull$$$0(4);
        }
        chart.addMouseMotionListener((MouseMotionListener)new CpuChartTooltipView(chart, stageView));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chart";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stageView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/CpuChartTooltipView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showTooltip";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

