/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class CpuProfilerConfigModel {
    private ProfilingConfiguration myProfilingConfiguration;
    @NotNull
    private List<ProfilingConfiguration> myCustomProfilingConfigurations;
    @NotNull
    private List<ProfilingConfiguration> myCustomProfilingConfigurationsDeviceFiltered;
    @NotNull
    private List<ProfilingConfiguration> myDefaultProfilingConfigurations;
    private ProfilingConfiguration myActiveConfig;
    @NotNull
    private final StudioProfilers myProfilers;
    private AspectObserver myAspectObserver;

    public CpuProfilerConfigModel(@NotNull StudioProfilers profilers, CpuProfilerStage profilerStage) {
        if (profilers == null) {
            CpuProfilerConfigModel.$$$reportNull$$$0(0);
        }
        this.myProfilers = profilers;
        this.myCustomProfilingConfigurations = new ArrayList<ProfilingConfiguration>();
        this.myCustomProfilingConfigurationsDeviceFiltered = new ArrayList<ProfilingConfiguration>();
        this.myDefaultProfilingConfigurations = new ArrayList<ProfilingConfiguration>();
        this.myAspectObserver = new AspectObserver();
        profilerStage.getAspect().addDependency(this.myAspectObserver).onChange((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION, this::updateProfilingConfigurations);
    }

    public void setActiveConfig(CpuProfiler.CpuProfilerType profilerType, CpuProfiler.CpuProfilingAppStartRequest.Mode mode, int bufferSizeLimitMb, int samplingIntervalUs) {
        String anyConfigName = "Current config";
        this.myActiveConfig = new ProfilingConfiguration(anyConfigName, profilerType, mode);
        this.myActiveConfig.setProfilingBufferSizeInMb(bufferSizeLimitMb);
        this.myActiveConfig.setProfilingSamplingIntervalUs(samplingIntervalUs);
    }

    public ProfilingConfiguration getActiveConfig() {
        return this.myActiveConfig;
    }

    @NotNull
    public ProfilingConfiguration getProfilingConfiguration() {
        ProfilingConfiguration profilingConfiguration = this.myProfilingConfiguration;
        if (profilingConfiguration == null) {
            CpuProfilerConfigModel.$$$reportNull$$$0(1);
        }
        return profilingConfiguration;
    }

    public void setProfilingConfiguration(@NotNull ProfilingConfiguration mode) {
        if (mode == null) {
            CpuProfilerConfigModel.$$$reportNull$$$0(2);
        }
        this.myProfilingConfiguration = mode;
    }

    @NotNull
    public List<ProfilingConfiguration> getCustomProfilingConfigurations() {
        List<ProfilingConfiguration> list = this.myCustomProfilingConfigurations;
        if (list == null) {
            CpuProfilerConfigModel.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<ProfilingConfiguration> getCustomProfilingConfigurationsDeviceFiltered() {
        List<ProfilingConfiguration> list = this.myCustomProfilingConfigurationsDeviceFiltered;
        if (list == null) {
            CpuProfilerConfigModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<ProfilingConfiguration> getDefaultProfilingConfigurations() {
        List<ProfilingConfiguration> list = this.myDefaultProfilingConfigurations;
        if (list == null) {
            CpuProfilerConfigModel.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void updateProfilingConfigurations() {
        boolean isSimplePerfEnabled;
        List<ProfilingConfiguration> savedConfigs = this.myProfilers.getIdeServices().getCpuProfilingConfigurations();
        this.myCustomProfilingConfigurations = this.filterConfigurations(savedConfigs, false);
        this.myCustomProfilingConfigurationsDeviceFiltered = this.filterConfigurations(savedConfigs, true);
        List<ProfilingConfiguration> defaultConfigs = ProfilingConfiguration.getDefaultProfilingConfigurations();
        this.myDefaultProfilingConfigurations = this.filterConfigurations(defaultConfigs, true);
        Common.Device selectedDevice = this.myProfilers.getDevice();
        boolean bl = isSimplePerfEnabled = selectedDevice != null && selectedDevice.getFeatureLevel() >= 26 && this.myProfilers.getIdeServices().getFeatureConfig().isSimplePerfEnabled();
        if (this.myProfilingConfiguration == null) {
            this.myProfilingConfiguration = this.myProfilers.getIdeServices().isNativeProfilingConfigurationPreferred() && isSimplePerfEnabled ? (ProfilingConfiguration)Iterables.find(defaultConfigs, pref -> pref != null && pref.getProfilerType() == CpuProfiler.CpuProfilerType.SIMPLEPERF) : (ProfilingConfiguration)Iterables.find(defaultConfigs, pref -> pref != null && pref.getProfilerType() == CpuProfiler.CpuProfilerType.ART && pref.getMode() == CpuProfiler.CpuProfilingAppStartRequest.Mode.SAMPLED);
        }
    }

    private List<ProfilingConfiguration> filterConfigurations(List<ProfilingConfiguration> configurations, boolean filterOnDevice) {
        Common.Device selectedDevice = this.myProfilers.getDevice();
        Predicate<ProfilingConfiguration> filter = pref -> {
            if (selectedDevice != null && pref.getRequiredDeviceLevel() > selectedDevice.getFeatureLevel() && filterOnDevice) {
                return false;
            }
            if (pref.getProfilerType() == CpuProfiler.CpuProfilerType.SIMPLEPERF) {
                return this.myProfilers.getIdeServices().getFeatureConfig().isSimplePerfEnabled();
            }
            if (pref.getProfilerType() == CpuProfiler.CpuProfilerType.ATRACE) {
                return this.myProfilers.getIdeServices().getFeatureConfig().isAtraceEnabled();
            }
            return true;
        };
        return configurations.stream().filter(filter).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerConfigModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerConfigModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomProfilingConfigurations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomProfilingConfigurationsDeviceFiltered";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProfilingConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setProfilingConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

