/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AxisComponentModel;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DefaultDataSeries;
import com.android.tools.adtui.model.DefaultDurationData;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.model.FilterModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SelectionListener;
import com.android.tools.adtui.model.SelectionModel;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.UpdatableManager;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.analytics.FilterMetadata;
import com.android.tools.profilers.cpu.CaptureModel;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureParser;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerConfigModel;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfilerStage
extends Stage
implements CodeNavigator.Listener {
    private static final String HAS_USED_CPU_CAPTURE = "cpu.used.capture";
    private static final SingleUnitAxisFormatter CPU_USAGE_FORMATTER = new SingleUnitAxisFormatter(1, 5, 10, "%");
    private static final SingleUnitAxisFormatter NUM_THREADS_AXIS = new SingleUnitAxisFormatter(1, 5, 1, "");
    static final ProfilingConfiguration EDIT_CONFIGURATIONS_ENTRY = new ProfilingConfiguration();
    static final ProfilingConfiguration CONFIG_SEPARATOR_ENTRY = new ProfilingConfiguration();
    private static final long INVALID_CAPTURE_START_TIME = Long.MAX_VALUE;
    private static final CaptureModel.Details.Type DEFAULT_CAPTURE_DETAILS = CaptureModel.Details.Type.CALL_CHART;
    private final CpuThreadsModel myThreadsStates;
    private final AxisComponentModel myCpuUsageAxis;
    private final AxisComponentModel myThreadCountAxis;
    private final AxisComponentModel myTimeAxisGuide;
    private final DetailedCpuUsage myCpuUsage;
    private final CpuStageLegends myLegends;
    private final DurationDataModel<CpuTraceInfo> myTraceDurations;
    private final EventMonitor myEventMonitor;
    private final SelectionModel mySelectionModel;
    private final EaseOutModel myInstructionsEaseOutModel;
    private final CpuProfilerConfigModel myProfilerModel;
    @NotNull
    private final DurationDataModel<DefaultDurationData> myInProgressTraceDuration;
    @NotNull
    private final DefaultDataSeries<DefaultDurationData> myInProgressTraceSeries;
    @NotNull
    private final CpuTraceDataSeries myCpuTraceDataSeries;
    private final AspectModel<CpuProfilerAspect> myAspect;
    @NotNull
    private final CaptureModel myCaptureModel;
    @NotNull
    private CaptureState myCaptureState;
    private long myCaptureStartTimeNs;
    private CaptureElapsedTimeUpdatable myCaptureElapsedTimeUpdatable;
    @NotNull
    private final UpdatableManager myUpdatableManager;
    private final CpuCaptureParser myCaptureParser;
    private boolean mySelectionFailure;

    public CpuProfilerStage(final @NotNull StudioProfilers profilers) {
        if (profilers == null) {
            CpuProfilerStage.$$$reportNull$$$0(0);
        }
        super(profilers);
        this.myAspect = new AspectModel();
        this.myCaptureState = CaptureState.IDLE;
        this.myCpuTraceDataSeries = new CpuTraceDataSeries();
        this.myProfilerModel = new CpuProfilerConfigModel(profilers, this);
        Range viewRange = this.getStudioProfilers().getTimeline().getViewRange();
        Range dataRange = this.getStudioProfilers().getTimeline().getDataRange();
        Range selectionRange = this.getStudioProfilers().getTimeline().getSelectionRange();
        this.myCpuUsage = new DetailedCpuUsage(profilers);
        this.myCpuUsageAxis = new AxisComponentModel(this.myCpuUsage.getCpuRange(), (BaseAxisFormatter)CPU_USAGE_FORMATTER);
        this.myCpuUsageAxis.setClampToMajorTicks(true);
        this.myThreadCountAxis = new AxisComponentModel(this.myCpuUsage.getThreadRange(), (BaseAxisFormatter)NUM_THREADS_AXIS);
        this.myThreadCountAxis.setClampToMajorTicks(true);
        this.myTimeAxisGuide = new AxisComponentModel(viewRange, (BaseAxisFormatter)TimeAxisFormatter.DEFAULT_WITHOUT_MINOR_TICKS);
        this.myTimeAxisGuide.setGlobalRange(dataRange);
        this.myLegends = new CpuStageLegends(this.myCpuUsage, dataRange);
        this.myTraceDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)this.getCpuTraceDataSeries()));
        this.myThreadsStates = new CpuThreadsModel(viewRange, this, this.getStudioProfilers().getSession());
        this.myInProgressTraceSeries = new DefaultDataSeries();
        this.myInProgressTraceDuration = new DurationDataModel(new RangedSeries(viewRange, this.myInProgressTraceSeries));
        this.myEventMonitor = new EventMonitor(profilers);
        this.mySelectionModel = new SelectionModel(selectionRange);
        this.mySelectionModel.addConstraint(this.myTraceDurations);
        this.mySelectionModel.addListener(new SelectionListener(){

            public void selectionCreated() {
                CpuProfilerStage.this.mySelectionFailure = false;
                profilers.getIdeServices().getFeatureTracker().trackSelectRange();
                CpuProfilerStage.this.selectionChanged();
            }

            public void selectionCleared() {
                CpuProfilerStage.this.mySelectionFailure = false;
                CpuProfilerStage.this.selectionChanged();
            }

            public void selectionCreationFailure() {
                CpuProfilerStage.this.mySelectionFailure = true;
                CpuProfilerStage.this.selectionChanged();
                CpuProfilerStage.this.setProfilerMode(ProfilerMode.EXPANDED);
            }
        });
        this.myInstructionsEaseOutModel = new EaseOutModel(profilers.getUpdater(), PROFILING_INSTRUCTIONS_EASE_OUT_NS);
        this.myCaptureElapsedTimeUpdatable = new CaptureElapsedTimeUpdatable();
        this.updateProfilingState();
        this.myProfilerModel.updateProfilingConfigurations();
        this.myCaptureModel = new CaptureModel(this);
        this.myUpdatableManager = new UpdatableManager(this.getStudioProfilers().getUpdater());
        this.myCaptureParser = new CpuCaptureParser(this.getStudioProfilers().getIdeServices());
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuProfilerStage.class);
    }

    public boolean hasUserUsedCpuCapture() {
        return this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getBoolean(HAS_USED_CPU_CAPTURE, false);
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this.mySelectionModel;
        if (selectionModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(1);
        }
        return selectionModel;
    }

    @NotNull
    public EaseOutModel getInstructionsEaseOutModel() {
        EaseOutModel easeOutModel = this.myInstructionsEaseOutModel;
        if (easeOutModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(2);
        }
        return easeOutModel;
    }

    public AxisComponentModel getCpuUsageAxis() {
        return this.myCpuUsageAxis;
    }

    public AxisComponentModel getThreadCountAxis() {
        return this.myThreadCountAxis;
    }

    public AxisComponentModel getTimeAxisGuide() {
        return this.myTimeAxisGuide;
    }

    public DetailedCpuUsage getCpuUsage() {
        return this.myCpuUsage;
    }

    public CpuStageLegends getLegends() {
        return this.myLegends;
    }

    public DurationDataModel<CpuTraceInfo> getTraceDurations() {
        return this.myTraceDurations;
    }

    @NotNull
    public DurationDataModel<DefaultDurationData> getInProgressTraceDuration() {
        DurationDataModel<DefaultDurationData> durationDataModel = this.myInProgressTraceDuration;
        if (durationDataModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(3);
        }
        return durationDataModel;
    }

    public String getName() {
        return "CPU";
    }

    public EventMonitor getEventMonitor() {
        return this.myEventMonitor;
    }

    public boolean isSelectionFailure() {
        return this.mySelectionFailure;
    }

    @Override
    public void enter() {
        this.myEventMonitor.enter();
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().register(this.myInProgressTraceDuration);
        this.getStudioProfilers().getUpdater().register(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myThreadCountAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myTimeAxisGuide);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myLegends);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myThreadsStates);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCaptureElapsedTimeUpdatable);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().addListener(this);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getClass());
        this.getStudioProfilers().addDependency(this).onChange((Enum)ProfilerAspect.DEVICES, this.myProfilerModel::updateProfilingConfigurations);
    }

    @Override
    public void exit() {
        this.myEventMonitor.exit();
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().unregister(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().unregister(this.myInProgressTraceDuration);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myThreadCountAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myTimeAxisGuide);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myLegends);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myThreadsStates);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCaptureElapsedTimeUpdatable);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().removeListener(this);
        this.getStudioProfilers().removeDependencies(this);
        this.mySelectionModel.clearListeners();
        this.myUpdatableManager.releaseAll();
    }

    @NotNull
    public UpdatableManager getUpdatableManager() {
        UpdatableManager updatableManager = this.myUpdatableManager;
        if (updatableManager == null) {
            CpuProfilerStage.$$$reportNull$$$0(4);
        }
        return updatableManager;
    }

    public AspectModel<CpuProfilerAspect> getAspect() {
        return this.myAspect;
    }

    public void startCapturing() {
        ProfilingConfiguration config = this.myProfilerModel.getProfilingConfiguration();
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getStudioProfilers().getClient().getCpuClient();
        CpuProfiler.CpuProfilingAppStartRequest request = CpuProfiler.CpuProfilingAppStartRequest.newBuilder().setSession(this.getStudioProfilers().getSession()).setMode(config.getMode()).setProfilerType(config.getProfilerType()).setBufferSizeInMb(config.getProfilingBufferSizeInMb()).setSamplingIntervalUs(config.getProfilingSamplingIntervalUs()).setAbiCpuArch(this.getStudioProfilers().getProcess().getAbiCpuArch()).build();
        this.setCaptureState(CaptureState.STARTING);
        CompletableFuture.supplyAsync(() -> cpuService.startProfilingApp(request), this.getStudioProfilers().getIdeServices().getPoolExecutor()).thenAcceptAsync(response -> this.startCapturingCallback((CpuProfiler.CpuProfilingAppStartResponse)response, config), this.getStudioProfilers().getIdeServices().getMainExecutor());
        this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setBoolean(HAS_USED_CPU_CAPTURE, true);
        this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
    }

    private void startCapturingCallback(CpuProfiler.CpuProfilingAppStartResponse response, ProfilingConfiguration profilingConfiguration) {
        if (response.getStatus().equals((Object)CpuProfiler.CpuProfilingAppStartResponse.Status.SUCCESS)) {
            this.myProfilerModel.setActiveConfig(profilingConfiguration.getProfilerType(), profilingConfiguration.getMode(), profilingConfiguration.getProfilingBufferSizeInMb(), profilingConfiguration.getProfilingSamplingIntervalUs());
            this.setCaptureState(CaptureState.CAPTURING);
            this.myCaptureStartTimeNs = this.currentTimeNs();
            this.myInProgressTraceSeries.clear();
            this.myInProgressTraceSeries.add(TimeUnit.NANOSECONDS.toMicros(this.myCaptureStartTimeNs), (Object)new DefaultDurationData(Long.MAX_VALUE));
            this.getStudioProfilers().getTimeline().setStreaming(true);
        } else {
            CpuProfilerStage.getLogger().warn("Unable to start tracing: " + response.getStatus());
            CpuProfilerStage.getLogger().warn(response.getErrorMessage());
            this.setCaptureState(CaptureState.START_FAILURE);
            this.getStudioProfilers().getIdeServices().showErrorBalloon("Recording failed to start", "Try recording again, or report a bug by selecting Help > Submit Feedback.");
            this.setCaptureState(CaptureState.IDLE);
        }
    }

    public void stopCapturing() {
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getStudioProfilers().getClient().getCpuClient();
        CpuProfiler.CpuProfilingAppStopRequest request = CpuProfiler.CpuProfilingAppStopRequest.newBuilder().setProfilerType(this.myProfilerModel.getActiveConfig().getProfilerType()).setSession(this.getStudioProfilers().getSession()).build();
        this.setCaptureState(CaptureState.STOPPING);
        this.myInProgressTraceSeries.clear();
        CompletableFuture.supplyAsync(() -> cpuService.stopProfilingApp(request), this.getStudioProfilers().getIdeServices().getPoolExecutor()).thenAcceptAsync(this::stopCapturingCallback, this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    public long getCaptureElapsedTimeUs() {
        return TimeUnit.NANOSECONDS.toMicros(this.currentTimeNs() - this.myCaptureStartTimeNs);
    }

    private void stopCapturingCallback(CpuProfiler.CpuProfilingAppStopResponse response) {
        CpuCaptureMetadata captureMetadata = new CpuCaptureMetadata(this.myProfilerModel.getActiveConfig());
        if (!response.getStatus().equals((Object)CpuProfiler.CpuProfilingAppStopResponse.Status.SUCCESS)) {
            CpuProfilerStage.getLogger().warn("Unable to stop tracing: " + response.getStatus());
            CpuProfilerStage.getLogger().warn(response.getErrorMessage());
            this.setCaptureState(CaptureState.STOP_FAILURE);
            this.getStudioProfilers().getIdeServices().showErrorBalloon("Recording failed to stop", "Try recording another method trace, or report a bug by selecting Help > Submit Feedback.");
            this.setCaptureState(CaptureState.IDLE);
            captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.STOP_CAPTURING_FAILURE);
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
        } else {
            this.setCaptureState(CaptureState.PARSING);
            ByteString traceBytes = response.getTrace();
            captureMetadata.setTraceFileSizeBytes(traceBytes.size());
            this.handleCaptureParsing(response.getTraceId(), traceBytes, captureMetadata);
        }
    }

    private void handleCaptureParsing(int traceId, ByteString traceBytes, CpuCaptureMetadata captureMetadata) {
        long beforeParsingTime = System.currentTimeMillis();
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.parse(this.getStudioProfilers().getSession(), traceId, traceBytes, this.myProfilerModel.getActiveConfig().getProfilerType());
        if (capture == null) {
            this.setCaptureState(CaptureState.IDLE);
            captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING);
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
            return;
        }
        Consumer<CpuCapture> parsingCallback = parsedCapture -> {
            if (parsedCapture != null) {
                this.setCaptureState(CaptureState.IDLE);
                this.setAndSelectCapture((CpuCapture)parsedCapture);
                this.setCaptureDetails(DEFAULT_CAPTURE_DETAILS);
                this.saveTraceInfo(traceId, (CpuCapture)parsedCapture);
                captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.SUCCESS);
                captureMetadata.setParsingTimeMs(System.currentTimeMillis() - beforeParsingTime);
                captureMetadata.setCaptureDurationMs(TimeUnit.MICROSECONDS.toMillis(parsedCapture.getDuration()));
                captureMetadata.setRecordDurationMs(CpuProfilerStage.calculateRecordDurationMs(parsedCapture));
            } else {
                captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILURE);
                this.setCaptureState(CaptureState.PARSING_FAILURE);
                this.getStudioProfilers().getIdeServices().showErrorBalloon("Trace data was not recorded", "The profiler was unable to parse the method trace data. Try recording another method trace, or report a bug by selecting Help > Submit Feedback.");
                this.setCaptureState(CaptureState.IDLE);
                this.setCapture(null);
            }
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
        };
        capture.handleAsync((parsedCapture, exception) -> {
            if (parsedCapture == null) {
                assert (exception != null);
                CpuProfilerStage.getLogger().warn("Unable to parse capture: " + exception.getMessage());
            }
            parsingCallback.accept((CpuCapture)parsedCapture);
            return parsedCapture;
        }, this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    private static long calculateRecordDurationMs(CpuCapture capture) {
        Range maxDataRange = new Range();
        for (CpuThreadInfo thread : capture.getThreads()) {
            CaptureNode threadMainNode = capture.getCaptureNode(thread.getId());
            assert (threadMainNode != null);
            maxDataRange.expand((double)threadMainNode.getStartGlobal(), (double)threadMainNode.getEndGlobal());
        }
        return TimeUnit.MICROSECONDS.toMillis((long)maxDataRange.getLength());
    }

    private void saveTraceInfo(int traceId, @NotNull CpuCapture capture) {
        if (capture == null) {
            CpuProfilerStage.$$$reportNull$$$0(5);
        }
        long captureFrom = TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMin());
        long captureTo = TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMax());
        ArrayList<CpuProfiler.Thread> threads = new ArrayList<CpuProfiler.Thread>();
        for (CpuThreadInfo thread : capture.getThreads()) {
            threads.add(CpuProfiler.Thread.newBuilder().setTid(thread.getId()).setName(thread.getName()).build());
        }
        CpuProfiler.TraceInfo traceInfo = CpuProfiler.TraceInfo.newBuilder().setTraceId(traceId).setFromTimestamp(captureFrom).setToTimestamp(captureTo).setProfilerType(this.myProfilerModel.getActiveConfig().getProfilerType()).addAllThreads(threads).build();
        CpuProfiler.SaveTraceInfoRequest request = CpuProfiler.SaveTraceInfoRequest.newBuilder().setSession(this.getStudioProfilers().getSession()).setTraceInfo(traceInfo).build();
        CpuServiceGrpc.CpuServiceBlockingStub service = this.getStudioProfilers().getClient().getCpuClient();
        service.saveTraceInfo(request);
    }

    private void updateProfilingState() {
        CpuProfiler.ProfilingStateRequest request;
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getStudioProfilers().getClient().getCpuClient();
        CpuProfiler.ProfilingStateResponse response = cpuService.checkAppProfilingState(request = CpuProfiler.ProfilingStateRequest.newBuilder().setSession(this.getStudioProfilers().getSession()).setTimestamp(this.currentTimeNs()).build());
        if (response.getBeingProfiled()) {
            long elapsedTime = response.getCheckTimestamp() - response.getStartTimestamp();
            this.myCaptureStartTimeNs = this.currentTimeNs() - elapsedTime;
            this.myCaptureState = CaptureState.CAPTURING;
            this.myInProgressTraceSeries.clear();
            this.myInProgressTraceSeries.add(TimeUnit.NANOSECONDS.toMicros(this.myCaptureStartTimeNs), (Object)new DefaultDurationData(Long.MAX_VALUE));
            CpuProfiler.CpuProfilingAppStartRequest startRequest = response.getStartRequest();
            this.myProfilerModel.setActiveConfig(startRequest.getProfilerType(), startRequest.getMode(), startRequest.getBufferSizeInMb(), startRequest.getSamplingIntervalUs());
        } else {
            this.myCaptureStartTimeNs = Long.MAX_VALUE;
            this.myCaptureState = CaptureState.IDLE;
        }
    }

    private void selectionChanged() {
        Range range = this.getStudioProfilers().getTimeline().getSelectionRange();
        List infoList = this.getTraceDurations().getSeries().getDataSeries().getDataForXRange(range);
        for (SeriesData info : infoList) {
            Range captureRange = ((CpuTraceInfo)info.value).getRange();
            if (captureRange.getIntersection(range).isEmpty()) continue;
            this.setCapture(((CpuTraceInfo)info.value).getTraceId());
            return;
        }
        this.setCapture(null);
    }

    private long currentTimeNs() {
        return TimeUnit.MICROSECONDS.toNanos((long)this.getStudioProfilers().getTimeline().getDataRange().getMax());
    }

    void setCapture(@Nullable CpuCapture capture) {
        this.myCaptureModel.setCapture(capture);
        this.setProfilerMode(capture == null ? ProfilerMode.NORMAL : ProfilerMode.EXPANDED);
    }

    private void setCapture(int traceId) {
        CompletableFuture<CpuCapture> future = this.getCaptureFuture(traceId);
        if (future != null) {
            future.handleAsync((capture, exception) -> {
                this.setCapture((CpuCapture)capture);
                return capture;
            }, this.getStudioProfilers().getIdeServices().getMainExecutor());
        }
    }

    public void setAndSelectCapture(int traceId) {
        CompletableFuture<CpuCapture> future = this.getCaptureFuture(traceId);
        if (future != null) {
            future.handleAsync((capture, exception) -> {
                this.setAndSelectCapture((CpuCapture)capture);
                return capture;
            }, this.getStudioProfilers().getIdeServices().getMainExecutor());
        }
    }

    public void setAndSelectCapture(@NotNull CpuCapture capture) {
        if (capture == null) {
            CpuProfilerStage.$$$reportNull$$$0(6);
        }
        ProfilerTimeline timeline = this.getStudioProfilers().getTimeline();
        timeline.getSelectionRange().set(capture.getRange());
        this.setCapture(capture);
    }

    public int getSelectedThread() {
        return this.myCaptureModel.getThread();
    }

    public void setSelectedThread(int id) {
        this.myCaptureModel.setThread(id);
        Range range = this.getStudioProfilers().getTimeline().getSelectionRange();
        if (range.isEmpty()) {
            this.mySelectionFailure = true;
            this.myAspect.changed((Enum)CpuProfilerAspect.SELECTED_THREADS);
            this.setProfilerMode(ProfilerMode.EXPANDED);
        }
    }

    @NotNull
    public List<ClockType> getClockTypes() {
        ImmutableList immutableList = ImmutableList.of((Object)ClockType.GLOBAL, (Object)ClockType.THREAD);
        if (immutableList == null) {
            CpuProfilerStage.$$$reportNull$$$0(7);
        }
        return immutableList;
    }

    @NotNull
    public ClockType getClockType() {
        ClockType clockType = this.myCaptureModel.getClockType();
        if (clockType == null) {
            CpuProfilerStage.$$$reportNull$$$0(8);
        }
        return clockType;
    }

    public void setClockType(@NotNull ClockType clockType) {
        if (clockType == null) {
            CpuProfilerStage.$$$reportNull$$$0(9);
        }
        this.myCaptureModel.setClockType(clockType);
    }

    @Nullable
    public CpuCapture getCapture() {
        return this.myCaptureModel.getCapture();
    }

    @NotNull
    public CaptureState getCaptureState() {
        CaptureState captureState = this.myCaptureState;
        if (captureState == null) {
            CpuProfilerStage.$$$reportNull$$$0(10);
        }
        return captureState;
    }

    private void setCaptureState(@NotNull CaptureState captureState) {
        if (captureState == null) {
            CpuProfilerStage.$$$reportNull$$$0(11);
        }
        this.myCaptureState = captureState;
        this.myCaptureStartTimeNs = Long.MAX_VALUE;
        this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_STATE);
    }

    public void setCaptureFilter(@Nullable Pattern filter) {
        this.myCaptureModel.setFilter(filter);
    }

    public void setCaptureFilter(@Nullable Pattern filter, @NotNull FilterModel model) {
        if (model == null) {
            CpuProfilerStage.$$$reportNull$$$0(12);
        }
        this.setCaptureFilter(filter);
        this.trackFilterUsage(filter, model);
    }

    private void trackFilterUsage(@Nullable Pattern filter, @NotNull FilterModel model) {
        if (model == null) {
            CpuProfilerStage.$$$reportNull$$$0(13);
        }
        FilterMetadata filterMetadata = new FilterMetadata();
        FeatureTracker featureTracker = this.getStudioProfilers().getIdeServices().getFeatureTracker();
        CaptureModel.Details details = this.getCaptureDetails();
        switch (details.getType()) {
            case TOP_DOWN: {
                filterMetadata.setView(FilterMetadata.View.CPU_TOP_DOWN);
                break;
            }
            case BOTTOM_UP: {
                filterMetadata.setView(FilterMetadata.View.CPU_BOTTOM_UP);
                break;
            }
            case CALL_CHART: {
                filterMetadata.setView(FilterMetadata.View.CPU_CALL_CHART);
                break;
            }
            case FLAME_CHART: {
                filterMetadata.setView(FilterMetadata.View.CPU_FLAME_CHART);
            }
        }
        filterMetadata.setFeaturesUsed(model.getIsMatchCase(), model.getIsRegex());
        filterMetadata.setMatchedElementCount(this.myCaptureModel.getFilterNodeCount());
        filterMetadata.setTotalElementCount(this.myCaptureModel.getNodeCount());
        filterMetadata.setFilterTextLength(filter == null ? 0 : filter.pattern().length());
        featureTracker.trackFilterMetadata(filterMetadata);
    }

    public void openProfilingConfigurationsDialog() {
        Consumer<ProfilingConfiguration> dialogCallback = configuration -> {
            this.myAspect.changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
            if (configuration != null) {
                this.setProfilingConfiguration((ProfilingConfiguration)configuration);
            }
        };
        Common.Device selectedDevice = this.getStudioProfilers().getDevice();
        int deviceFeatureLevel = selectedDevice != null ? selectedDevice.getFeatureLevel() : 0;
        this.getStudioProfilers().getIdeServices().openCpuProfilingConfigurationsDialog(this.myProfilerModel, deviceFeatureLevel, dialogCallback);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackOpenProfilingConfigDialog();
    }

    @NotNull
    public ProfilingConfiguration getProfilingConfiguration() {
        ProfilingConfiguration profilingConfiguration = this.myProfilerModel.getProfilingConfiguration();
        if (profilingConfiguration == null) {
            CpuProfilerStage.$$$reportNull$$$0(14);
        }
        return profilingConfiguration;
    }

    public void setProfilingConfiguration(@NotNull ProfilingConfiguration mode) {
        if (mode == null) {
            CpuProfilerStage.$$$reportNull$$$0(15);
        }
        if (mode == EDIT_CONFIGURATIONS_ENTRY) {
            this.openProfilingConfigurationsDialog();
        } else if (mode != CONFIG_SEPARATOR_ENTRY) {
            this.myProfilerModel.setProfilingConfiguration(mode);
        }
        this.myAspect.changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
    }

    @NotNull
    public List<ProfilingConfiguration> getProfilingConfigurations() {
        ArrayList<ProfilingConfiguration> configs = new ArrayList<ProfilingConfiguration>();
        configs.add(EDIT_CONFIGURATIONS_ENTRY);
        List<ProfilingConfiguration> customEntries = this.myProfilerModel.getCustomProfilingConfigurationsDeviceFiltered();
        if (!customEntries.isEmpty()) {
            configs.add(CONFIG_SEPARATOR_ENTRY);
            configs.addAll(customEntries);
        }
        configs.add(CONFIG_SEPARATOR_ENTRY);
        configs.addAll(this.myProfilerModel.getDefaultProfilingConfigurations());
        ArrayList<ProfilingConfiguration> arrayList = configs;
        if (arrayList == null) {
            CpuProfilerStage.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    public CpuTraceDataSeries getCpuTraceDataSeries() {
        CpuTraceDataSeries cpuTraceDataSeries = this.myCpuTraceDataSeries;
        if (cpuTraceDataSeries == null) {
            CpuProfilerStage.$$$reportNull$$$0(17);
        }
        return cpuTraceDataSeries;
    }

    @NotNull
    public CpuThreadsModel getThreadStates() {
        CpuThreadsModel cpuThreadsModel = this.myThreadsStates;
        if (cpuThreadsModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(18);
        }
        return cpuThreadsModel;
    }

    @Nullable
    public CompletableFuture<CpuCapture> getCaptureFuture(int traceId) {
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.getCapture(traceId);
        if (capture == null) {
            CpuProfiler.GetTraceRequest request = CpuProfiler.GetTraceRequest.newBuilder().setSession(this.getStudioProfilers().getSession()).setTraceId(traceId).build();
            CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getStudioProfilers().getClient().getCpuClient();
            CpuProfiler.GetTraceResponse trace = cpuService.getTrace(request);
            if (trace.getStatus() == CpuProfiler.GetTraceResponse.Status.SUCCESS) {
                capture = this.myCaptureParser.parse(this.getStudioProfilers().getSession(), traceId, trace.getData(), trace.getProfilerType());
            }
        }
        return capture;
    }

    public void setCaptureDetails(@Nullable CaptureModel.Details.Type type) {
        this.myCaptureModel.setDetails(type);
    }

    @Nullable
    public CaptureModel.Details getCaptureDetails() {
        return this.myCaptureModel.getDetails();
    }

    @Override
    public void onNavigated(@NotNull CodeLocation location) {
        if (location == null) {
            CpuProfilerStage.$$$reportNull$$$0(19);
        }
        this.setProfilerMode(ProfilerMode.NORMAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerStage";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capture";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clockType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureState";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerStage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructionsEaseOutModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInProgressTraceDuration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatableManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClockTypes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getClockType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureState";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingConfiguration";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingConfigurations";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuTraceDataSeries";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveTraceInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setAndSelectCapture";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setClockType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setCaptureState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setCaptureFilter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "trackFilterUsage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setProfilingConfiguration";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "onNavigated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CpuStageLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myCpuLegend;
        @NotNull
        private final SeriesLegend myOthersLegend;
        @NotNull
        private final SeriesLegend myThreadsLegend;

        public CpuStageLegends(@NotNull DetailedCpuUsage cpuUsage, @NotNull Range dataRange) {
            if (cpuUsage == null) {
                CpuStageLegends.$$$reportNull$$$0(0);
            }
            if (dataRange == null) {
                CpuStageLegends.$$$reportNull$$$0(1);
            }
            super(100);
            this.myCpuLegend = new SeriesLegend(cpuUsage.getCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myOthersLegend = new SeriesLegend(cpuUsage.getOtherCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myThreadsLegend = new SeriesLegend(cpuUsage.getThreadsCountSeries(), (BaseAxisFormatter)NUM_THREADS_AXIS, dataRange, Interpolatable.SteppedLineInterpolator);
            this.add((Legend)this.myCpuLegend);
            this.add((Legend)this.myOthersLegend);
            this.add((Legend)this.myThreadsLegend);
        }

        @NotNull
        public SeriesLegend getCpuLegend() {
            SeriesLegend seriesLegend = this.myCpuLegend;
            if (seriesLegend == null) {
                CpuStageLegends.$$$reportNull$$$0(2);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getOthersLegend() {
            SeriesLegend seriesLegend = this.myOthersLegend;
            if (seriesLegend == null) {
                CpuStageLegends.$$$reportNull$$$0(3);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getThreadsLegend() {
            SeriesLegend seriesLegend = this.myThreadsLegend;
            if (seriesLegend == null) {
                CpuStageLegends.$$$reportNull$$$0(4);
            }
            return seriesLegend;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpuUsage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataRange";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerStage$CpuStageLegends";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerStage$CpuStageLegends";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCpuLegend";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOthersLegend";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThreadsLegend";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @VisibleForTesting
    class CpuTraceDataSeries
    implements DataSeries<CpuTraceInfo> {
        CpuTraceDataSeries() {
        }

        public List<SeriesData<CpuTraceInfo>> getDataForXRange(Range xRange) {
            long rangeMin = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMin());
            long rangeMax = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMax());
            CpuServiceGrpc.CpuServiceBlockingStub cpuService = CpuProfilerStage.this.getStudioProfilers().getClient().getCpuClient();
            CpuProfiler.GetTraceInfoResponse response = cpuService.getTraceInfo(CpuProfiler.GetTraceInfoRequest.newBuilder().setSession(CpuProfilerStage.this.getStudioProfilers().getSession()).setFromTimestamp(rangeMin).setToTimestamp(rangeMax).build());
            ArrayList<SeriesData<CpuTraceInfo>> seriesData = new ArrayList<SeriesData<CpuTraceInfo>>();
            for (CpuProfiler.TraceInfo protoTraceInfo : response.getTraceInfoList()) {
                CpuTraceInfo info = new CpuTraceInfo(protoTraceInfo);
                seriesData.add((SeriesData<CpuTraceInfo>)new SeriesData((long)info.getRange().getMin(), (Object)info));
            }
            return seriesData;
        }
    }

    private class CaptureElapsedTimeUpdatable
    implements Updatable {
        private CaptureElapsedTimeUpdatable() {
        }

        public void update(long elapsedNs) {
            if (CpuProfilerStage.this.myCaptureState == CaptureState.CAPTURING) {
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME);
            }
        }
    }

    public static enum CaptureState {
        IDLE,
        CAPTURING,
        PARSING,
        PARSING_FAILURE,
        STARTING,
        START_FAILURE,
        STOPPING,
        STOP_FAILURE;

    }

    public static enum ThreadState {
        RUNNING,
        RUNNING_CAPTURED,
        SLEEPING,
        SLEEPING_CAPTURED,
        DEAD,
        DEAD_CAPTURED,
        WAITING,
        WAITING_CAPTURED,
        UNKNOWN;

    }
}

