/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.SelectionComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.linechart.DurationDataRenderer;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineChartCustomRenderer;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.chart.linechart.OverlayComponent;
import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.flat.FlatButton;
import com.android.tools.adtui.instructions.IconInstruction;
import com.android.tools.adtui.instructions.InstructionsPanel;
import com.android.tools.adtui.instructions.NewRowInstruction;
import com.android.tools.adtui.instructions.RenderInstruction;
import com.android.tools.adtui.instructions.TextInstruction;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.updater.UpdatableManager;
import com.android.tools.profilers.JComboBoxView;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayeredPane;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerScrollbar;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureView;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.CpuThreadsTooltip;
import com.android.tools.profilers.cpu.CpuThreadsTooltipView;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.CpuUsageTooltip;
import com.android.tools.profilers.cpu.CpuUsageTooltipView;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.event.EventMonitorView;
import com.android.tools.profilers.stacktrace.LoadingPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfilerStageView
extends StageView<CpuProfilerStage> {
    private final CpuProfilerStage myStage;
    private final JButton myCaptureButton;
    private final JLabel myCaptureStatus;
    private final JBList<CpuThreadsModel.RangedCpuThread> myThreads;
    @NotNull
    private final JBSplitter mySplitter;
    @NotNull
    private final LoadingPanel myCaptureViewLoading;
    @Nullable
    private CpuCaptureView myCaptureView;
    @NotNull
    private final JComboBox<ProfilingConfiguration> myProfilingConfigurationCombo;
    @NotNull
    private final JPanel myHelpTipPanel;

    public CpuProfilerStageView(@NotNull StudioProfilersView profilersView, @NotNull CpuProfilerStage stage) {
        if (profilersView == null) {
            CpuProfilerStageView.$$$reportNull$$$0(0);
        }
        if (stage == null) {
            CpuProfilerStageView.$$$reportNull$$$0(1);
        }
        super(profilersView, stage);
        this.myStage = stage;
        stage.getAspect().addDependency((AspectObserver)this).onChange((Enum)CpuProfilerAspect.CAPTURE_STATE, this::updateCaptureState).onChange((Enum)CpuProfilerAspect.CAPTURE_SELECTION, this::updateCaptureSelection).onChange((Enum)CpuProfilerAspect.SELECTED_THREADS, this::updateThreadSelection).onChange((Enum)CpuProfilerAspect.CAPTURE_DETAILS, this::updateCaptureDetails).onChange((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME, this::updateCaptureElapsedTime);
        this.getTooltipBinder().bind(CpuUsageTooltip.class, CpuUsageTooltipView::new);
        this.getTooltipBinder().bind(CpuThreadsTooltip.class, CpuThreadsTooltipView::new);
        StudioProfilers profilers = stage.getStudioProfilers();
        ProfilerTimeline timeline = profilers.getTimeline();
        TabularLayout layout = new TabularLayout("*");
        JPanel details = new JPanel((LayoutManager)layout);
        details.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        EventMonitorView eventsView = new EventMonitorView(profilersView, stage.getEventMonitor());
        JComponent eventsComponent = eventsView.getComponent();
        JBPanel monitorPanel = new JBPanel((LayoutManager)new TabularLayout("*", "*"));
        monitorPanel.setOpaque(false);
        monitorPanel.setBorder(ProfilerLayout.MONITOR_BORDER);
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent leftAxis = new AxisComponent(((CpuProfilerStage)this.getStage()).getCpuUsageAxis(), AxisComponent.AxisOrientation.RIGHT);
        leftAxis.setShowAxisLine(false);
        leftAxis.setShowMax(true);
        leftAxis.setShowUnitAtMax(true);
        leftAxis.setHideTickAtMin(true);
        leftAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        leftAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)leftAxis, "West");
        AxisComponent rightAxis = new AxisComponent(((CpuProfilerStage)this.getStage()).getThreadCountAxis(), AxisComponent.AxisOrientation.LEFT);
        rightAxis.setShowAxisLine(false);
        rightAxis.setShowMax(true);
        rightAxis.setShowUnitAtMax(true);
        rightAxis.setHideTickAtMin(true);
        rightAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        rightAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)rightAxis, "East");
        SelectionComponent selection = new SelectionComponent(((CpuProfilerStage)this.getStage()).getSelectionModel(), timeline.getViewRange());
        selection.setCursorSetter(ProfilerLayeredPane::setCursorOnProfilerLayeredPane);
        JBPanel overlayPanel = new JBPanel((LayoutManager)new BorderLayout());
        overlayPanel.setOpaque(false);
        overlayPanel.setBorder(BorderFactory.createEmptyBorder(ProfilerLayout.Y_AXIS_TOP_MARGIN, 0, 0, 0));
        OverlayComponent overlay = new OverlayComponent((Component)selection);
        overlayPanel.add((Component)overlay, "Center");
        JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
        lineChartPanel.setOpaque(false);
        DetailedCpuUsage cpuUsage = ((CpuProfilerStage)this.getStage()).getCpuUsage();
        LineChart lineChart = new LineChart((LineChartModel)cpuUsage);
        lineChart.configure(cpuUsage.getCpuSeries(), new LineConfig(ProfilerColors.CPU_USAGE).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        lineChart.configure(cpuUsage.getOtherCpuSeries(), new LineConfig(ProfilerColors.CPU_OTHER_USAGE).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        lineChart.configure(cpuUsage.getThreadsCountSeries(), new LineConfig(ProfilerColors.THREADS_COUNT).setStepped(true).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChartPanel.add((Component)lineChart, "Center");
        lineChart.setTopPadding(ProfilerLayout.Y_AXIS_TOP_MARGIN);
        lineChart.setFillEndGap(true);
        CpuProfilerStage.CpuStageLegends legends = ((CpuProfilerStage)this.getStage()).getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.PROFILER_LEGEND_RIGHT_PADDING).build();
        legend.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
        legend.configure((Legend)legends.getCpuLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.CPU_USAGE_CAPTURED));
        legend.configure((Legend)legends.getOthersLegend(), new LegendConfig(LegendConfig.IconType.BOX, ProfilerColors.CPU_OTHER_USAGE_CAPTURED));
        legend.configure((Legend)legends.getThreadsLegend(), new LegendConfig(LegendConfig.IconType.DASHED_LINE, ProfilerColors.THREADS_COUNT_CAPTURED));
        JLabel label = new JLabel(((CpuProfilerStage)this.getStage()).getName());
        label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        label.setVerticalAlignment(1);
        label.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
        JBPanel legendPanel = new JBPanel((LayoutManager)new BorderLayout());
        legendPanel.setOpaque(false);
        legendPanel.add((Component)label, "West");
        legendPanel.add((Component)legend, "East");
        DurationDataRenderer traceRenderer = new DurationDataRenderer.Builder(((CpuProfilerStage)this.getStage()).getTraceDurations(), ProfilerColors.CPU_CAPTURE_EVENT).setDurationBg(ProfilerColors.CPU_CAPTURE_BACKGROUND).setLabelProvider(this::formatCaptureLabel).setLabelColors(ProfilerColors.CPU_DURATION_LABEL_BACKGROUND, Color.BLACK, Color.lightGray, Color.WHITE).setClickHander(traceInfo -> ((CpuProfilerStage)this.getStage()).setAndSelectCapture(traceInfo.getTraceId())).build();
        traceRenderer.addCustomLineConfig(cpuUsage.getCpuSeries(), new LineConfig(ProfilerColors.CPU_USAGE_CAPTURED).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        traceRenderer.addCustomLineConfig(cpuUsage.getOtherCpuSeries(), new LineConfig(ProfilerColors.CPU_OTHER_USAGE_CAPTURED).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        traceRenderer.addCustomLineConfig(cpuUsage.getThreadsCountSeries(), new LineConfig(ProfilerColors.THREADS_COUNT_CAPTURED).setStepped(true).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
        overlay.addDurationDataRenderer(traceRenderer);
        lineChart.addCustomRenderer((LineChartCustomRenderer)traceRenderer);
        DurationDataRenderer inProgressTraceRenderer = new DurationDataRenderer.Builder(((CpuProfilerStage)this.getStage()).getInProgressTraceDuration(), ProfilerColors.CPU_CAPTURE_EVENT).setDurationBg(ProfilerColors.CPU_CAPTURE_BACKGROUND).setLabelColors(ProfilerColors.CPU_DURATION_LABEL_BACKGROUND, Color.BLACK, Color.lightGray, Color.WHITE).build();
        inProgressTraceRenderer.addCustomLineConfig(cpuUsage.getCpuSeries(), new LineConfig(ProfilerColors.CPU_USAGE_CAPTURED).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        inProgressTraceRenderer.addCustomLineConfig(cpuUsage.getOtherCpuSeries(), new LineConfig(ProfilerColors.CPU_OTHER_USAGE_CAPTURED).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
        inProgressTraceRenderer.addCustomLineConfig(cpuUsage.getThreadsCountSeries(), new LineConfig(ProfilerColors.THREADS_COUNT_CAPTURED).setStepped(true).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
        overlay.addDurationDataRenderer(inProgressTraceRenderer);
        lineChart.addCustomRenderer((LineChartCustomRenderer)inProgressTraceRenderer);
        if (!((CpuProfilerStage)this.getStage()).hasUserUsedCpuCapture()) {
            this.installProfilingInstructions((JPanel)monitorPanel);
        }
        monitorPanel.add((Component)axisPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)legendPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)overlayPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)selection, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)lineChartPanel, new TabularLayout.Constraint(0, 0));
        CpuThreadsModel model = this.myStage.getThreadStates();
        this.myThreads = new JBList((ListModel)model);
        this.myThreads.addListSelectionListener(e -> {
            int selectedIndex = this.myThreads.getSelectedIndex();
            if (selectedIndex >= 0) {
                CpuThreadsModel.RangedCpuThread thread = (CpuThreadsModel.RangedCpuThread)model.getElementAt(selectedIndex);
                if (this.myStage.getSelectedThread() != thread.getThreadId()) {
                    this.myStage.setSelectedThread(thread.getThreadId());
                    this.myStage.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectThread();
                }
            } else {
                this.myStage.setSelectedThread(-1);
            }
        });
        this.myThreads.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CpuProfilerStageView.this.myThreads.getSelectedIndex() < 0 && CpuProfilerStageView.this.myThreads.getItemsCount() > 0) {
                    CpuProfilerStageView.this.myThreads.setSelectedIndex(0);
                }
            }
        });
        MyScrollPane scrollingThreads = new MyScrollPane();
        ((JComponent)((Object)scrollingThreads)).setBorder(ProfilerLayout.MONITOR_BORDER);
        ((JScrollPane)((Object)scrollingThreads)).setViewportView((Component)this.myThreads);
        this.myThreads.setCellRenderer((ListCellRenderer)new ThreadCellRenderer((JList<CpuThreadsModel.RangedCpuThread>)this.myThreads, this.myStage.getUpdatableManager()));
        this.myThreads.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        details.add((Component)eventsComponent, new TabularLayout.Constraint(0, 0));
        details.add((Component)this.createTooltip((JPanel)overlayPanel, (JComponent)overlay, this.myThreads), new TabularLayout.Constraint(1, 0, 2, 1));
        MouseAdapter doubleClick = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed()) {
                    CpuProfilerStageView.this.clearSelection();
                }
            }
        };
        overlay.addMouseListener((MouseListener)doubleClick);
        overlayPanel.addMouseListener(doubleClick);
        layout.setRowSizing(1, "4*");
        details.add((Component)monitorPanel, new TabularLayout.Constraint(1, 0));
        layout.setRowSizing(2, "6*");
        final AxisComponent timeAxisGuide = new AxisComponent(this.myStage.getTimeAxisGuide(), AxisComponent.AxisOrientation.BOTTOM);
        timeAxisGuide.setShowAxisLine(false);
        timeAxisGuide.setShowLabels(false);
        timeAxisGuide.setHideTickAtMin(true);
        timeAxisGuide.setMarkerColor(ProfilerColors.CPU_AXIS_GUIDE_COLOR);
        ((Component)((Object)scrollingThreads)).addComponentListener(new ComponentAdapter((JScrollPane)((Object)scrollingThreads)){
            final /* synthetic */ JScrollPane val$scrollingThreads;
            {
                this.val$scrollingThreads = jScrollPane;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                timeAxisGuide.setMarkerLengths(this.val$scrollingThreads.getHeight(), 0);
            }
        });
        details.add((Component)timeAxisGuide, new TabularLayout.Constraint(2, 0));
        details.add((Component)((Object)scrollingThreads), new TabularLayout.Constraint(2, 0));
        JComponent timeAxis = this.buildTimeAxis(profilers);
        details.add((Component)timeAxis, new TabularLayout.Constraint(3, 0));
        ProfilerScrollbar scrollbar = new ProfilerScrollbar(timeline, details);
        details.add((Component)((Object)scrollbar), new TabularLayout.Constraint(4, 0));
        this.myHelpTipPanel = new JPanel(new BorderLayout());
        InstructionsPanel infoMessage = new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(ProfilerLayout.INFO_MESSAGE_HEADER_FONT, "Thread details unavailable"), new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), new TextInstruction(ProfilerLayout.INFO_MESSAGE_DESCRIPTION_FONT, "Click the record button "), new IconInstruction(StudioIcons.Profiler.Toolbar.RECORD, ProfilerLayout.PROFILING_INSTRUCTIONS_ICON_PADDING, null), new TextInstruction(ProfilerLayout.INFO_MESSAGE_DESCRIPTION_FONT, " to start CPU profiling"), new NewRowInstruction(NewRowInstruction.DEFAULT_ROW_MARGIN), new TextInstruction(ProfilerLayout.INFO_MESSAGE_DESCRIPTION_FONT, "or select a capture in the timeline.")}).setColors(JBColor.foreground(), null).build();
        this.myHelpTipPanel.add((Component)infoMessage, "Center");
        this.mySplitter = new JBSplitter(true);
        this.mySplitter.setFirstComponent((JComponent)details);
        this.mySplitter.setSecondComponent(null);
        this.mySplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_HORIZONTAL_BORDERS);
        this.getComponent().add((Component)this.mySplitter, "Center");
        this.myCaptureButton = new FlatButton();
        this.myCaptureButton.addActionListener(event -> this.capture());
        this.myCaptureStatus = new JLabel("");
        this.myCaptureStatus.setFont((Font)AdtUiUtils.DEFAULT_FONT.deriveFont(12.0f));
        this.myCaptureStatus.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.myCaptureStatus.setForeground(ProfilerColors.CPU_CAPTURE_STATUS);
        this.myCaptureViewLoading = this.getProfilersView().getIdeProfilerComponents().createLoadingPanel(-1);
        this.myCaptureViewLoading.setLoadingText("Parsing capture...");
        this.myProfilingConfigurationCombo = new ComboBox();
        JComboBoxView<ProfilingConfiguration, CpuProfilerAspect> profilingConfiguration = new JComboBoxView<ProfilingConfiguration, CpuProfilerAspect>(this.myProfilingConfigurationCombo, stage.getAspect(), CpuProfilerAspect.PROFILING_CONFIGURATION, stage::getProfilingConfigurations, stage::getProfilingConfiguration, stage::setProfilingConfiguration);
        profilingConfiguration.bind();
        this.myProfilingConfigurationCombo.setFocusable(false);
        this.myProfilingConfigurationCombo.addKeyListener(new KeyAdapter(){

            private void skipSeparators(int indexDelta) {
                int selectedIndex = CpuProfilerStageView.this.myProfilingConfigurationCombo.getSelectedIndex() + indexDelta;
                if (selectedIndex < 0 || selectedIndex == CpuProfilerStageView.this.myProfilingConfigurationCombo.getItemCount()) {
                    return;
                }
                while (CpuProfilerStageView.this.myProfilingConfigurationCombo.getItemAt(selectedIndex) == CpuProfilerStage.CONFIG_SEPARATOR_ENTRY) {
                    selectedIndex += indexDelta;
                }
                CpuProfilerStageView.this.myProfilingConfigurationCombo.setSelectedIndex(selectedIndex);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    this.skipSeparators(1);
                    e.consume();
                } else if (e.getKeyCode() == 38) {
                    this.skipSeparators(-1);
                    e.consume();
                }
            }
        });
        this.myProfilingConfigurationCombo.setRenderer((ListCellRenderer<ProfilingConfiguration>)((Object)new ProfilingConfigurationRenderer()));
        this.updateCaptureState();
    }

    private void clearSelection() {
        ((CpuProfilerStage)this.getStage()).getStudioProfilers().getTimeline().getSelectionRange().clear();
    }

    private void installProfilingInstructions(@NotNull JPanel parent) {
        if (parent == null) {
            CpuProfilerStageView.$$$reportNull$$$0(2);
        }
        assert (parent.getLayout().getClass() == TabularLayout.class);
        Icon recordIcon = UIUtil.isUnderDarcula() ? IconUtil.darker((Icon)StudioIcons.Profiler.Toolbar.RECORD, (int)3) : IconUtil.brighter((Icon)StudioIcons.Profiler.Toolbar.RECORD, (int)3);
        InstructionsPanel panel = new InstructionsPanel.Builder(new RenderInstruction[]{new TextInstruction(ProfilerLayout.PROFILING_INSTRUCTIONS_FONT, "Click "), new IconInstruction(recordIcon, ProfilerLayout.PROFILING_INSTRUCTIONS_ICON_PADDING, null), new TextInstruction(ProfilerLayout.PROFILING_INSTRUCTIONS_FONT, " to start method profiling")}).setEaseOut(((CpuProfilerStage)this.getStage()).getInstructionsEaseOutModel(), instructionsPanel -> {
            if (parent == null) {
                CpuProfilerStageView.$$$reportNull$$$0(7);
            }
            parent.remove((Component)instructionsPanel);
        }).setBackgroundCornerRadius(ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER, ProfilerLayout.PROFILING_INSTRUCTIONS_BACKGROUND_ARC_DIAMETER).build();
        parent.add((Component)panel, new TabularLayout.Constraint(0, 0));
    }

    @NotNull
    private JComponent createTooltip(@NotNull JPanel overlayPanel, @NotNull JComponent overlay, final @NotNull JBList<CpuThreadsModel.RangedCpuThread> threads) {
        if (overlayPanel == null) {
            CpuProfilerStageView.$$$reportNull$$$0(3);
        }
        if (overlay == null) {
            CpuProfilerStageView.$$$reportNull$$$0(4);
        }
        if (threads == null) {
            CpuProfilerStageView.$$$reportNull$$$0(5);
        }
        ProfilerTimeline timeline = this.myStage.getStudioProfilers().getTimeline();
        ProfilerTooltipMouseAdapter usageListener = new ProfilerTooltipMouseAdapter(this.myStage, () -> new CpuUsageTooltip(this.myStage));
        overlay.addMouseListener(usageListener);
        overlayPanel.addMouseListener(usageListener);
        threads.addMouseListener((MouseListener)new ProfilerTooltipMouseAdapter(this.myStage, () -> new CpuThreadsTooltip(this.myStage)));
        threads.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = threads.locationToIndex(e.getPoint());
                if (row != -1) {
                    CpuThreadsModel.RangedCpuThread model = (CpuThreadsModel.RangedCpuThread)threads.getModel().getElementAt(row);
                    if (CpuProfilerStageView.this.myStage.getTooltip() instanceof CpuThreadsTooltip) {
                        CpuThreadsTooltip tooltip = (CpuThreadsTooltip)CpuProfilerStageView.this.myStage.getTooltip();
                        tooltip.setThread(model.getName(), model.getStateSeries());
                    }
                }
            }
        });
        RangeTooltipComponent tooltip = new RangeTooltipComponent(timeline.getTooltipRange(), timeline.getViewRange(), timeline.getDataRange(), (Component)this.getTooltipPanel(), ProfilerLayeredPane.class);
        tooltip.registerListenersOn((Component)overlay);
        tooltip.registerListenersOn((Component)overlayPanel);
        tooltip.registerListenersOn(threads);
        RangeTooltipComponent rangeTooltipComponent = tooltip;
        if (rangeTooltipComponent == null) {
            CpuProfilerStageView.$$$reportNull$$$0(6);
        }
        return rangeTooltipComponent;
    }

    @Override
    public JComponent getToolbar() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel toolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        toolbar.add(this.myProfilingConfigurationCombo);
        toolbar.add(Box.createHorizontalStrut(3));
        toolbar.add(this.myCaptureButton);
        toolbar.add(this.myCaptureStatus);
        StudioProfilers profilers = ((CpuProfilerStage)this.getStage()).getStudioProfilers();
        profilers.addDependency(this).onChange((Enum)ProfilerAspect.PROCESSES, () -> this.myCaptureButton.setEnabled(profilers.isProcessAlive()));
        this.myCaptureButton.setEnabled(profilers.isProcessAlive());
        panel.add((Component)toolbar, "West");
        return panel;
    }

    private String formatCaptureLabel(CpuTraceInfo info) {
        Range range = ((CpuProfilerStage)this.getStage()).getStudioProfilers().getTimeline().getDataRange();
        long min = (long)(info.getRange().getMin() - range.getMin());
        long max = (long)(info.getRange().getMax() - range.getMin());
        return TimeAxisFormatter.DEFAULT.getClockFormattedString(min) + " - " + TimeAxisFormatter.DEFAULT.getClockFormattedString(max);
    }

    private void updateCaptureState() {
        this.myCaptureViewLoading.stopLoading();
        switch (this.myStage.getCaptureState()) {
            case IDLE: {
                this.myCaptureButton.setEnabled(true);
                this.myCaptureStatus.setText("");
                this.myCaptureButton.setToolTipText("Record a method trace");
                this.myCaptureButton.setIcon(StudioIcons.Profiler.Toolbar.RECORD);
                this.myProfilingConfigurationCombo.setEnabled(true);
                this.myCaptureButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.RECORD));
                break;
            }
            case CAPTURING: {
                this.myCaptureButton.setEnabled(true);
                this.myCaptureStatus.setText("");
                this.myCaptureButton.setToolTipText("Stop recording");
                this.myCaptureButton.setIcon(StudioIcons.Profiler.Toolbar.STOP_RECORDING);
                this.myProfilingConfigurationCombo.setEnabled(false);
                this.myCaptureButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.STOP_RECORDING));
                break;
            }
            case PARSING: {
                this.myCaptureViewLoading.startLoading();
                this.mySplitter.setSecondComponent(this.myCaptureViewLoading.getComponent());
                break;
            }
            case PARSING_FAILURE: {
                this.mySplitter.setSecondComponent(null);
                break;
            }
            case STARTING: {
                this.myCaptureButton.setEnabled(false);
                this.myCaptureStatus.setText("Starting record...");
                this.myCaptureButton.setToolTipText("");
                this.myProfilingConfigurationCombo.setEnabled(false);
                break;
            }
            case START_FAILURE: {
                this.mySplitter.setSecondComponent(null);
                break;
            }
            case STOPPING: {
                this.myCaptureButton.setEnabled(false);
                this.myCaptureStatus.setText("Stopping record...");
                this.myCaptureButton.setToolTipText("");
                this.myProfilingConfigurationCombo.setEnabled(false);
                break;
            }
            case STOP_FAILURE: {
                this.mySplitter.setSecondComponent(null);
            }
        }
    }

    private void updateCaptureSelection() {
        CpuCapture capture = this.myStage.getCapture();
        if (capture == null) {
            if (this.myStage.getCaptureState() != CpuProfilerStage.CaptureState.PARSING) {
                if (this.myStage.isSelectionFailure()) {
                    this.mySplitter.setSecondComponent((JComponent)this.myHelpTipPanel);
                } else {
                    this.mySplitter.setSecondComponent(null);
                }
            }
            this.clearSelection();
            this.myCaptureView = null;
        } else if (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.IDLE) {
            this.myCaptureView = new CpuCaptureView(this);
            this.mySplitter.setSecondComponent(this.myCaptureView.getComponent());
        }
    }

    private void updateCaptureElapsedTime() {
        if (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.CAPTURING) {
            long elapsedTimeUs = this.myStage.getCaptureElapsedTimeUs();
            this.myCaptureStatus.setText("Recording - " + TimeAxisFormatter.DEFAULT.getClockFormattedString(elapsedTimeUs));
        }
    }

    private void capture() {
        if (this.myStage.getCaptureState() == CpuProfilerStage.CaptureState.CAPTURING) {
            this.myStage.stopCapturing();
        } else {
            this.myStage.startCapturing();
        }
    }

    private void updateThreadSelection() {
        if (this.myStage.getSelectedThread() == -1) {
            this.myThreads.clearSelection();
            return;
        }
        for (int i = 0; i < this.myThreads.getModel().getSize(); ++i) {
            CpuThreadsModel.RangedCpuThread thread = (CpuThreadsModel.RangedCpuThread)this.myThreads.getModel().getElementAt(i);
            if (this.myStage.getSelectedThread() != thread.getThreadId()) continue;
            this.myThreads.setSelectedIndex(i);
            break;
        }
        if (this.myStage.getSelectedThread() != -1 && this.myStage.isSelectionFailure()) {
            this.mySplitter.setSecondComponent((JComponent)this.myHelpTipPanel);
        }
    }

    private void updateCaptureDetails() {
        if (this.myCaptureView != null) {
            this.myCaptureView.updateView();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilersView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overlayPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overlay";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threads";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerStageView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerStageView";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installProfilingInstructions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTooltip";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$installProfilingInstructions$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ThreadCellRenderer
    implements ListCellRenderer<CpuThreadsModel.RangedCpuThread> {
        private final JLabel myLabel = new JLabel();
        private final Map<Integer, StateChartData> myStateCharts;
        private int myHoveredIndex = -1;
        private final UpdatableManager myUpdatableManager;

        ThreadCellRenderer(final JList<CpuThreadsModel.RangedCpuThread> list, UpdatableManager updatableManager) {
            this.myLabel.setFont((Font)AdtUiUtils.DEFAULT_FONT);
            MatteBorder rightSeparator = BorderFactory.createMatteBorder(0, 0, 0, 1, ProfilerColors.THREAD_LABEL_BORDER);
            EmptyBorder marginLeft = new EmptyBorder(0, 10, 0, 0);
            this.myLabel.setBorder(new CompoundBorder(rightSeparator, marginLeft));
            this.myLabel.setOpaque(true);
            this.myUpdatableManager = updatableManager;
            this.myStateCharts = new HashMap<Integer, StateChartData>();
            list.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    Point p = new Point(e.getX(), e.getY());
                    myHoveredIndex = list.locationToIndex(p);
                }
            });
        }

        @Override
        public Component getListCellRendererComponent(JList list, CpuThreadsModel.RangedCpuThread value, int index, boolean isSelected, boolean cellHasFocus) {
            JPanel panel = new JPanel((LayoutManager)new TabularLayout("150px,*", "*"));
            panel.setPreferredSize(new Dimension(panel.getPreferredSize().width, JBUI.scale((int)15)));
            panel.setBackground(list.getBackground());
            this.myLabel.setText(value.getName());
            this.myLabel.setBackground(ProfilerColors.THREAD_LABEL_BACKGROUND);
            this.myLabel.setForeground(ProfilerColors.THREAD_LABEL_TEXT);
            int tid = value.getThreadId();
            StateChartModel<CpuProfilerStage.ThreadState> model = value.getModel();
            if (this.myStateCharts.containsKey(tid) && !model.equals(this.myStateCharts.get(tid).getModel())) {
                this.myUpdatableManager.unregister(this.myStateCharts.get(tid).getModel());
            }
            StateChart<CpuProfilerStage.ThreadState> stateChart = this.getOrCreateStateChart(tid, model);
            stateChart.getColors().setColorIndex(isSelected ? 1 : 0);
            stateChart.setOpaque(true);
            if (isSelected) {
                panel.setBackground(ProfilerColors.THREAD_SELECTED_BACKGROUND);
                this.myLabel.setBackground(ProfilerColors.THREAD_SELECTED_BACKGROUND);
                this.myLabel.setForeground(ProfilerColors.SELECTED_THREAD_LABEL_TEXT);
                stateChart.setOpaque(false);
            } else if (this.myHoveredIndex == index) {
                JPanel overlay = new JPanel();
                overlay.setBackground(ProfilerColors.DEFAULT_HOVER_COLOR);
                panel.add((Component)overlay, new TabularLayout.Constraint(0, 0, 2));
            }
            panel.add((Component)this.myLabel, new TabularLayout.Constraint(0, 0));
            panel.add((Component)stateChart, new TabularLayout.Constraint(0, 0, 2));
            return panel;
        }

        private StateChart<CpuProfilerStage.ThreadState> getOrCreateStateChart(int tid, StateChartModel<CpuProfilerStage.ThreadState> model) {
            if (this.myStateCharts.containsKey(tid) && this.myStateCharts.get(tid).getModel().equals(model)) {
                return this.myStateCharts.get(tid).getChart();
            }
            StateChart stateChart = new StateChart(model, ProfilerColors.THREAD_STATES);
            StateChartData data = new StateChartData((StateChart<CpuProfilerStage.ThreadState>)stateChart, model);
            stateChart.setHeightGap(0.4f);
            this.myStateCharts.put(tid, data);
            this.myUpdatableManager.register(model);
            return stateChart;
        }

        private static class StateChartData {
            private final StateChart<CpuProfilerStage.ThreadState> myChart;
            private final StateChartModel<CpuProfilerStage.ThreadState> myModel;

            StateChartData(StateChart<CpuProfilerStage.ThreadState> chart, StateChartModel<CpuProfilerStage.ThreadState> model) {
                this.myChart = chart;
                this.myModel = model;
            }

            public StateChart<CpuProfilerStage.ThreadState> getChart() {
                return this.myChart;
            }

            public StateChartModel<CpuProfilerStage.ThreadState> getModel() {
                return this.myModel;
            }
        }
    }

    private static class MyScrollPane
    extends JBScrollPane {
        private MyScrollPane() {
            this.getVerticalScrollBar().setOpaque(false);
        }

        protected JViewport createViewport() {
            if (SystemInfo.isMac) {
                return super.createViewport();
            }
            return new JViewport();
        }
    }

    private static class ProfilingConfigurationRenderer
    extends ColoredListCellRenderer<ProfilingConfiguration> {
        ProfilingConfigurationRenderer() {
            this.setIpad((Insets)new JBInsets(0, UIUtil.isUnderNativeMacLookAndFeel() ? 5 : UIUtil.getListCellHPadding(), 0, 0));
        }

        public Component getListCellRendererComponent(JList<? extends ProfilingConfiguration> list, ProfilingConfiguration value, int index, boolean selected, boolean hasFocus) {
            if (value == CpuProfilerStage.CONFIG_SEPARATOR_ENTRY) {
                TitledSeparator separator = new TitledSeparator("");
                separator.setBorder((Border)new EmptyBorder(0, -6, 0, -3));
                return separator;
            }
            return super.getListCellRendererComponent(list, (Object)value, index, selected, hasFocus);
        }

        protected void customizeCellRenderer(@NotNull JList<? extends ProfilingConfiguration> list, ProfilingConfiguration value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                ProfilingConfigurationRenderer.$$$reportNull$$$0(0);
            }
            if (value == CpuProfilerStage.EDIT_CONFIGURATIONS_ENTRY) {
                this.setIcon(AllIcons.Actions.EditSource);
                this.append("Edit configurations...");
            } else {
                this.append(value.getName());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/profilers/cpu/CpuProfilerStageView$ProfilingConfigurationRenderer", "customizeCellRenderer"));
        }
    }
}

